/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MessageInfo {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private Packet msg;
    private SysMessageID mid;
    private int packetSize;
    private HashMap iidMap = null;
    private int[] statearray = null;

    MessageInfo(DstMsgStore p, Packet msg, ConsumerUID[] iids, int[] states) throws BrokerException {
        this.mid = (SysMessageID)msg.getSysMessageID().clone();
        this.packetSize = msg.getPacketSize();
        this.iidMap = new HashMap();
        this.statearray = new int[iids.length];
        this.storeStates(iids, states);
    }

    synchronized Packet getMessage() throws IOException {
        return this.msg;
    }

    int getSize() {
        return this.packetSize;
    }

    SysMessageID getID() {
        return this.mid;
    }

    synchronized void storeStates(ConsumerUID[] iids, int[] states) throws BrokerException {
        if (this.iidMap.size() != 0) {
            this.logger.log(16, "B3084", (Object)this.mid.toString());
            throw new BrokerException(this.br.getString("B3084", this.mid.toString()));
        }
        int size = iids.length;
        this.iidMap = new HashMap(size);
        this.statearray = new int[size];
        for (int i = 0; i < size; ++i) {
            this.iidMap.put(iids[i], i);
            this.statearray[i] = states[i];
        }
    }

    synchronized void updateState(ConsumerUID iid, int state) throws IOException, BrokerException {
        Integer indexObj = null;
        if (this.iidMap == null || (indexObj = (Integer)this.iidMap.get(iid)) == null) {
            this.logger.log(32, "B3014", (Object)iid.toString(), (Object)this.mid.toString());
            throw new BrokerException(this.br.getString("B3014", iid.toString(), this.mid.toString()));
        }
        int index = indexObj;
        if (this.statearray[index] != state) {
            this.statearray[index] = state;
        }
    }

    synchronized int getInterestState(ConsumerUID iid) throws BrokerException {
        Integer indexobj = null;
        if (this.iidMap == null || (indexobj = (Integer)this.iidMap.get(iid)) == null) {
            this.logger.log(32, "B3014", (Object)iid.toString(), (Object)this.mid.toString());
            throw new BrokerException(this.br.getString("B3014", iid.toString(), this.mid.toString()));
        }
        return this.statearray[indexobj];
    }

    synchronized HashMap getInterestStates() {
        HashMap states = new HashMap();
        if (this.iidMap != null) {
            Set entries = this.iidMap.entrySet();
            for (Map.Entry entry : entries) {
                int index = (Integer)entry.getValue();
                states.put(entry.getKey(), this.statearray[index]);
            }
        }
        return states;
    }

    synchronized ConsumerUID[] getConsumerUIDs() {
        ConsumerUID[] ids = new ConsumerUID[]{};
        if (this.iidMap != null) {
            ArrayList list = new ArrayList();
            Set entries = this.iidMap.entrySet();
            for (Map.Entry entry : entries) {
                Integer index = (Integer)entry.getValue();
                if (this.statearray[index] == 2) continue;
                list.add(entry.getKey());
            }
            ids = list.toArray(ids);
        }
        return ids;
    }

    synchronized boolean hasMessageBeenAck() {
        if (this.statearray != null && this.statearray.length > 0) {
            int len = this.statearray.length;
            for (int i = 0; i < len; ++i) {
                if (this.statearray[i] == 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

