/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.InMemoryStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

class MsgStore {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap dstMap = new ConcurrentHashMap(32);
    private InMemoryStore store = null;
    private static final Enumeration emptyEnum = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };

    MsgStore(InMemoryStore s) {
        this.store = s;
    }

    Hashtable getDebugState() {
        Hashtable t = new Hashtable();
        for (DstMsgStore dstMsgStore : this.dstMap.values()) {
            t.putAll(dstMsgStore.getDebugState());
        }
        return t;
    }

    void storeMessage(DestinationUID dst, Packet message, ConsumerUID[] iids, int[] states) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(1, "storeMessage for " + dst);
        }
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true);
        dstMsgStore.storeMessage(message, iids, states);
    }

    Packet getMessage(DestinationUID dst, SysMessageID mid) throws BrokerException {
        try {
            return this.getDstMsgStore(dst).getMessage(mid);
        }
        catch (IOException e) {
            this.logger.log(32, "B4107", (Object)mid.toString(), (Throwable)e);
            throw new BrokerException(this.br.getString("B4107", mid.toString()), e);
        }
    }

    boolean containsMessage(DestinationUID dst, SysMessageID mid) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true);
        return dstMsgStore.containsMsg(mid);
    }

    void removeMessage(DestinationUID dst, SysMessageID id) throws IOException, BrokerException {
        this.getDstMsgStore(dst).removeMessage(id);
    }

    void moveMessage(Packet message, DestinationUID from, DestinationUID to, ConsumerUID[] ints, int[] states) throws IOException, BrokerException {
        SysMessageID mid = message.getSysMessageID();
        DstMsgStore fromdst = this.getDstMsgStore(from);
        if (fromdst == null || !fromdst.containsMsg(mid)) {
            this.logger.log(32, "B3007", (Object)mid, (Object)from);
            throw new BrokerException(this.br.getString("B3007", mid, from));
        }
        this.storeMessage(to, message, ints, states);
        try {
            fromdst.removeMessage(message.getSysMessageID());
        }
        catch (BrokerException e) {
            this.getDstMsgStore(to).removeMessage(message.getSysMessageID());
            Object[] args = new Object[]{mid, from, to};
            this.logger.log(32, "B4187", args, (Throwable)e);
            throw e;
        }
    }

    public boolean hasMessageBeenAcked(DestinationUID dst, SysMessageID mid) throws BrokerException {
        return this.getDstMsgStore(dst).getMessageInfo(mid).hasMessageBeenAck();
    }

    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        return new HashMap();
    }

    void compactDestination(Destination destination) throws BrokerException {
    }

    void removeAllMessages(DestinationUID dst, boolean sync) throws IOException, BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true);
        if (dstMsgStore != null) {
            dstMsgStore.removeAllMessages(sync);
        }
    }

    void releaseMessageDir(DestinationUID dst) {
        DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.remove(dst);
        dstMsgStore.close();
    }

    Enumeration messageEnumeration() {
        Enumeration msgEnum = new Enumeration(){
            Iterator dstitr;
            Enumeration tempenum;
            Object nextToReturn;
            {
                this.dstitr = MsgStore.this.store.getDstStore().getDestinations().iterator();
                this.tempenum = null;
                this.nextToReturn = null;
            }

            @Override
            public boolean hasMoreElements() {
                while (true) {
                    if (this.tempenum != null) {
                        if (this.tempenum.hasMoreElements()) {
                            this.nextToReturn = this.tempenum.nextElement();
                            return true;
                        }
                        this.tempenum = null;
                        continue;
                    }
                    while (this.dstitr.hasNext()) {
                        Destination dst = (Destination)this.dstitr.next();
                        try {
                            this.tempenum = MsgStore.this.messageEnumeration(dst.getDestinationUID());
                            break;
                        }
                        catch (BrokerException e) {
                            MsgStore.this.logger.log(32, "B4145", (Object)dst.getDestinationUID(), (Throwable)e);
                        }
                    }
                    if (this.tempenum == null) break;
                }
                return false;
            }

            public Object nextElement() {
                if (this.nextToReturn != null) {
                    Object tmp = this.nextToReturn;
                    this.nextToReturn = null;
                    return tmp;
                }
                throw new NoSuchElementException();
            }
        };
        return msgEnum;
    }

    Enumeration messageEnumeration(DestinationUID dst) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true);
        if (dstMsgStore != null) {
            return dstMsgStore.messageEnumeration();
        }
        return emptyEnum;
    }

    int getMessageCount(DestinationUID dst) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true);
        if (dstMsgStore != null) {
            return dstMsgStore.getMessageCount();
        }
        return 0;
    }

    long getByteCount(DestinationUID dst) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(dst, true);
        if (dstMsgStore != null) {
            return dstMsgStore.getByteCount();
        }
        return 0L;
    }

    void storeInterestStates(DestinationUID dst, SysMessageID mid, ConsumerUID[] iids, int[] states, boolean sync) throws BrokerException {
        try {
            this.getDstMsgStore(dst).storeInterestStates(mid, iids, states);
        }
        catch (IOException e) {
            this.logger.log(32, "B4105", (Object)mid.toString());
            throw new BrokerException(this.br.getString("B4105", mid.toString()), e);
        }
    }

    void updateInterestState(DestinationUID dst, SysMessageID mid, ConsumerUID iid, int state, boolean sync) throws BrokerException {
        try {
            this.getDstMsgStore(dst).updateInterestState(mid, iid, state);
        }
        catch (IOException e) {
            this.logger.log(32, "B4015", (Object)iid.toString(), (Object)mid.toString());
            throw new BrokerException(this.br.getString("B4015", iid.toString(), mid.toString()), e);
        }
    }

    int getInterestState(DestinationUID dst, SysMessageID mid, ConsumerUID iid) throws BrokerException {
        return this.getDstMsgStore(dst).getMessageInfo(mid).getInterestState(iid);
    }

    HashMap getInterestStates(DestinationUID dst, SysMessageID mid) throws BrokerException {
        return this.getDstMsgStore(dst).getMessageInfo(mid).getInterestStates();
    }

    ConsumerUID[] getConsumerUIDs(DestinationUID dst, SysMessageID mid) throws BrokerException {
        return this.getDstMsgStore(dst).getMessageInfo(mid).getConsumerUIDs();
    }

    void clearAll() throws BrokerException {
        if (this.dstMap != null) {
            this.closeAllDstMsgStore(false);
            this.dstMap.clear();
        }
    }

    void close(boolean cleanup) {
        this.closeAllDstMsgStore(cleanup);
        this.dstMap.clear();
    }

    private DstMsgStore getDstMsgStore(DestinationUID dst) throws BrokerException {
        DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.get(dst);
        if (dstMsgStore == null) {
            String emsg = this.br.getKString("B3013", dst);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return dstMsgStore;
    }

    private DstMsgStore getDstMsgStore(DestinationUID dst, boolean create) throws BrokerException {
        DstMsgStore oldValue;
        this.store.getDstStore().checkDestination(dst);
        DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.get(dst);
        if (dstMsgStore == null && create && (oldValue = this.dstMap.putIfAbsent(dst, dstMsgStore = new DstMsgStore(dst))) != null) {
            dstMsgStore = oldValue;
        }
        return dstMsgStore;
    }

    private void closeAllDstMsgStore(boolean msgCleanup) {
        for (DstMsgStore dstMsgStore : this.dstMap.values()) {
            if (dstMsgStore == null) continue;
            dstMsgStore.close();
        }
    }
}

