/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.util.DestType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class DestinationDAOImpl
extends BaseDAOImpl
implements DestinationDAO {
    private final String tableName;
    private String insertSQL;
    private String updateSQL;
    private String updateConnectedTimeSQL;
    private String deleteSQL;
    private String deleteBySessionSQL;
    private String deleteSharedDstSQL;
    private String selectSQL;
    private String selectConnectedTimeSQL;
    private String selectDstsByBrokerSQL;
    private String selectLocalDstsByBrokerSQL;
    private String selectExistSQL;

    DestinationDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQDST41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("STORE_SESSION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION").append(" = ?, ").append("IS_LOCAL").append(" = ?, ").append("CONNECTION_ID").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.updateConnectedTimeSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("CONNECTED_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteBySessionSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("STORE_SESSION_ID").append(" = ? ").append(" AND EXISTS (SELECT * FROM ").append(dbMgr.getTableName("MQSES41")).append(" WHERE ").append("ID").append(" = ? ").append(" AND ").append("BROKER_ID").append(" = ? )").toString();
        this.deleteSharedDstSQL = new StringBuffer(128).append(this.deleteSQL).append(" AND NOT EXISTS (SELECT * FROM ").append(dbMgr.getTableName("MQMSG41")).append(" WHERE ").append("DESTINATION_ID").append(" = ?)").append(" AND NOT EXISTS (SELECT * FROM ").append(dbMgr.getTableName("MQBKR41")).append(" WHERE ").append("ID").append(" <> ? ").append(" AND ").append("STATE").append(" = ").append(1).append(")").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectConnectedTimeSQL = new StringBuffer(128).append("SELECT ").append("CONNECTED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectDstsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" IN (SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("IS_LOCAL").append(" = 0").append(" UNION SELECT dstTbl.").append("ID").append(" FROM ").append(this.tableName).append(" dstTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = dstTbl.").append("STORE_SESSION_ID").append(")").toString();
        this.selectLocalDstsByBrokerSQL = new StringBuffer(128).append("SELECT ").append("DESTINATION").append(" FROM ").append(this.tableName).append(" dstTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl WHERE ").append(" sesTbl.").append("BROKER_ID").append(" = ?").append(" AND ").append(" sesTbl.").append("ID").append(" = dstTbl.").append("STORE_SESSION_ID").toString();
        this.selectExistSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQDST41";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, Destination destination, long storeSessionID, long connectedTime, long createdTime) throws BrokerException {
        block18: {
            Exception myex;
            PreparedStatement pstmt;
            block17: {
                String destName = destination.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (this.hasDestination(conn, destName)) {
                        throw new BrokerException(this.br.getKString("B3012", destName));
                    }
                    try {
                        ConnectionUID cUID;
                        int isLocal;
                        int n = isLocal = destination.getIsLocal() ? 1 : 0;
                        if (isLocal == 0) {
                            storeSessionID = 0L;
                        }
                        long connectionID = -1L;
                        if (destination.isTemporary() && (cUID = destination.getConnectionUID()) != null) {
                            connectionID = cUID.longValue();
                            if (connectedTime <= 0L) {
                                connectedTime = System.currentTimeMillis();
                            }
                        }
                        pstmt = DBManager.createPreparedStatement(conn, this.insertSQL);
                        pstmt.setString(1, destName);
                        Util.setObject(pstmt, 2, destination);
                        pstmt.setInt(3, isLocal);
                        Util.setLong(pstmt, 4, connectionID);
                        Util.setLong(pstmt, 5, connectedTime);
                        Util.setLong(pstmt, 6, storeSessionID);
                        pstmt.setLong(7, createdTime);
                        pstmt.executeUpdate();
                    }
                    catch (Exception e) {
                        myex = e;
                        try {
                            if (!conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)e) : e);
                        throw new BrokerException(this.br.getKString("B4014", destName), ex);
                    }
                    if (!myConn) break block17;
                }
                catch (BrokerException e) {
                    try {
                        myex = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block18;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void update(Connection conn, Destination destination) throws BrokerException {
        block14: {
            Exception myex;
            PreparedStatement pstmt;
            block13: {
                String destName = destination.getUniqueName();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    ConnectionUID cUID;
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    int isLocal = destination.getIsLocal() ? 1 : 0;
                    long connectionID = -1L;
                    if (isLocal > 0 && (cUID = destination.getConnectionUID()) != null) {
                        connectionID = cUID.longValue();
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.updateSQL);
                    Util.setObject(pstmt, 1, destination);
                    pstmt.setInt(2, isLocal);
                    Util.setLong(pstmt, 3, connectionID);
                    pstmt.setString(4, destName);
                    if (pstmt.executeUpdate() == 0) {
                        throw new DestinationNotFoundException(this.br.getKString("B3013", destName), 404);
                    }
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.updateSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateSQL + "]", (SQLException)e) : e);
                        throw new BrokerException(this.br.getKString("B4014", destName), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block14;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void updateConnectedTime(Connection conn, Destination destination, long connectedTime) throws BrokerException {
        block14: {
            Exception myex;
            PreparedStatement pstmt;
            block13: {
                String destName = destination.getUniqueName();
                if (!destination.getIsLocal()) {
                    throw new BrokerException(this.br.getKString("B3181", destName));
                }
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.updateConnectedTimeSQL);
                    pstmt.setLong(1, connectedTime);
                    pstmt.setString(2, destName);
                    if (pstmt.executeUpdate() == 0) {
                        throw new DestinationNotFoundException(this.br.getKString("B3013", destName), 404);
                    }
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateConnectedTimeSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4014", destName), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block14;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public boolean delete(Connection conn, Destination destination, Long storeSessionID) throws BrokerException {
        return this.delete(conn, destination.getDestinationUID(), destination.getType(), storeSessionID);
    }

    @Override
    public boolean delete(Connection conn, DestinationUID dstUID, int type) throws BrokerException {
        return this.delete(conn, dstUID, type, null);
    }

    public boolean delete(Connection conn, DestinationUID dstUID, int type, Long storeSessionID) throws BrokerException {
        boolean isDeleted;
        block17: {
            Exception myex;
            PreparedStatement pstmt;
            block16: {
                isDeleted = false;
                String destName = dstUID.toString();
                boolean myConn = false;
                String sql = null;
                pstmt = null;
                myex = null;
                try {
                    int msgCount;
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    if ((msgCount = dbMgr.getDAOFactory().getMessageDAO().deleteByDestinationBySession(conn, dstUID, storeSessionID)) > 0) {
                        this.logger.log(16, "B2181", (Object)String.valueOf(msgCount), (Object)dstUID);
                    }
                    if (storeSessionID != null) {
                        sql = this.deleteBySessionSQL;
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        pstmt.setString(1, destName);
                        pstmt.setLong(2, storeSessionID);
                        pstmt.setLong(3, storeSessionID);
                        pstmt.setString(4, dbMgr.getBrokerID());
                    }
                    if (Globals.getHAEnabled() && DestType.isAutoCreated((int)type) && !DestType.isTemporary((int)type)) {
                        sql = this.deleteSharedDstSQL;
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        pstmt.setString(1, destName);
                        pstmt.setString(2, destName);
                        pstmt.setString(3, dbMgr.getBrokerID());
                    } else {
                        sql = this.deleteSQL;
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        pstmt.setString(1, destName);
                    }
                    int count = pstmt.executeUpdate();
                    if (myConn) {
                        conn.commit();
                    }
                    boolean bl = isDeleted = count > 0;
                    if (!myConn) break block16;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4144", destName), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block17;
            }
            Util.close(null, pstmt, null, myex);
        }
        return isDeleted;
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        String whereClause = null;
        if (Globals.getHAEnabled()) {
            DBManager dbMgr = DBManager.getDBManager();
            whereClause = new StringBuffer(128).append("EXISTS (SELECT ").append("ID").append(" FROM ").append(dbMgr.getTableName("MQSES41")).append(" WHERE ").append("ID").append(" = ").append(this.tableName).append(".").append("STORE_SESSION_ID").append(" AND ").append("BROKER_ID").append(" = '").append(dbMgr.getBrokerID()).append("')").toString();
        }
        this.deleteAll(conn, whereClause, null, 0);
    }

    @Override
    public Destination getDestination(Connection conn, String destName) throws BrokerException {
        Destination dest;
        block12: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block11: {
                dest = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectSQL);
                    pstmt.setString(1, destName);
                    rs = pstmt.executeQuery();
                    dest = (Destination)this.loadData(rs, true);
                    if (!myConn) break block11;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4224", destName), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block12;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return dest;
    }

    @Override
    public long getDestinationConnectedTime(Connection conn, String destName) throws BrokerException {
        long connectedTime;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                connectedTime = -1L;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectConnectedTimeSQL);
                    pstmt.setString(1, destName);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new DestinationNotFoundException(this.br.getKString("B3013", destName), 404);
                    }
                    connectedTime = rs.getLong(1);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectConnectedTimeSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4224", destName), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return connectedTime;
    }

    @Override
    public List getAllDestinations(Connection conn, String brokerID) throws BrokerException {
        List list;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                list = Collections.EMPTY_LIST;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (brokerID == null) {
                        brokerID = dbMgr.getBrokerID();
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectDstsByBrokerSQL);
                    pstmt.setString(1, brokerID);
                    rs = pstmt.executeQuery();
                    list = (List)this.loadData(rs, false);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectDstsByBrokerSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4031"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return list;
    }

    @Override
    public List getLocalDestinationsByBroker(Connection conn, String brokerID) throws BrokerException {
        List list;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                list = Collections.EMPTY_LIST;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (brokerID == null) {
                        brokerID = dbMgr.getBrokerID();
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectLocalDstsByBrokerSQL);
                    pstmt.setString(1, brokerID);
                    rs = pstmt.executeQuery();
                    list = (List)this.loadData(rs, false);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectLocalDstsByBrokerSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B3175", brokerID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return list;
    }

    @Override
    public boolean hasDestination(Connection conn, String destName) throws BrokerException {
        boolean found;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                found = false;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectExistSQL);
                    pstmt.setString(1, destName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        found = true;
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectExistSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4166", this.selectExistSQL), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return found;
    }

    @Override
    public void checkDestination(Connection conn, String destName) throws BrokerException {
        if (!this.hasDestination(conn, destName)) {
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[checkDestination:" + destName + "]", (Throwable)rbe);
            }
            throw new DestinationNotFoundException(this.br.getKString("B3013", destName), 404);
        }
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put("Destinations(" + this.tableName + ")", String.valueOf(count));
        return map;
    }

    protected Object loadData(ResultSet rs, boolean isSingleRow) throws SQLException {
        ArrayList<Destination> list = null;
        if (!isSingleRow) {
            list = new ArrayList<Destination>(100);
        }
        while (rs.next()) {
            try {
                Destination dest = (Destination)Util.readObject(rs, 1);
                if (isSingleRow) {
                    return dest;
                }
                list.add(dest);
            }
            catch (Exception e) {
                this.logger.logStack(32, "B4124", (Throwable)e);
            }
        }
        return list;
    }
}

