/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestinationDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertyDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class UpgradeStore
implements DBConstants {
    private BrokerResources br = Globals.getBrokerResources();
    private Logger logger = Globals.getLogger();
    private JDBCStore store;
    private DBManager dbMgr;
    private String brokerID;
    private long storeSessionID;
    private int oldStoreVersion;
    private String oldVersionTable;
    private String oldPropTable;
    private String oldConfigRecordTable;
    private String oldDestTable;
    private String oldMsgTable;
    private String oldStateTable;
    private String oldInterestTable;
    private String oldTxnTable;
    private String oldAckTable;
    private boolean useBlob;
    private static boolean DEBUG = false;

    UpgradeStore(JDBCStore jdbcStore, int oldVersion) throws BrokerException {
        this.store = jdbcStore;
        this.dbMgr = DBManager.getDBManager();
        this.brokerID = this.dbMgr.getBrokerID();
        this.oldStoreVersion = oldVersion;
        if (this.oldStoreVersion == 400) {
            this.useBlob = true;
            this.oldVersionTable = this.dbMgr.getTableName("MQVER40");
            this.oldPropTable = this.dbMgr.getTableName("MQPROP40");
            this.oldConfigRecordTable = this.dbMgr.getTableName("MQCREC40");
            this.oldDestTable = this.dbMgr.getTableName("MQDST40");
            this.oldMsgTable = this.dbMgr.getTableName("MQMSG40");
            this.oldStateTable = this.dbMgr.getTableName("MQCONSTATE40");
            this.oldInterestTable = this.dbMgr.getTableName("MQCON40");
            this.oldTxnTable = this.dbMgr.getTableName("MQTXN40");
        } else if (this.oldStoreVersion == 370) {
            this.useBlob = true;
            this.oldVersionTable = "IMQSV37" + this.brokerID;
            this.oldPropTable = "IMQPROPS37" + this.brokerID;
            this.oldConfigRecordTable = "IMQCCREC37" + this.brokerID;
            this.oldDestTable = "IMQDEST37" + this.brokerID;
            this.oldMsgTable = "IMQMSG37" + this.brokerID;
            this.oldStateTable = "IMQILIST37" + this.brokerID;
            this.oldInterestTable = "IMQINT37" + this.brokerID;
            this.oldTxnTable = "IMQTXN37" + this.brokerID;
            this.oldAckTable = "IMQTACK37" + this.brokerID;
        } else {
            this.useBlob = false;
            this.oldVersionTable = "IMQSV35" + this.brokerID;
            this.oldPropTable = "IMQPROPS35" + this.brokerID;
            this.oldConfigRecordTable = "IMQCCREC35" + this.brokerID;
            this.oldDestTable = "IMQDEST35" + this.brokerID;
            this.oldMsgTable = "IMQMSG35" + this.brokerID;
            this.oldStateTable = "IMQILIST35" + this.brokerID;
            this.oldInterestTable = "IMQINT35" + this.brokerID;
            this.oldTxnTable = "IMQTXN35" + this.brokerID;
            this.oldAckTable = "IMQTACK35" + this.brokerID;
        }
    }

    void upgradeStore(Connection conn) throws BrokerException {
        Object[] args = new Object[]{410};
        this.logger.logToAll(8, "B1115", args);
        if (this.store.resetMessage()) {
            this.logger.logToAll(8, "B1101");
            this.logger.logToAll(8, "B1102");
        } else if (this.store.resetInterest()) {
            this.logger.logToAll(8, "B1103");
            this.logger.logToAll(8, "B1102");
        }
        try {
            DBTool.createTables(conn);
            this.storeSessionID = this.dbMgr.getDAOFactory().getStoreSessionDAO().getStoreSession(conn, this.brokerID);
        }
        catch (Throwable e) {
            String url = this.dbMgr.getCreateDBURL();
            if (url == null || url.length() == 0) {
                url = this.dbMgr.getOpenDBURL();
            }
            String errorMsg = this.br.getKString("B3073", url);
            this.logger.logToAll(32, errorMsg, (Object)e);
            throw new BrokerException(errorMsg, e);
        }
        try {
            conn.setAutoCommit(false);
            this.upgradeProperties(conn);
            this.upgradeChangeRecords(conn);
            this.upgradeDestinations(conn);
            this.upgradeMessages(conn);
            this.upgradeInterests(conn);
            this.upgradeTxns(conn);
            this.upgradeTxnAcks(conn);
            this.logger.logToAll(8, "B1106");
            if (this.store.upgradeNoBackup()) {
                this.dropTable(conn, this.oldVersionTable);
            } else {
                this.logger.logToAll(8, "B1121");
            }
        }
        catch (Exception e) {
            this.logger.logToAll(32, "B1116");
            try {
                DBTool.dropTables(conn, this.dbMgr.getTableNames(410), false, false, this.dbMgr);
            }
            catch (SQLException ex) {
                this.logger.logStack(32, "B4117", (Object)"Failed to clean up new tables after upgrade failed", (Throwable)ex);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(this.br.getKString("B3207"), e);
        }
    }

    private void upgradeDestinations(Connection conn) throws BrokerException {
        DestinationDAO dstDAO = this.dbMgr.getDAOFactory().getDestinationDAO();
        StringBuffer strBuf = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            strBuf.append("SELECT ").append("DESTINATION").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("CREATED_TS");
        } else {
            strBuf.append("SELECT ").append("DEST");
        }
        strBuf.append(" FROM ").append(this.oldDestTable);
        String getAllDestFromOldSQL = strBuf.toString();
        String insertDestSQL = new StringBuffer(128).append("INSERT INTO ").append(dstDAO.getTableName()).append(" ( ").append("ID").append(", ").append("DESTINATION").append(", ").append("IS_LOCAL").append(", ").append("CONNECTION_ID").append(", ").append("CONNECTED_TS").append(", ").append("STORE_SESSION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Destination dst = null;
        Exception myex = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertDestSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllDestFromOldSQL);
            while (rs.next()) {
                ConnectionUID cUID;
                Object obj = Util.readObject(rs, 1);
                dst = (Destination)obj;
                String destName = dst.getUniqueName();
                int isLocal = dst.getIsLocal() ? 1 : 0;
                long connectionID = -1L;
                long connectedTS = -1L;
                long createdTS = System.currentTimeMillis();
                if (this.oldStoreVersion == 400) {
                    connectionID = rs.getLong(2);
                    connectedTS = rs.getLong(3);
                    createdTS = rs.getLong(4);
                } else if (isLocal > 0 && (cUID = dst.getConnectionUID()) != null) {
                    connectionID = cUID.longValue();
                    connectedTS = createdTS;
                }
                try {
                    pstmt.setString(1, destName);
                    Util.setObject(pstmt, 2, dst);
                    pstmt.setInt(3, isLocal);
                    Util.setLong(pstmt, 4, connectionID);
                    Util.setLong(pstmt, 5, connectedTS);
                    Util.setLong(pstmt, 6, this.storeSessionID);
                    pstmt.setLong(7, createdTS);
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (IOException e) {
                    IOException ex = DBManager.wrapIOException("[" + insertDestSQL + "]", e);
                    throw ex;
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertDestSQL + "]", e);
                    throw ex;
                }
            }
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
            if (this.store.upgradeNoBackup()) {
                this.dropTable(conn, this.oldDestTable);
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4162", dst == null ? "loading" : dst.getUniqueName());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        Util.close(null, pstmt, null, myex);
    }

    private void upgradeMessages(Connection conn) throws BrokerException {
        String sql = null;
        int nummsg = 0;
        Statement stmt = null;
        ResultSet rs = null;
        SQLException myex = null;
        try {
            sql = "SELECT COUNT(*) FROM " + this.oldMsgTable;
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, sql);
            if (rs.next()) {
                nummsg = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                myex = e;
                this.logger.log(32, "B4166", (Object)sql, (Throwable)e);
                throw new BrokerException(this.br.getString("B4166", sql), e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        if (Store.getDEBUG()) {
            this.logger.log(4, "number of messages in old table = " + nummsg);
        }
        boolean nobackup = this.store.upgradeNoBackup();
        if (nummsg == 0) {
            if (nobackup) {
                this.dropTable(conn, this.oldMsgTable);
                this.dropTable(conn, this.oldStateTable);
            }
        } else if (this.store.resetMessage()) {
            if (nobackup) {
                this.dropTable(conn, this.oldMsgTable);
                this.dropTable(conn, this.oldStateTable);
            } else {
                this.clearTable(conn, this.oldMsgTable);
                this.clearTable(conn, this.oldStateTable);
            }
        } else {
            this.logger.logToAll(8, this.br.getString("B1118", String.valueOf(nummsg)));
            this.doUpgradeMsg(conn);
            if (nobackup) {
                this.dropTable(conn, this.oldMsgTable);
                this.dropTable(conn, this.oldStateTable);
            }
        }
    }

    private void doUpgradeMsg(Connection conn) throws BrokerException {
        MessageDAO msgDAO = this.dbMgr.getDAOFactory().getMessageDAO();
        HashMap<String, String> oldIDToNewID = new HashMap<String, String>();
        HashMap<String, String> msgToDst = new HashMap<String, String>();
        StringBuffer strBuf = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            strBuf.append("SELECT ").append("ID").append(", ").append("MESSAGE").append(", ").append("DESTINATION_ID").append(", ").append("CREATED_TS");
        } else {
            strBuf.append("SELECT ").append("MID").append(", ").append("MSG").append(", ").append("DID").append(", ").append(0);
        }
        strBuf.append(" FROM ").append(this.oldMsgTable);
        String getAllMsgFromOldSQL = strBuf.toString();
        Statement stmt = null;
        ResultSet rs = null;
        Packet msg = null;
        String oldMsgID = null;
        Exception myex = null;
        try {
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllMsgFromOldSQL);
            while (rs.next()) {
                oldMsgID = rs.getString(1);
                msg = new Packet(false);
                msg.generateTimestamp(false);
                msg.generateSequenceNumber(false);
                InputStream is = this.useBlob ? rs.getBlob(2).getBinaryStream() : rs.getBinaryStream(2);
                msg.readPacket(is);
                is.close();
                SysMessageID sysMsgID = msg.getSysMessageID();
                String dstID = rs.getString(3);
                long createdTS = rs.getLong(4);
                if (createdTS == 0L) {
                    createdTS = sysMsgID.getTimestamp();
                }
                msgDAO.insert(conn, dstID, msg, null, null, this.storeSessionID, createdTS, false, false);
                String newMsgID = sysMsgID.toString();
                oldIDToNewID.put(oldMsgID, newMsgID);
                msgToDst.put(newMsgID, dstID);
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4163", msg == null ? oldMsgID : msg.getSysMessageID().toString());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        ConsumerStateDAO stateDAO = this.dbMgr.getDAOFactory().getConsumerStateDAO();
        strBuf = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            strBuf.append("SELECT ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS");
        } else {
            strBuf.append("SELECT ").append("MID").append(", ").append("CUID").append(", ").append("STATE");
        }
        strBuf.append(" FROM ").append(this.oldStateTable).append(" WHERE ").append("STATE").append(" <> ").append(2);
        String getAllStateFromOldSQL = strBuf.toString();
        String insertStateSQL = new StringBuffer(128).append("INSERT INTO ").append(stateDAO.getTableName()).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement pstmt = null;
        long cuid = 0L;
        oldMsgID = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertStateSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllStateFromOldSQL);
            while (rs.next()) {
                oldMsgID = rs.getString(1);
                cuid = rs.getLong(2);
                int state = rs.getInt(3);
                String newMsgID = (String)oldIDToNewID.get(oldMsgID);
                if (newMsgID == null) {
                    String errorMsg = this.br.getKString("B3100", "Unable to update message ID format of interest " + cuid + " for message " + oldMsgID);
                    throw new BrokerException(errorMsg);
                }
                String dst = (String)msgToDst.get(newMsgID);
                if (dst == null) {
                    this.logger.log(16, "Destination not found: ignore state of interest " + cuid + " for message " + oldMsgID);
                    continue;
                }
                long txnID = -1L;
                long createdTS = System.currentTimeMillis();
                if (this.oldStoreVersion == 400) {
                    txnID = rs.getLong(4);
                    if (rs.wasNull()) {
                        txnID = -1L;
                    }
                    createdTS = rs.getLong(5);
                }
                try {
                    pstmt.setString(1, newMsgID);
                    pstmt.setLong(2, cuid);
                    pstmt.setInt(3, state);
                    Util.setLong(pstmt, 4, txnID);
                    pstmt.setLong(5, createdTS);
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertStateSQL + "]", e);
                    throw ex;
                }
            }
            msgToDst.clear();
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
        }
        catch (SQLException e) {
            myex = e;
            String errorMsg = this.br.getKString("B4163", oldMsgID == null ? "loading" : oldMsgID);
            this.logger.logStack(32, errorMsg, (Throwable)e);
            throw new BrokerException(errorMsg, e);
        }
        finally {
            Util.close(rs, stmt, null, myex);
            Util.close(null, pstmt, null, myex);
        }
    }

    private void upgradeInterests(Connection conn) throws BrokerException {
        String sql = "SELECT COUNT(*) FROM " + this.oldInterestTable;
        int numint = 0;
        Statement stmt = null;
        ResultSet rs = null;
        SQLException myex = null;
        try {
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, sql);
            if (rs.next()) {
                numint = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                myex = e;
                this.logger.log(32, "B4166", (Object)sql, (Throwable)e);
                throw new BrokerException(this.br.getString("B4166", sql), e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        if (Store.getDEBUG()) {
            this.logger.log(4, "number of interests in old table = " + numint);
        }
        boolean nobackup = this.store.upgradeNoBackup();
        if (numint == 0) {
            if (nobackup) {
                this.dropTable(conn, this.oldInterestTable);
            }
        } else if (this.store.resetInterest()) {
            if (nobackup) {
                this.dropTable(conn, this.oldInterestTable);
            } else {
                this.clearTable(conn, this.oldInterestTable);
            }
        } else {
            this.doUpgradeInterests(this.store, conn);
        }
    }

    private void doUpgradeInterests(JDBCStore store, Connection conn) throws BrokerException {
        ConsumerDAO conDAO = this.dbMgr.getDAOFactory().getConsumerDAO();
        StringBuffer strBuf = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            strBuf.append("SELECT ").append("CONSUMER").append(", ").append("CREATED_TS");
        } else {
            strBuf.append("SELECT ").append("INTEREST");
        }
        strBuf.append(" FROM ").append(this.oldInterestTable);
        String getAllInterestFromOldSQL = strBuf.toString();
        String insertInterestSQL = new StringBuffer(128).append("INSERT INTO ").append(conDAO.getTableName()).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        Consumer consumer = null;
        Exception myex = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertInterestSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllInterestFromOldSQL);
            while (rs.next()) {
                consumer = (Consumer)Util.readObject(rs, 1);
                String durableName = null;
                String clientID = null;
                if (consumer instanceof Subscription) {
                    Subscription sub = (Subscription)consumer;
                    durableName = sub.getDurableName();
                    clientID = sub.getClientID();
                }
                long createdTS = System.currentTimeMillis();
                if (this.oldStoreVersion == 400) {
                    createdTS = rs.getLong(2);
                }
                try {
                    pstmt.setLong(1, consumer.getConsumerUID().longValue());
                    Util.setObject(pstmt, 2, consumer);
                    Util.setString(pstmt, 3, durableName);
                    Util.setString(pstmt, 4, clientID);
                    pstmt.setLong(5, createdTS);
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (IOException e) {
                    IOException ex = DBManager.wrapIOException("[" + insertInterestSQL + "]", e);
                    throw ex;
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertInterestSQL + "]", e);
                    throw ex;
                }
            }
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
            if (store.upgradeNoBackup()) {
                this.dropTable(conn, this.oldInterestTable);
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4168", consumer == null ? "loading" : consumer.toString());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        Util.close(null, pstmt, null, myex);
    }

    private void upgradeTxns(Connection conn) throws BrokerException {
        TransactionDAO txnDAO = this.dbMgr.getDAOFactory().getTransactionDAO();
        StringBuffer strBuf = new StringBuffer(128);
        if (this.oldStoreVersion == 400) {
            strBuf.append("SELECT ").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE");
        } else {
            strBuf.append("SELECT ").append("TUID").append(", ").append("STATE").append(", ").append("TSTATEOBJ");
        }
        strBuf.append(" FROM ").append(this.oldTxnTable).append(" WHERE ").append("STATE").append(" <> ").append(-1);
        String getAllTxnsFromOldSQL = strBuf.toString();
        String insertTxnSQL = new StringBuffer(128).append("INSERT INTO ").append(txnDAO.getTableName()).append(" ( ").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("AUTO_ROLLBACK").append(", ").append("XID").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(", ").append("STORE_SESSION_ID").append(", ").append("EXPIRED_TS").append(", ").append("ACCESSED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        TransactionUID tid = null;
        Exception myex = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertTxnSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllTxnsFromOldSQL);
            while (rs.next()) {
                long id = rs.getLong(1);
                tid = new TransactionUID(id);
                int state = rs.getInt(2);
                TransactionState txnState = (TransactionState)Util.readObject(rs, 3);
                if (DEBUG) {
                    String msg = "reading transaction from old format: state=" + state + " txnState = " + txnState;
                    this.logger.log(4, msg);
                }
                txnState.setState(state);
                try {
                    pstmt.setLong(1, id);
                    pstmt.setInt(2, 1);
                    pstmt.setInt(3, state);
                    pstmt.setInt(4, txnState.getType().intValue());
                    JMQXid jmqXid = txnState.getXid();
                    if (jmqXid != null) {
                        pstmt.setString(5, jmqXid.toString());
                    } else {
                        pstmt.setNull(5, 12);
                    }
                    Util.setObject(pstmt, 6, txnState);
                    Util.setObject(pstmt, 7, null);
                    Util.setObject(pstmt, 8, null);
                    pstmt.setLong(9, this.storeSessionID);
                    pstmt.setLong(10, txnState.getExpirationTime());
                    pstmt.setLong(11, txnState.getLastAccessTime());
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (IOException e) {
                    IOException ex = DBManager.wrapIOException("[" + insertTxnSQL + "]", e);
                    throw ex;
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertTxnSQL + "]", e);
                    throw ex;
                }
            }
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4172", tid == null ? "loading" : tid.toString());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        Util.close(null, pstmt, null, myex);
    }

    private void upgradeTxnAcks(Connection conn) throws BrokerException {
        if (this.oldStoreVersion == 400) {
            return;
        }
        ConsumerStateDAO stateDAO = this.dbMgr.getDAOFactory().getConsumerStateDAO();
        String getAllTxnAcksFromOldSQL = "SELECT atbl.TUID, TXNACK FROM " + this.oldTxnTable + " ttbl, " + this.oldAckTable + " atbl" + " WHERE ttbl." + "TUID" + " = atbl." + "TUID";
        String insertTxnAckSQL = new StringBuffer(128).append("UPDATE ").append(stateDAO.getTableName()).append(" SET ").append("TRANSACTION_ID").append(" = ? ").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates() && !this.dbMgr.isHADB();
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        TransactionUID tid = null;
        Exception myex = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertTxnAckSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllTxnAcksFromOldSQL);
            while (rs.next()) {
                long id = rs.getLong(1);
                tid = new TransactionUID(id);
                TransactionAcknowledgement ack = (TransactionAcknowledgement)Util.readObject(rs, 2);
                try {
                    pstmt.setLong(1, id);
                    pstmt.setString(2, ack.getSysMessageID().toString());
                    pstmt.setLong(3, ack.getStoredConsumerUID().longValue());
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertTxnAckSQL + "]", e);
                    throw ex;
                }
            }
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
            if (this.store.upgradeNoBackup()) {
                this.dropTable(conn, this.oldTxnTable);
                this.dropTable(conn, this.oldAckTable);
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4173", tid == null ? "loading" : tid.toString());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        Util.close(null, pstmt, null, myex);
    }

    private void upgradeChangeRecords(Connection conn) throws BrokerException {
        ConfigRecordDAO recordDAO = this.dbMgr.getDAOFactory().getConfigRecordDAO();
        StringBuffer strBuf = new StringBuffer(128).append("SELECT ").append("RECORD").append(", ");
        if (this.oldStoreVersion == 400) {
            strBuf.append("CREATED_TS");
        } else {
            strBuf.append("RECORDTIME");
        }
        strBuf.append(" FROM ").append(this.oldConfigRecordTable);
        String getAllRecordFromOldSQL = strBuf.toString();
        String insertRecordSQL = new StringBuffer(128).append("INSERT INTO ").append(recordDAO.getTableName()).append(" ( ").append("RECORD").append(", ").append("CREATED_TS").append(") VALUES ( ?, ? )").toString();
        PreparedStatement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        Long recordTS = null;
        Exception myex = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertRecordSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllRecordFromOldSQL);
            while (rs.next()) {
                byte[] rec = Util.readBytes(rs, 1);
                long ts = rs.getLong(2);
                recordTS = ts;
                try {
                    Util.setBytes(pstmt, 1, rec);
                    pstmt.setLong(2, ts);
                    pstmt.executeUpdate();
                }
                catch (IOException e) {
                    IOException ex = DBManager.wrapIOException("[" + insertRecordSQL + "]", e);
                    throw ex;
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertRecordSQL + "]", e);
                    throw ex;
                }
            }
            conn.commit();
            if (this.store.upgradeNoBackup()) {
                this.dropTable(conn, this.oldConfigRecordTable);
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4171", recordTS == null ? "loading" : recordTS.toString());
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        Util.close(null, pstmt, null, myex);
    }

    private void upgradeProperties(Connection conn) throws BrokerException {
        PropertyDAO propDAO = this.dbMgr.getDAOFactory().getPropertyDAO();
        String getAllPropFromOldSQL = "SELECT PROPNAME, PROPVALUE FROM " + this.oldPropTable;
        String insertPropSQL = new StringBuffer(128).append("INSERT INTO ").append(propDAO.getTableName()).append(" ( ").append("PROPNAME").append(", ").append("PROPVALUE").append(") VALUES ( ?, ? )").toString();
        boolean dobatch = this.dbMgr.supportsBatchUpdates();
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String name = null;
        Exception myex = null;
        try {
            pstmt = DBManager.createPreparedStatement(conn, insertPropSQL);
            stmt = conn.createStatement();
            rs = DBManager.executeQueryStatement(stmt, getAllPropFromOldSQL);
            while (rs.next()) {
                name = rs.getString(1);
                Object value = Util.readObject(rs, 2);
                try {
                    pstmt.setString(1, name);
                    Util.setObject(pstmt, 2, value);
                    if (dobatch) {
                        pstmt.addBatch();
                        continue;
                    }
                    pstmt.executeUpdate();
                }
                catch (IOException e) {
                    IOException ex = DBManager.wrapIOException("[" + insertPropSQL + "]", e);
                    throw ex;
                }
                catch (SQLException e) {
                    SQLException ex = DBManager.wrapSQLException("[" + insertPropSQL + "]", e);
                    throw ex;
                }
            }
            if (dobatch) {
                pstmt.executeBatch();
            }
            conn.commit();
            if (this.store.upgradeNoBackup()) {
                this.dropTable(conn, this.oldPropTable);
            }
        }
        catch (Exception e) {
            try {
                myex = e;
                String errorMsg = this.br.getKString("B4170", name == null ? "loading" : name);
                this.logger.logStack(32, errorMsg, (Throwable)e);
                throw new BrokerException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Util.close(rs, stmt, null, myex);
                Util.close(null, pstmt, null, myex);
                throw throwable;
            }
        }
        Util.close(rs, stmt, null, myex);
        Util.close(null, pstmt, null, myex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(Connection conn, String table) throws BrokerException {
        String sql = "DROP TABLE " + table;
        Statement stmt = null;
        SQLException myex = null;
        try {
            stmt = conn.createStatement();
            DBManager.executeUpdateStatement(stmt, sql);
            conn.commit();
            if (Store.getDEBUG()) {
                Globals.getLogger().log(4, "Dropped table " + table);
            }
        }
        catch (SQLException e) {
            myex = e;
            Globals.getLogger().log(32, "B1117", (Object)table, (Throwable)DBManager.wrapSQLException("[" + sql + "]", e));
        }
        finally {
            Util.close(null, stmt, null, myex);
        }
    }

    private void clearTable(Connection conn, String table) throws BrokerException {
        String sql = "DELETE FROM " + table;
        Statement stmt = null;
        SQLException myex = null;
        try {
            stmt = conn.createStatement();
            int numdeleted = DBManager.executeUpdateStatement(stmt, sql);
            conn.commit();
            if (Store.getDEBUG()) {
                Globals.getLogger().log(4, "Deleted " + numdeleted + " entries in " + table);
            }
        }
        catch (SQLException e) {
            myex = e;
            SQLException ex = DBManager.wrapSQLException("[" + sql + "]", e);
            String errorMsg = Globals.getBrokerResources().getString("B4174", table);
            Globals.getLogger().log(32, errorMsg, (Throwable)ex);
            throw new BrokerException(errorMsg, ex);
        }
        finally {
            Util.close(null, stmt, null, myex);
        }
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }
}

