/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketDispatcher;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.IMQBlockingQueue;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.HandOffQueue;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Queue;
import javax.jms.JMSException;

public class IMQDualThreadConnection
extends IMQBasicConnection
implements DirectBrokerConnection {
    DummyQueue inputQueue;
    ThreadLocal<Queue<Packet>> replies = new ThreadLocal();
    IMQBlockingQueue outputQueue;
    PacketDispatcher replyDispatcher;
    String localsvcstring = null;

    public IMQDualThreadConnection(Service svc, PacketRouter router) throws IOException, BrokerException {
        super(svc, router);
        this.inputQueue = new DummyQueue();
        this.outputQueue = new IMQBlockingQueue();
        this.setConnectionState(0);
    }

    @Override
    public boolean setConnectionState(int state) {
        this.state = state;
        if (this.state >= 6) {
            return false;
        }
        if (state == 4) {
            this.logConnectionInfo(false);
        }
        return true;
    }

    @Override
    public HandOffQueue getClientToBrokerQueue() {
        return this.inputQueue;
    }

    @Override
    public HandOffQueue getBrokerToClientQueue() {
        return this.outputQueue;
    }

    public void putReply(Packet packet) {
        Queue<Packet> packets = this.replies.get();
        if (packets == null) {
            packets = new LinkedList<Packet>();
            this.replies.set(packets);
        }
        packets.add(packet);
        try {
            this.replyDispatcher.dispatch((ReadWritePacket)packet);
        }
        catch (JMSException e) {
            this.logger.logStack(32, "Error dispatching reply packet " + packet, (Throwable)e);
        }
    }

    public Packet fetchReply() {
        Queue<Packet> packets = this.replies.get();
        return packets.poll();
    }

    @Override
    public void checkState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startConnection() {
        super.startConnection();
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            for (Session session : this.sessions.values()) {
                while (session.isBusy()) {
                    Packet emptyPacket = new Packet();
                    session.fillNextPacket(emptyPacket);
                    this.writePacket(emptyPacket, false);
                }
            }
        }
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    public void setFlowCount() {
    }

    @Override
    public void haltFlow() {
    }

    @Override
    public void resumeFlow(int cnt) {
    }

    @Override
    public void cleanupControlPackets(boolean shutdown) {
    }

    @Override
    public boolean useDirectBuffers() {
        return true;
    }

    @Override
    protected void checkConnection() {
    }

    @Override
    protected void flushConnection(long timeout) {
    }

    @Override
    public void logConnectionInfo(boolean closing) {
        this.logConnectionInfo(closing, "Unknown");
    }

    public void logConnectionInfo(boolean closing, String reason) {
        Object[] args = new String[]{this.getRemoteConnectionString(), this.localServiceString(), Integer.toString(Globals.getConnectionManager().size()), reason, "0", Integer.toString(this.service.size())};
        if (!closing) {
            this.logger.log(8, "B1065", args);
        } else {
            this.logger.log(8, "B1066", args);
        }
    }

    public void processReadPacket(Packet p) {
        ++this.msgsIn;
        if (p.getPacketType() < 80) {
            int n = p.getPacketType();
            this.pktsIn[n] = this.pktsIn[n] + 1;
        }
        if (DEBUG || DUMP_PACKET || IN_DUMP_PACKET) {
            int flag = DUMP_PACKET || IN_DUMP_PACKET ? 8 : 1;
            this.logger.log(flag, "\n------------------------------\nReceived incoming Packet - Dumping\nConnection: " + this + "\n------------------------------" + "\n" + p.dumpPacketString(">>>>****") + "\n------------------------------");
        }
        this.router.handleMessage(this, p);
    }

    public boolean isDirectBuffers() {
        return false;
    }

    @Override
    public void sendControlMessage(Packet p) {
        if (p.getPacketType() > 6) {
            p.setIP(ipAddress);
            p.setPort(0);
        }
        this.writePacket(p, true);
    }

    public void writePacket(Packet p, boolean control) {
        int flag;
        if (control) {
            if (DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
                flag = DUMP_PACKET || OUT_DUMP_PACKET ? 8 : 1;
                this.logger.log(flag, "\n------------------------------\nSending Control Packet - Dumping\n------------------------------\n" + p.dumpPacketString("<<<<****") + "\n------------------------------");
            }
        } else if (DEBUG || DUMP_PACKET || OUT_DUMP_PACKET) {
            flag = DUMP_PACKET || OUT_DUMP_PACKET ? 8 : 1;
            this.logger.log(flag, "\n------------------------------\nSending JMS Message - Dumping\n------------------------------\n" + p.dumpPacketString("<<<<****") + "\n------------------------------");
        }
        int n = p.getPacketType();
        this.pktsOut[n] = this.pktsOut[n] + 1;
        try {
            ReadWritePacket rp = new ReadWritePacket();
            rp.fill(p, !control);
            if (Globals.getAPIDirectTwoThreadSyncReplies() && rp.isReply() && rp.getPacketType() != 23) {
                this.putReply((Packet)rp);
            } else {
                this.outputQueue.add(rp);
            }
        }
        catch (IOException ex) {
            this.logger.log(4, "Unable to duplicate packet ", (Throwable)ex);
        }
    }

    public void eventOccured(EventType type, Reason r, Object target, Object oldval, Object newval, Object userdata) {
        Session s = (Session)target;
        if (!this.runningMsgs) {
            return;
        }
        while (s.isBusy()) {
            Packet emptyPacket = new Packet();
            s.fillNextPacket(emptyPacket);
            this.writePacket(emptyPacket, false);
        }
    }

    @Override
    public synchronized Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        ht.put("transport", "Embedded2");
        ht.put("inputQueue", this.inputQueue.toString());
        ht.put("outputQueue", this.outputQueue.toString());
        return ht;
    }

    @Override
    public String getRemoteConnectionString() {
        String userString;
        boolean userset;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            userset = false;
            userString = "???";
            if (this.state >= 4) {
                try {
                    Principal principal = this.getAuthenticatedName();
                    if (principal != null) {
                        userString = principal.getName();
                        userset = true;
                    }
                }
                catch (BrokerException e) {
                    if (!DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + (Object)((Object)this.conId), (Throwable)e);
                }
            }
        }
        String retstr = userString + "@" + "Direct2" + ":" + (Object)((Object)this.getConnectionUID());
        if (userset) {
            this.remoteConString = retstr;
        }
        return retstr;
    }

    @Override
    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        this.localsvcstring = this.service.getName();
        return this.localsvcstring;
    }

    @Override
    public synchronized void closeConnection(boolean force, int reason, String reasonStr) {
        this.notifyConnectionClosed();
    }

    public void setReplyDispatcher(PacketDispatcher rd) {
        this.replyDispatcher = rd;
    }

    class DummyQueue<Packet>
    implements HandOffQueue<Packet> {
        DummyQueue() {
        }

        @Override
        public Packet take() throws InterruptedException {
            return null;
        }

        @Override
        public void put(Packet p) throws InterruptedException {
            IMQDualThreadConnection.this.processReadPacket((Packet)p);
        }

        @Override
        public void close() {
        }
    }
}

