/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.io.BigPacketException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQConnectionFilter;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQPacket;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyMQPacketList;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.NullaryFunction;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.BufferInputStream;
import org.glassfish.grizzly.utils.BufferOutputStream;

public class GrizzlyMQPacketFilter
extends BaseFilter {
    private static boolean DEBUG = false;
    private final Attribute<PacketParseState> parsestateAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyMQPacketFilter.class + ".parsestateAttr", (NullaryFunction)new NullaryFunction<PacketParseState>(){

        public PacketParseState evaluate() {
            return new PacketParseState();
        }
    });
    private final Attribute<GrizzlyMQIPConnection> connAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyMQConnectionFilter.GRIZZLY_MQIPCONNECTION_ATTR);
    private Logger logger = Globals.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        GrizzlyMQPacketList packetList = GrizzlyMQPacketList.create();
        Connection c = ctx.getConnection();
        Buffer buf = (Buffer)ctx.getMessage();
        PacketParseState parsestate = (PacketParseState)this.parsestateAttr.get((AttributeStorage)c);
        while (buf.hasRemaining()) {
            GrizzlyMQIPConnection conn;
            int pos;
            int buflen = buf.remaining();
            if (DEBUG) {
                this.logger.log(8, "[@" + c.hashCode() + "]buflen=" + buflen + ", gotpsize=" + parsestate.gotpsize + ", psize=" + parsestate.psize + ", pos=" + buf.position());
            }
            if (!parsestate.gotpsize) {
                if (buflen < 72) {
                    if (!DEBUG) break;
                    this.logger.log(8, "[@" + c.hashCode() + "] not enough for header size " + 72);
                    break;
                }
                pos = buf.position();
                parsestate.psize = GrizzlyMQPacket.parsePacketSize(buf);
                buf.position(pos);
                parsestate.gotpsize = true;
            }
            if (buflen < parsestate.psize) {
                if (!DEBUG) break;
                this.logger.log(8, "[@" + c.hashCode() + "] not enough for packet size " + parsestate.psize);
                break;
            }
            if (DEBUG) {
                this.logger.log(8, "[@" + c.hashCode() + "]reading packet at pos=" + buf.position() + ", size=" + parsestate.psize);
            }
            pos = buf.position();
            GrizzlyMQPacket pkt = null;
            BufferInputStream bis = null;
            try {
                pkt = new GrizzlyMQPacket(false);
                pkt.generateSequenceNumber(false);
                pkt.generateTimestamp(false);
                bis = new BufferInputStream(buf);
                pkt.readPacket((InputStream)bis);
                if (DEBUG) {
                    this.logger.log(8, "[@" + c.hashCode() + "]read packet: " + (Object)((Object)pkt) + ", pre-pos=" + pos);
                }
                packetList.getPackets().add(pkt);
            }
            catch (OutOfMemoryError err) {
                Globals.handleGlobalError(err, Globals.getBrokerResources().getKString("B0018") + ": " + (pkt == null ? "null" : pkt.headerToString()));
                buf.position(pos);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                continue;
            }
            catch (BigPacketException e) {
                conn = (GrizzlyMQIPConnection)this.connAttr.get((AttributeStorage)c);
                conn.handleBigPacketException(pkt, e);
            }
            catch (IllegalArgumentException e) {
                conn = (GrizzlyMQIPConnection)this.connAttr.get((AttributeStorage)c);
                conn.handleIllegalArgumentExceptionPacket(pkt, e);
            }
            finally {
                if (bis == null) continue;
                bis.close();
                continue;
            }
            buf.position(pos + parsestate.psize);
            parsestate.reset();
        }
        if (packetList.getPackets().isEmpty()) {
            packetList.recycle(false);
            return ctx.getStopAction((Object)buf);
        }
        Buffer remainder = buf.hasRemaining() ? buf.split(buf.position()) : null;
        packetList.setPacketsBuffer(buf);
        ctx.setMessage((Object)packetList);
        if (DEBUG) {
            this.logger.log(8, "[@" + c.hashCode() + "]handleRead.return: " + (remainder == null ? "no remainder" : "remainer=" + remainder.hasRemaining() + ", remaining=" + remainder.remaining()));
        }
        return ctx.getInvokeAction((Object)remainder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Packet packet = (Packet)ctx.getMessage();
        MemoryManager mm = ctx.getConnection().getTransport().getMemoryManager();
        try (BufferOutputStream bos = null;){
            bos = new BufferOutputStream(mm);
            packet.writePacket((OutputStream)bos);
            bos.close();
            Buffer buf = bos.getBuffer();
            buf.trim();
            buf.allowBufferDispose(true);
            if (buf.isComposite()) {
                ((CompositeBuffer)buf).allowInternalBuffersDispose(true);
            }
            ctx.setMessage((Object)buf);
            NextAction nextAction = ctx.getInvokeAction();
            return nextAction;
        }
    }

    static final class PacketParseState {
        boolean gotpsize = false;
        int psize = -1;

        PacketParseState() {
        }

        void reset() {
            this.gotpsize = false;
            this.psize = -1;
        }
    }
}

