/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.pool.BasicRunnable;
import com.sun.messaging.jmq.jmsserver.pool.ThreadPool;
import com.sun.messaging.jmq.jmsserver.service.imq.group.SelectThread;
import java.io.IOException;
import java.util.Hashtable;

public class GroupRunnable
extends BasicRunnable {
    SelectThread selthr = null;
    protected int ioevents = 0;
    Object threadUpdateLock = new Object();
    boolean paused = false;

    public GroupRunnable(int id, ThreadPool pool) {
        super(id, pool);
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        if (this.selthr == null) {
            ht.put("selthr", "empty");
        } else {
            ht.put("selthr", this.selthr.getDebugState());
        }
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignThread(SelectThread selthr, int events) throws IOException {
        Object object = this.threadUpdateLock;
        synchronized (object) {
            if (this.selthr != null) {
                throw new IOException(Globals.getBrokerResources().getKString("B4117", "Error trying to assign " + selthr + " to  group runnable " + this));
            }
            this.selthr = selthr;
            selthr.assign(this);
            this.ioevents = events;
            this.assigned();
        }
    }

    @Override
    public String toString() {
        return "GroupRun[id =" + this.id + ", ioevents=" + this.ioevents + ", behavior=" + GroupRunnable.behaviorToString(this.behavior) + ", selthr={" + this.selthr + "}, state=" + this.stateToString(this.state) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeThread() {
        Object object = this.threadUpdateLock;
        synchronized (object) {
            if (this.selthr != null) {
                this.selthr.free(this);
                this.selthr = null;
                this.ioevents = 0;
                this.release();
            }
        }
    }

    @Override
    public void suspend() {
        super.suspend();
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        super.resume();
        GroupRunnable groupRunnable = this;
        synchronized (groupRunnable) {
            this.paused = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() throws IOException {
        boolean OK = false;
        GroupRunnable groupRunnable = this;
        synchronized (groupRunnable) {
            while (this.paused) {
                try {
                    this.wait();
                }
                catch (Exception ex) {}
            }
        }
        Exception err = null;
        try {
            if (this.selthr != null) {
                this.selthr.processThread();
            }
            OK = true;
        }
        catch (NullPointerException ex) {
            if (this.selthr != null && this.selthr.isValid()) {
                this.logger.logStack(16, "B3100", (Object)this.selthr.getSelector().toString(), (Throwable)ex);
            }
            err = ex;
        }
        catch (IOException ex) {
            OK = true;
            err = ex;
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", (Throwable)ex);
            err = ex;
        }
        finally {
            if (!OK) {
                if (err != null) {
                    this.logger.logStack(16, "got an unexpected error " + err + " freeing thread " + this, (Throwable)err);
                }
                this.freeThread();
            }
        }
    }
}

