/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.util.ThreadedTask;
import com.sun.messaging.jmq.util.MQThread;
import java.util.ArrayList;
import java.util.List;

public abstract class ThreadedListProcessor
implements Runnable {
    private Thread thr = null;
    private List list = null;
    private String name = null;
    protected static final long DEFAULT_TIME = 10000L;

    public ThreadedListProcessor() {
        this(null);
    }

    public ThreadedListProcessor(String name) {
        this.name = name == null ? this.toString() : name;
    }

    protected long getLifeTime() {
        return 10000L;
    }

    protected abstract boolean startThreading(ThreadedTask var1);

    protected abstract void process(ThreadedTask var1);

    protected final synchronized void add(ThreadedTask q) {
        if (this.thr == null && this.startThreading(q)) {
            if (this.list == null) {
                this.list = new ArrayList();
            }
            this.thr = new MQThread((Runnable)this, this.name);
            this.thr.start();
        }
        if (this.thr != null) {
            this.list.add(q);
            this.notifyAll();
        } else {
            this.process(q);
        }
    }

    public synchronized void clear() {
        if (this.list != null) {
            this.list.clear();
        }
        this.thr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long time = this.getLifeTime();
        while (true) {
            ThreadedTask entry = null;
            ThreadedListProcessor threadedListProcessor = this;
            synchronized (threadedListProcessor) {
                if (this.thr == null) {
                    break;
                }
                if (this.list.size() == 0) {
                    try {
                        this.wait(time);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (this.list.size() <= 0) {
                    this.thr = null;
                    break;
                }
                entry = (ThreadedTask)this.list.remove(0);
                if (entry != null) {
                    this.process(entry);
                    Thread.currentThread();
                    Thread.yield();
                }
            }
        }
    }
}

