/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.GenericPortMapperClient;
import com.sun.messaging.jmq.management.JMXMQAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Properties;
import javax.management.JMException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class AdminConnectionFactory
extends AdministeredObject {
    private static final String defaultsBase = "AdminConnectionFactory";
    private static final String DEFAULT_IMQ_ADMIN_USERNAME_PASSWORD = "admin";
    private static final String DEFAULT_IMQ_ADMIN_USERNAME_LABEL = "Default Administrator Username";
    private static final String DEFAULT_IMQ_ADMIN_PASSWORD_LABEL = "Default Administrator Password";

    public AdminConnectionFactory() {
        super(defaultsBase);
    }

    protected AdminConnectionFactory(String defaultsBase) {
        super(defaultsBase);
    }

    public JMXConnector createConnection() throws JMException {
        String u = null;
        String p = null;
        try {
            u = this.getCurrentConfiguration().getProperty("imqDefaultAdminUsername");
            p = this.getCurrentConfiguration().getProperty("imqDefaultAdminPassword");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createConnection(u, p);
    }

    public JMXConnector createConnection(String username, String password) throws JMException {
        JMXConnector jmxc = null;
        JMXServiceURL url = null;
        url = this.getJMXServiceURL();
        try {
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            String[] credentials = new String[]{username, password};
            env.put("jmx.remote.credentials", credentials);
            jmxc = JMXConnectorFactory.connect(url, env);
        }
        catch (Exception e) {
            JMException jme = new JMException("Caught exception when creating JMXConnector");
            jme.initCause(e);
            throw jme;
        }
        return jmxc;
    }

    public String toString() {
        return "Oracle GlassFish(tm) Server MQ AdminConnectionFactory" + super.toString();
    }

    public JMXServiceURL getJMXServiceURL() throws JMException {
        JMXServiceURL url;
        GenericPortMapperClient pmc;
        String connectorName;
        int port;
        String host;
        String addr = null;
        try {
            addr = this.getCurrentConfiguration().getProperty("imqAddress");
            JMXMQAddress mqAddr = JMXMQAddress.createAddress(addr);
            host = mqAddr.getHostName();
            port = mqAddr.getPort();
            connectorName = mqAddr.getServiceName();
        }
        catch (Exception e) {
            JMException jme = new JMException("Caught exception when parsing address: " + addr);
            jme.initCause(e);
            throw jme;
        }
        try {
            pmc = new GenericPortMapperClient(host, port);
        }
        catch (Exception e) {
            JMException jme = new JMException("Caught exception when contacing portmapper.");
            jme.initCause(e);
            throw jme;
        }
        String urlString = pmc.getProperty("url", null, "JMX", connectorName);
        if (urlString == null) {
            JMException jme = new JMException("No JMXServiceURL was found for connector " + connectorName + ".\n" + "Address used: " + addr);
            throw jme;
        }
        try {
            url = new JMXServiceURL(urlString);
        }
        catch (MalformedURLException mfe) {
            JMException jme = new JMException("Caught exception when creating JMXServiceURL.");
            jme.initCause(mfe);
            throw jme;
        }
        return url;
    }

    public void setDefaultConfiguration() {
        this.configuration = new Properties();
        this.configurationTypes = new Properties();
        this.configurationLabels = new Properties();
        this.configuration.put("imqDefaultAdminUsername", DEFAULT_IMQ_ADMIN_USERNAME_PASSWORD);
        this.configurationTypes.put("imqDefaultAdminUsername", "java.lang.String");
        this.configurationLabels.put("imqDefaultAdminUsername", DEFAULT_IMQ_ADMIN_USERNAME_LABEL);
        this.configuration.put("imqDefaultAdminPassword", DEFAULT_IMQ_ADMIN_USERNAME_PASSWORD);
        this.configurationTypes.put("imqDefaultAdminPassword", "java.lang.String");
        this.configurationLabels.put("imqDefaultAdminPassword", DEFAULT_IMQ_ADMIN_PASSWORD_LABEL);
    }
}

