/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.core.proxy;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.remote.JMXConnectionNotification;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.AMXProxyHandler;
import org.glassfish.admin.amx.util.AMXDebugHelper;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

@Deprecated
@Taxonomy(stability=Stability.UNCOMMITTED)
public final class ProxyFactory
implements NotificationListener {
    private final MBeanServerConnection mMBeanServerConnection;
    private final String mMBeanServerID;
    private final ObjectName mDomainRootObjectName;
    private final DomainRoot mDomainRoot;
    private final ConcurrentMap<ObjectName, MBeanInfo> mMBeanInfoCache = new ConcurrentHashMap<ObjectName, MBeanInfo>();
    private static final AMXDebugHelper mDebug = new AMXDebugHelper(ProxyFactory.class.getName());
    private static final Map<MBeanServerConnection, ProxyFactory> INSTANCES = Collections.synchronizedMap(new HashMap());
    private static final String DOMAIN_ROOT_KEY = "DomainRoot";

    private static void debug(Object ... args) {
        System.out.println(StringUtil.toString(", ", args));
    }

    private static void warning(Object ... args) {
        ProxyFactory.debug(args);
    }

    private ProxyFactory(MBeanServerConnection conn) {
        mDebug.setEchoToStdOut(true);
        assert (conn != null);
        this.mMBeanServerConnection = conn;
        try {
            this.mMBeanServerID = JMXUtil.getMBeanServerID(conn);
            this.mDomainRootObjectName = AMXGlassfish.DEFAULT.domainRoot();
            if (this.mDomainRootObjectName == null) {
                throw new IllegalStateException("ProxyFactory: AMX has not been started");
            }
            this.mDomainRoot = this.getProxy(this.mDomainRootObjectName, DomainRoot.class);
            try {
                MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
                filter.enableAllObjectNames();
                filter.disableAllTypes();
                filter.enableType("JMX.mbean.unregistered");
                JMXUtil.listenToMBeanServerDelegate(conn, this, filter, null);
            }
            catch (Exception e) {
                ProxyFactory.warning("ProxyFactory: connection does not support notifications: ", this.mMBeanServerID, conn);
            }
        }
        catch (Exception e) {
            ProxyFactory.warning("ProxyFactory.ProxyFactory:\n", e);
            throw new RuntimeException(e);
        }
    }

    private void connectionBad() {
        HashSet proxies = new HashSet();
        for (AMXProxy amx : proxies) {
            AMXProxyHandler proxy = AMXProxyHandler.unwrap(amx);
            proxy.connectionBad();
        }
    }

    public boolean checkConnection() {
        boolean connectionGood = true;
        try {
            this.getMBeanServerConnection().isRegistered(JMXUtil.getMBeanServerDelegateObjectName());
            connectionGood = true;
        }
        catch (Exception e) {
            this.connectionBad();
        }
        return connectionGood;
    }

    void notifsLost() {
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        String type = notifIn.getType();
        if (!type.equals("JMX.mbean.unregistered")) {
            if (notifIn instanceof JMXConnectionNotification) {
                if (type.equals("jmx.remote.connection.closed") || type.equals("jmx.remote.connection.failed")) {
                    ProxyFactory.debug("ProxyFactory.handleNotification: connection closed or failed: ", notifIn);
                    this.connectionBad();
                } else if (type.equals("jmx.remote.connection.notifs.lost")) {
                    ProxyFactory.debug("ProxyFactory.handleNotification: notifications lost: ", notifIn);
                    this.notifsLost();
                }
            } else {
                ProxyFactory.debug("ProxyFactory.handleNotification: UNKNOWN notification: ", notifIn);
            }
        }
    }

    public DomainRoot createDomainRoot() throws IOException {
        return this.mDomainRoot;
    }

    public DomainRoot initDomainRoot() throws IOException {
        ObjectName domainRootObjectName = this.getDomainRootObjectName();
        DomainRoot dr = this.getProxy(domainRootObjectName, DomainRoot.class);
        return dr;
    }

    public ObjectName getDomainRootObjectName() {
        return this.mDomainRootObjectName;
    }

    public DomainRoot getDomainRootProxy() {
        return this.getDomainRootProxy(false);
    }

    public DomainRoot getDomainRootProxy(boolean waitReady) {
        if (waitReady) {
            this.mDomainRoot.waitAMXReady();
        }
        return this.mDomainRoot;
    }

    public String getMBeanServerID() {
        return this.mMBeanServerID;
    }

    public static ProxyFactory getInstance(MBeanServer server) {
        return ProxyFactory.getInstance(server, true);
    }

    public static ProxyFactory getInstance(MBeanServerConnection conn) {
        return ProxyFactory.getInstance(conn, true);
    }

    public static synchronized ProxyFactory getInstance(MBeanServerConnection conn, boolean useMBeanServerID) {
        ProxyFactory instance = ProxyFactory.findInstance(conn);
        if (instance == null) {
            try {
                if (useMBeanServerID) {
                    String id = JMXUtil.getMBeanServerID(conn);
                    instance = ProxyFactory.findInstanceByID(id);
                }
                if (instance == null) {
                    instance = new ProxyFactory(conn);
                    INSTANCES.put(conn, instance);
                }
            }
            catch (Exception e) {
                ProxyFactory.warning("ProxyFactory.getInstance: failure creating ProxyFactory: ", e);
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstance(MBeanServerConnection conn) {
        ProxyFactory instance = null;
        Collection<ProxyFactory> values = INSTANCES.values();
        for (ProxyFactory factory : values) {
            if (factory.getMBeanServerConnection() != conn) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public static synchronized ProxyFactory findInstanceByID(String mbeanServerID) {
        ProxyFactory instance = null;
        Collection<ProxyFactory> values = INSTANCES.values();
        for (ProxyFactory factory : values) {
            if (!factory.getMBeanServerID().equals(mbeanServerID)) continue;
            instance = factory;
            break;
        }
        return instance;
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) {
        try {
            MBeanInfo info = (MBeanInfo)this.mMBeanInfoCache.get(objectName);
            if (info == null && ProxyFactory.invariantMBeanInfo(info = this.getMBeanServerConnection().getMBeanInfo(objectName))) {
                this.mMBeanInfoCache.put(objectName, info);
            }
            return info;
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static boolean invariantMBeanInfo(MBeanInfo info) {
        Descriptor d = info.getDescriptor();
        String value = "" + d.getFieldValue("immutableInfo");
        return Boolean.valueOf(value);
    }

    protected MBeanServerConnection getMBeanServerConnection() {
        return this.mMBeanServerConnection;
    }

    public <T extends AMXProxy> T getProxy(ObjectName objectName, Class<T> intf) {
        MBeanInfo info = this.getMBeanInfo(objectName);
        if (info == null) {
            return null;
        }
        T proxy = this.getProxy(objectName, info, intf);
        return proxy;
    }

    public AMXProxy getProxy(ObjectName objectName) {
        MBeanInfo info = this.getMBeanInfo(objectName);
        if (info == null) {
            return null;
        }
        Class<? extends AMXProxy> intf = ProxyFactory.genericInterface(info);
        AMXProxy proxy = this.getProxy(objectName, info, intf);
        return proxy;
    }

    public static Class<? extends AMXProxy> genericInterface(MBeanInfo info) {
        String intfName = AMXProxyHandler.genericInterfaceName(info);
        Class<AMXProxy> intf = AMXProxy.class;
        if (intfName == null || AMXProxy.class.getName().equals(intfName)) {
            intf = AMXProxy.class;
        } else if (AMXConfigProxy.class.getName().equals(intfName)) {
            intf = AMXConfigProxy.class;
        } else if (intfName.startsWith(AMXProxy.class.getPackage().getName())) {
            try {
                intf = Class.forName(intfName, false, ProxyFactory.class.getClassLoader()).asSubclass(AMXProxy.class);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.getInterfaceClass(): Unable to load interface " + intfName);
            }
        } else {
            intf = AMXProxy.class;
        }
        return intf;
    }

    <T extends AMXProxy> T getProxy(ObjectName objectName, MBeanInfo mbeanInfoIn, Class<T> intfIn) {
        AMXProxy proxy = null;
        try {
            Class<Object> intf;
            MBeanInfo mbeanInfo = mbeanInfoIn;
            if (mbeanInfo == null) {
                mbeanInfo = this.getMBeanInfo(objectName);
            }
            if (AMXProxy.class == (intf = intfIn)) {
                intf = ProxyFactory.genericInterface(mbeanInfoIn);
            }
            AMXProxyHandler handler = new AMXProxyHandler(this.getMBeanServerConnection(), objectName, mbeanInfo);
            proxy = (AMXProxy)Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)handler);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            if (!(rootCause instanceof InstanceNotFoundException)) {
                throw new RuntimeException(e);
            }
            proxy = null;
        }
        return (T)(proxy == null ? null : (AMXProxy)intfIn.cast(proxy));
    }

    protected static String toString(Object o) {
        return "" + o;
    }

    public AMXProxy[] toProxy(ObjectName[] objectNames) {
        AMXProxy[] result = new AMXProxy[objectNames.length];
        for (int i = 0; i < objectNames.length; ++i) {
            result[i] = this.getProxy(objectNames[i]);
        }
        return result;
    }

    public Set<AMXProxy> toProxySet(Set<ObjectName> objectNames) {
        HashSet<AMXProxy> s = new HashSet<AMXProxy>();
        for (ObjectName objectName : objectNames) {
            try {
                AMXProxy proxy = this.getProxy(objectName);
                if (proxy == null) continue;
                s.add(proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return s;
    }

    public Set<AMXProxy> toProxySet(ObjectName[] objectNames, Class<? extends AMXProxy> intf) {
        HashSet<AMXProxy> result = new HashSet<AMXProxy>();
        for (ObjectName objectName : objectNames) {
            AMXProxy proxy = this.getProxy(objectName, intf);
            if (proxy == null) continue;
            result.add(proxy);
        }
        return result;
    }

    public List<AMXProxy> toProxyList(Collection<ObjectName> objectNames) {
        ArrayList<AMXProxy> list = new ArrayList<AMXProxy>();
        for (ObjectName objectName : objectNames) {
            try {
                AMXProxy proxy = this.getProxy(objectName);
                if (proxy == null) continue;
                list.add(proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return list;
    }

    public Map<String, AMXProxy> toProxyMap(Map<String, ObjectName> objectNameMap) {
        HashMap<String, AMXProxy> resultMap = new HashMap<String, AMXProxy>();
        for (Map.Entry<String, ObjectName> me : objectNameMap.entrySet()) {
            ObjectName objectName = me.getValue();
            try {
                AMXProxy proxy = this.getProxy(objectName);
                if (proxy == null) continue;
                resultMap.put(me.getKey(), proxy);
            }
            catch (Exception e) {
                ProxyFactory.debug("ProxyFactory.toProxySet: exception for MBean ", objectName, " = ", ExceptionUtil.getRootCause(e));
            }
        }
        return resultMap;
    }

    public Map<String, AMXProxy> toProxyMap(ObjectName[] objectNames, Class<? extends AMXProxy> intf) {
        HashMap<String, AMXProxy> resultMap = new HashMap<String, AMXProxy>();
        for (ObjectName objectName : objectNames) {
            String key = Util.unquoteIfNeeded(objectName.getKeyProperty("name"));
            AMXProxy proxy = this.getProxy(objectName, intf);
            if (proxy == null) continue;
            resultMap.put(key, proxy);
        }
        return resultMap;
    }

    public List<AMXProxy> toProxyList(ObjectName[] objectNames, Class<? extends AMXProxy> intf) {
        ArrayList<AMXProxy> result = new ArrayList<AMXProxy>();
        for (ObjectName objectName : objectNames) {
            AMXProxy proxy = this.getProxy(objectName, intf);
            if (proxy == null) continue;
            result.add(proxy);
        }
        return result;
    }
}

