/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SecureAdminHelper;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.security.SecurityUpgradeService;
import com.sun.enterprise.security.admin.cli.EnableSecureAdminCommand;
import com.sun.enterprise.security.admin.cli.SecureAdminUpgradeHelper;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.net.NetUtils;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.GrizzlyConfigSchemaMigrator;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class SecureAdminConfigUpgrade
extends SecureAdminUpgradeHelper
implements ConfigurationUpgrade,
PostConstruct {
    private static final String ADMIN_LISTENER_NAME = "admin-listener";
    private static final String ASADMIN_LISTENER_PORT = "${ASADMIN_LISTENER_PORT}";
    private static final String ASADMIN_LISTENER_TRANSPORT = "tcp";
    private static final String ASADMIN_LISTENER_THREADPOOL = "http-thread-pool";
    private static final String ASADMIN_VS_NAME = "__asadmin";
    private static final Logger logger = Logger.getAnonymousLogger();
    @Inject
    private GrizzlyConfigSchemaMigrator grizzlyMigrator;
    @Inject
    private SecurityUpgradeService securityUpgradeService;
    @Inject
    private Configs configs;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private MasterPassword masterPassword;
    private Map<String, Config> writableConfigs = new HashMap<String, Config>();
    private static String CERTIFICATE_DN_PREFIX = "CN=";
    private static String CERTIFICATE_DN_SUFFIX = ",OU=GlassFish,O=Oracle Corporation,L=Santa Clara,ST=California,C=US";
    private static final String INSTANCE_CN_SUFFIX = "-instance";

    @Override
    public void postConstruct() {
        if (Globals.getDefaultHabitat() == null) {
            Globals.setDefaultHabitat((ServiceLocator)this.habitat);
        }
        String stage = null;
        try {
            stage = "adding admin-listener to non-DAS configuration";
            this.ensureNonDASConfigsHaveAdminNetworkListener();
            logger.log(Level.INFO, "Added admin-listener network listeners to non-DAS configurations");
            stage = "upgrading config for secure DAS-to-instance admin traffic";
            this.setupNewDefaultConfig();
            if (this.requiresSecureAdmin()) {
                EnableSecureAdminCommand enableSecureAdminCommand = this.habitat.getService(EnableSecureAdminCommand.class, new Annotation[0]);
                stage = "upgrading secure admin set-up";
                try {
                    enableSecureAdminCommand.run();
                    logger.log(Level.INFO, "Upgraded secure admin set-up");
                }
                catch (SecureAdminHelper.SecureAdminCommandException ex) {
                    logger.log(Level.INFO, "Attempt to upgrade secure admin set-up failed", ex);
                    throw ex;
                }
            } else {
                logger.log(Level.INFO, "No secure admin set-up was detected in the original configuration so no upgrade of it was needed");
            }
            this.commit();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error " + stage, ex);
            this.rollback();
        }
    }

    private void setupNewDefaultConfig() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException, ProcessManagerException, TransactionFailure, RetryableException, PropertyVetoException {
        this.ensureKeyPairForInstanceAlias();
        this.ensureSecureAdminReady();
        this.prepareDASConfig();
    }

    private boolean requiresSecureAdmin() {
        return this.isOriginalAdminSecured() || this.securityUpgradeService.requiresSecureAdmin();
    }

    private void prepareDASConfig() throws TransactionFailure, PropertyVetoException {
        Config dasConfig = this.writableConfig(this.configs.getConfigByName("server-config"));
        NetworkConfig nc = dasConfig.getNetworkConfig();
        NetworkListener nl_w = (NetworkListener)this.transaction().enroll((ConfigBeanProxy)nc.getNetworkListener(ADMIN_LISTENER_NAME));
        nl_w.setProtocol(ADMIN_LISTENER_NAME);
    }

    private void ensureConfigReady(Config c, String adminListenerProtocol) throws TransactionFailure, PropertyVetoException {
        NetworkConfig nc = c.getNetworkConfig();
        NetworkListener nl = nc.getNetworkListener(ADMIN_LISTENER_NAME);
        if (nl != null) {
            return;
        }
        Config config_w = this.writableConfig(c);
        this.createAdminNetworkListener(this.transaction(), nc, adminListenerProtocol);
        this.createAdminVirtualServer(this.transaction(), config_w);
    }

    private Config writableConfig(Config c) throws TransactionFailure {
        Config result = this.writableConfigs.get(c.getName());
        if (result == null) {
            result = (Config)this.transaction().enroll((ConfigBeanProxy)c);
            this.writableConfigs.put(c.getName(), result);
        }
        return result;
    }

    private void ensureNonDASConfigsHaveAdminNetworkListener() throws TransactionFailure, PropertyVetoException {
        for (Config c : this.configs.getConfig()) {
            if (c.getName().equals("server-config")) continue;
            this.ensureConfigReady(c, "pu-protocol");
        }
    }

    private NetworkListener createAdminNetworkListener(Transaction t, NetworkConfig nc, String adminListenerProtocolName) throws TransactionFailure {
        NetworkListeners nls_w = (NetworkListeners)t.enroll((ConfigBeanProxy)nc.getNetworkListeners());
        NetworkListener nl_w = (NetworkListener)nls_w.createChild(NetworkListener.class);
        nls_w.getNetworkListener().add(nl_w);
        nl_w.setName(ADMIN_LISTENER_NAME);
        nl_w.setProtocol(adminListenerProtocolName);
        nl_w.setPort(ASADMIN_LISTENER_PORT);
        nl_w.setTransport(ASADMIN_LISTENER_TRANSPORT);
        nl_w.setThreadPool(ASADMIN_LISTENER_THREADPOOL);
        return nl_w;
    }

    private VirtualServer createAdminVirtualServer(Transaction t, Config config_w) throws TransactionFailure, PropertyVetoException {
        HttpService hs_w = (HttpService)t.enroll((ConfigBeanProxy)config_w.getHttpService());
        VirtualServer vs_w = (VirtualServer)hs_w.createChild(VirtualServer.class);
        hs_w.getVirtualServer().add(vs_w);
        vs_w.setId(ASADMIN_VS_NAME);
        vs_w.setNetworkListeners(ADMIN_LISTENER_NAME);
        return vs_w;
    }

    private boolean isOriginalAdminSecured() {
        Config serverConfig = this.configs.getConfigByName("server-config");
        if (serverConfig == null) {
            return false;
        }
        NetworkConfig nc = serverConfig.getNetworkConfig();
        if (nc == null) {
            return false;
        }
        Protocol p = nc.findProtocol(ADMIN_LISTENER_NAME);
        if (p == null) {
            return false;
        }
        Ssl ssl = p.getSsl();
        return ssl != null;
    }

    private void ensureKeyPairForInstanceAlias() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException, ProcessManagerException {
        KeyStore ks = this.sslUtils().getKeyStore();
        if (ks.containsAlias("glassfish-instance")) {
            return;
        }
        File keyStoreFile = this.serverEnv.getJKS();
        File trustStoreFile = new File(this.serverEnv.getConfigDirPath(), "cacerts.jks");
        String pw = this.masterPassword();
        ProcessManager pm = new ProcessManager(new String[]{"keytool", "-genkey", "-keyalg", "RSA", "-keystore", keyStoreFile.getAbsolutePath(), "-alias", "glassfish-instance", "-dname", this.getCertificateDN(), "-validity", "3650", "-keypass", pw, "-storepass", pw});
        pm.execute();
        if (pm.getExitValue() != 0) {
            String err = pm.getStdout();
            throw new RuntimeException(err);
        }
        File tempCertFile = new File(this.serverEnv.getConfigDirPath(), "temp.cer");
        tempCertFile.deleteOnExit();
        pm = new ProcessManager(new String[]{"keytool", "-exportcert", "-keystore", keyStoreFile.getAbsolutePath(), "-alias", "glassfish-instance", "-keypass", pw, "-storepass", pw, "-file", tempCertFile.getAbsolutePath()});
        pm.execute();
        if (pm.getExitValue() != 0) {
            throw new RuntimeException(pm.getStderr());
        }
        pm = new ProcessManager(new String[]{"keytool", "-importcert", "-noprompt", "-trustcacerts", "-storepass", pw, "-keypass", pw, "-keystore", trustStoreFile.getAbsolutePath(), "-file", tempCertFile.getAbsolutePath(), "-alias", "glassfish-instance"});
        pm.execute();
        if (!tempCertFile.delete()) {
            logger.log(Level.FINE, "Unable to delete temp file {0}; continuing", tempCertFile.getAbsolutePath());
        }
        if (pm.getExitValue() != 0) {
            throw new RuntimeException(pm.getStderr());
        }
        this.reload(this.sslUtils().getKeyStore(), keyStoreFile, pw);
        this.reload(this.sslUtils().getTrustStore(), this.serverEnv.getTrustStore(), pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(KeyStore keystore, File keystoreFile, String pw) throws FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream is = null;){
            is = new BufferedInputStream(new FileInputStream(keystoreFile));
            keystore.load(is, pw.toCharArray());
        }
    }

    private String masterPassword() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String masterPWFromPWFile;
        String masterPW = "changeit";
        String pwFileArg = this.startupArg("-passwordfile");
        if (pwFileArg != null && (masterPWFromPWFile = this.pwProps(pwFileArg).getProperty("AS_ADMIN_MASTERPASSWORD")) != null) {
            masterPW = masterPWFromPWFile;
        }
        return masterPW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties pwProps(String pwFilePath) throws IOException {
        Properties result = new Properties();
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(pwFilePath));
            result.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
            return result;
        }
    }

    private String getCertificateDN() throws UnknownHostException {
        String cn;
        try {
            cn = NetUtils.getCanonicalHostName();
        }
        catch (Exception e) {
            cn = "localhost";
        }
        String x509DistinguishedName = CERTIFICATE_DN_PREFIX + cn + INSTANCE_CN_SUFFIX + CERTIFICATE_DN_SUFFIX;
        return x509DistinguishedName;
    }
}

