/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.JMQByteArrayInputStream;
import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class PacketProperties {
    public static final short BOOLEAN = 1;
    public static final short BYTE = 2;
    public static final short SHORT = 3;
    public static final short INTEGER = 4;
    public static final short LONG = 5;
    public static final short FLOAT = 6;
    public static final short DOUBLE = 7;
    public static final short STRING = 8;
    public static final short OBJECT = 9;
    public static final int VERSION1 = 1;

    public static void write(Map map, OutputStream os) throws IOException {
        if (map == null) {
            return;
        }
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(1);
        dos.writeInt(map.size());
        Iterator itr = map.entrySet().iterator();
        Map.Entry pair = null;
        String key = null;
        Object value = null;
        while (itr.hasNext()) {
            pair = itr.next();
            key = (String)pair.getKey();
            value = pair.getValue();
            dos.writeUTF(key);
            if (value instanceof Boolean) {
                dos.writeShort(1);
                dos.writeBoolean((Boolean)value);
                continue;
            }
            if (value instanceof Byte) {
                dos.writeShort(2);
                dos.writeByte(((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Short) {
                dos.writeShort(3);
                dos.writeShort(((Short)value).shortValue());
                continue;
            }
            if (value instanceof Integer) {
                dos.writeShort(4);
                dos.writeInt((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                dos.writeShort(5);
                dos.writeLong((Long)value);
                continue;
            }
            if (value instanceof Float) {
                dos.writeShort(6);
                dos.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                dos.writeShort(7);
                dos.writeDouble((Double)value);
                continue;
            }
            if (value instanceof String) {
                dos.writeShort(8);
                dos.writeUTF(value);
                continue;
            }
            dos.writeShort(9);
            JMQByteArrayOutputStream bos = new JMQByteArrayOutputStream(new byte[256]);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.close();
            byte[] data = bos.getBuf();
            dos.writeInt(data.length);
            dos.write(data, 0, data.length);
        }
    }

    public static Hashtable parseProperties(InputStream is) throws IOException, ClassNotFoundException {
        String key;
        DataInputStream dis = new DataInputStream(is);
        int version = dis.readInt();
        if (version != 1) {
            throw new IOException("Unsupported version of properties serialization [" + version + "]");
        }
        int propcnt = dis.readInt();
        Hashtable<String, String> ht = new Hashtable<String, String>(propcnt);
        for (int cnt = 0; cnt < propcnt && (key = dis.readUTF()).length() > 0; ++cnt) {
            short type = dis.readShort();
            Object value = null;
            switch (type) {
                case 1: {
                    value = dis.readBoolean();
                    break;
                }
                case 2: {
                    value = dis.readByte();
                    break;
                }
                case 3: {
                    value = dis.readShort();
                    break;
                }
                case 4: {
                    value = dis.readInt();
                    break;
                }
                case 5: {
                    value = dis.readLong();
                    break;
                }
                case 6: {
                    value = Float.valueOf(dis.readFloat());
                    break;
                }
                case 7: {
                    value = dis.readDouble();
                    break;
                }
                case 8: {
                    value = dis.readUTF();
                    break;
                }
                case 9: {
                    int bytes = dis.readInt();
                    byte[] buf = new byte[bytes];
                    dis.read(buf, 0, bytes);
                    JMQByteArrayInputStream bis = new JMQByteArrayInputStream(buf);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    value = ois.readObject();
                    ois.close();
                    bis.close();
                }
            }
            ht.put(key, (String)value);
        }
        return ht;
    }
}

