/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io.disk;

import com.sun.messaging.jmq.io.disk.VRFile;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.io.disk.VRecord;
import com.sun.messaging.jmq.io.disk.VRecordMap;
import com.sun.messaging.jmq.resources.SharedResources;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;

public class VRFileMap
extends VRFile {
    static final int EIGHT_K = 8192;
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    protected ArrayList mappedBuffers = new ArrayList(1);
    protected MappedByteBuffer mbuffer = null;
    protected ArrayList startsAt = new ArrayList(1);

    public VRFileMap(File file) {
        this(file, 0xA00000L, false, false);
    }

    public VRFileMap(String name) {
        this(new File(name), 0xA00000L, false, false);
    }

    public VRFileMap(String name, long size, boolean isMinimumWrites, boolean interruptSafe) {
        this(new File(name), size, isMinimumWrites, interruptSafe);
    }

    public VRFileMap(File file, long size, boolean isMinimumWrites, boolean interruptSafe) {
        super(file, size, isMinimumWrites, interruptSafe);
    }

    @Override
    public synchronized void open() throws IOException, VRFileWarning {
        this.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void open(boolean create) throws IOException, VRFileWarning {
        if (this.opened) {
            return;
        }
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel fc = null;
        try {
            raf = new RandomAccessFile(this.backingFile, "rw");
            fc = raf.getChannel();
            long fsize = raf.length();
            if (fsize == 0L) {
                if (!create) return;
                this.initNewFile(raf, (FileChannel)fc);
            } else {
                this.loadFile(raf, (FileChannel)fc);
            }
            this.opened = true;
            this.force();
            if (DEBUG) {
                System.out.println("file version=" + this.fileversion);
                System.out.println("number of allocated buffer loaded " + this.allocated.size());
                System.out.println("number of free buffer loaded " + this.numFree);
                System.out.println("safe=" + this.safe);
                this.printMappedBuffers();
            }
            if (this.warning == null) return;
            throw this.warning;
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (raf != null) {
                raf.close();
            }
        }
    }

    @Override
    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.backingFile + ": closing...");
            System.out.println("filePointer = " + this.filePointer);
            System.out.println("number of allocated buffers =" + this.allocated.size());
            System.out.println("number of free buffers = " + this.numFree);
            this.printMappedBuffers();
        }
        this.force();
        this.mappedBuffers.clear();
        this.startsAt.clear();
        this.mbuffer = null;
        this.reset();
    }

    @Override
    public synchronized int[] getMap() throws IOException {
        if (!this.opened) {
            try {
                this.open(false);
            }
            catch (VRFileWarning w) {
                // empty catch block
            }
        }
        if (this.mappedBuffers.size() == 0) {
            return new int[0];
        }
        int[] map = new int[this.allocated.size() + this.numFree];
        boolean done = false;
        for (int i = 0; i < this.mappedBuffers.size(); ++i) {
            MappedByteBuffer buf = (MappedByteBuffer)this.mappedBuffers.get(i);
            int pos = buf.position();
            int ptr = 0;
            ptr = (Integer)this.startsAt.get(i);
            buf.position(ptr);
            int index = 0;
            while (!done && buf.hasRemaining()) {
                try {
                    buf.getInt();
                    int cap = buf.getInt();
                    int state = this.adjustRecordState(this.fileversion, buf.getShort());
                    if (ptr + cap > buf.remaining()) {
                        state = -1;
                    }
                    switch (state) {
                        case -1: {
                            done = true;
                            break;
                        }
                        case 2: 
                        case 4: {
                            map[index++] = cap;
                            buf.position(ptr + cap);
                            break;
                        }
                        case 1: {
                            map[index++] = 0 - cap;
                            buf.position(ptr + cap);
                            break;
                        }
                        case 1001: {
                            done = true;
                            break;
                        }
                    }
                    ptr += cap;
                }
                catch (BufferUnderflowException e) {
                    e.printStackTrace();
                }
            }
            buf.position(pos);
        }
        return map;
    }

    @Override
    public synchronized VRecord allocate(int size) throws IOException {
        VRecord record;
        this.checkOpenAndWrite();
        int allocateSize = (size + 12 + this.blockSize - 1) / this.blockSize * this.blockSize;
        if (DEBUG) {
            System.out.println("allocating " + allocateSize);
        }
        if ((record = this.findFreeRecord(allocateSize)) != null) {
            record.allocate((short)2);
            if (this.safe) {
                record.force();
            }
            --this.numFree;
            ++this.hits;
            if (DEBUG) {
                System.out.println("allocate(): hit, requested " + size + ", allocated " + record.getCapacity());
            }
        } else {
            if (this.numFree > 0) {
                ++this.misses;
            }
            if (this.mbuffer.remaining() < allocateSize) {
                this.growfile(allocateSize + 12);
            }
            record = this.getNewSlice(allocateSize);
        }
        this.allocated.add(record);
        this.bytesAllocated += (long)record.getCapacity();
        return record;
    }

    @Override
    public synchronized void force() {
        this.checkOpen();
        int size = this.mappedBuffers.size();
        for (int i = 0; i < size; ++i) {
            MappedByteBuffer buf = (MappedByteBuffer)this.mappedBuffers.get(i);
            buf.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear(boolean truncate) throws IOException {
        try (RandomAccessFile raf = null;){
            if (this.opened) {
                MappedByteBuffer buf = (MappedByteBuffer)this.mappedBuffers.get(0);
                buf.position(0);
                this.writeFileHeader(buf);
                buf.put(this.lastRecordHeader);
                buf.force();
                this.mappedBuffers.clear();
                this.allocated.clear();
                this.freeMap.clear();
                buf.clear();
                if (this.fileSize > (long)buf.capacity()) {
                    this.fileSize = buf.capacity();
                    raf = new RandomAccessFile(this.backingFile, "rw");
                    raf.setLength(this.fileSize);
                }
                buf.position(24);
                buf.limit(buf.capacity());
                this.filePointer = 24L;
                this.mappedBuffers.add(buf);
                this.mbuffer = buf;
                this.force();
            } else if (this.backingFile.exists()) {
                raf = new RandomAccessFile(this.backingFile, "rw");
                raf.setLength(0L);
                raf.getChannel().force(false);
            }
        }
    }

    public String toString() {
        return "VRFileMap:" + this.backingFile + ":# of buffers=" + this.allocated.size() + ":# of free buffers=" + this.numFree + ":# of MappedByteBuffer=" + this.mappedBuffers.size();
    }

    private void initNewFile(RandomAccessFile raf, FileChannel fc) throws IOException {
        if (DEBUG) {
            System.out.println("Creating new backing file with initial size " + this.initialFileSize);
        }
        this.fileSize = this.initialFileSize;
        raf.setLength(this.fileSize);
        this.mbuffer = fc.map(FileChannel.MapMode.READ_WRITE, 0L, this.fileSize);
        this.mappedBuffers.add(this.mbuffer);
        this.writeFileHeader(this.mbuffer);
        this.mbuffer.put(this.lastRecordHeader);
        this.mbuffer.position(24);
        this.startsAt.add(24);
        this.filePointer = 24L;
    }

    private void loadFile(RandomAccessFile raf, FileChannel fc) throws IOException {
        byte[] barray;
        int num;
        if (DEBUG) {
            System.out.println("Loading backing file with size " + raf.length());
        }
        if ((num = raf.read(barray = new byte[16])) != 16) {
            throw new IOException(SharedResources.getResources().getString("S3017", this.backingFile));
        }
        short fversion = this.checkFileHeader(ByteBuffer.wrap(barray));
        if (fversion == 2) {
            raf.readLong();
        }
        boolean done = false;
        long offset = 0L;
        long left = raf.length();
        long mapsize = left <= Integer.MAX_VALUE ? left : Integer.MAX_VALUE;
        boolean firstbuf = true;
        while (!done) {
            int added;
            long cut = offset / 8192L * 8192L;
            int bufptr = 0;
            if (left > mapsize) {
                this.mbuffer = fc.map(FileChannel.MapMode.READ_WRITE, cut, mapsize);
                if (firstbuf) {
                    int headeroffset = this.fileversion == 2 ? 24 : 16;
                    this.mbuffer.position(headeroffset);
                    firstbuf = false;
                } else if (cut < offset) {
                    int index = (int)(offset - cut);
                    this.mbuffer.position(index);
                }
                this.startsAt.add(this.mbuffer.position());
                bufptr = this.load(this.mbuffer, false);
                this.mbuffer.limit(bufptr);
                added = bufptr - (int)(offset - cut);
                offset += (long)added;
                left -= (long)added;
            } else {
                if (!firstbuf && left < this.initialFileSize) {
                    long fsize = offset + this.initialFileSize;
                    raf.setLength(fsize);
                    left = this.initialFileSize;
                }
                this.mbuffer = fc.map(FileChannel.MapMode.READ_WRITE, cut, left);
                if (firstbuf) {
                    int headeroffset = this.fileversion == 2 ? 24 : 16;
                    this.mbuffer.position(headeroffset);
                    firstbuf = false;
                } else if (cut < offset) {
                    int index = (int)(offset - cut);
                    this.mbuffer.position(index);
                }
                this.startsAt.add(this.mbuffer.position());
                bufptr = this.load(this.mbuffer, true);
                added = bufptr - (int)(offset - cut);
                this.filePointer = offset + (long)added;
                done = true;
            }
            this.mappedBuffers.add(this.mbuffer);
        }
        this.fileSize = raf.length();
    }

    private int load(MappedByteBuffer mbuf, boolean last) throws StreamCorruptedException, IOException {
        boolean done = false;
        ByteBuffer recordheader = ByteBuffer.wrap(new byte[12]);
        int current = mbuf.position();
        while (!done && mbuf.hasRemaining()) {
            short state = 1;
            ByteBuffer slice = null;
            VRecordMap record = null;
            if (mbuf.remaining() < 12) {
                if (!last) break;
                state = -7;
            } else {
                state = this.checkRecord(mbuf, recordheader);
            }
            switch (state) {
                case 1: 
                case 2: {
                    mbuf.position(current);
                    slice = mbuf.slice();
                    record = new VRecordMap(this, mbuf, slice);
                    int capacity = record.getCapacity();
                    if (state == 2) {
                        this.allocated.add(record);
                        this.bytesAllocated += (long)capacity;
                    } else {
                        this.putFreeList(record, true);
                    }
                    mbuf.position(current += capacity);
                    break;
                }
                case 1001: {
                    mbuf.position(current);
                    done = true;
                    break;
                }
                case -1: {
                    mbuf.position(current);
                    if (!last && current != 0) {
                        done = true;
                        break;
                    }
                    current = this.handleBadRecord((short)-6, recordheader, mbuf, last);
                    mbuf.position(current);
                    break;
                }
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: {
                    mbuf.position(current);
                    current = this.handleBadRecord(state, recordheader, mbuf, last);
                    mbuf.position(current);
                    break;
                }
            }
        }
        return current;
    }

    private short checkRecord(ByteBuffer buf, ByteBuffer recordheader) {
        int position = buf.position();
        int magic = buf.getInt();
        int capacity = buf.getInt();
        short statefromfile = buf.getShort();
        recordheader.rewind();
        recordheader.putInt(magic);
        recordheader.putInt(capacity);
        recordheader.putShort(statefromfile);
        short state = this.adjustRecordState(this.fileversion, statefromfile);
        if (magic != -1431677611) {
            return -2;
        }
        if (state == -3) {
            return state;
        }
        if (state == 1001) {
            if (capacity != 0) {
                return -6;
            }
            return state;
        }
        if (capacity <= 12) {
            return -4;
        }
        if (position + capacity == buf.limit()) {
            return state;
        }
        if ((long)position + (long)capacity > (long)buf.limit()) {
            return -1;
        }
        if (buf.limit() - position - capacity > 4) {
            magic = buf.getInt(position + capacity);
            if (magic != -1431677611) {
                return -5;
            }
            return state;
        }
        return state;
    }

    private int handleBadRecord(short errcode, ByteBuffer h, MappedByteBuffer mbuf, boolean last) throws IOException {
        if (DEBUG) {
            System.out.println("bad record found at " + mbuf.position() + " in " + mbuf);
        }
        int current = mbuf.position();
        int pos = this.findGoodRecord(mbuf);
        mbuf.position(current);
        if (pos == mbuf.limit() && last) {
            if (mbuf.remaining() >= 12) {
                mbuf.put(this.lastRecordHeader);
            } else {
                mbuf.limit(current);
            }
            VRFileMap.addWarning(this.getNewWarning(), errcode, current, h, null);
            return current;
        }
        ByteBuffer slice = mbuf.slice();
        VRecordMap record = new VRecordMap(this, mbuf, slice, pos - current);
        ((VRecord)record).free();
        this.putFreeList(record, true);
        VRFileMap.addWarning(this.getNewWarning(), errcode, current, h, record);
        return pos;
    }

    private VRecord getNewSlice(int size) throws IOException {
        int bytesLeft = this.mbuffer.remaining() - size;
        int newPosition = this.mbuffer.position() + size;
        ByteBuffer buf = this.mbuffer.slice();
        buf.limit(size);
        VRecordMap record = new VRecordMap(this, this.mbuffer, buf, size);
        this.mbuffer.position(newPosition);
        this.filePointer += (long)size;
        if (DEBUG) {
            System.out.println("getNewSlice(" + size + "):");
            System.out.println("Slice at " + (newPosition - size) + " on " + this.mbuffer);
            System.out.println("filePointer advanced to " + this.filePointer);
        }
        this.mbuffer.put(this.lastRecordHeader);
        this.mbuffer.position(newPosition);
        if (this.safe) {
            ((VRecord)record).force();
        }
        return record;
    }

    private void growfile(int needSize) throws IOException {
        if (DEBUG) {
            System.out.println("growfile(): need to grow file; remaining = " + this.mbuffer.remaining() + "; need = " + needSize);
        }
        long newfileSize = 0L;
        newfileSize = this.isThresholdReached() ? (long)((float)this.fileSize + (float)this.getThreshold() * this.getThresholdFactor()) : (long)((float)this.fileSize + (float)this.fileSize * this.getGrowthFactor());
        int remaining = this.mbuffer.remaining() + (int)(newfileSize - this.fileSize);
        while (remaining < needSize) {
            newfileSize = this.isThresholdReached() ? (long)((float)newfileSize + (float)this.getThreshold() * this.getThresholdFactor()) : (long)((float)newfileSize + (float)newfileSize * this.getGrowthFactor());
            remaining = this.mbuffer.remaining() + (int)(newfileSize - this.fileSize);
        }
        long cut = this.filePointer / 8192L * 8192L;
        if (newfileSize - cut > Integer.MAX_VALUE) {
            newfileSize = cut + Integer.MAX_VALUE;
        }
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel fc = null;
        long mapsize = 0L;
        try {
            raf = new RandomAccessFile(this.backingFile, "rw");
            raf.setLength(newfileSize);
            fc = raf.getChannel();
            mapsize = newfileSize - cut;
            MappedByteBuffer newbuf = ((FileChannel)fc).map(FileChannel.MapMode.READ_WRITE, cut, mapsize);
            this.mappedBuffers.add(newbuf);
            if (cut < this.filePointer) {
                int index = (int)(this.filePointer - cut);
                newbuf.position(index);
                this.startsAt.add(index);
            }
            this.mbuffer.limit(this.mbuffer.position());
            if (DEBUG) {
                System.out.println("number of records allocated=" + this.allocated.size());
                System.out.println("growing file from " + this.fileSize + " to " + newfileSize);
                System.out.println("old buffer =" + this.mbuffer);
                System.out.println("new mapped buffer =" + newbuf);
                System.out.println("new mapped buffer starts at " + cut);
                System.out.println("filePointer = " + this.filePointer);
            }
            this.mbuffer = newbuf;
            this.fileSize = newfileSize;
        }
        catch (IOException e) {
            if (DEBUG) {
                System.out.println(e);
                e.printStackTrace();
                System.out.println("file position= " + this.filePointer);
                System.out.println("current file size= " + this.fileSize);
                System.out.println("new file size= " + newfileSize);
                System.out.println("tried to map from " + cut + " for " + mapsize);
                this.printMappedBuffers();
            }
            if (raf != null) {
                raf.setLength(this.fileSize);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (DEBUG) {
                System.out.println(e);
                e.printStackTrace();
                System.out.println("file position= " + this.filePointer);
                System.out.println("current file size= " + this.fileSize);
                System.out.println("new file size= " + newfileSize);
                System.out.println("tried to map from " + cut + " for " + mapsize);
                this.printMappedBuffers();
            }
            throw new IOException(e.getMessage());
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (raf != null) {
                raf.close();
            }
        }
    }

    private int findGoodRecord(MappedByteBuffer buf) {
        int current;
        int start = current = buf.position();
        while (buf.hasRemaining()) {
            try {
                int magic = buf.getInt();
                if (magic == -1431677611) {
                    int capacity = buf.getInt();
                    short state = this.adjustRecordState(this.fileversion, buf.getShort());
                    int nextpos = current + capacity;
                    if (state != -3 && (state == 1001 || capacity > 12)) {
                        if (state == 1001) {
                            if (capacity == 0) {
                                return current;
                            }
                        } else {
                            if (nextpos == buf.limit()) {
                                return current;
                            }
                            if (nextpos > buf.limit() ? current - start > 12 : (magic = buf.getInt(nextpos)) == -1431677611) {
                                return current;
                            }
                        }
                    }
                }
                buf.position(current += 4);
            }
            catch (IndexOutOfBoundsException e) {
                buf.position(buf.limit());
                current = buf.limit();
            }
            catch (BufferUnderflowException e) {
                buf.position(buf.limit());
                current = buf.limit();
            }
        }
        return current;
    }

    private void printMappedBuffers() {
        System.out.println("mapped buffers:");
        for (int i = 0; i < this.mappedBuffers.size(); ++i) {
            System.out.println((MappedByteBuffer)this.mappedBuffers.get(i));
        }
    }
}

