/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceClassElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceFieldElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.RelationshipElementImpl;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.util.LogHelperModel;
import com.sun.jdo.api.persistence.model.util.ModelValidator;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.WeakHashSet;
import com.sun.jdo.spi.persistence.utility.WeakValueHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.migration.archiver.XMLInputStream;
import org.netbeans.modules.dbschema.migration.archiver.XMLOutputStream;

public abstract class Model {
    public static final Model RUNTIME;
    public static final Model ENHANCER;
    public static final String[] NO_ARGS;
    private final Map _classes = new WeakValueHashMap();
    private final Set _nonPCClasses = new WeakHashSet();
    private static List _illegalPrefixes;
    private static List _illegalClasses;
    private static List _scoClasses;
    private static List _mutableScoClasses;
    private static List _collectionClasses;
    public static final String messageBase = "com.sun.jdo.api.persistence.model.Bundle";
    private static final ResourceBundle _messages;

    protected static Model NewModel(String testName, String modelName) {
        Class<?> DynamicClass = null;
        Model model = null;
        try {
            if (testName != null) {
                Class.forName(testName);
            }
            if ((DynamicClass = Class.forName(modelName)) != null) {
                model = (Model)DynamicClass.newInstance();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return model;
    }

    protected static final ResourceBundle getMessages() {
        return _messages;
    }

    protected abstract BufferedInputStream getInputStreamForResource(String var1, ClassLoader var2, String var3);

    public abstract boolean isInterface(String var1);

    public boolean hasPersistentSuperclass(String className) {
        while ((className = this.getSuperclass(className)) != null) {
            if (!this.isPersistent(className)) continue;
            return true;
        }
        return false;
    }

    protected abstract String findPenultimateSuperclass(String var1);

    protected abstract String getSuperclass(String var1);

    public PersistenceClassElement getPersistenceClass(String className) {
        return this.getPersistenceClass(className, null);
    }

    public PersistenceClassElement getPersistenceClass(String className, ClassLoader classLoader) {
        return this.getPersistenceClass(this.getMappingClass(className, classLoader));
    }

    protected PersistenceClassElement getPersistenceClass(MappingClassElement mappingClass) {
        return mappingClass == null ? null : ((MappingClassElementImpl)mappingClass).getPersistenceElement();
    }

    public MappingClassElement getMappingClass(String className) {
        return this.getMappingClass(className, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingClassElement getMappingClass(String className, ClassLoader classLoader) {
        Map map = this._classes;
        synchronized (map) {
            MappingClassElement mappingClass = (MappingClassElement)this._classes.get(className);
            if (mappingClass == null) {
                if (this._nonPCClasses.contains(className)) {
                    return null;
                }
                try {
                    BufferedInputStream stream = this.getInputStreamForResource(className, classLoader, this.getResourceNameWithExtension(className));
                    if (stream != null) {
                        if (((InputStream)stream).available() > 0) {
                            XMLInputStream xmlInput = new XMLInputStream((InputStream)stream, this.getClass().getClassLoader());
                            mappingClass = (MappingClassElement)xmlInput.readObject();
                            xmlInput.close();
                            mappingClass.postUnarchive();
                            this._classes.put(className, mappingClass);
                            mappingClass.setModified(false);
                            this.getPersistenceClass(mappingClass).setModified(false);
                        }
                    } else {
                        this._nonPCClasses.add(className);
                    }
                }
                catch (ModelException e) {
                    LogHelperModel.getLogger().log(900, e.getMessage());
                    return null;
                }
                catch (Exception e) {
                    LogHelperModel.getLogger().log(900, I18NHelper.getMessage(Model.getMessages(), "file.cannot_read", className, e.toString()));
                }
            }
            return mappingClass;
        }
    }

    public Map getMappingCache() {
        return Collections.unmodifiableMap(this._classes);
    }

    public Map getClassLoaderCache() {
        return null;
    }

    public void removeResourcesFromCaches(ClassLoader classLoader) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeResourcesFromCaches(Collection classNames) {
        if (classNames == null) {
            return;
        }
        Map map = this._classes;
        synchronized (map) {
            for (String className : classNames) {
                MappingClassElement mapping = (MappingClassElement)this._classes.get(className);
                if (mapping != null) {
                    SchemaElement.removeFromCache((String)mapping.getDatabaseRoot());
                }
                this._classes.remove(className);
                this._nonPCClasses.remove(className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String className) {
        Map map = this._classes;
        synchronized (map) {
            this._nonPCClasses.remove(className);
        }
    }

    public void storeMappingClass(MappingClassElement mappingClass) throws IOException {
        if (mappingClass != null) {
            String className = mappingClass.getName();
            BufferedOutputStream stream = className == null ? null : this.createFile(className, this.getFileName(className), "mapping");
            this.storeMappingClass(mappingClass, stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMappingClass(MappingClassElement mappingClass, OutputStream stream) throws IOException {
        if (mappingClass != null) {
            String className = mappingClass.getName();
            if (stream != null) {
                XMLOutputStream xmlOutput = new XMLOutputStream(stream);
                try {
                    mappingClass.preArchive();
                    xmlOutput.writeObject((Object)mappingClass);
                    mappingClass.setModified(false);
                    this.getPersistenceClass(mappingClass).setModified(false);
                }
                catch (ModelException e) {
                    LogHelperModel.getLogger().log(900, e.getMessage());
                }
                finally {
                    if (xmlOutput != null) {
                        xmlOutput.close();
                    }
                    this.unlockFile(stream, className);
                }
                return;
            }
            throw new IOException(I18NHelper.getMessage(Model.getMessages(), "file.cannot_save", className));
        }
    }

    public void unlockFile(OutputStream stream, String className) throws IOException {
        this.unlockFile(className);
        if (stream != null) {
            stream.close();
        }
    }

    public void lockFile(String className) throws IOException {
    }

    public void unlockFile(String className) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMappingClass(String className) throws IOException {
        MappingClassElement mappingClass = null;
        Map map = this._classes;
        synchronized (map) {
            mappingClass = (MappingClassElement)this._classes.get(className);
        }
        this.storeMappingClass(mappingClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateKeyForClass(MappingClassElement mappingClass, String oldName) {
        Map map = this._classes;
        synchronized (map) {
            if (oldName != null) {
                this._classes.remove(oldName);
            }
            if (mappingClass != null) {
                String className = mappingClass.getName();
                this._classes.put(className, mappingClass);
                this._nonPCClasses.remove(className);
            }
        }
    }

    public boolean isPersistent(String className) {
        return this.isPersistent(className, (ClassLoader)null);
    }

    public boolean isPersistent(String className, ClassLoader classLoader) {
        return this.getPersistenceClass(className, classLoader) != null;
    }

    public boolean isPersistenceCapableAllowed(String className) {
        int modifier = this.getModifiersForClass(className);
        if (!(Modifier.isStatic(modifier) || Modifier.isAbstract(modifier) || this.isInterface(className) || this.hasPersistentSuperclass(className))) {
            String highestSuperclassName = this.findPenultimateSuperclass(className);
            Iterator iterator = _illegalPrefixes.iterator();
            while (iterator.hasNext()) {
                String nextPrefix = iterator.next().toString();
                if (!highestSuperclassName.startsWith(nextPrefix)) continue;
                return false;
            }
            iterator = _illegalClasses.iterator();
            while (iterator.hasNext()) {
                String nextClass = iterator.next().toString();
                if (!highestSuperclassName.equals(nextClass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected String getResourceNameWithExtension(String className) {
        return this.getResourceName(className) + "." + "mapping";
    }

    protected String getResourceName(String className) {
        return className != null ? className.replace('.', '/') : null;
    }

    protected String getFileNameWithExtension(String className) {
        return this.getFileName(className) + "." + "mapping";
    }

    protected String getFileName(String className) {
        return className != null ? className.replace('.', File.separatorChar) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertToPersistenceCapable(String className, boolean flag) throws IOException {
        Exception conversionException;
        block12: {
            boolean classIsPersistent = this.isPersistent(className);
            conversionException = null;
            if (flag && !classIsPersistent && this.isPersistenceCapableAllowed(className)) {
                try {
                    this.createSkeletonMappingClass(className);
                }
                catch (Exception e) {
                    conversionException = e;
                }
            }
            if (!flag && classIsPersistent || conversionException != null) {
                try {
                    this.deleteFile(className, this.getFileNameWithExtension(className));
                    Map e = this._classes;
                    synchronized (e) {
                        this._classes.remove(className);
                        this._nonPCClasses.add(className);
                    }
                }
                catch (Exception e) {
                    if (conversionException != null) break block12;
                    conversionException = e;
                }
            }
        }
        if (conversionException != null) {
            if (conversionException instanceof RuntimeException) {
                throw (RuntimeException)conversionException;
            }
            if (conversionException instanceof IOException) {
                throw (IOException)conversionException;
            }
        }
    }

    public void convertToPersistenceCapable(String className) throws IOException {
        this.convertToPersistenceCapable(className, true);
        this.convertDefaultFields(className);
        this.storeMappingClass(className);
    }

    private void createSkeletonMappingClass(String className) {
        PersistenceClassElement element = new PersistenceClassElement(new PersistenceClassElementImpl(className));
        this.updateKeyForClass(new MappingClassElementImpl(element), null);
    }

    public void convertDefaultFields(String className) {
        this.convertFields(className, this.getFields(className));
    }

    public void convertFields(String className, List fields) {
        PersistenceClassElement element = this.getPersistenceClass(className);
        if (element != null) {
            for (String fieldName : fields) {
                if (!this.isPersistentAllowed(className, fieldName) || !this.shouldBePersistent(className, fieldName)) continue;
                this.addFieldElement(element, fieldName);
            }
        }
    }

    public boolean addFieldElement(PersistenceClassElement element, String fieldName) {
        String fieldType = this.getFieldType(element.getName(), fieldName);
        boolean isCollection = this.isCollection(fieldType);
        try {
            if (this.isPersistent(fieldType) || isCollection) {
                RelationshipElement relationship = new RelationshipElement(new RelationshipElementImpl(fieldName), element);
                if (isCollection) {
                    relationship.setCollectionClass(this.getDefaultCollectionClass(fieldType));
                } else {
                    relationship.setUpperBound(1);
                }
                element.addField(relationship);
            } else {
                element.addField(new PersistenceFieldElement(new PersistenceFieldElementImpl(fieldName), element));
            }
            return true;
        }
        catch (ModelException e) {
            return false;
        }
    }

    public void removeFieldElement(PersistenceFieldElement element) throws ModelException {
        if (element != null) {
            if (element instanceof RelationshipElement) {
                ((RelationshipElement)element).setInverseRelationship(null, this);
            }
            element.getDeclaringClass().removeField(element);
        }
    }

    public String getRelatedClass(RelationshipElement element) {
        if (element != null) {
            String fieldType = this.getFieldType(element.getDeclaringClass().getName(), element.getName());
            String relatedClass = this.isCollection(fieldType) ? element.getElementClass() : fieldType;
            return StringHelper.isEmpty(relatedClass) ? null : relatedClass.trim();
        }
        return null;
    }

    public ArrayList getSupportedCollectionClasses(String className) {
        String supportedSet = "java.util.HashSet";
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add(supportedSet);
        return returnList;
    }

    public String getDefaultCollectionClass(String className) {
        String collectionClass = "java.util.HashSet";
        return collectionClass;
    }

    protected abstract BufferedOutputStream createFile(String var1, String var2, String var3) throws IOException;

    protected abstract void deleteFile(String var1, String var2) throws IOException;

    public abstract List getFields(String var1);

    public List getAllFields(String className) {
        ArrayList returnList = new ArrayList();
        while (className != null) {
            returnList.addAll(this.getFields(className));
            className = this.getSuperclass(className);
        }
        return returnList;
    }

    public Object getClass(String className) {
        return this.getClass(className, null);
    }

    public abstract Object getClass(String var1, ClassLoader var2);

    public boolean hasClass(String className) {
        return this.hasClass(className, null);
    }

    public boolean hasClass(String className, ClassLoader classLoader) {
        return this.getClass(className, classLoader) != null;
    }

    public abstract boolean implementsInterface(Object var1, String var2);

    public abstract boolean hasConstructor(String var1);

    public abstract Object getConstructor(String var1, String[] var2);

    public abstract Object getMethod(String var1, String var2, String[] var3);

    public Object getInheritedMethod(String className, String methodName, String[] argTypeNames) {
        String superClass = this.getSuperclass(className);
        Object method = null;
        while (superClass != null && (method = this.getMethod(superClass, methodName, argTypeNames)) == null) {
            superClass = this.getSuperclass(superClass);
        }
        return method;
    }

    public abstract String getType(Object var1);

    public abstract Object getField(String var1, String var2);

    public Object getInheritedField(String className, String fieldName) {
        String superClass = this.getSuperclass(className);
        Object field = null;
        while (superClass != null && (field = this.getField(superClass, fieldName)) == null) {
            superClass = this.getSuperclass(superClass);
        }
        return field;
    }

    public boolean hasField(String className, String fieldName) {
        return this.getField(className, fieldName) != null;
    }

    public String getFieldType(String className, String fieldName) {
        return this.getType(this.getField(className, fieldName));
    }

    public abstract boolean isSerializable(Object var1);

    public boolean isPrimitive(String className, String fieldName) {
        return this.isPrimitive(this.getFieldType(className, fieldName));
    }

    protected boolean isPrimitive(String className) {
        return className != null && JavaTypeHelper.getPrimitiveClass(className) != null;
    }

    public abstract boolean isArray(String var1, String var2);

    public boolean isByteArray(String className, String fieldName) {
        return this.isByteArray(this.getFieldType(className, fieldName));
    }

    protected boolean isByteArray(String className) {
        return "byte[]".equals(className);
    }

    public boolean isCollection(String className) {
        return _collectionClasses.contains(className);
    }

    public boolean isSecondClassObject(String className) {
        return _scoClasses.contains(className);
    }

    public boolean isMutableSecondClassObject(String className) {
        return _mutableScoClasses.contains(className);
    }

    public abstract String getDeclaringClass(Object var1);

    public abstract int getModifiers(Object var1);

    public int getModifiersForClass(String className) {
        return this.getModifiers(this.getClass(className));
    }

    protected int getModifiers(String className, String fieldName) {
        return this.getModifiers(this.getField(className, fieldName));
    }

    public boolean isPersistentAllowed(String className, String fieldName) {
        return this.isPersistentAllowed(className, null, fieldName);
    }

    public boolean isPersistentAllowed(String className, ClassLoader classLoader, String fieldName) {
        int modifier = this.getModifiers(className, fieldName);
        if (!Modifier.isStatic(modifier) && !Modifier.isFinal(modifier)) {
            return this.isPersistentTypeAllowed(this.getFieldType(className, fieldName), classLoader);
        }
        return false;
    }

    protected boolean isPersistentTypeAllowed(String className, ClassLoader classLoader) {
        return this.isPrimitive(className) || this.isSecondClassObject(className) || this.isByteArray(className) || this.isPersistent(className, classLoader);
    }

    public boolean shouldBePersistent(String className, String fieldName) {
        return !Modifier.isVolatile(this.getModifiers(className, fieldName));
    }

    public PersistenceFieldElement getPersistenceField(String className, String fieldName) {
        return this.hasField(className, fieldName) ? this.getPersistenceFieldInternal(className, fieldName) : null;
    }

    protected PersistenceFieldElement getPersistenceFieldInternal(String className, String fieldName) {
        PersistenceClassElement classElement = this.getPersistenceClass(className);
        return classElement != null ? classElement.getField(fieldName) : null;
    }

    public boolean isPersistent(String className, String fieldName) {
        PersistenceFieldElement fieldElement = this.getPersistenceField(className, fieldName);
        if (fieldElement != null) {
            return 0 == fieldElement.getPersistenceType();
        }
        return false;
    }

    public boolean isKey(String className, String fieldName) {
        String keyClass;
        PersistenceClassElement classElement;
        if (this.hasField(className, fieldName) && (classElement = this.getPersistenceClass(className)) != null && (keyClass = classElement.getKeyClass()) != null) {
            return this.hasField(keyClass, fieldName);
        }
        return false;
    }

    public boolean isValidKeyType(String className, String fieldName) {
        String fieldType = this.getFieldType(className, fieldName);
        if (fieldType == null) {
            fieldType = this.getType(this.getInheritedField(className, fieldName));
        }
        return this.isPrimitive(fieldType) || this.isSecondClassObject(fieldType) && !this.isCollection(fieldType);
    }

    public boolean isDefaultFetchGroup(String className, String fieldName) {
        MappingClassElement mappingClass = this.getMappingClass(className);
        try {
            return 1 == mappingClass.getField(fieldName).getFetchGroup();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean parse(String className) {
        return new ModelValidator(this, className, Model.getMessages()).parseCheck();
    }

    public Collection validate(String className, ResourceBundle bundle) {
        return this.validate(className, null, bundle);
    }

    public Collection validate(String className, ClassLoader classLoader, ResourceBundle bundle) {
        return new ModelValidator(this, className, classLoader, bundle == null ? Model.getMessages() : bundle).fullValidationCheck();
    }

    public static String[] getReadObjectArgs() {
        return new String[]{"java.io.ObjectInputStream"};
    }

    public static String[] getEqualsArgs() {
        return new String[]{"java.lang.Object"};
    }

    public static String[] getWriteObjectArgs() {
        return new String[]{"java.io.ObjectOutputStream"};
    }

    static {
        NO_ARGS = new String[0];
        _messages = I18NHelper.loadBundle(Model.class);
        String[] prefixes = new String[]{"java.awt", "java.applet", "javax.swing", "javax.ejb"};
        String[] classes = new String[]{"java.lang.Throwable"};
        String[] collectionClasses = new String[]{"java.util.Collection", "java.util.AbstractCollection", "java.util.Set", "java.util.AbstractSet", "java.util.HashSet", "com.sun.jdo.spi.persistence.support.sqlstore.sco.HashSet"};
        String[] mutableScoClasses = new String[]{"java.util.Date", "com.sun.jdo.spi.persistence.support.sqlstore.sco.Date", "java.sql.Date", "com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlDate", "java.sql.Time", "com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTime", "java.sql.Timestamp", "com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTimestamp"};
        String[] scoClasses = new String[]{"java.lang.String", "java.lang.Character", "java.lang.Boolean", "java.lang.Long", "java.lang.Number", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Float", "java.lang.Double", "java.math.BigDecimal", "java.math.BigInteger"};
        _illegalPrefixes = Arrays.asList(prefixes);
        _illegalClasses = Arrays.asList(classes);
        _collectionClasses = Arrays.asList(collectionClasses);
        _mutableScoClasses = new ArrayList<String>(Arrays.asList(mutableScoClasses));
        _mutableScoClasses.addAll(_collectionClasses);
        _scoClasses = new ArrayList<String>(Arrays.asList(scoClasses));
        _scoClasses.addAll(_mutableScoClasses);
        RUNTIME = Model.NewModel(null, "com.sun.jdo.api.persistence.model.RuntimeModel");
        ENHANCER = Model.NewModel(null, "com.sun.jdo.api.persistence.model.EnhancerModel");
    }
}

