/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakValueHashMap
extends HashMap {
    private transient ReferenceQueue queue = new ReferenceQueue();
    private Set hashEntrySet = null;
    private Set entrySet = null;
    private transient Collection values = null;

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(WeakValue.create(value));
    }

    @Override
    public Object get(Object key) {
        return this.getReferenceObject((WeakReference)super.get(key));
    }

    @Override
    public Object put(Object key, Object value) {
        this.processQueue();
        WeakValue oldValue = super.put(key, WeakValue.create(key, value, this.queue));
        return this.getReferenceObject(oldValue);
    }

    @Override
    public Object remove(Object key) {
        return this.getReferenceObject((WeakReference)super.remove(key));
    }

    private final Object getReferenceObject(WeakReference ref) {
        return ref == null ? null : ref.get();
    }

    private void processQueue() {
        WeakValue wv = null;
        while ((wv = (WeakValue)this.queue.poll()) != null) {
            super.remove(wv.key);
        }
    }

    @Override
    public Set entrySet() {
        if (this.entrySet == null) {
            this.hashEntrySet = super.entrySet();
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = WeakValueHashMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Entry)this.i.next()).getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return WeakValueHashMap.this.size();
                }

                @Override
                public boolean contains(Object v) {
                    return WeakValueHashMap.this.containsValue(v);
                }
            };
        }
        return this.values;
    }

    private class Entry
    implements Map.Entry {
        private Map.Entry ent;
        private Object value;

        Entry(Map.Entry ent, Object value) {
            this.ent = ent;
            this.value = value;
        }

        public Object getKey() {
            return this.ent.getKey();
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            this.ent.setValue(WeakValue.create(this.getKey(), value, WeakValueHashMap.this.queue));
            return oldValue;
        }

        private boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.valEquals(this.ent.getKey(), e.getKey()) && this.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            Object k = this.ent.getKey();
            return (k == null ? 0 : k.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            WeakValueHashMap.this.processQueue();
            return new Iterator(){
                Iterator hashIterator;
                Entry next;
                {
                    this.hashIterator = WeakValueHashMap.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    if (this.hashIterator.hasNext()) {
                        Map.Entry ent = (Map.Entry)this.hashIterator.next();
                        WeakValue wv = (WeakValue)ent.getValue();
                        Object v = wv == null ? null : wv.get();
                        this.next = new Entry(ent, v);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ek = e.getKey();
            Object ev = e.getValue();
            Object hv = WeakValueHashMap.this.get(ek);
            if (hv == null) {
                if (ev == null && WeakValueHashMap.this.containsKey(ek)) {
                    WeakValueHashMap.this.remove(ek);
                    return true;
                }
                return false;
            }
            if (hv.equals(ev)) {
                WeakValueHashMap.this.remove(ek);
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry ent : WeakValueHashMap.this.hashEntrySet) {
                WeakValue wv = (WeakValue)ent.getValue();
                if (wv == null) continue;
                Object k = ent.getKey();
                h += (k == null ? 0 : k.hashCode()) ^ wv.hashCode();
            }
            return h;
        }
    }

    private static class WeakValue
    extends WeakReference {
        private Object key;

        private WeakValue(Object value) {
            super(value);
        }

        private static WeakValue create(Object value) {
            if (value == null) {
                return null;
            }
            return new WeakValue(value);
        }

        private WeakValue(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }

        private static WeakValue create(Object key, Object value, ReferenceQueue queue) {
            if (value == null) {
                return null;
            }
            return new WeakValue(key, value, queue);
        }

        public boolean equals(Object obj) {
            Object ref2;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WeakValue)) {
                return false;
            }
            Object ref1 = this.get();
            if (ref1 == (ref2 = ((WeakValue)obj).get())) {
                return true;
            }
            if (ref1 == null || ref2 == null) {
                return false;
            }
            return ref1.equals(ref2);
        }

        public int hashCode() {
            Object ref = this.get();
            return ref == null ? 0 : ref.hashCode();
        }
    }
}

