/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http-listener")
@PerLookup
@I18n(value="delete.http.listener")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteHttpListener
implements AdminCommand {
    private static final ResourceBundle rb = HttpServiceStatsProviderBootstrap.rb;
    @LogMessageInfo(message="Specified http listener, {0}, doesn''t exist.", level="INFO")
    protected static final String DELETE_HTTP_LISTENER_NOT_EXISTS = "AS-WEB-ADMIN-00028";
    @LogMessageInfo(message="{0} delete failed.", level="INFO")
    protected static final String DELETE_HTTP_LISTENER_FAIL = "AS-WEB-ADMIN-00029";
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Param(name="secure", optional=true)
    String secure;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;
    private NetworkConfig networkConfig;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        this.networkConfig = this.config.getNetworkConfig();
        if (!this.exists()) {
            report.setMessage(MessageFormat.format(rb.getString(DELETE_HTTP_LISTENER_NOT_EXISTS), this.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            NetworkListener ls = this.networkConfig.getNetworkListener(this.listenerId);
            String name = ls.getProtocol();
            VirtualServer vs = this.config.getHttpService().getVirtualServerByName(ls.findHttpProtocol().getHttp().getDefaultVirtualServer());
            ConfigSupport.apply((SingleConfigCode)new DeleteNetworkListener(), (ConfigBeanProxy)this.networkConfig.getNetworkListeners());
            ConfigSupport.apply((SingleConfigCode)new UpdateVirtualServer(), (ConfigBeanProxy)vs);
            this.cleanUp(name);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString(DELETE_HTTP_LISTENER_FAIL), this.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean exists() {
        if (this.networkConfig != null) {
            return this.networkConfig.getNetworkListener(this.listenerId) != null;
        }
        return false;
    }

    private void cleanUp(String name) throws TransactionFailure {
        boolean found = false;
        if (this.networkConfig != null) {
            for (NetworkListener candidate : this.networkConfig.getNetworkListeners().getNetworkListener()) {
                found |= candidate.getProtocol().equals(name);
            }
            if (!found) {
                ConfigSupport.apply((SingleConfigCode)new DeleteProtocol(name), (ConfigBeanProxy)this.networkConfig.getProtocols());
            }
        }
    }

    private class DeleteNetworkListener
    implements SingleConfigCode<NetworkListeners> {
        private DeleteNetworkListener() {
        }

        public Object run(NetworkListeners param) throws PropertyVetoException, TransactionFailure {
            List list = param.getNetworkListener();
            for (NetworkListener listener : list) {
                if (!listener.getName().equals(DeleteHttpListener.this.listenerId)) continue;
                list.remove(listener);
                break;
            }
            return list;
        }
    }

    private static class DeleteProtocol
    implements SingleConfigCode<Protocols> {
        private final String name;

        public DeleteProtocol(String name) {
            this.name = name;
        }

        public Object run(Protocols param) throws PropertyVetoException, TransactionFailure {
            ArrayList list = new ArrayList(param.getProtocol());
            for (Protocol old : list) {
                if (!this.name.equals(old.getName())) continue;
                param.getProtocol().remove(old);
                break;
            }
            return param;
        }
    }

    private class UpdateVirtualServer
    implements SingleConfigCode<VirtualServer> {
        private UpdateVirtualServer() {
        }

        public Object run(VirtualServer avs) throws PropertyVetoException {
            String lss = avs.getNetworkListeners();
            if (lss != null && lss.contains(DeleteHttpListener.this.listenerId)) {
                Pattern p = Pattern.compile(",");
                String[] names = p.split(lss);
                ArrayList<String> nl = new ArrayList<String>();
                for (String rawName : names) {
                    String name = rawName.trim();
                    if (DeleteHttpListener.this.listenerId.equals(name)) continue;
                    nl.add(name);
                }
                lss = ((Object)nl).toString();
                lss = lss.substring(1, lss.length() - 1);
                avs.setNetworkListeners(lss);
            }
            return avs;
        }
    }
}

