/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.appclient.server.core.AppClientDeployer;
import org.glassfish.appclient.server.core.AppClientServerApplication;
import org.glassfish.appclient.server.core.jws.AppClientHTTPAdapter;
import org.glassfish.appclient.server.core.jws.ExtensionFileManager;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.glassfish.appclient.server.core.jws.NamingConventions;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.AutoSignedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.SimpleDynamicContentImpl;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.enterprise.iiop.api.GlassFishORBFactory;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.orb.admin.config.IiopService;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class JWSAdapterManager
implements PostConstruct {
    private static final String SIGNING_ALIAS_PROPERTY_NAME = "jar-signing-alias";
    private static final String DEFAULT_SIGNING_ALIAS = "s1as";
    private static final String MANIFEST_APP_NAME_FOR_SYSTEM_FILES = "GlassFish";
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ServerContext serverContext;
    @Inject
    private RequestDispatcher requestDispatcher;
    @Inject
    private ASJarSigner jarSigner;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    AppClientDeployer appClientDeployer;
    @Inject
    private GlassFishORBFactory orbFactory;
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final List<String> DO_NOT_SERVE_LIST = Collections.EMPTY_LIST;
    private static final String JWS_SIGNED_SYSTEM_JARS_ROOT = "java-web-start/___system";
    private static final String JWS_SIGNED_DOMAIN_JARS_ROOT = "java-web-start/___domain";
    private static final String JAVA_WEB_START_CONTEXT_ROOT_PROPERTY_NAME = "javaWebStartContextRoot";
    private final Map<String, AutoSignedContent> appLevelSignedSystemContent = new HashMap<String, AutoSignedContent>();
    private URI installRootURI = null;
    private AppClientHTTPAdapter systemAdapter = null;
    private Logger logger = null;
    private IiopService iiopService;
    private final HashMap<String, Set<AppClientServerApplication>> contributingAppClients = new HashMap();
    private final ConcurrentHashMap<String, AppClientHTTPAdapter> httpAdapters = new ConcurrentHashMap();
    private URI umbrellaRootURI = null;
    private File umbrellaRoot = null;
    private File systemLevelSignedJARsRoot = null;
    private File domainLevelSignedJARsRoot = null;
    @LogMessageInfo(message="Error starting the adapter to serve static system-level content", cause="An unexpected internal system error occurred", action="Please consult the exception stack trace")
    public static final String ERROR_STARTING_SYSTEM_ADAPTER = "AS-ACDEPL-00105";

    public synchronized void postConstruct() {
        this.installRootURI = this.serverContext.getInstallRoot().toURI();
        this.logger = Logger.getLogger("javax.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
        this.iiopService = (IiopService)this.config.getExtensionByType(IiopService.class);
        this.umbrellaRoot = new File(this.installRootURI).getParentFile();
        this.umbrellaRootURI = this.umbrellaRoot.toURI();
        this.systemLevelSignedJARsRoot = new File(this.serverEnv.getDomainRoot(), JWS_SIGNED_SYSTEM_JARS_ROOT);
        this.domainLevelSignedJARsRoot = new File(this.serverEnv.getDomainRoot(), JWS_SIGNED_DOMAIN_JARS_ROOT);
    }

    public static String signingAlias(DeploymentContext dc) {
        return JWSAdapterManager.chooseAlias(dc);
    }

    synchronized File rootForSignedFilesInDomain() {
        return this.domainLevelSignedJARsRoot;
    }

    void addStaticSystemContent(String lookupURI, StaticContent newContent) throws IOException {
        this.systemAdapter().addContentIfAbsent(lookupURI, newContent);
    }

    private static String chooseAlias(DeploymentContext dc) {
        String userSpecifiedAlias = JWSAdapterManager.extractUserProvidedAlias(dc);
        return userSpecifiedAlias != null ? userSpecifiedAlias : DEFAULT_SIGNING_ALIAS;
    }

    private static String extractUserProvidedAlias(DeploymentContext dc) {
        return dc.getAppProps().getProperty(SIGNING_ALIAS_PROPERTY_NAME);
    }

    private synchronized AppClientHTTPAdapter startSystemContentAdapter() {
        try {
            AppClientHTTPAdapter sysAdapter = new AppClientHTTPAdapter("/___JWSappclient/___system", new Properties(), this.serverEnv.getDomainRoot(), new File(this.installRootURI), this.iiopService, this.orbFactory);
            this.requestDispatcher.registerEndpoint("/___JWSappclient/___system", (HttpHandler)sysAdapter, null);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Registered system content adapter serving {0}", (Object)sysAdapter);
            }
            return sysAdapter;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, ERROR_STARTING_SYSTEM_ADAPTER, e);
            return null;
        }
    }

    void addContentIfAbsent(Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent) throws IOException {
        this.systemAdapter().addContentIfAbsent(staticContent, dynamicContent);
    }

    Map<String, StaticContent> addStaticSystemContent(List<String> systemJARRelativeURIs, String signingAlias) throws IOException {
        HashMap<String, StaticContent> result = new HashMap<String, StaticContent>();
        File gfClientJAR = this.gfClientJAR();
        String classPathExpr = this.getGFClientModuleClassPath(gfClientJAR);
        URI gfClientJARURI = gfClientJAR.toURI();
        result.put(this.systemPath(gfClientJARURI, signingAlias), this.systemJarSignedContent(gfClientJAR, signingAlias));
        if (classPathExpr != null) {
            for (String classPathElement : classPathExpr.split(" ")) {
                URI uri = gfClientJARURI.resolve(classPathElement);
                String systemPath = this.systemPath(uri, signingAlias);
                File candidateFile = new File(uri);
                String relativeSystemPath = this.relativeSystemPath(uri);
                if (!candidateFile.exists() || candidateFile.isDirectory() || DO_NOT_SERVE_LIST.contains(relativeSystemPath)) continue;
                result.put(systemPath, this.systemJarSignedContent(candidateFile, signingAlias));
                systemJARRelativeURIs.add(this.relativeSystemPath(uri));
            }
        }
        File endorsedDir = new File(this.modulesDir(), "endorsed");
        for (File endorsedJar : endorsedDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".jar");
            }
        })) {
            result.put(this.systemPath(endorsedJar.toURI()), this.systemJarSignedContent(endorsedJar, signingAlias));
            systemJARRelativeURIs.add(this.relativeSystemPath(endorsedJar.toURI()));
        }
        return result;
    }

    File gfClientJAR() {
        return new File(this.libDir(), "gf-client.jar");
    }

    File gfClientModuleJAR() {
        return new File(this.modulesDir(), "gf-client-module.jar");
    }

    private synchronized File modulesDir() {
        return new File(new File(this.installRootURI), "modules");
    }

    private synchronized File libDir() {
        return new File(new File(this.installRootURI), "lib");
    }

    static String publicExtensionHref(ExtensionFileManager.Extension ext) {
        return "/___JWSappclient/___system/" + JWSAdapterManager.publicExtensionLookupURIText(ext);
    }

    static String publicExtensionLookupURIText(ExtensionFileManager.Extension ext) {
        return "___ext/" + ext.getExtDirectoryNumber() + "/" + ext.getFile().getName();
    }

    private AutoSignedContent systemJarSignedContent(File unsignedFile, String signingAlias) throws FileNotFoundException {
        String relativeURI = this.relativeSystemPath(unsignedFile.toURI());
        File signedFile = new File(this.signedSystemContentAliasDir(signingAlias), relativeURI);
        return new AutoSignedContent(unsignedFile, signedFile, signingAlias, this.jarSigner, relativeURI, MANIFEST_APP_NAME_FOR_SYSTEM_FILES);
    }

    Map<String, DynamicContent> addDynamicSystemContent(List<String> systemJARRelativeURIs, String signingAlias) throws IOException {
        HashMap<String, DynamicContent> result = new HashMap<String, DynamicContent>();
        String template = JavaWebStartInfo.textFromURL("/org/glassfish/appclient/server/core/jws/templates/systemJarsDocumentTemplate.jnlp");
        StringBuilder sb = new StringBuilder();
        for (String relativeURIString : systemJARRelativeURIs) {
            sb.append("<jar href=\"").append(signingAlias).append("/").append(relativeURIString).append("\"/>").append(LINE_SEP);
        }
        Properties p = new Properties();
        p.setProperty("system.jars", sb.toString());
        String replacedText = Util.replaceTokens(template, p);
        result.put(NamingConventions.systemJNLPURI(signingAlias), new SimpleDynamicContentImpl(replacedText, "jnlp"));
        return result;
    }

    private String systemPath(URI systemFileURI) {
        return this.relativeSystemPath(systemFileURI);
    }

    String systemPath(URI systemFileURI, String signingAlias) {
        return signingAlias + "/" + this.relativeSystemPath(systemFileURI);
    }

    String systemPathInClientJNLP(URI systemFileURI, String signingAlias) {
        return "${request.scheme}://${request.host}:${request.port}/___JWSappclient/___system/" + signingAlias + "/" + this.relativeSystemPath(systemFileURI);
    }

    private synchronized String relativeSystemPath(URI systemFileURI) {
        return this.umbrellaRootURI.relativize(systemFileURI).getPath();
    }

    public synchronized void addContentForAppClient(String appName, String clientURIWithinEAR, AppClientServerApplication contributor, Properties tokens, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent) throws EndpointRegistrationException, IOException {
        AppClientHTTPAdapter appAdapter = this.httpAdapters.get(appName);
        if (appAdapter == null) {
            appAdapter = this.addAppAdapter(appName, staticContent, dynamicContent, tokens, contributor);
        } else {
            appAdapter.addContentIfAbsent(staticContent, dynamicContent);
        }
        AppClientHTTPAdapter userFriendlyAppAdapter = this.addAdapterForUserFriendlyContextRoot(staticContent, dynamicContent, tokens, contributor);
        this.appClientDeployer.recordContextRoot(appName, clientURIWithinEAR, userFriendlyAppAdapter.contextRoot());
        this.logger.log(Level.FINE, "Registered at context roots {0},{1}", new Object[]{appAdapter.contextRoot(), userFriendlyAppAdapter.contextRoot()});
        this.addContributorToAppLevelAdapter(appName, contributor);
    }

    private synchronized AppClientHTTPAdapter createAndRegisterAdapter(String contextRoot, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens, AppClientServerApplication contributor) throws IOException, EndpointRegistrationException {
        AppClientHTTPAdapter adapter = new AppClientHTTPAdapter(contextRoot, staticContent, dynamicContent, tokens, this.serverEnv.getDomainRoot(), new File(this.installRootURI), this.iiopService, this.orbFactory);
        this.requestDispatcher.registerEndpoint(contextRoot, (HttpHandler)adapter, null);
        return adapter;
    }

    private synchronized AppClientHTTPAdapter addAdapterForUserFriendlyContextRoot(Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens, AppClientServerApplication contributor) throws IOException, EndpointRegistrationException {
        String ufContextRoot = JWSAdapterManager.userFriendlyContextRoot(contributor);
        return this.createAndRegisterAdapter(ufContextRoot, staticContent, dynamicContent, tokens, contributor);
    }

    private synchronized AppClientHTTPAdapter systemAdapter() {
        if (this.systemAdapter == null) {
            this.systemAdapter = this.startSystemContentAdapter();
        }
        return this.systemAdapter;
    }

    private synchronized AppClientHTTPAdapter addAppAdapter(String appName, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens, AppClientServerApplication contributor) throws IOException, EndpointRegistrationException {
        this.systemAdapter();
        String contextRoot = NamingConventions.contextRootForAppAdapter(appName);
        AppClientHTTPAdapter adapter = this.createAndRegisterAdapter(contextRoot, staticContent, dynamicContent, tokens, contributor);
        this.httpAdapters.put(appName, adapter);
        return adapter;
    }

    public static String userFriendlyContextRoot(AppClientServerApplication contributor) {
        return JWSAdapterManager.userFriendlyContextRoot(contributor.getDescriptor(), contributor.dc().getAppProps());
    }

    public static String userFriendlyContextRoot(ApplicationClientDescriptor acDesc, Properties p) {
        String ufContextRoot = NamingConventions.defaultUserFriendlyContextRoot(acDesc);
        String overridingContextRoot = null;
        if (acDesc.getApplication().isVirtual()) {
            overridingContextRoot = p.getProperty(JAVA_WEB_START_CONTEXT_ROOT_PROPERTY_NAME);
        } else {
            String uriToNestedClient = NamingConventions.uriToNestedClient(acDesc);
            overridingContextRoot = p.getProperty("javaWebStartContextRoot." + uriToNestedClient);
        }
        if (overridingContextRoot != null) {
            ufContextRoot = overridingContextRoot;
        }
        if (!ufContextRoot.startsWith("/")) {
            ufContextRoot = "/" + ufContextRoot;
        }
        return ufContextRoot;
    }

    public synchronized AutoSignedContent appLevelSignedSystemContent(String relativePathToSystemJar, String alias) throws FileNotFoundException {
        String key = JWSAdapterManager.keyToAppLevelSignedSystemContentMap(relativePathToSystemJar, alias);
        AutoSignedContent result = this.appLevelSignedSystemContent.get(key);
        if (result == null) {
            File unsignedFile = new File(this.umbrellaRoot, relativePathToSystemJar);
            File signedFile = new File(this.systemLevelSignedJARsRoot, key);
            result = new AutoSignedContent(unsignedFile, signedFile, alias, this.jarSigner, relativePathToSystemJar, MANIFEST_APP_NAME_FOR_SYSTEM_FILES);
            this.appLevelSignedSystemContent.put(key, result);
        }
        return result;
    }

    private static String keyToAppLevelSignedSystemContentMap(String relativePathToSystemJar, String alias) {
        return alias + "/" + relativePathToSystemJar;
    }

    synchronized File signedSystemContentAliasDir(String alias) {
        return new File(this.systemLevelSignedJARsRoot, alias);
    }

    public String contextRootForAppAdapter(String appName) {
        AppClientHTTPAdapter adapter = this.httpAdapters.get(appName);
        if (adapter != null) {
            return adapter.contextRoot();
        }
        return null;
    }

    private synchronized void addContributorToAppLevelAdapter(String appName, AppClientServerApplication contributor) {
        Set<AppClientServerApplication> contributorsToAppLevelAdapter = this.contributingAppClients.get(appName);
        if (contributorsToAppLevelAdapter == null) {
            contributorsToAppLevelAdapter = new HashSet<AppClientServerApplication>();
            this.contributingAppClients.put(appName, contributorsToAppLevelAdapter);
        }
        contributorsToAppLevelAdapter.add(contributor);
    }

    public synchronized void removeContentForAppClient(String appName, String clientURIWithinEAR, AppClientServerApplication contributor) throws EndpointRegistrationException {
        this.removeAdapter(JWSAdapterManager.userFriendlyContextRoot(contributor));
        this.removeContributorToAppLevelAdapter(appName, contributor);
        this.appClientDeployer.removeContextRoot(appName, clientURIWithinEAR);
    }

    private synchronized void removeContributorToAppLevelAdapter(String appName, AppClientServerApplication contributor) throws EndpointRegistrationException {
        Set<AppClientServerApplication> contributorsToAppLevelAdapter = this.contributingAppClients.get(appName);
        if (contributorsToAppLevelAdapter == null) {
            return;
        }
        contributorsToAppLevelAdapter.remove(contributor);
        if (contributorsToAppLevelAdapter.isEmpty()) {
            this.contributingAppClients.remove(appName);
            this.removeAdapter(NamingConventions.contextRootForAppAdapter(appName));
            this.httpAdapters.remove(appName);
        }
    }

    private synchronized void removeAdapter(String contextRoot) throws EndpointRegistrationException {
        this.requestDispatcher.unregisterEndpoint(contextRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGFClientModuleClassPath(File gfClientJAR) throws IOException {
        try (JarFile jf = new JarFile(gfClientJAR);){
            Manifest mf = jf.getManifest();
            Attributes mainAttrs = mf.getMainAttributes();
            String string = mainAttrs.getValue(Attributes.Name.CLASS_PATH);
            return string;
        }
    }
}

