/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import com.sun.enterprise.security.ssl.JarSigner;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.inject.Singleton;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ASJarSigner
implements PostConstruct {
    public static final String USER_SPECIFIED_ALIAS_PROPERTYNAME = "com.sun.aas.jws.signing.alias";
    private static final String JKS_KEYSTORE_TYPE_VALUE = "jks";
    private static final String DEFAULT_ALIAS_VALUE = "s1as";
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA1";
    private static final String DEFAULT_KEY_ALGORITHM = "RSA";
    private static final StringManager localStrings = StringManager.getManager(ASJarSigner.class);
    private Logger logger;

    public void postConstruct() {
        this.logger = Logger.getLogger("javax.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
    }

    public long signJar(File unsignedJar, File signedJar, String alias, Attributes attrs) throws Exception {
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(signedJar));){
            long result;
            long l = result = this.signJar(unsignedJar, zout, alias, attrs, Collections.EMPTY_MAP);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long signJar(File unsignedJar, ZipOutputStream signedJar, String alias, Attributes attrs, Map<String, byte[]> additionalContent) throws Exception {
        if (alias == null) {
            alias = DEFAULT_ALIAS_VALUE;
        }
        long startTime = System.currentTimeMillis();
        long duration = 0L;
        ASJarSigner aSJarSigner = this;
        synchronized (aSJarSigner) {
            try {
                JarSigner jarSigner = new JarSigner(DEFAULT_DIGEST_ALGORITHM, DEFAULT_KEY_ALGORITHM);
                jarSigner.signJar(unsignedJar, signedJar, alias, attrs, additionalContent);
            }
            catch (Throwable t) {
                try {
                    throw new Exception(localStrings.getString("jws.sign.errorSigning", (Object)unsignedJar.getAbsolutePath(), (Object)alias), t);
                }
                catch (Throwable throwable) {
                    duration = System.currentTimeMillis() - startTime;
                    this.logger.log(Level.FINE, "Signing {0} took {1} ms", new Object[]{unsignedJar.getAbsolutePath(), duration});
                    throw throwable;
                }
            }
            duration = System.currentTimeMillis() - startTime;
            this.logger.log(Level.FINE, "Signing {0} took {1} ms", new Object[]{unsignedJar.getAbsolutePath(), duration});
        }
        return duration;
    }

    public static class ASJarSignerException
    extends Exception {
        public ASJarSignerException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

