/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.glassfish.gmbal.AMXClient;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.impl.AttributeDescriptor;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.gmbal.impl.TypeConverter;
import org.glassfish.gmbal.impl.trace.TraceRegistration;
import org.glassfish.gmbal.impl.trace.TraceRegistrationFine;
import org.glassfish.gmbal.impl.trace.TraceRuntime;
import org.glassfish.gmbal.typelib.EvaluatedArrayType;
import org.glassfish.gmbal.typelib.EvaluatedClassAnalyzer;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;
import org.glassfish.pfl.basic.algorithm.Algorithms;
import org.glassfish.pfl.basic.algorithm.DumpToString;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.facet.FacetAccessor;
import org.glassfish.pfl.basic.func.UnaryPredicate;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@TraceRuntime
@TraceRegistration
@TraceRegistrationFine
public abstract class TypeConverterImpl
implements TypeConverter {
    private static final Map<EvaluatedType, OpenType> simpleTypeMap = new HashMap<EvaluatedType, OpenType>();
    private static final Map<OpenType, EvaluatedClassDeclaration> simpleOpenTypeMap = new HashMap<OpenType, EvaluatedClassDeclaration>();
    public static final String NULL_STRING = "<NULL>";
    private static final Runnable NoOp;
    @DumpToString
    protected final EvaluatedType dataType;
    @DumpToString
    protected final OpenType managedType;

    private static void initMaps(OpenType otype, EvaluatedClassDeclaration ... types) {
        boolean first = true;
        for (EvaluatedClassDeclaration type : types) {
            simpleTypeMap.put(type, otype);
            if (!first) continue;
            first = false;
            simpleOpenTypeMap.put(otype, type);
        }
    }

    public static Class getJavaClass(OpenType ot) {
        if (ot instanceof SimpleType) {
            SimpleType st = (SimpleType)ot;
            return simpleOpenTypeMap.get(st).cls();
        }
        if (ot instanceof ArrayType) {
            ArrayType at = (ArrayType)ot;
            OpenType<?> cot = at.getElementOpenType();
            Class cjt = TypeConverterImpl.getJavaClass(cot);
            Object temp = Array.newInstance(cjt, 0);
            return temp.getClass();
        }
        if (ot instanceof TabularType) {
            return TabularData.class;
        }
        if (ot instanceof CompositeType) {
            return CompositeData.class;
        }
        throw Exceptions.self.unsupportedOpenType(ot);
    }

    private static EvaluatedType canonicalType(EvaluatedType et) {
        OpenType ot = simpleTypeMap.get(et);
        if (ot == null) {
            return et;
        }
        return simpleOpenTypeMap.get(ot);
    }

    public static Class getJavaClass(EvaluatedType type) {
        if (type instanceof EvaluatedClassDeclaration) {
            return ((EvaluatedClassDeclaration)type).cls();
        }
        if (type instanceof EvaluatedArrayType) {
            EvaluatedArrayType gat = (EvaluatedArrayType)type;
            EvaluatedType ctype = TypeConverterImpl.canonicalType(gat.componentType());
            Class cclass = TypeConverterImpl.getJavaClass(ctype);
            Object temp = Array.newInstance(cclass, 0);
            return temp.getClass();
        }
        throw Exceptions.self.cannotConvertToJavaType(type);
    }

    @TraceRegistration
    public static TypeConverter makeTypeConverter(EvaluatedType type, ManagedObjectManagerInternal mom) {
        TypeConverter result;
        block6: {
            result = null;
            try {
                OpenType stype = simpleTypeMap.get(type);
                if (stype != null) {
                    result = TypeConverterImpl.handleSimpleType(type, stype);
                    break block6;
                }
                if (type instanceof EvaluatedClassDeclaration) {
                    EvaluatedClassDeclaration cls = (EvaluatedClassDeclaration)type;
                    ManagedObject mo = mom.getFirstAnnotationOnClass(cls, ManagedObject.class);
                    ManagedData md = mom.getFirstAnnotationOnClass(cls, ManagedData.class);
                    result = mo != null ? TypeConverterImpl.handleManagedObject(cls, mom, mo) : (md != null ? TypeConverterImpl.handleManagedData(cls, mom, md) : (cls.cls().isEnum() ? TypeConverterImpl.handleEnum(cls) : TypeConverterImpl.handleClass(cls, mom)));
                    break block6;
                }
                if (type instanceof EvaluatedArrayType) {
                    result = TypeConverterImpl.handleArrayType((EvaluatedArrayType)type, mom);
                    break block6;
                }
                throw new IllegalArgumentException("Unknown kind of Type " + type);
            }
            catch (RuntimeException exc) {
                throw exc;
            }
            catch (OpenDataException exc) {
                throw new RuntimeException(exc);
            }
        }
        return result;
    }

    private static TypeConverter handleSimpleType(final EvaluatedType type, OpenType stype) {
        final EvaluatedType canType = TypeConverterImpl.canonicalType(type);
        return new TypeConverterImpl(type, stype){

            @Override
            public Object toManagedEntity(Object obj) {
                return obj;
            }

            @Override
            public Object fromManagedEntity(Object entity) {
                return entity;
            }

            @Override
            public boolean isIdentity() {
                return canType.equals(type);
            }
        };
    }

    @TraceRegistration
    private static TypeConverter handleManagedObject(EvaluatedClassDeclaration type, final ManagedObjectManagerInternal mom, ManagedObject mo) {
        TypeConverterImpl result = null;
        result = new TypeConverterImpl(type, SimpleType.OBJECTNAME){

            @Override
            public Object toManagedEntity(Object obj) {
                if (obj == null) {
                    return AMXClient.NULL_OBJECTNAME;
                }
                return mom.getObjectName(obj);
            }

            @Override
            public Object fromManagedEntity(Object entity) {
                if (!(entity instanceof ObjectName)) {
                    throw Exceptions.self.entityNotObjectName(entity);
                }
                ObjectName oname = (ObjectName)entity;
                if (oname.equals(AMXClient.NULL_OBJECTNAME)) {
                    return null;
                }
                return mom.getObject(oname);
            }
        };
        return result;
    }

    @TraceRegistration
    private static Collection<AttributeDescriptor> analyzeManagedData(EvaluatedClassDeclaration cls, ManagedObjectManagerInternal mom) {
        Collection<AttributeDescriptor> result = null;
        EvaluatedClassAnalyzer ca = (EvaluatedClassAnalyzer)mom.getClassAnalyzer(cls, ManagedData.class).second();
        Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> ainfos = mom.getAttributes(ca, ManagedObjectManagerInternal.AttributeDescriptorType.COMPOSITE_DATA_ATTR);
        result = ((Map)ainfos.first()).values();
        return result;
    }

    @InfoMethod
    private static void describe(String msg, Object data) {
    }

    @TraceRegistration
    private static CompositeType makeCompositeType(EvaluatedClassDeclaration cls, ManagedObjectManagerInternal mom, ManagedData md, Collection<AttributeDescriptor> minfos) {
        CompositeType result = null;
        String name = md.name();
        if (name.equals("")) {
            name = mom.getTypeName(cls.cls(), "GMBAL_TYPE", md.name());
        }
        TypeConverterImpl.describe("name", name);
        String mdDescription = mom.getDescription(cls);
        TypeConverterImpl.describe("mdDescription", mdDescription);
        int length = minfos.size();
        String[] attrNames = new String[length];
        String[] attrDescriptions = new String[length];
        OpenType[] attrOTypes = new OpenType[length];
        int ctr = 0;
        for (AttributeDescriptor minfo : minfos) {
            attrNames[ctr] = minfo.id();
            attrDescriptions[ctr] = minfo.description();
            attrOTypes[ctr] = minfo.tc().getManagedType();
            ++ctr;
        }
        TypeConverterImpl.describe("attrNames=", Arrays.asList(attrNames));
        TypeConverterImpl.describe("attrDescriptions=", Arrays.asList(attrDescriptions));
        TypeConverterImpl.describe("attrOTypes=", Arrays.asList(attrOTypes));
        try {
            result = new CompositeType(name, mdDescription, attrNames, attrDescriptions, attrOTypes);
        }
        catch (OpenDataException exc) {
            throw Exceptions.self.exceptionInMakeCompositeType(exc);
        }
        return result;
    }

    @TraceRegistration
    private static TypeConverter handleManagedData(final EvaluatedClassDeclaration cls, final ManagedObjectManagerInternal mom, ManagedData md) {
        TypeConverterImpl result = null;
        final Collection<AttributeDescriptor> minfos = TypeConverterImpl.analyzeManagedData(cls, mom);
        final CompositeType myType = TypeConverterImpl.makeCompositeType(cls, mom, md, minfos);
        TypeConverterImpl.describe("minfos=", minfos);
        TypeConverterImpl.describe("myType=", myType);
        result = new TypeConverterImpl(cls, myType){

            @Override
            @TraceRuntime
            public Object toManagedEntity(Object obj) {
                CompositeDataSupport runResult = null;
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (AttributeDescriptor minfo : minfos) {
                    TypeConverterImpl.describe("Fetching attribute ", minfo.id());
                    Object value = null;
                    if (minfo.isApplicable(obj)) {
                        try {
                            FacetAccessor fa = mom.getFacetAccessor(obj);
                            value = minfo.get(fa);
                        }
                        catch (JMException ex) {
                            Exceptions.self.errorInConstructingOpenData(cls.name(), minfo.id(), ex);
                        }
                    }
                    data.put(minfo.id(), value);
                }
                try {
                    runResult = new CompositeDataSupport(myType, data);
                }
                catch (OpenDataException exc) {
                    throw Exceptions.self.exceptionInHandleManagedData(exc);
                }
                return runResult;
            }
        };
        return result;
    }

    private static TypeConverter handleEnum(final EvaluatedClassDeclaration cls) {
        return new TypeConverterImpl(cls, SimpleType.STRING){

            @Override
            public Object toManagedEntity(Object obj) {
                if (obj == null) {
                    return TypeConverterImpl.NULL_STRING;
                }
                return obj.toString();
            }

            @Override
            public Object fromManagedEntity(Object entity) {
                if (TypeConverterImpl.NULL_STRING.equals(entity)) {
                    return null;
                }
                if (!(entity instanceof String)) {
                    throw Exceptions.self.notAString(entity);
                }
                return Enum.valueOf(cls.cls(), (String)entity);
            }
        };
    }

    private static ArrayType getArrayType(OpenType ot) throws OpenDataException {
        ArrayType result;
        if (ot instanceof ArrayType) {
            ArrayType atype = (ArrayType)ot;
            int dim = atype.getDimension();
            OpenType<?> lowestComponentType = atype.getElementOpenType();
            result = new ArrayType(dim + 1, lowestComponentType);
        } else {
            result = new ArrayType(1, ot);
        }
        return result;
    }

    @TraceRegistration
    private static TypeConverter handleArrayType(EvaluatedArrayType type, ManagedObjectManagerInternal mom) throws OpenDataException {
        TypeConverterImpl result = null;
        final EvaluatedType ctype = type.componentType();
        final TypeConverter ctypeTc = mom.getTypeConverter(ctype);
        final OpenType cotype = ctypeTc.getManagedType();
        ArrayType ot = TypeConverterImpl.getArrayType(cotype);
        TypeConverterImpl.describe("ctype", ctype);
        TypeConverterImpl.describe("ctypeTc", ctypeTc);
        TypeConverterImpl.describe("cotype", cotype);
        TypeConverterImpl.describe("ot", ot);
        result = new TypeConverterImpl(type, ot){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @TraceRuntime
            public Object toManagedEntity(Object obj) {
                if (this.isIdentity()) {
                    return obj;
                }
                Class cclass = 5.getJavaClass(cotype);
                int length = obj == null ? 0 : Array.getLength(obj);
                Object result = Array.newInstance(cclass, length);
                for (int ctr = 0; ctr < length; ++ctr) {
                    TypeConverterImpl.describe("Entering (handleArrayType):toManagedEntity", ctr);
                    try {
                        Object elem = Array.get(obj, ctr);
                        Object relem = ctypeTc.toManagedEntity(elem);
                        Array.set(result, ctr, relem);
                        continue;
                    }
                    finally {
                        TypeConverterImpl.describe("Exiting (handleArrayType):toManagedEntity", ctr);
                    }
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @TraceRuntime
            public Object fromManagedEntity(Object entity) {
                if (this.isIdentity()) {
                    return entity;
                }
                Class cclass = 5.getJavaClass(ctype);
                int length = entity == null ? 0 : Array.getLength(entity);
                Object result = Array.newInstance(cclass, length);
                for (int ctr = 0; ctr < length; ++ctr) {
                    TypeConverterImpl.describe("Entering (handleArrayType):fromManagedEntity", ctr);
                    try {
                        Object elem = Array.get(entity, ctr);
                        Object relem = ctypeTc.fromManagedEntity(elem);
                        Array.set(result, ctr, relem);
                        continue;
                    }
                    finally {
                        TypeConverterImpl.describe("Exiting (handleArrayType):fromManagedEntity", ctr);
                    }
                }
                return result;
            }

            @Override
            public boolean isIdentity() {
                return ctypeTc.isIdentity();
            }
        };
        return result;
    }

    private static EvaluatedMethodDeclaration findMethod(EvaluatedClassAnalyzer eca, final String mname) {
        return (EvaluatedMethodDeclaration)Algorithms.getFirst(eca.findMethods(new UnaryPredicate<EvaluatedMethodDeclaration>(){

            public boolean evaluate(EvaluatedMethodDeclaration m) {
                return m.name().equals(mname);
            }
        }), (Runnable)NoOp);
    }

    private static EvaluatedType getReturnType(EvaluatedClassDeclaration decl, String mname) {
        EvaluatedClassAnalyzer eca = new EvaluatedClassAnalyzer(decl);
        EvaluatedMethodDeclaration meth = TypeConverterImpl.findMethod(eca, mname);
        if (meth == null) {
            return null;
        }
        return meth.returnType();
    }

    private static EvaluatedType getParameterType(EvaluatedClassDeclaration decl, String mname, int pindex) {
        EvaluatedClassAnalyzer eca = new EvaluatedClassAnalyzer(decl);
        EvaluatedMethodDeclaration meth = TypeConverterImpl.findMethod(eca, mname);
        if (meth == null) {
            return null;
        }
        if (pindex < meth.parameterTypes().size()) {
            return meth.parameterTypes().get(pindex);
        }
        throw new IndexOutOfBoundsException("Parameter index is out of bounds");
    }

    private static Table emptyTable() {
        return new Table(){

            public Object get(Object key) {
                return null;
            }

            @Override
            public Iterator iterator() {
                return TypeConverterImpl.emptyIterator();
            }
        };
    }

    private static Iterator emptyIterator() {
        ArrayList list = new ArrayList();
        return list.iterator();
    }

    @TraceRegistration
    private static TypeConverter handleClass(EvaluatedClassDeclaration type, ManagedObjectManagerInternal mom) {
        TypeConverter result = null;
        if (Iterable.class.isAssignableFrom(type.cls())) {
            EvaluatedClassDeclaration type2 = (EvaluatedClassDeclaration)TypeConverterImpl.getReturnType(type, "iterator");
            if (type2 == null) {
                throw Exceptions.self.iteratorNotFound(type);
            }
            EvaluatedType tcType = TypeConverterImpl.getReturnType(type2, "next");
            if (tcType == null) {
                throw Exceptions.self.nextNotFound(type);
            }
            TypeConverter tc = mom.getTypeConverter(tcType);
            result = new TypeConverterListBase((EvaluatedType)type, tc){

                @Override
                protected Iterator getIterator(Object obj) {
                    if (obj == null) {
                        return TypeConverterImpl.emptyIterator();
                    }
                    return ((Iterable)obj).iterator();
                }
            };
        } else if (Collection.class.isAssignableFrom(type.cls())) {
            EvaluatedClassDeclaration type2 = (EvaluatedClassDeclaration)TypeConverterImpl.getReturnType(type, "iterator");
            EvaluatedType tcType = TypeConverterImpl.getReturnType(type2, "next");
            TypeConverter tc = mom.getTypeConverter(tcType);
            result = new TypeConverterListBase((EvaluatedType)type, tc){

                @Override
                protected Iterator getIterator(Object obj) {
                    if (obj == null) {
                        return TypeConverterImpl.emptyIterator();
                    }
                    return ((Iterable)obj).iterator();
                }
            };
        } else if (Iterator.class.isAssignableFrom(type.cls())) {
            EvaluatedType tcType = TypeConverterImpl.getReturnType(type, "next");
            TypeConverter tc = mom.getTypeConverter(tcType);
            result = new TypeConverterListBase((EvaluatedType)type, tc){

                @Override
                protected Iterator getIterator(Object obj) {
                    if (obj == null) {
                        return TypeConverterImpl.emptyIterator();
                    }
                    return (Iterator)obj;
                }
            };
        } else if (Enumeration.class.isAssignableFrom(type.cls())) {
            EvaluatedType tcType = TypeConverterImpl.getReturnType(type, "next");
            TypeConverter tc = mom.getTypeConverter(tcType);
            result = new TypeConverterListBase((EvaluatedType)type, tc){

                @Override
                protected Iterator getIterator(Object obj) {
                    if (obj == null) {
                        return TypeConverterImpl.emptyIterator();
                    }
                    return new EnumerationAdapter((Enumeration)obj);
                }
            };
        } else if (Map.class.isAssignableFrom(type.cls())) {
            EvaluatedType type1 = TypeConverterImpl.getParameterType(type, "put", 0);
            TypeConverter firstTc = mom.getTypeConverter(type1);
            EvaluatedType type2 = TypeConverterImpl.getReturnType(type, "put");
            TypeConverter secondTc = mom.getTypeConverter(type2);
            result = new TypeConverterMapBase(type, firstTc, secondTc){

                @Override
                protected Table getTable(Object obj) {
                    if (obj == null) {
                        return TypeConverterImpl.emptyTable();
                    }
                    return new TableMapImpl((Map)obj);
                }
            };
        } else if (Dictionary.class.isAssignableFrom(type.cls())) {
            EvaluatedType type1 = TypeConverterImpl.getParameterType(type, "put", 0);
            TypeConverter firstTc = mom.getTypeConverter(type1);
            EvaluatedType type2 = TypeConverterImpl.getReturnType(type, "put");
            TypeConverter secondTc = mom.getTypeConverter(type2);
            result = new TypeConverterMapBase(type, firstTc, secondTc){

                @Override
                protected Table getTable(Object obj) {
                    if (obj == null) {
                        return TypeConverterImpl.emptyTable();
                    }
                    return new TableDictionaryImpl((Dictionary)obj);
                }
            };
        } else {
            result = TypeConverterImpl.handleAsString(type);
        }
        return result;
    }

    private static TypeConverter handleAsString(final EvaluatedClassDeclaration cls) {
        Constructor tcons;
        try {
            SecurityManager sman = System.getSecurityManager();
            tcons = sman == null ? cls.cls().getDeclaredConstructor(String.class) : (Constructor)Algorithms.doPrivileged((Algorithms.Action)new Algorithms.Action<Constructor>(){

                public Constructor run() throws Exception {
                    return cls.cls().getDeclaredConstructor(String.class);
                }
            });
        }
        catch (Exception exc) {
            Exceptions.self.noStringConstructorAvailable(exc, cls.name());
            tcons = null;
        }
        final Constructor cons = tcons;
        return new TypeConverterImpl(cls, SimpleType.STRING){

            @Override
            public Object toManagedEntity(Object obj) {
                if (obj == null) {
                    return TypeConverterImpl.NULL_STRING;
                }
                return obj.toString();
            }

            @Override
            public Object fromManagedEntity(Object entity) {
                if (entity == null) {
                    return null;
                }
                if (cons == null) {
                    throw Exceptions.self.noStringConstructor(cls.cls());
                }
                try {
                    String str = (String)entity;
                    return cons.newInstance(str);
                }
                catch (InstantiationException exc) {
                    throw Exceptions.self.stringConversionError(cls.cls(), exc);
                }
                catch (IllegalAccessException exc) {
                    throw Exceptions.self.stringConversionError(cls.cls(), exc);
                }
                catch (InvocationTargetException exc) {
                    throw Exceptions.self.stringConversionError(cls.cls(), exc);
                }
            }
        };
    }

    protected TypeConverterImpl(EvaluatedType dataType, OpenType managedType) {
        this.dataType = dataType;
        this.managedType = managedType;
    }

    @Override
    public final EvaluatedType getDataType() {
        return this.dataType;
    }

    @Override
    public final OpenType getManagedType() {
        return this.managedType;
    }

    @Override
    public abstract Object toManagedEntity(Object var1);

    @Override
    public Object fromManagedEntity(Object entity) {
        throw Exceptions.self.openToJavaNotSupported(this.managedType, this.dataType);
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    private String displayOpenType(OpenType otype) {
        if (otype instanceof SimpleType) {
            SimpleType stype = (SimpleType)otype;
            return "SimpleType(" + stype.getTypeName() + ")";
        }
        if (otype instanceof ArrayType) {
            ArrayType atype = (ArrayType)otype;
            return "ArrayType(" + this.displayOpenType(atype.getElementOpenType()) + "," + atype.getDimension() + ")";
        }
        if (otype instanceof CompositeType) {
            CompositeType ctype = (CompositeType)otype;
            return "CompositeType(" + ctype.getTypeName() + ")";
        }
        if (otype instanceof TabularType) {
            TabularType ttype = (TabularType)otype;
            return "TabularType(" + ttype.getTypeName() + "," + "rowType=" + ttype.getRowType() + "indexNames=" + ttype.getIndexNames() + ")";
        }
        return "UNKNOWN(" + otype + ")";
    }

    public String toString() {
        return "TypeConverter[dataType=" + this.dataType + ",managedType=" + this.displayOpenType(this.managedType) + "]";
    }

    static {
        TypeConverterImpl.initMaps(SimpleType.BOOLEAN, EvaluatedType.EBOOLEANW, EvaluatedType.EBOOLEAN);
        TypeConverterImpl.initMaps(SimpleType.CHARACTER, EvaluatedType.ECHARW, EvaluatedType.ECHAR);
        TypeConverterImpl.initMaps(SimpleType.INTEGER, EvaluatedType.EINTW, EvaluatedType.EINT);
        TypeConverterImpl.initMaps(SimpleType.SHORT, EvaluatedType.ESHORTW, EvaluatedType.ESHORT);
        TypeConverterImpl.initMaps(SimpleType.LONG, EvaluatedType.ELONGW, EvaluatedType.ELONG);
        TypeConverterImpl.initMaps(SimpleType.BYTE, EvaluatedType.EBYTEW, EvaluatedType.EBYTE);
        TypeConverterImpl.initMaps(SimpleType.FLOAT, EvaluatedType.EFLOATW, EvaluatedType.EFLOAT);
        TypeConverterImpl.initMaps(SimpleType.DOUBLE, EvaluatedType.EDOUBLEW, EvaluatedType.EDOUBLE);
        TypeConverterImpl.initMaps(SimpleType.STRING, EvaluatedType.ESTRING);
        TypeConverterImpl.initMaps(SimpleType.VOID, EvaluatedType.EVOID);
        TypeConverterImpl.initMaps(SimpleType.DATE, EvaluatedType.EDATE);
        TypeConverterImpl.initMaps(SimpleType.OBJECTNAME, EvaluatedType.EOBJECT_NAME);
        TypeConverterImpl.initMaps(SimpleType.BIGDECIMAL, EvaluatedType.EBIG_DECIMAL);
        TypeConverterImpl.initMaps(SimpleType.BIGINTEGER, EvaluatedType.EBIG_INTEGER);
        NoOp = new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    private static class EnumerationAdapter<T>
    implements Iterator<T> {
        private final Enumeration<T> enumeration;

        public EnumerationAdapter(Enumeration<T> en) {
            this.enumeration = en;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw Exceptions.self.removeNotSupported();
        }
    }

    private static interface Table<K, V>
    extends Iterable<K> {
        public V get(K var1);
    }

    private static class TableDictionaryImpl<K, V>
    implements Table<K, V> {
        private final Dictionary<K, V> dict;

        public TableDictionaryImpl(Dictionary<K, V> dict) {
            this.dict = dict;
        }

        @Override
        public Iterator<K> iterator() {
            return new EnumerationAdapter<K>(this.dict.keys());
        }

        @Override
        public V get(K key) {
            return this.dict.get(key);
        }
    }

    private static class TableMapImpl<K, V>
    implements Table<K, V> {
        private final Map<K, V> map;

        public TableMapImpl(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public Iterator<K> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }
    }

    private static abstract class TypeConverterListBase
    extends TypeConverterImpl {
        final TypeConverter memberTc;

        public TypeConverterListBase(EvaluatedType dataType, TypeConverter memberTc) {
            super(dataType, TypeConverterListBase.makeArrayType(memberTc.getManagedType()));
            this.memberTc = memberTc;
        }

        private static ArrayType makeArrayType(OpenType ot) {
            try {
                return TypeConverterImpl.getArrayType(ot);
            }
            catch (OpenDataException exc) {
                throw Exceptions.self.openTypeInArrayTypeException(ot, exc);
            }
        }

        protected abstract Iterator getIterator(Object var1);

        @Override
        public Object toManagedEntity(Object obj) {
            Iterator iter = this.getIterator(obj);
            ArrayList list = new ArrayList();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            Class cclass = TypeConverterListBase.getJavaClass(this.memberTc.getManagedType());
            Object result = Array.newInstance(cclass, list.size());
            int ctr = 0;
            for (Object elem : list) {
                Object mappedElem = this.memberTc.toManagedEntity(elem);
                Array.set(result, ctr++, mappedElem);
            }
            return result;
        }
    }

    private static abstract class TypeConverterMapBase
    extends TypeConverterImpl {
        private final TypeConverter keyTypeConverter;
        private final TypeConverter valueTypeConverter;

        public TypeConverterMapBase(EvaluatedType dataType, TypeConverter keyTypeConverter, TypeConverter valueTypeConverter) {
            super(dataType, TypeConverterMapBase.makeMapTabularType(keyTypeConverter, valueTypeConverter));
            this.keyTypeConverter = keyTypeConverter;
            this.valueTypeConverter = valueTypeConverter;
        }

        private static TabularType makeMapTabularType(TypeConverter firstTc, TypeConverter secondTc) {
            String mapType = firstTc + "->" + secondTc;
            String[] itemNames = new String[]{"key", "value"};
            String description = Exceptions.self.rowTypeDescription(mapType);
            String[] itemDescriptions = new String[]{Exceptions.self.keyFieldDescription(mapType), Exceptions.self.valueFieldDescription(mapType)};
            OpenType[] itemTypes = new OpenType[]{firstTc.getManagedType(), secondTc.getManagedType()};
            try {
                CompositeType rowType = new CompositeType(mapType, description, itemNames, itemDescriptions, itemTypes);
                String[] keys = new String[]{"key"};
                String tableName = Exceptions.self.tableName(mapType);
                String tableDescription = Exceptions.self.tableDescription(mapType);
                TabularType result = new TabularType(tableName, tableDescription, rowType, keys);
                return result;
            }
            catch (OpenDataException exc) {
                throw Exceptions.self.exceptionInMakeMapTabularType(exc);
            }
        }

        protected abstract Table getTable(Object var1);

        @Override
        public Object toManagedEntity(Object obj) {
            try {
                Table table = this.getTable(obj);
                TabularType ttype = (TabularType)this.getManagedType();
                CompositeType ctype = ttype.getRowType();
                TabularDataSupport result = new TabularDataSupport(ttype);
                for (Object key : table) {
                    Object value = table.get(key);
                    Object mappedKey = this.keyTypeConverter.toManagedEntity(key);
                    Object mappedValue = this.valueTypeConverter.toManagedEntity(value);
                    HashMap<String, Object> items = new HashMap<String, Object>();
                    items.put("key", mappedKey);
                    items.put("value", mappedValue);
                    CompositeDataSupport cdata = new CompositeDataSupport(ctype, items);
                    result.put(cdata);
                }
                return result;
            }
            catch (OpenDataException exc) {
                throw Exceptions.self.excInMakeMapTabularDataToManagedEntity(exc);
            }
        }
    }

    public static class TypeConverterPlaceHolderImpl
    implements TypeConverter {
        private EvaluatedType et;

        public TypeConverterPlaceHolderImpl(EvaluatedType type) {
            this.et = type;
        }

        @Override
        public EvaluatedType getDataType() {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }

        @Override
        public OpenType getManagedType() {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }

        @Override
        public Object toManagedEntity(Object obj) {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }

        @Override
        public Object fromManagedEntity(Object entity) {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }

        @Override
        public boolean isIdentity() {
            throw Exceptions.self.recursiveTypesNotSupported(this.et);
        }
    }
}

