/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackEventListener;
import com.sun.messaging.jmq.jmsserver.multibroker.ClientDownCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterCreateDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterDestroyDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterUpdateDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ConfigSyncCompleteCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.GPacketCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestCreatedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestRemovedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.PrimaryInterestChangedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterGoodbyeInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageAckInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class CallbackDispatcher
extends Thread {
    private static boolean DEBUG = false;
    private static final boolean DEBUG_CLUSTER_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.debug.all");
    private static final boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg") || DEBUG || DEBUG_CLUSTER_ALL;
    private static final boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG || DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_MSG;
    private static final Logger logger = Globals.getLogger();
    private MessageBusCallback cb = null;
    private LinkedList eventQ = null;
    private boolean stopThread = false;
    private ExecutorService commitAckExecutor = null;
    private ExecutorService syncAckExecutor = null;
    private ExecutorService msgDataExecutor = null;
    private BrokerResources br = Globals.getBrokerResources();
    private static FaultInjection fi = FaultInjection.getInjection();

    public CallbackDispatcher(MessageBusCallback cb) {
        this.cb = cb;
        this.eventQ = new LinkedList();
        this.setName("MessageBusCallbackDispatcher");
        this.setDaemon(true);
        this.start();
        this.commitAckExecutor = Executors.newSingleThreadExecutor();
        this.syncAckExecutor = Executors.newSingleThreadExecutor();
        this.msgDataExecutor = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configSyncComplete() {
        ConfigSyncCompleteCallbackEvent cbe = new ConfigSyncCompleteCallbackEvent();
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGPacket(BrokerAddress sender, GPacket pkt, Protocol p) {
        GPacketCallbackEvent cbe = new GPacketCallbackEvent(sender, pkt, p);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
    }

    public void processMessageAckReply(final BrokerAddress sender, final GPacket pkt, final Protocol p) {
        short type = pkt.getType();
        if (type != 4) {
            throw new RuntimeException("Internal Error: Unexpected packet type " + type + " passed to CallbackDispatcher.processMessageAckReply()");
        }
        if (this.processCommitAck(sender, pkt)) {
            return;
        }
        if (DEBUG_CLUSTER_MSG || DEBUG_CLUSTER_TXN) {
            logger.log(8, "processMessageAckReply: Received " + ProtocolGlobals.getPacketTypeDisplayString(type) + " from " + sender + ": " + ClusterMessageAckInfo.toString(pkt));
        }
        try {
            this.syncAckExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        p.handleGPacket(CallbackDispatcher.this.cb, sender, pkt);
                    }
                    catch (Throwable t) {
                        Logger logger = logger;
                        logger;
                        logger.logStack(16, "Exception in processing " + ClusterMessageAckInfo.toString(pkt) + " from " + sender, t);
                    }
                }
            });
        }
        catch (Throwable t) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore event " + ClusterMessageAckInfo.toString(pkt) + " from " + sender);
            }
            logger.logStack(16, "Exception in submitting for processing " + ClusterMessageAckInfo.toString(pkt) + " from " + sender, t);
        }
    }

    private boolean processCommitAck(final BrokerAddress sender, final GPacket pkt) {
        if (!ClusterMessageAckInfo.isAckAckAsync(pkt)) {
            return false;
        }
        Integer acktype = ClusterMessageAckInfo.getAckAckType(pkt);
        if (acktype == null || acktype != 3) {
            return false;
        }
        Long transactionID = ClusterMessageAckInfo.getAckAckTransactionID(pkt);
        if (transactionID == null) {
            return false;
        }
        if (ClusterMessageAckInfo.getAckAckStatus(pkt) != 200) {
            logger.log(16, this.br.getKString("B2117", sender, ClusterMessageAckInfo.toString(pkt)));
            return true;
        }
        if (DEBUG_CLUSTER_TXN || DEBUG) {
            logger.log(8, "processCommitAck: Received " + ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()) + " from " + sender + ": " + ClusterMessageAckInfo.toString(pkt));
        }
        if (CallbackDispatcher.fi.FAULT_INJECTION) {
            ClusterMessageAckInfo.CHECKFAULT(new HashMap(), 3, transactionID, "msg.remote_ack.p.", "3");
        }
        try {
            final TransactionUID tuid = new TransactionUID(transactionID);
            final UID ss = ClusterMessageAckInfo.getAckAckStoreSessionUID(pkt);
            this.commitAckExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object[] oo;
                        BrokerAddress addr = sender;
                        if (ss != null) {
                            addr = (BrokerAddress)sender.clone();
                            addr.setStoreSessionUID(ss);
                        }
                        if ((oo = TransactionList.getTransListAndState(tuid, null, true, false)) == null) {
                            Logger logger = logger;
                            logger;
                            logger.log(8, Globals.getBrokerResources().getKString("B2264", tuid, addr));
                            return;
                        }
                        TransactionList tl = (TransactionList)oo[0];
                        tl.completeClusterTransactionBrokerState(tuid, 6, addr, true);
                    }
                    catch (Throwable t) {
                        Object[] args = new Object[]{tuid, sender + "[" + ClusterMessageAckInfo.toString(pkt) + "]", t.getMessage()};
                        BrokerResources brokerResources = CallbackDispatcher.this.br;
                        CallbackDispatcher.this.br;
                        String emsg = brokerResources.getKString("B2273", args);
                        if (t instanceof BrokerException && ((BrokerException)t).getStatusCode() == 404) {
                            if (DEBUG_CLUSTER_TXN || DEBUG) {
                                Logger logger = logger;
                                logger;
                                logger.log(16, emsg + " - already completed");
                            }
                            return;
                        }
                        Logger logger = logger;
                        logger;
                        logger.logStack(16, emsg, t);
                    }
                }
            });
        }
        catch (Throwable t) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore event " + ClusterMessageAckInfo.toString(pkt) + " from " + sender);
            }
            logger.logStack(16, "Exception in submitting for processing " + ClusterMessageAckInfo.toString(pkt) + " from " + sender, t);
        }
        return true;
    }

    public void processMessageData(final BrokerAddress sender, final GPacket pkt, final Protocol p) {
        short type = pkt.getType();
        if (type != 1 && type != 6 && type != 10 && type != 36 && type != 8 && type != 22) {
            throw new RuntimeException("Internal Error: Unexpected packet type " + type + " passed to CallbackDispatcher.processMessageData()");
        }
        if (DEBUG_CLUSTER_MSG || DEBUG_CLUSTER_TXN) {
            logger.log(8, "processMessageData: Received " + ProtocolGlobals.getPacketTypeDisplayString(type) + " from " + sender);
        }
        try {
            this.msgDataExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        p.handleGPacket(CallbackDispatcher.this.cb, sender, pkt);
                    }
                    catch (Throwable t) {
                        Logger logger = logger;
                        logger;
                        logger.logStack(16, "Exception in processing " + ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()) + " from " + sender, t);
                    }
                }
            });
        }
        catch (Throwable t) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore packet " + ProtocolGlobals.getPacketTypeDisplayString(type) + " from " + sender);
            }
            logger.logStack(16, "Exception in submitting for processing " + ProtocolGlobals.getPacketTypeDisplayString(type) + " from " + sender, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGoodbye(BrokerAddress sender, ClusterGoodbyeInfo cgi) {
        CallbackEvent ev = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            Iterator itr = this.eventQ.iterator();
            while (itr.hasNext()) {
                GPacketCallbackEvent gpev;
                ev = (CallbackEvent)itr.next();
                if (!(ev instanceof GPacketCallbackEvent) || !(gpev = (GPacketCallbackEvent)ev).getSender().equals(sender) || gpev.getEventType() != 3 && gpev.getEventType() != 1) continue;
                if (DEBUG_CLUSTER_MSG || DEBUG_CLUSTER_TXN) {
                    logger.log(8, "Discard unprocessed " + ProtocolGlobals.getPacketTypeString(gpev.getEventType()) + " because received GOODBYE from " + sender);
                }
                itr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGoodbyeReply(BrokerAddress sender) {
        CallbackEvent ev = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            Iterator itr = this.eventQ.iterator();
            while (itr.hasNext()) {
                GPacketCallbackEvent gpev;
                ev = (CallbackEvent)itr.next();
                if (!(ev instanceof GPacketCallbackEvent) || !(gpev = (GPacketCallbackEvent)ev).getSender().equals(sender) || gpev.getEventType() != 4) continue;
                if (DEBUG) {
                    logger.log(8, "Processed G_MESSAGE_ACK_REPLY from " + sender);
                }
                gpev.dispatch(this.cb);
                itr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestCreated(Consumer intr) {
        InterestCreatedCallbackEvent cbe = new InterestCreatedCallbackEvent(intr);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestRemoved(Consumer intr, Map<TransactionUID, LinkedHashMap<SysMessageID, Integer>> pendingMsgs, boolean cleanup) {
        InterestRemovedCallbackEvent cbe = new InterestRemovedCallbackEvent(intr, pendingMsgs, cleanup);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeStateChanged(ConsumerUID intid) {
        PrimaryInterestChangedCallbackEvent cbe = new PrimaryInterestChangedCallbackEvent(intid);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeStateChanged(Consumer intr) {
        PrimaryInterestChangedCallbackEvent cbe = new PrimaryInterestChangedCallbackEvent(intr);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientDown(ConnectionUID conid) {
        ClientDownCallbackEvent cbe = new ClientDownCallbackEvent(conid);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brokerDown(BrokerAddress broker) {
        CallbackEvent e = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            Iterator itr = this.eventQ.iterator();
            while (itr.hasNext()) {
                GPacketCallbackEvent ge;
                e = (CallbackEvent)itr.next();
                if (!(e instanceof GPacketCallbackEvent) || !(ge = (GPacketCallbackEvent)e).getSender().equals(broker) || ge.getSender().getBrokerSessionUID() != null && broker.getBrokerSessionUID() != null && !ge.getSender().getBrokerSessionUID().equals(broker.getBrokerSessionUID())) continue;
                if (ge.getEventType() == 4 || ge.getEventType() == 5 || ge.getEventType() == 9 || ge.getEventType() == 35 || ge.getEventType() == 4 || ge.getEventType() == 2 || ge.getEventType() == 7 || ge.getEventType() == 15 || ge.getEventType() == 13 || ge.getEventType() == 21) {
                    ge.dispatch(this.cb);
                }
                itr.remove();
            }
        }
        this.cb.brokerDown(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCreateDestination(Destination d) {
        ClusterCreateDestinationCallbackEvent cbe = new ClusterCreateDestinationCallbackEvent(d, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore create destination event on " + d);
                return;
            }
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
        ((CallbackEvent)cbe).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDestroyDestination(DestinationUID uid) {
        ClusterDestroyDestinationCallbackEvent cbe = new ClusterDestroyDestinationCallbackEvent(uid, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore destroy destination event on " + uid);
                return;
            }
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
        ((CallbackEvent)cbe).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdateDestination(DestinationUID uid, Map changes) {
        ClusterUpdateDestinationCallbackEvent cbe = new ClusterUpdateDestinationCallbackEvent(uid, changes, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                logger.log(4, "Cluster shutdown, ignore update destination event on " + uid);
                return;
            }
            this.eventQ.add(cbe);
            this.eventQ.notifyAll();
        }
        ((CallbackEvent)cbe).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.stopThread = true;
            this.eventQ.notifyAll();
        }
        this.msgDataExecutor.shutdown();
        this.commitAckExecutor.shutdown();
        this.syncAckExecutor.shutdown();
        try {
            this.join(30000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            if (!this.msgDataExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.log(8, "Force cluster msgDataExecutor thread shutdown");
                this.msgDataExecutor.shutdownNow();
                this.msgDataExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            this.msgDataExecutor.shutdownNow();
        }
        try {
            if (!this.commitAckExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.log(8, "Force cluster commitAckExecutor thread shutdown");
                this.commitAckExecutor.shutdownNow();
                this.commitAckExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            this.commitAckExecutor.shutdownNow();
        }
        try {
            if (!this.syncAckExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                logger.log(8, "Force cluster syncAckExecutor thread shutdown");
                this.syncAckExecutor.shutdownNow();
                this.syncAckExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            this.syncAckExecutor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("stopThread", this.stopThread);
        Object[] events = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            events = this.eventQ.toArray();
        }
        ht.put("eventQCount", events.length);
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < events.length; ++i) {
            v.add(events[i].toString());
        }
        ht.put("eventQ", v);
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block41: {
            restartCode = BrokerStateHandler.getRestartCode();
            oomsg = Globals.getBrokerResources().getKString("B0083");
            cbe = null;
            try {
                firstpass = true;
                while (true) lbl-1000:
                // 5 sources

                {
                    try {
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            var5_8 = this.eventQ;
                            synchronized (var5_8) {
                                while (!this.stopThread && this.eventQ.isEmpty()) {
                                    try {
                                        this.eventQ.wait();
                                    }
                                    catch (Exception e) {}
                                }
                                if (this.stopThread) {
                                    break block41;
                                }
                                cbe = (CallbackEvent)this.eventQ.removeFirst();
                            }
                            try {
                                cbe.dispatch(this.cb);
                                firstpass = true;
                            }
                            finally {
                                l = cbe.getEventListener();
                                if (l == null) continue;
                                l.eventProcessed();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        CallbackDispatcher.logger.logStack(16, "Cluster dispatcher thread encountered exception: " + e.getMessage(), e);
                    }
                    catch (OutOfMemoryError e) {
                        if (firstpass) {
                            firstpass = false;
                            Globals.handleGlobalError(e, oomsg);
                            try {
                                CallbackDispatcher.sleep(1L);
                            }
                            catch (InterruptedException ex) {}
                        }
                        Broker.getBroker().exit(restartCode, oomsg, BrokerEvent.Type.RESTART, e, false, false, false);
                        continue;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (Throwable t) {
                CallbackDispatcher.logger.logStack(16, "Cluster dispatcher thread got unrecoverable exception", t);
                break block41;
            }
            finally {
                if (!this.stopThread) {
                    CallbackDispatcher.logger.log(16, "Cluster dispatcher thread exiting");
                }
                firstpass = this.eventQ;
                synchronized (firstpass) {
                    try {
                        cbe = (CallbackEvent)this.eventQ.removeFirst();
                        while (cbe != null) {
                            l = cbe.getEventListener();
                            if (l != null) {
                                l.eventProcessed();
                            }
                            cbe = (CallbackEvent)this.eventQ.removeFirst();
                        }
                    }
                    catch (NoSuchElementException e) {}
                    this.stopThread = true;
                }
            }
            ** GOTO lbl-1000
        }
    }
}

