/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerLink;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.Packet;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;

class BrokerLinkWriter
extends Thread {
    private OutputStream os = null;
    private LinkedList q = null;
    private BrokerLink parent;
    private boolean flowControl = false;
    private ArrayList backupQ = null;
    private static final int MAX_BUFFER_SIZE = 8192;
    private boolean stopThread = false;
    private boolean threadInWaiting = false;
    private boolean shutdownOutput = false;
    private boolean writeActive = false;

    public BrokerLinkWriter(BrokerLink parent) {
        this.parent = parent;
        this.setName("BrokerLinkWriter:" + parent.getRemoteString());
        this.setDaemon(true);
    }

    public void startWriterThread(OutputStream os) {
        this.os = new BufferedOutputStream(os, 8192);
        this.q = new LinkedList();
        this.flowControl = false;
        this.backupQ = new ArrayList();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlowControl(boolean enabled) {
        LinkedList linkedList = this.q;
        synchronized (linkedList) {
            if (this.stopThread || this.shutdownOutput) {
                return;
            }
            this.flowControl = enabled;
            if (!this.flowControl && !this.backupQ.isEmpty()) {
                this.q.addAll(0, this.backupQ);
                this.backupQ.clear();
                this.q.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.q == null) {
            return;
        }
        LinkedList linkedList = this.q;
        synchronized (linkedList) {
            if (this.shutdownOutput) {
                return;
            }
            this.stopThread = true;
            this.q.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputShutdown() {
        if (this.q == null) {
            return false;
        }
        LinkedList linkedList = this.q;
        synchronized (linkedList) {
            return this.shutdownOutput;
        }
    }

    public void sendPacket(Object p, boolean shutdownOutput) throws IOException {
        this.sendPacket(p, shutdownOutput, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Object p, boolean shutdownOutput, boolean urgent) throws IOException {
        LinkedList linkedList = this.q;
        synchronized (linkedList) {
            if (this.stopThread || this.shutdownOutput) {
                throw new IOException("Packet send failed. Unreachable BrokerAddress : " + this.parent.getRemoteString());
            }
            if (!shutdownOutput) {
                if (!urgent) {
                    this.q.add(p);
                } else {
                    this.q.addFirst(p);
                }
                this.q.notifyAll();
                return;
            }
            this.shutdownOutput = true;
            while (this.isAlive() && !this.threadInWaiting) {
                try {
                    this.q.wait();
                }
                catch (Exception e) {}
            }
            try {
                this.sendPacketDirect(p);
                this.stopThread = true;
                this.q.notifyAll();
                this.parent.closeConn(true, false);
                if (!this.parent.isOutputShutdown()) {
                    throw new IOException("socket output shutdown check failed");
                }
            }
            catch (IOException e) {
                this.shutdownOutput = false;
                this.parent.closeConn(false, true);
                throw e;
            }
        }
    }

    public void sendPacket(Object p) throws IOException {
        this.sendPacket(p, false, false);
    }

    private void sendPacketDirect(Object p) throws IOException {
        if (p instanceof GPacket) {
            this.sendPacketDirect((GPacket)p, true);
        } else {
            this.sendPacketDirect((Packet)p, true);
        }
    }

    private void sendPacketDirect(GPacket gp, boolean doFlush) throws IOException {
        if (this.os == null) {
            throw new IOException("os null");
        }
        try {
            gp.write(this.os);
            if (doFlush) {
                this.os.flush();
            }
            if (gp.getType() != 33) {
                this.writeActive = true;
            }
        }
        catch (IOException e) {
            this.os = null;
            throw e;
        }
    }

    private void sendPacketDirect(Packet p, boolean doFlush) throws IOException {
        if (this.os == null) {
            throw new IOException("os null");
        }
        try {
            p.writePacket(this.os);
            if (doFlush) {
                this.os.flush();
            }
            if (p.getPacketType() != 7) {
                this.writeActive = true;
            }
        }
        catch (IOException e) {
            this.os = null;
            throw e;
        }
    }

    protected void clearWriteActiveFlag() {
        this.writeActive = false;
    }

    protected boolean isWriteActive() {
        return this.writeActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        l = new ArrayList<Object>();
        while (true) {
            l.clear();
            var2_2 = this.q;
            synchronized (var2_2) {
                while (this.q.isEmpty() && !this.stopThread) {
                    try {
                        this.threadInWaiting = true;
                        this.q.notifyAll();
                        this.q.wait();
                        this.threadInWaiting = false;
                    }
                    catch (Exception e) {}
                }
                if (this.stopThread) {
                    return;
                }
                n = 0;
                bufferFull = false;
                while (!this.q.isEmpty()) {
                    block24: {
                        block23: {
                            o = this.q.getFirst();
                            gp = null;
                            p = null;
                            try {
                                gp = (GPacket)o;
                            }
                            catch (ClassCastException cce) {
                                p = (Packet)o;
                            }
                            if (gp == null) break block23;
                            if (!this.flowControl) ** GOTO lbl-1000
                            if (gp.getBit(32)) {
                                this.backupQ.add(gp);
                            } else lbl-1000:
                            // 2 sources

                            {
                                if (n + gp.getSize() > 8192) {
                                    bufferFull = true;
                                    break;
                                }
                                l.add(gp);
                                n += gp.getSize();
                            }
                            break block24;
                        }
                        if (!this.flowControl) ** GOTO lbl-1000
                        if (p.getFlag(1)) {
                            this.backupQ.add(p);
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (n + p.getPacketSize() > 8192) {
                                bufferFull = true;
                                break;
                            }
                            l.add(p);
                            n += p.getPacketSize();
                        }
                    }
                    this.q.removeFirst();
                }
                if (l.size() == 0 && bufferFull && !this.q.isEmpty()) {
                    l.add(this.q.removeFirst());
                }
            }
            try {
                for (i = 0; i < l.size(); ++i) {
                    try {
                        gp = (GPacket)l.get(i);
                        this.sendPacketDirect(gp, false);
                        continue;
                    }
                    catch (ClassCastException cce) {
                        p = (Packet)l.get(i);
                        this.sendPacketDirect(p, false);
                    }
                }
                if (this.os == null) continue;
                this.os.flush();
                continue;
            }
            catch (Exception e) {
                this.os = null;
                continue;
            }
            break;
        }
    }
}

