/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.heartbeat;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.HeartbeatInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.spi.Heartbeat;
import com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.spi.HeartbeatCallback;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.MQThreadGroup;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class HeartbeatService
implements HeartbeatCallback,
ClusterListener,
ConfigListener {
    private static boolean DEBUG = false;
    public static final String SERVICE_NAME = "heartbeat";
    public static final String SERVICE_TYPE = "HEARTBEAT";
    public static final short HEARTBEAT_ALIVE = 0;
    public static final int HEARTBEAT_PROTOCOL_VERSION = 400;
    public static final String HEARTBEAT_CLASS_PROP = "imq.cluster.heartbeat.class";
    public static final String HEARTBEAT_HOST_PROP = "imq.cluster.heartbeat.hostname";
    public static final String HEARTBEAT_PORT_PROP = "imq.cluster.heartbeat.port";
    public static final String HEARTBEAT_INTERVAL_PROP = "imq.cluster.heartbeat.interval";
    public static final String HEARTBEAT_THRESHOLD_PROP = "imq.cluster.heartbeat.threshold";
    private static final int HEARTBEAT_INTERVAL_DEFAULT = 5;
    private static final int HEARTBEAT_THRESHOLD_DEFAULT = 3;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private ClusterManager clsmgr = null;
    private Heartbeat hb = null;
    private Map<HeartbeatEntry, HeartbeatEntry> brokers = Collections.synchronizedMap(new LinkedHashMap());
    private TimeoutTimer timeoutTimer = null;
    private FaultInjection fi = FaultInjection.getInjection();
    private static final int MAX_PORTMAPPER_CONNECT_RETRY = 3;

    public HeartbeatService() throws Exception {
        this.clsmgr = Globals.getClusterManager();
        if (this.clsmgr == null) {
            throw new BrokerException("No cluster manager");
        }
        if (!this.clsmgr.isHA()) {
            throw new BrokerException("Non HA cluster");
        }
        this.initHeartbeat();
        this.clsmgr.addEventListener(this);
    }

    private void initHeartbeat() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnknownHostException, IOException {
        String cs = Globals.getConfig().getProperty(HEARTBEAT_CLASS_PROP);
        Class<?> c = Class.forName(cs);
        this.hb = (Heartbeat)c.newInstance();
        this.hb.setHeartbeatInterval(Globals.getConfig().getIntProperty(HEARTBEAT_INTERVAL_PROP, 5));
        this.hb.setTimeoutThreshold(Globals.getConfig().getIntProperty(HEARTBEAT_THRESHOLD_PROP, 3));
        int p = Globals.getConfig().getIntProperty(HEARTBEAT_PORT_PROP, this.clsmgr.getMQAddress().getPort());
        String h = Globals.getConfig().getProperty(HEARTBEAT_HOST_PROP);
        if (h == null) {
            h = Globals.getBrokerHostName();
        }
        InetSocketAddress bindEndpoint = new InetSocketAddress(InetAddress.getByName(h), p);
        this.hb.init(bindEndpoint, this);
        this.timeoutTimer = new TimeoutTimer();
        this.timeoutTimer.setPriority(10);
        this.timeoutTimer.setDaemon(true);
        this.timeoutTimer.start();
        Object[] args = new Object[]{SERVICE_NAME + (this.hb.getName() == null ? "" : " [" + this.hb.getName() + "]"), this.hb.getProtocol() + " ( " + bindEndpoint + " )", 1, 1};
        this.logger.log(8, "B1004", args);
    }

    public String getHeartbeatHostAddress() {
        return this.hb.getBindEndpoint().getAddress().getHostAddress();
    }

    public int getHeartbeatPort() {
        return this.hb.getBindEndpoint().getPort();
    }

    public int getHeartbeatInterval() {
        return this.hb.getHeartbeatInterval();
    }

    public void stopService() {
        try {
            this.hb.stop();
        }
        catch (IOException e) {
            this.logger.logStack(16, this.br.getKString("B2124"), e);
        }
        this.timeoutTimer.destroy();
        this.clsmgr.removeEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addBroker(HAClusteredBroker cb, UID brokerSession, BrokerInfo brokerInfo) {
        HeartbeatEntry hbe2 = null;
        ArrayList<Long> brokerSessions = new ArrayList<Long>();
        Map<HeartbeatEntry, HeartbeatEntry> map = this.brokers;
        synchronized (map) {
            for (HeartbeatEntry hbe2 : this.brokers.keySet()) {
                if (!cb.getBrokerName().equals(hbe2.brokerID)) continue;
                brokerSessions.add(hbe2.sessionUID);
            }
        }
        Iterator itr = brokerSessions.iterator();
        while (itr.hasNext()) {
            this.removeBroker(cb, new UID((Long)itr.next()));
        }
        hbe2 = new HeartbeatEntry();
        try {
            hbe2.brokerID = cb.getBrokerName();
            hbe2.sessionUID = brokerSession.longValue();
            hbe2.endpoint = new InetSocketAddress(InetAddress.getByName(brokerInfo.getHeartbeatHostAddress()), brokerInfo.getHeartbeatPort());
            HeartbeatInfo hbi = HeartbeatInfo.newInstance();
            HAClusteredBroker lcb = (HAClusteredBroker)this.clsmgr.getLocalBroker();
            hbi.setBrokerID(lcb.getBrokerName());
            hbi.setBrokerSession(lcb.getBrokerSessionUID().longValue());
            hbi.setBrokerAddress((BrokerMQAddress)lcb.getBrokerURL());
            hbi.setToBrokerID(cb.getBrokerName());
            hbi.setToBrokerSession(brokerSession.longValue());
            hbi.setSequence(0L);
            hbe2.gp = hbi.getGPacket();
            hbi = HeartbeatInfo.newInstance();
            hbi.setBrokerID(cb.getBrokerName());
            hbi.setBrokerSession(brokerSession.longValue());
            hbi.setBrokerAddress((BrokerMQAddress)cb.getBrokerURL());
            hbi.setToBrokerID(lcb.getBrokerName());
            hbi.setToBrokerSession(lcb.getBrokerSessionUID().longValue());
            hbe2.dataLength = HeartbeatInfo.toByteArray(hbi.getGPacket()).length;
            hbe2.heartbeatInterval = brokerInfo.getHeartbeatInterval();
            hbe2.lastTimestamp = System.currentTimeMillis();
            hbe2.lastSequence = 0L;
            this.brokers.put(hbe2, hbe2);
            this.hb.addEndpoint(hbe2, hbe2.endpoint, hbe2.dataLength + 500);
            this.logger.log(8, this.br.getKString("B1181", hbe2));
        }
        catch (Exception e) {
            this.logger.logStack(32, this.br.getKString("B3193", hbe2), e);
        }
    }

    public void removeHeartbeatEndpoint(HAClusteredBroker cb, UID brokerSession) {
        this.removeBroker(cb, brokerSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeBroker(HAClusteredBroker cb, UID brokerSession) {
        HeartbeatEntry hbe = new HeartbeatEntry();
        try {
            hbe.brokerID = cb.getBrokerName();
            hbe.sessionUID = brokerSession.longValue();
            HeartbeatEntry existed = this.brokers.remove(hbe);
            if (existed == null) {
                this.logger.log(16, this.br.getKString("B2121", hbe));
                return;
            }
            if (this.hb.removeEndpoint(existed, existed.endpoint)) {
                Map<HeartbeatEntry, HeartbeatEntry> map = this.brokers;
                synchronized (map) {
                    Iterator<HeartbeatEntry> itr = this.brokers.keySet().iterator();
                    while (itr.hasNext()) {
                        HeartbeatEntry entry = itr.next();
                        if (!cb.getBrokerName().equals(entry.brokerID) || !entry.endpoint.equals(existed.endpoint)) continue;
                        itr.remove();
                    }
                }
            }
            this.logger.log(8, this.br.getKString("B1182", existed));
        }
        catch (Exception e) {
            this.logger.logStack(32, this.br.getKString("B3194", hbe), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsuspect(HAClusteredBroker cb, UID brokerSession) {
        HeartbeatEntry hbe = new HeartbeatEntry();
        hbe.brokerID = cb.getBrokerName();
        hbe.sessionUID = brokerSession.longValue();
        HeartbeatEntry existed = this.brokers.get(hbe);
        if (existed == null) {
            if (DEBUG) {
                this.logger.log(8, "Unsuspect " + hbe + " not exist");
            }
            return;
        }
        HeartbeatEntry heartbeatEntry = existed;
        synchronized (heartbeatEntry) {
            existed.lastTimestamp = System.currentTimeMillis();
            existed.lastSequence = 0L;
        }
        this.logger.log(8, this.br.getKString("B1184", existed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeartbeatTimedout(String brokerid, UID brokerSession) {
        HeartbeatEntry hbe = new HeartbeatEntry();
        hbe.brokerID = brokerid;
        hbe.sessionUID = brokerSession.longValue();
        this.logger.log(8, this.br.getKString("B1410", hbe.toString()));
        HeartbeatEntry existed = this.brokers.get(hbe);
        if (existed == null) {
            this.logger.log(8, this.br.getKString("B1411", hbe.toString()));
            return true;
        }
        long timestamp = 0L;
        int interval = 0;
        HeartbeatEntry heartbeatEntry = existed;
        synchronized (heartbeatEntry) {
            timestamp = existed.lastTimestamp;
            interval = existed.heartbeatInterval;
        }
        long timeout = (long)(interval * this.hb.getTimeoutThreshold()) * 1000L;
        return timestamp < System.currentTimeMillis() - timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartbeatReceived(InetSocketAddress sender, byte[] data) throws IOException {
        if (data == null) {
            if (DEBUG) {
                this.logger.log(8, "HEARTBEAT: Ignore null data from " + sender);
            }
            throw new IOException("No data");
        }
        HeartbeatInfo hbi = null;
        HeartbeatEntry hbe = new HeartbeatEntry();
        try {
            hbi = HeartbeatInfo.newInstance(data);
        }
        catch (Exception e) {
            if (DEBUG) {
                this.logger.logStack(8, "HEARTBEAT: Ignore data from " + sender + " because " + e.getMessage(), e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
        hbe.brokerID = hbi.getBrokerID();
        hbe.sessionUID = hbi.getBrokerSession();
        hbe.lastSequence = hbi.getSequence();
        HeartbeatEntry assigned = this.brokers.get(hbe);
        if (assigned == null) {
            if (DEBUG) {
                this.logger.log(8, "HEARTBEAT: Ignore heartbeat from " + sender + " " + hbe.toStringKS());
            }
            throw new IOException("Ignore heartbeat because of not found " + hbe.toStringK());
        }
        HAClusteredBroker lcb = (HAClusteredBroker)this.clsmgr.getLocalBroker();
        if (!hbi.getToBrokerID().equals(lcb.getBrokerName()) || hbi.getToBrokerSession() != lcb.getBrokerSessionUID().longValue()) {
            if (DEBUG) {
                this.logger.log(8, "HEARTBEAT: Ignore heartbeat not for me. " + hbi);
            }
            throw new IOException("Ignore heartbeat not for me. " + hbi);
        }
        boolean order = false;
        HeartbeatEntry heartbeatEntry = assigned;
        synchronized (heartbeatEntry) {
            order = hbe.lastSequence > assigned.lastSequence;
        }
        if (!order) {
            if (DEBUG) {
                this.logger.log(8, "HEARTBEAT: Ignore duplicate or out-of-order heartbeat " + hbe.toStringKS() + "[" + assigned + "] from " + sender);
            }
            throw new IOException("Ignore duplicate or out-of-order heartbeat " + hbe.toStringKS());
        }
        if (DEBUG) {
            this.logger.log(8, "HEARTBEAT: Received heartbeat #" + hbe.lastSequence + " from " + assigned);
        }
        if (this.fi.FAULT_INJECTION) {
            HashMap<String, String> fips = new HashMap<String, String>();
            fips.put("mqBrokerID", hbi.getBrokerID());
            if (this.fi.checkFault("hb.recv", null) || this.fi.checkFault("hb.recv.brokerid", fips)) {
                this.logger.log(8, "DISCARD heartbeat from " + assigned + " because of FAULT");
                return;
            }
        }
        heartbeatEntry = assigned;
        synchronized (heartbeatEntry) {
            assigned.lastTimestamp = System.currentTimeMillis();
            assigned.lastSequence = hbi.getSequence();
        }
        assigned.sender = sender;
    }

    @Override
    public byte[] getBytesToSend(Object key, InetSocketAddress endpoint) throws IOException {
        HeartbeatEntry hbe = (HeartbeatEntry)key;
        assert (hbe.endpoint.equals(endpoint));
        if (this.fi.FAULT_INJECTION) {
            HashMap<String, String> fips = new HashMap<String, String>();
            fips.put("mqBrokerID", hbe.brokerID);
            if (this.fi.checkFault("hb.send", null) || this.fi.checkFault("hb.send.brokerid", fips)) {
                this.logger.log(8, "NOT SEND heartbeat to " + hbe + " because of FAULT");
                return null;
            }
        }
        hbe.gp.setSequence(hbe.gp.getSequence() + 1L);
        return HeartbeatInfo.toByteArray(hbe.gp);
    }

    @Override
    public void heartbeatIOException(Object key, InetSocketAddress endpoint, IOException reason) {
        this.heartbeatTimeout(key, endpoint, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartbeatTimeout(Object key, InetSocketAddress endpoint, IOException reason) {
        HeartbeatEntry hbe = (HeartbeatEntry)key;
        assert (endpoint.equals(hbe.endpoint));
        HeartbeatEntry entry = this.brokers.get(hbe);
        if (entry == null) {
            if (DEBUG) {
                this.logger.logStack(8, "HEARTBEAT: NotFound: Heart beat timeout because " + (reason == null ? "" : reason.getMessage()) + ": " + hbe + ". Ignore.", reason);
            }
            return;
        }
        long indoubtTimestamp = 0L;
        int heartbeatInterval = 0;
        HeartbeatEntry heartbeatEntry = entry;
        synchronized (heartbeatEntry) {
            indoubtTimestamp = entry.indoubtTimestamp;
            heartbeatInterval = entry.heartbeatInterval;
        }
        long timeout = (long)(heartbeatInterval * this.hb.getTimeoutThreshold()) * 1000L;
        if (indoubtTimestamp < System.currentTimeMillis() - timeout) {
            if (DEBUG) {
                this.logger.logStack(8, "Heart beat timeout because " + (reason == null ? "" : reason.getMessage()) + ": " + entry, reason);
            } else {
                this.logger.log(16, this.br.getKString("B2122", entry) + ": " + (reason == null ? "" : reason.getMessage()), reason);
            }
            if (!Globals.getSFSHAEnabled()) {
                HAClusteredBroker cb = (HAClusteredBroker)this.clsmgr.getBroker(entry.brokerID);
                cb.setBrokerInDoubt(true, new UID(hbe.sessionUID));
            }
            HeartbeatEntry heartbeatEntry2 = entry;
            synchronized (heartbeatEntry2) {
                entry.indoubtTimestamp = System.currentTimeMillis();
            }
        }
    }

    @Override
    public void clusterPropertyChanged(String name, String value) {
    }

    @Override
    public void brokerAdded(ClusteredBroker broker, UID brokerSession) {
    }

    @Override
    public void brokerRemoved(ClusteredBroker broker, UID brokerSession) {
    }

    @Override
    public void masterBrokerChanged(ClusteredBroker oldMaster, ClusteredBroker newMaster) {
    }

    @Override
    public void brokerStatusChanged(String brokerid, int oldStatus, int newStatus, UID brokerSession, Object userData) {
        HAClusteredBroker cb = (HAClusteredBroker)this.clsmgr.getBroker(brokerid);
        if (cb.isLocalBroker()) {
            return;
        }
        if ((BrokerStatus.getBrokerIsDown(oldStatus) || BrokerStatus.getBrokerLinkIsDown(oldStatus)) && BrokerStatus.getBrokerIsUp(newStatus) && BrokerStatus.getBrokerLinkIsUp(newStatus)) {
            this.logger.log(8, this.br.getKString("B1185", brokerid));
            this.addBroker(cb, brokerSession, (BrokerInfo)userData);
        }
        if (BrokerStatus.getBrokerInDoubt(oldStatus) && BrokerStatus.getBrokerNotInDoubt(newStatus)) {
            this.logger.log(8, this.br.getKString("B1183", brokerid));
            this.unsuspect(cb, brokerSession);
        }
        if (BrokerStatus.getBrokerIsDown(newStatus)) {
            this.logger.log(8, this.br.getKString("B1186", brokerid + "[BrokerSession:" + brokerSession + "]"));
            this.removeBroker(cb, brokerSession);
        }
    }

    @Override
    public void brokerStateChanged(String brokerid, BrokerState oldState, BrokerState newState) {
        ClusteredBroker cb = this.clsmgr.getBroker(brokerid);
        if (cb.isLocalBroker() && (newState == BrokerState.SHUTDOWN_COMPLETE || newState == BrokerState.SHUTDOWN_FAILOVER)) {
            this.stopService();
        }
    }

    @Override
    public void brokerVersionChanged(String brokerid, int oldVersion, int newVersion) {
    }

    @Override
    public void brokerURLChanged(String brokerid, MQAddress oldAddress, MQAddress newAddress) {
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
        if (name.equals(HEARTBEAT_HOST_PROP) || name.equals(HEARTBEAT_PORT_PROP)) {
            throw new PropertyUpdateException(this.br.getKString("B4248", name));
        }
        if (name.equals(HEARTBEAT_INTERVAL_PROP)) {
            throw new PropertyUpdateException(this.br.getKString("B4248", name));
        }
        if (name.equals(HEARTBEAT_THRESHOLD_PROP)) {
            throw new PropertyUpdateException(this.br.getKString("B4248", name));
        }
    }

    @Override
    public boolean update(String name, String value) {
        return true;
    }

    private static class HeartbeatEntry {
        String brokerID = null;
        long sessionUID = 0L;
        InetSocketAddress endpoint = null;
        InetSocketAddress sender = null;
        int heartbeatInterval = 0;
        long lastTimestamp = 0L;
        long lastSequence = 0L;
        int dataLength = 0;
        long indoubtTimestamp = 0L;
        GPacket gp = null;

        private HeartbeatEntry() {
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HeartbeatEntry)) {
                return false;
            }
            HeartbeatEntry hbe = (HeartbeatEntry)obj;
            return this.brokerID.equals(hbe.brokerID) && this.sessionUID == hbe.sessionUID;
        }

        public int hashCode() {
            return this.brokerID.hashCode() + String.valueOf(this.sessionUID).hashCode();
        }

        public String toString() {
            return (this.endpoint == null ? "" : this.endpoint.toString()) + " [brokerID=" + this.brokerID + ", brokerSession=" + String.valueOf(this.sessionUID) + "] (seq#=" + this.lastSequence + ", ts=" + this.lastTimestamp + ", interval=" + this.heartbeatInterval + ", len=" + this.dataLength + ")" + (this.sender == null ? "" : " sender=" + this.sender.toString());
        }

        public String toStringKS() {
            return "#" + this.lastSequence + " [brokerID=" + this.brokerID + ", brokerSession=" + String.valueOf(this.sessionUID) + "]";
        }

        public String toStringK() {
            return "[brokerID=" + this.brokerID + ", brokerSession=" + String.valueOf(this.sessionUID) + "]";
        }
    }

    class TimeoutTimer
    extends Thread {
        private Object lock;
        private boolean stopped;

        public TimeoutTimer() {
            Logger logger = HeartbeatService.this.logger;
            BrokerResources brokerResources = HeartbeatService.this.br;
            HeartbeatService.this.br;
            super((ThreadGroup)new MQThreadGroup("HeartbeatService", logger, brokerResources.getKString("B2258")), "Heartbeat-Timeout-Timer");
            this.lock = new Object();
            this.stopped = false;
            this.setPriority(10);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HeartbeatEntry[] hbes = null;
            HeartbeatEntry hbe = null;
            HeartbeatEntry entry = null;
            while (!this.stopped) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.stopped) {
                            break;
                        }
                        try {
                            this.lock.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (this.stopped) {
                            break;
                        }
                        Map e = HeartbeatService.this.brokers;
                        synchronized (e) {
                            Set ks = HeartbeatService.this.brokers.keySet();
                            hbes = ks.toArray(new HeartbeatEntry[ks.size()]);
                        }
                    }
                    if (DEBUG) {
                        Logger logger = HeartbeatService.this.logger;
                        HeartbeatService.this.logger;
                        logger.log(1, this.getName() + " checking " + hbes.length + " endpoints");
                    }
                    for (int i = 0; i < hbes.length; ++i) {
                        hbe = hbes[i];
                        long timeout = (long)(hbe.heartbeatInterval * HeartbeatService.this.hb.getTimeoutThreshold()) * 1000L;
                        if (hbe.lastTimestamp >= System.currentTimeMillis() - timeout || hbe.indoubtTimestamp >= System.currentTimeMillis() - timeout) continue;
                        Logger logger = HeartbeatService.this.logger;
                        HeartbeatService.this.logger;
                        BrokerResources brokerResources = HeartbeatService.this.br;
                        HeartbeatService.this.br;
                        logger.log(16, brokerResources.getKString("B2122", hbe));
                        if (!Globals.getSFSHAEnabled()) {
                            ClusteredBroker cb = HeartbeatService.this.clsmgr.getBroker(hbe.brokerID);
                            cb.setBrokerInDoubt(true, new UID(hbe.sessionUID));
                        }
                        if ((entry = (HeartbeatEntry)HeartbeatService.this.brokers.get(hbe)) == null) continue;
                        entry.indoubtTimestamp = System.currentTimeMillis();
                    }
                }
                catch (Throwable t) {
                    Logger logger = HeartbeatService.this.logger;
                    HeartbeatService.this.logger;
                    logger.logStack(16, this.getName() + ": " + t.getMessage(), t);
                }
            }
            if (!this.stopped) {
                Logger logger = HeartbeatService.this.logger;
                HeartbeatService.this.logger;
                BrokerResources brokerResources = HeartbeatService.this.br;
                HeartbeatService.this.br;
                logger.log(16, brokerResources.getKString("B0074", this.getName()));
            } else if (DEBUG) {
                Logger logger = HeartbeatService.this.logger;
                HeartbeatService.this.logger;
                BrokerResources brokerResources = HeartbeatService.this.br;
                HeartbeatService.this.br;
                logger.log(8, brokerResources.getKString("B0074", this.getName()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = this.lock;
            synchronized (object) {
                this.stopped = true;
                this.lock.notifyAll();
            }
        }
    }
}

