/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.CommitToken;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.CommitPointConsistencyPolicy;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.util.DbBackup;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.RepHAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.MigratableStore;
import com.sun.messaging.jmq.jmsserver.persist.api.MigratableStoreUtil;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.ReplicableStore;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreManager;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BrokerCurrentFile;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BrokerHostPortFile;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BrokerStateFile;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ConfigRecordStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.DestinationStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.InitTakeoverRunnable;
import com.sun.messaging.jmq.jmsserver.persist.bdb.InterestStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.JoinRunnable;
import com.sun.messaging.jmq.jmsserver.persist.bdb.MessageEnumeration;
import com.sun.messaging.jmq.jmsserver.persist.bdb.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.PropertiesStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ReplicationStateChangeListener;
import com.sun.messaging.jmq.jmsserver.persist.bdb.TakeoverSessionStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.TxnStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.Util;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.util.UID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore")
@Singleton
public class BDBStore
extends Store
implements PartitionedStore,
MigratableStore,
ReplicableStore {
    private FaultInjection fi = FaultInjection.getInjection();
    public static final int STORE_VERSION = 500;
    static final String BDB_PROP_PREFIX = "imq.persist.bdb.";
    static final String MAX_RETRIES_PROP = "imq.persist.bdb.maxRetriesOnLockConflict";
    static final String ODSYNC_PROP = "imq.persist.bdb.useOdsync";
    static final boolean DEFAULT_USE_ODSYNC = false;
    static final String TAKEOVER_USE_CLUSTER_LOCK_PROP = "imq.persist.bdb.haUseClusterLock";
    static final boolean DEFAULT_TAKEOVER_USE_CLUSTER_LOCK = true;
    static final String HOSTNAME_PROP = "imq.persist.bdb.replication.hostname";
    static final String PORTBASE_PROP = "imq.persist.bdb.replication.portbase";
    static final String REPLICA_SYNC_TIMEOUT_PROP = "imq.persist.bdb.replicaSyncTimeout";
    static final String REPLICA_MAX_CLOCK_SKEW_PROP = "imq.persist.bdb.replication.maxClockSkew";
    private static final ConsumerUID[] emptysids = new ConsumerUID[0];
    private static final int[] emptystates = new int[0];
    static final int OP_DEFAULT_MAX_RETRIES = 5;
    static final int DEFAULT_REPLICA_SYNC_TIMEOUT = 3600;
    static final int DEFAULT_REPLICA_MAX_CLOCK_SKEW = 15;
    private Database dstDatabase = null;
    private Database intDatabase = null;
    private Database txnDatabase = null;
    private Database txnackDatabase = null;
    private Database configRecordDatabase = null;
    private Database propDatabase = null;
    private Database takeoverSessionDatabase = null;
    private Database classDatabase = null;
    private StoredClassCatalog classCatalog = null;
    private DestinationStore dstStore = null;
    private MsgStore msgStore = null;
    private InterestStore intStore = null;
    private PropertiesStore propStore = null;
    private TakeoverSessionStore takeoverSessionStore = null;
    private ConfigRecordStore configRecordStore = null;
    private TxnStore txnStore = null;
    static final String BDBSTORE_BASENAME = "bdb";
    static final String BDBSTORE_TOP = "bdb" + String.valueOf(500);
    static final String SFS_PARTITIONS_TOP = "PARTITIONS_" + BDBSTORE_TOP;
    private Object replicaTOPLock = new Object();
    private int maxRetries = config.getIntProperty("imq.persist.bdb.maxRetriesOnLockConflict", 5);
    private boolean useOdsync = config.getBooleanProperty("imq.persist.bdb.useOdsync", false);
    private long replicaSyncTimeout = config.getIntProperty("imq.persist.bdb.replicaSyncTimeout", 3600);
    private long maxClockSkew = config.getIntProperty("imq.persist.bdb.replication.maxClockSkew", 15);
    private List<Enumeration> dataEnums = Collections.synchronizedList(new ArrayList());
    private TransactionConfig syncTxncf = null;
    protected Map<String, ReplicatedEnvironment> replicaEnvs = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, ExecutorService> joinExecutors = Collections.synchronizedMap(new LinkedHashMap());
    private AtomicInteger nextReplicaPort = null;
    private int shutdownReplicaTimeout = 60;
    protected String myrepGroupName = null;
    protected String myEffectiveBrokerID = null;
    private File jeenvtop = null;
    private File envhome = null;
    private File bdbtop = null;
    private Environment dbEnv = null;
    private DatabaseConfig dbcf = null;
    private boolean replica = false;
    ReplicationStateChangeListener repStateListener = null;
    BrokerCurrentFile currentFile = null;
    BrokerStateFile brokerstateFile = null;
    private UID partitionid = PartitionedStore.DEFAULT_UID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDBStore() throws BrokerException {
        String instancename = Globals.getJMQ_INSTANCES_HOME() + File.separator + Globals.getConfigName() + File.separator;
        File instanceDir = new File(instancename);
        this.bdbtop = new File(instanceDir, BDBSTORE_TOP);
        if (Globals.getSFSHAEnabled()) {
            this.jeenvtop = new File(Globals.getJMQ_INSTANCES_HOME(), SFS_PARTITIONS_TOP);
            if (!this.jeenvtop.exists() && !this.jeenvtop.mkdirs()) {
                String emsg = br.getKString("B3017", this.jeenvtop);
                logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        } else {
            this.jeenvtop = this.bdbtop;
        }
        if (this.removeStore && !this.bdbtop.exists()) {
            return;
        }
        boolean newstore = false;
        String storeSessionState = null;
        String lastmyhost = null;
        try {
            if (!this.bdbtop.exists()) {
                if (!this.bdbtop.mkdirs()) {
                    logger.log(32, "B3017", this.bdbtop);
                    throw new BrokerException(br.getString("B3017", this.bdbtop));
                }
                newstore = true;
                this.currentFile = new BrokerCurrentFile(this.bdbtop, false);
                storeSessionState = "NEW_CREATED:";
                this.brokerstateFile = new BrokerStateFile(this.jeenvtop, this.bdbtop, true, this.currentFile, Globals.getConfigName(), false);
            } else {
                this.currentFile = new BrokerCurrentFile(this.bdbtop, false);
                UID uid = this.currentFile.readStoreSession();
                if (uid == null) {
                    newstore = true;
                    storeSessionState = "NEW_CREATED:";
                    this.brokerstateFile = new BrokerStateFile(this.jeenvtop, this.bdbtop, true, this.currentFile, Globals.getConfigName(), false);
                } else {
                    this.brokerstateFile = new BrokerStateFile(this.jeenvtop, this.bdbtop, false, uid, Globals.getConfigName(), false);
                }
            }
            this.envhome = this.brokerstateFile.envhome;
            lastmyhost = BrokerStateFile.readHostFromRepHostPortFile(this.bdbtop, Globals.getConfigName());
            int state = this.brokerstateFile.readBrokerState();
            BrokerState st = BrokerState.getState(state);
            if (st == BrokerState.FAILOVER_PREPARED || st == BrokerState.FAILOVER_COMPLETE) {
                newstore = true;
                storeSessionState = "NEW_CREATED:";
                this.brokerstateFile.close();
                this.brokerstateFile = new BrokerStateFile(this.jeenvtop, this.bdbtop, true, this.currentFile, Globals.getConfigName(), false);
                this.envhome = this.brokerstateFile.envhome;
            }
            this.syncTxncf = new TransactionConfig();
            this.syncTxncf.setDurability(Durability.COMMIT_SYNC);
            Durability defaultdp = new Durability(Durability.SyncPolicy.WRITE_NO_SYNC, Durability.SyncPolicy.WRITE_NO_SYNC, Durability.ReplicaAckPolicy.NONE);
            EnvironmentConfig envcf = new EnvironmentConfig();
            envcf.setAllowCreate(!this.removeStore && this.createStore);
            envcf.setTransactional(true);
            envcf.setReadOnly(false);
            envcf.setDurability(defaultdp);
            envcf.setTxnTimeout(60L, TimeUnit.SECONDS);
            if (this.useOdsync || StoreManager.isConfiguredBDBSharedFS()) {
                envcf.setConfigParam("je.log.useODSYNC", "true");
            }
            this.dbcf = new DatabaseConfig();
            this.dbcf.setReadOnly(envcf.getReadOnly());
            this.dbcf.setAllowCreate(!this.removeStore && this.createStore);
            this.dbcf.setTransactional(true);
            this.dbcf.setSortedDuplicates(false);
            if (!this.removeStore) {
                if (this.createStore) {
                    logger.log(8, "B1170");
                } else {
                    logger.log(8, "B1171");
                }
            }
            logger.logToAll(8, "Using Berkeley DB Java Edition " + JEVersion.CURRENT_VERSION);
            this.myEffectiveBrokerID = MigratableStoreUtil.makeEffectiveBrokerID(Globals.getConfigName(), this.brokerstateFile.uid);
            try {
                if (!StoreManager.bdbREPEnabled()) {
                    this.dbEnv = new Environment(this.envhome, envcf);
                    logger.logToAll(8, "BDB EnvironmentConfig: " + this.dbEnv.getConfig());
                } else {
                    this.initReplicationPort();
                    String myhostport = null;
                    while (true) {
                        ReplicationConfig repcf = new ReplicationConfig();
                        this.myrepGroupName = MigratableStoreUtil.makeReplicationGroupID(Globals.getConfigName(), this.brokerstateFile.uid);
                        repcf.setMaxClockDelta(this.maxClockSkew, TimeUnit.SECONDS);
                        repcf.setDesignatedPrimary(true);
                        repcf.setConfigParam("je.rep.electableGroupSizeOverride", "1");
                        repcf.setConfigParam("je.rep.electionsPrimaryRetries", "1");
                        repcf.setGroupName(this.myrepGroupName);
                        repcf.setNodeName(this.getMyReplicationNodeName());
                        myhostport = this.getMyReplicationHostPort();
                        if (!newstore && lastmyhost != null && !lastmyhost.equals(this.getMyReplicationHost())) {
                            String emsg = "Replication host cannot be changed for an existing store session. This broker's current store session " + this.brokerstateFile.id + " had host " + lastmyhost + ", but new host is " + this.getMyReplicationHost();
                            logger.log(32, emsg);
                            throw new BrokerException(emsg);
                        }
                        repcf.setNodeHostPort(myhostport);
                        logger.log(8, "BDB replication group " + this.myrepGroupName + " on [" + this.myEffectiveBrokerID + ", " + myhostport + "]");
                        repcf.setHelperHosts(myhostport);
                        this.dbEnv = new ReplicatedEnvironment(this.envhome, repcf, envcf);
                        this.repStateListener = new ReplicationStateChangeListener(this.getMyReplicationNodeName(), this.myrepGroupName);
                        ((ReplicatedEnvironment)this.dbEnv).setStateChangeListener((StateChangeListener)this.repStateListener);
                        try {
                            logger.log(8, "Waiting becoming BDB replication master for group " + this.myrepGroupName);
                            this.repStateListener.waitBecomeMaster(30000L);
                        }
                        catch (Exception e) {
                            if (newstore) {
                                throw e;
                            }
                            if (!(e instanceof BrokerException)) {
                                throw e;
                            }
                            logger.log(8, "Store session " + this.brokerstateFile.id + " has been taken over by someone, start new store session");
                            this.dbEnv.close();
                            newstore = true;
                            storeSessionState = "NEW_CREATED:";
                            this.brokerstateFile.close();
                            this.brokerstateFile = new BrokerStateFile(this.jeenvtop, this.bdbtop, true, this.currentFile, Globals.getConfigName(), false);
                            this.envhome = this.brokerstateFile.envhome;
                            continue;
                        }
                        break;
                    }
                    if (newstore) {
                        BrokerStateFile.writeRepHostPortFile(new File(BDBStore.getReplicaTop()), Globals.getConfigName(), myhostport);
                    }
                    logger.logToAll(8, "BDB ReplicatedEnvironmentConfig: " + this.dbEnv.getConfig());
                }
                Globals.setStoreSession(this.brokerstateFile.uid);
                if (!Globals.getSFSHAEnabled() && !this.removeStore) {
                    ClusteredBroker cb = Globals.getClusterManager().getLocalBroker();
                    ((RepHAClusteredBrokerImpl)cb).setStoreSessionUID(this.brokerstateFile.uid);
                }
                logger.logToAll(8, "BDB store started with store session " + this.brokerstateFile.uid);
            }
            catch (EnvironmentNotFoundException e) {
                if (this.removeStore) {
                    logger.log(8, e.getMessage());
                }
                logger.logStack(32, e.getMessage(), e);
                throw new BrokerException(e.getMessage(), e);
            }
            if (StoreManager.bdbREPEnabled()) {
                logger.logToAll(8, "BDB ReplicationConfig: " + ((ReplicatedEnvironment)this.dbEnv).getRepConfig());
            }
            if (this.removeStore) {
                try {
                    if (this.dbEnv != null) {
                        Transaction txn = this.dbEnv.beginTransaction(null, null);
                        try {
                            txn.setTxnTimeout(300L, TimeUnit.SECONDS);
                            List dbnames = this.dbEnv.getDatabaseNames();
                            for (int i = 0; i < dbnames.size(); ++i) {
                                this.dbEnv.removeDatabase(txn, (String)dbnames.get(i));
                            }
                            txn.commit(new Durability(Durability.SyncPolicy.SYNC, null, null));
                            txn = null;
                        }
                        catch (Exception e) {
                            logger.logStack(32, "Failed to remove store ", e);
                            try {
                                if (txn != null) {
                                    txn.abort();
                                }
                            }
                            catch (Exception e1) {
                                logger.logStack(16, "Abort removing store transaction failed", e1);
                            }
                            throw new BrokerException(e.getMessage(), e);
                        }
                    }
                    return;
                }
                finally {
                    try {
                        this.closeStores(false);
                    }
                    finally {
                        this.closeLockFiles();
                    }
                }
            }
            if (this.resetStore) {
                this.truncateDatabases(this.dbEnv);
            }
            this.classDatabase = this.dbEnv.openDatabase(null, "classdb", this.dbcf);
            this.classCatalog = new StoredClassCatalog(this.classDatabase);
            this.openStores(this.dbEnv);
            if (!this.resetStore) {
                if (this.resetMessage) {
                    this.clearMessages(true);
                }
                if (this.resetInterest) {
                    this.clearInterests();
                }
            }
            if (storeSessionState == null) {
                storeSessionState = ":";
            }
            this.storeTakeoverSession(this.brokerstateFile.id, storeSessionState + System.currentTimeMillis(), false, false, TakeoverSessionStore.OWNER_STATES);
        }
        catch (Exception e) {
            logger.logStack(32, e.getMessage(), e);
            this.close();
            throw new BrokerException(e.getMessage(), e);
        }
    }

    private BDBStore(Environment env) throws BrokerException {
        this.replica = true;
        this.dbEnv = env;
        this.dbcf = new DatabaseConfig();
        this.dbcf.setReadOnly(env.getConfig().getReadOnly());
        this.dbcf.setAllowCreate(false);
        this.dbcf.setTransactional(true);
        this.dbcf.setSortedDuplicates(false);
        this.classDatabase = this.dbEnv.openDatabase(null, "classdb", this.dbcf);
        this.classCatalog = new StoredClassCatalog(this.classDatabase);
        this.openStores(env);
    }

    private boolean isReplica() {
        return this.replica;
    }

    private void initReplicationPort() throws Exception {
        String str = Globals.getConfig().getProperty(PORTBASE_PROP);
        ArrayList<Integer> ports = new ArrayList<Integer>();
        Integer lastport = BrokerStateFile.readLastPortFromRepHostPortFile(new File(BDBStore.getReplicaTop()), ports);
        if (lastport != null) {
            this.nextReplicaPort = new AtomicInteger(lastport + 1);
            if (str != null) {
                String m1 = br.getKString("B2219", "imq.persist.bdb.replication.portbase=" + str);
                String m2 = br.getKString("B1419", ports.toString());
                logger.log(8, m1 + " - " + m2);
            }
            return;
        }
        int port = -1;
        if (str != null) {
            try {
                port = Integer.parseInt(str);
                if (port <= 0) {
                    throw new IllegalArgumentException(br.getKString("B4027", "imq.persist.bdb.replication.portbase=" + str));
                }
            }
            catch (Exception e) {
                String emsg = br.getKString("B4027", "imq.persist.bdb.replication.portbase=" + str);
                throw new BrokerException(emsg, e);
            }
            this.nextReplicaPort = new AtomicInteger(port);
        } else {
            this.nextReplicaPort = new AtomicInteger(new ReplicationConfig().getNodePort());
        }
    }

    @Override
    public String getMyReplicationGroupName() {
        return this.myrepGroupName;
    }

    private String getMyReplicationNodeName() {
        return Globals.getConfigName();
    }

    @Override
    public String getMyEffectiveBrokerID() {
        return this.myEffectiveBrokerID;
    }

    private String getMyReplicationHost() {
        return Globals.getBrokerInetAddress().getCanonicalHostName();
    }

    @Override
    public String getMyReplicationHostPort() throws BrokerException {
        try {
            String host = this.getMyReplicationHost();
            Integer p = BrokerStateFile.readPortFromRepHostPortFile(new File(BDBStore.getReplicaTop()), Globals.getConfigName());
            if (p != null) {
                return host + ":" + p;
            }
            int port = this.nextReplicaPort.getAndAdd(1);
            return host + ":" + port;
        }
        catch (Exception e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    public String getReplicaHostPortFor(String groupName, String ebrokerid) throws Exception {
        String instn;
        if (Store.getDEBUG()) {
            logger.log(8, "getReplicaHostPortFor(" + groupName + ", " + ebrokerid + ")");
        }
        if ((instn = MigratableStoreUtil.parseEffectiveBrokerIDToInstName(ebrokerid)).equals(Globals.getConfigName())) {
            throw new BrokerException(br.getKString("B3300", instn, ebrokerid));
        }
        String host = this.getMyReplicationHost();
        Integer p = BrokerStateFile.readPortFromRepHostPortFile(new File(BDBStore.getReplicaTop()), instn);
        if (p != null) {
            return host + ":" + p;
        }
        int port = this.nextReplicaPort.getAndAdd(1);
        return host + ":" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMyReplicas() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "getMyReplicas()");
        }
        super.checkClosedAndSetInProgress();
        try {
            Set nodes = ((ReplicatedEnvironment)this.dbEnv).getGroup().getElectableNodes();
            logger.log(8, "This broker current replication group [" + this.getMyReplicationGroupName() + "] members: " + nodes);
            String name = null;
            ArrayList<String> names = new ArrayList<String>();
            Iterator itr = nodes.iterator();
            while (itr.hasNext()) {
                name = ((ReplicationNode)itr.next()).getName();
                if (name.equals(this.getMyReplicationNodeName())) continue;
                names.add(name);
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        finally {
            super.setInProgress(false);
        }
    }

    public String getInstNameFromNodeName(String nodeName) throws BrokerException {
        int ind = nodeName.lastIndexOf("S");
        if (ind < 0 || ind >= nodeName.length() - 1) {
            String emsg = "Malformed replicain node name " + nodeName;
            throw new BrokerException(emsg);
        }
        String instn = nodeName.substring(0, ind);
        if (instn.trim().length() == 0) {
            String emsg = "Malformed replicain node name " + nodeName;
            throw new BrokerException(emsg);
        }
        String ss = nodeName.substring(ind + 1);
        try {
            Long.valueOf(ss);
        }
        catch (Exception e) {
            String emsg = "Malformed replica node name " + nodeName;
            throw new BrokerException(emsg, e);
        }
        return instn;
    }

    public static UID getStoreSessionFromNodeName(String nodeName) throws BrokerException {
        int ind = nodeName.lastIndexOf("S");
        if (ind < 0 || ind >= nodeName.length() - 1) {
            String emsg = "Malformed replicain node name " + nodeName;
            throw new BrokerException(emsg);
        }
        String instn = nodeName.substring(0, ind);
        if (instn.trim().length() == 0) {
            String emsg = "Malformed repliction node name " + nodeName;
            throw new BrokerException(emsg);
        }
        String ss = nodeName.substring(ind + 1);
        Long l = null;
        try {
            l = Long.valueOf(ss);
        }
        catch (Exception e) {
            String emsg = "Malformed replicain node name " + nodeName;
            throw new BrokerException(emsg, e);
        }
        return new UID(l);
    }

    public String toString() {
        if (this.dbEnv == null) {
            return "[" + this.getStoreType() + "]@" + super.toString();
        }
        return "[" + this.getStoreType() + "]" + this.dbEnv.getHome().getName() + "@" + super.toString();
    }

    private void openStores(Environment env) throws BrokerException {
        String logstr = this.isReplica() ? "replicated" : "";
        try {
            this.dstDatabase = env.openDatabase(null, "dststore", this.dbcf);
            this.intDatabase = env.openDatabase(null, "intstore", this.dbcf);
            this.txnDatabase = env.openDatabase(null, "txnstore", this.dbcf);
            this.txnackDatabase = env.openDatabase(null, "txnackstore", this.dbcf);
            this.configRecordDatabase = env.openDatabase(null, "crstore", this.dbcf);
            this.propDatabase = env.openDatabase(null, "propstore", this.dbcf);
            this.takeoverSessionDatabase = env.openDatabase(null, "takeovers", this.dbcf);
            this.dstStore = new DestinationStore(this);
            this.msgStore = new MsgStore(this, this.dstStore);
            this.intStore = new InterestStore(this);
            this.txnStore = new TxnStore(this);
            this.propStore = new PropertiesStore(this);
            this.takeoverSessionStore = new TakeoverSessionStore(this);
            this.configRecordStore = new ConfigRecordStore(this);
        }
        catch (Exception e) {
            String emsg = "Failed to open " + logstr + " store databases  " + env;
            logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    private void truncateDatabases(Environment env) throws BrokerException {
        String logstr = this.isReplica() ? "replica[" + env + "]" : "";
        Transaction txn = env.beginTransaction(null, null);
        try {
            txn.setTxnTimeout(300L, TimeUnit.SECONDS);
            List dbnames = env.getDatabaseNames();
            Object name = null;
            for (int i = 0; i < dbnames.size(); ++i) {
                env.truncateDatabase(txn, (String)dbnames.get(i), false);
            }
            txn.commit(new Durability(Durability.SyncPolicy.SYNC, null, null));
        }
        catch (Exception e) {
            logger.logStack(32, "Failed to reset " + logstr + " store", e);
            try {
                txn.abort();
            }
            catch (Exception e1) {
                logger.logStack(16, "Failed to abort reset " + logstr + " store transaction", e1);
            }
            throw new BrokerException(e.getMessage(), e);
        }
    }

    protected Environment getDBEnv() {
        return this.dbEnv;
    }

    @Override
    public final int getStoreVersion() {
        return 500;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeWaitOnClose() {
        Iterator<Enumeration> itr = null;
        List<Enumeration> list = this.dataEnums;
        synchronized (list) {
            itr = this.dataEnums.iterator();
            Enumeration en = null;
            while (itr.hasNext()) {
                en = itr.next();
                if (!(en instanceof MessageEnumeration)) continue;
                ((MessageEnumeration)en).cancel();
            }
        }
    }

    @Override
    public void close(boolean cleanup) {
        if (this.closed) {
            return;
        }
        logger.logToAll(8, "Closing BDB store .. ");
        super.setClosedAndWait();
        try {
            this.closeStores(false);
        }
        catch (Exception e) {
            logger.log(16, "Exception in closing store: " + e.getMessage());
        }
    }

    private void closeStores(boolean throwex) throws Exception {
        block50: {
            int level;
            block49: {
                block48: {
                    block47: {
                        block46: {
                            block45: {
                                block44: {
                                    block43: {
                                        block42: {
                                            block41: {
                                                block40: {
                                                    String logstr = this.isReplica() ? "replica[" + this.dbEnv + "]" : "";
                                                    int n = level = throwex ? 32 : 16;
                                                    if (this.msgStore != null) {
                                                        this.msgStore.close();
                                                    }
                                                    if (this.dstStore != null) {
                                                        this.dstStore.close();
                                                    }
                                                    if (this.intStore != null) {
                                                        this.intStore.close();
                                                    }
                                                    if (this.txnStore != null) {
                                                        this.txnStore.close();
                                                    }
                                                    if (this.propStore != null) {
                                                        this.propStore.close();
                                                    }
                                                    if (this.configRecordStore != null) {
                                                        this.configRecordStore.close();
                                                    }
                                                    if (this.takeoverSessionStore != null) {
                                                        this.takeoverSessionStore.close();
                                                    }
                                                    try {
                                                        if (this.dstDatabase != null) {
                                                            this.dstDatabase.close();
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        logger.logStack(level, "Exception in closing destination database", e);
                                                        if (!throwex) break block40;
                                                        throw e;
                                                    }
                                                }
                                                try {
                                                    if (this.intDatabase != null) {
                                                        this.intDatabase.close();
                                                    }
                                                }
                                                catch (Exception e) {
                                                    logger.logStack(level, "Exception in closing interest database", e);
                                                    if (!throwex) break block41;
                                                    throw e;
                                                }
                                            }
                                            try {
                                                if (this.txnDatabase != null) {
                                                    this.txnDatabase.close();
                                                }
                                            }
                                            catch (Exception e) {
                                                logger.logStack(level, "Exception in closing transaction database", e);
                                                if (!throwex) break block42;
                                                throw e;
                                            }
                                        }
                                        try {
                                            if (this.txnackDatabase != null) {
                                                this.txnackDatabase.close();
                                            }
                                        }
                                        catch (Exception e) {
                                            logger.logStack(level, "Exception in closing transaction ack database", e);
                                            if (!throwex) break block43;
                                            throw e;
                                        }
                                    }
                                    try {
                                        if (this.configRecordDatabase != null) {
                                            this.configRecordDatabase.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.logStack(level, "Exception in closing cluster configuration change record database", e);
                                        if (!throwex) break block44;
                                        throw e;
                                    }
                                }
                                try {
                                    if (this.propDatabase != null) {
                                        this.propDatabase.close();
                                    }
                                }
                                catch (Exception e) {
                                    logger.logStack(level, "Exception in closing properties database", e);
                                    if (!throwex) break block45;
                                    throw e;
                                }
                            }
                            try {
                                if (this.takeoverSessionDatabase != null) {
                                    this.takeoverSessionDatabase.close();
                                }
                            }
                            catch (Exception e) {
                                logger.logStack(level, "Exception in closing takeover session database", e);
                                if (!throwex) break block46;
                                throw e;
                            }
                        }
                        try {
                            if (this.classCatalog != null) {
                                this.classCatalog.close();
                            }
                        }
                        catch (Exception e) {
                            logger.logStack(level, "Exception in closing class catalog", e);
                            if (!throwex) break block47;
                            throw e;
                        }
                    }
                    try {
                        if (this.classDatabase != null) {
                            this.classDatabase.close();
                        }
                    }
                    catch (Exception e) {
                        logger.logStack(level, "Exception in closing class catalog database", e);
                        if (!throwex) break block48;
                        throw e;
                    }
                }
                if (this.dbEnv instanceof ReplicatedEnvironment && !this.isReplica()) {
                    try {
                        logger.log(8, "Shutdown BDB replication group " + this.myrepGroupName);
                        ((ReplicatedEnvironment)this.dbEnv).shutdownGroup((long)this.shutdownReplicaTimeout, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        logger.logStack(level, "Exception in shutdown BDB replicated environment", e);
                        if (!throwex) break block49;
                        throw e;
                    }
                }
            }
            if (this.dbEnv != null) {
                try {
                    this.dbEnv.close();
                }
                catch (Exception e) {
                    logger.logStack(level, "Exception in closing BDB environment", e);
                    if (!throwex) break block50;
                    throw e;
                }
            }
        }
        logger.log(8, "BDB store close complete");
    }

    private void closeLockFiles() {
        if (this.brokerstateFile != null) {
            try {
                this.brokerstateFile.close();
            }
            catch (Exception e) {
                logger.log(16, "Exception on closing " + this.brokerstateFile + ": " + e.getMessage());
            }
        }
        if (this.currentFile != null) {
            try {
                this.currentFile.close();
            }
            catch (Exception e) {
                logger.log(16, "Exception on closing " + this.currentFile + ": " + e.getMessage());
            }
        }
    }

    @Override
    public void clearAll(boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.clearAll(" + sync + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.closeStores(true);
            this.truncateDatabases(this.dbEnv);
            this.openStores(this.dbEnv);
            this.clearMessages(false);
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException("Close store failed: " + e.getMessage(), e);
        }
        finally {
            this.setInProgress(false);
        }
    }

    private void clearMessages(boolean msgonly) throws BrokerException {
        Transaction txn = this.dbEnv.beginTransaction(null, null);
        try {
            txn.setTxnTimeout(300L, TimeUnit.SECONDS);
            this.dstStore.clearAll(txn, msgonly);
            txn.commit(new Durability(Durability.SyncPolicy.SYNC, null, null));
            return;
        }
        catch (Exception e) {
            logger.logStack(32, "Clear all messages in store failed", e);
            try {
                txn.abort();
            }
            catch (Exception e1) {
                logger.logStack(16, "Failed to abort clear messages transaction", e1);
            }
            throw new BrokerException(e.getMessage(), e);
        }
    }

    private void clearInterests() throws BrokerException {
        Transaction txn = this.dbEnv.beginTransaction(null, null);
        try {
            txn.setTxnTimeout(300L, TimeUnit.SECONDS);
            this.intStore.clearAll(txn);
            txn.commit(new Durability(Durability.SyncPolicy.SYNC, null, null));
            return;
        }
        catch (Exception e) {
            logger.logStack(32, "Clear all interests in store failed", e);
            try {
                txn.abort();
            }
            catch (Exception e1) {
                logger.logStack(16, "Failed to abort clear interests transaction", e1);
            }
            throw new BrokerException(e.getMessage(), e);
        }
    }

    protected CommitToken storeTakeoverSession(String session, String state, boolean checkclose, boolean overide, String[] expectedStates) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeTakeoverSession(" + session + ", " + state + ")");
        }
        if (checkclose) {
            this.checkClosedAndSetInProgress();
        }
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, this.syncTxncf);
                    this.takeoverSessionStore.storeTakeoverSession(txn, session, state, overide, expectedStates);
                    txn.commit();
                    CommitToken commitToken = txn.getCommitToken();
                    return commitToken;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeTakeoverSession(" + session + ", " + state + ", " + Arrays.toString(expectedStates) + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            if (checkclose) {
                this.setInProgress(false);
            }
        }
    }

    protected String getTakeoverSessionState(String session) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTakeoverSessionState(" + session + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, this.syncTxncf);
                    String state = this.takeoverSessionStore.getTakeoverSessionState(txn, session);
                    txn.commit();
                    String string = state;
                    return string;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getTakeoverSessionState(" + session + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    private List getTakeoverSessionsByState(String state) throws BrokerException {
        String[] states = new String[]{state};
        return this.getTakeoverSessionsByStates(states);
    }

    private List getTakeoverSessionsByStates(String[] states) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTakeoverSessionsByState(" + Arrays.toString(states) + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, this.syncTxncf);
                    ArrayList<String> ss = this.takeoverSessionStore.getTakeoverSessionsByStates(txn, states);
                    txn.commit();
                    ArrayList<String> arrayList = ss;
                    return arrayList;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getTakeoverSessionsByState(" + Arrays.toString(states) + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    protected void updateTakeoverSessionState(String session, String state, String[] expectedStates) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateTakeoverSessionState(" + session + ", " + state + ", " + Arrays.toString(expectedStates) + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, this.syncTxncf);
                    this.takeoverSessionStore.updateTakeoverSessionState(txn, session, state, expectedStates);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeTakeoverSession(" + session + ", " + state + ", " + Arrays.toString(expectedStates) + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeMessage(DestinationUID duid, Packet message, ConsumerUID[] sids, int[] states, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeMessage(" + message.getSysMessageID() + "[" + duid + "])");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.msgStore.storeMessage(txn, duid, message, sids, states);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeMessage(" + message.getSysMessageID() + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeMessage(DestinationUID duid, Packet message, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeMessage(" + message.getSysMessageID() + "[" + duid + "])");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.msgStore.storeMessage(txn, duid, message, emptysids, emptystates);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeMessage(" + message.getSysMessageID() + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeMessage(DestinationUID duid, SysMessageID mid, boolean sync, boolean onRollback) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeMessage(" + mid + "[" + duid + "])");
        }
        if (mid == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.msgStore.removeMessage(txn, duid, mid);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "removeMessage(" + mid + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void moveMessage(Packet message, DestinationUID from, DestinationUID to, ConsumerUID[] sids, int[] states, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.moveMessage(" + message.getSysMessageID() + "[" + from + ", " + to + "])");
        }
        if (message == null || from == null || to == null) {
            throw new NullPointerException();
        }
        if (sids == null) {
            sids = emptysids;
            states = emptystates;
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.msgStore.moveMessage(txn, message, from, to, sids, states);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "moveMessage(" + message.getSysMessageID() + "[" + from + ", " + to + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeAllMessages(Destination dst, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeAllMessages(" + dst + ")");
        }
        throw new BrokerException("not implemented");
    }

    @Override
    public Enumeration messageEnumeration(Destination dst) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.messageEnumeration(" + dst + ") called");
        }
        this.checkClosedAndSetInProgress();
        Enumeration en = null;
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    en = this.msgStore.messageEnumeration(txn, dst);
                    txn.commit();
                    this.dataEnums.add(en);
                    return en;
                }
                catch (Throwable e) {
                    if (en != null) {
                        this.dataEnums.remove(en);
                        ((MessageEnumeration)en).close();
                    }
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "messageEnumeration(" + dst + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            try {
                if (en != null) {
                    this.dataEnums.remove(en);
                    ((MessageEnumeration)en).close();
                }
                if (e instanceof BrokerException) {
                    throw (BrokerException)e;
                }
                throw new BrokerException(e.toString(), e);
            }
            catch (Throwable throwable) {
                this.setInProgress(false);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEnumeration(Enumeration en) {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.closeEnumeration(" + (en == null ? "null" : en.getClass().getName()) + ") called");
        }
        if (!(en instanceof MessageEnumeration)) {
            return;
        }
        try {
            this.dataEnums.remove(en);
            ((MessageEnumeration)en).close();
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Packet getMessage(DestinationUID dst, String mid) throws BrokerException {
        return this.getMessage(dst, SysMessageID.get(mid));
    }

    @Override
    public Packet getMessage(DestinationUID duid, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getMessage(" + mid + "[" + duid + "]) called");
        }
        if (mid == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    Packet m = this.msgStore.getMessage(txn, duid, mid);
                    txn.commit();
                    Packet packet = m;
                    return packet;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getMessage(" + mid + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeInterestStates(DestinationUID duid, SysMessageID mid, ConsumerUID[] sids, int[] states, boolean sync, Packet msg) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeInterestStates(" + mid + "[" + duid + "]) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.msgStore.storeInterestStates(txn, duid, mid, sids, states);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeInterestStates(" + mid + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateInterestState(DestinationUID duid, SysMessageID mid, ConsumerUID sid, int state, boolean sync, TransactionUID txid, boolean isLastAck) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "BDBStore.updateInterestState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.msgStore.updateInterestState(txn, duid, mid, sid, state);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "updateInterestState(" + mid + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public int getInterestState(DestinationUID duid, SysMessageID mid, ConsumerUID sid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getInterestState(" + mid + "[" + duid + "]) called");
        }
        if (mid == null || sid == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    int state = this.msgStore.getInterestState(txn, duid, mid, sid);
                    txn.commit();
                    int n = state;
                    return n;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getInterestState(" + mid + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getInterestStates(DestinationUID duid, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getInterestStates(" + mid + "[" + duid + "]) called");
        }
        if (mid == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    HashMap states = this.msgStore.getInterestStates(txn, duid, mid);
                    txn.commit();
                    HashMap hashMap = states;
                    return hashMap;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getInterestStates(" + mid + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public ConsumerUID[] getConsumerUIDs(DestinationUID duid, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getConsumerUIDs(" + mid + "[" + duid + "]) called");
        }
        if (mid == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    ConsumerUID[] sids = this.msgStore.getUnAckedConsumerUIDs(txn, duid, mid);
                    txn.commit();
                    ConsumerUID[] consumerUIDArray = sids;
                    return consumerUIDArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getConsumerUIDs(" + mid + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public boolean hasMessageBeenAcked(DestinationUID duid, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.hasMessageBeenAcked(" + mid + "[" + duid + "]) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    boolean acked = this.msgStore.hasMessageBeenAcked(txn, duid, mid);
                    txn.commit();
                    boolean bl = acked;
                    return bl;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "hasMessageBeenAcked(" + mid + "[" + duid + "])", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeInterest(Consumer interest, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeInterest(" + interest + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.intStore.storeInterest(txn, interest);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeInterest(" + interest + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeInterest(Consumer interest, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeInterest(" + interest + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.intStore.removeInterest(txn, interest);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "removeInterest(" + interest + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Consumer[] getAllInterests() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllInterests() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    Consumer[] interests = this.intStore.getAllInterests(txn);
                    txn.commit();
                    Consumer[] consumerArray = interests;
                    return consumerArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getAllInterests()", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeDestination(Destination dst, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeDestination( " + dst + ")");
        }
        if (dst == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.dstStore.storeDestination(txn, dst);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeDestination(" + dst + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateDestination(Destination dst, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateDestination(" + dst + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.dstStore.updateDestination(txn, dst);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "updateDestination(" + dst + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeDestination(Destination dst, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeDestination(" + dst + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.dstStore.removeDestination(txn, dst);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "removeDestination(" + dst + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Destination getDestination(DestinationUID duid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getDestination(" + duid + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    Destination d = this.dstStore.getDestination(txn, duid);
                    txn.commit();
                    Destination destination = d;
                    return destination;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getDestination(" + duid + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Destination[] getAllDestinations() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllDestinations()");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    Destination[] dsts = this.dstStore.getAllDestinations(txn);
                    txn.commit();
                    Destination[] destinationArray = dsts;
                    return destinationArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getAllDestinations()", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeTransaction(TransactionUID id, TransactionState ts, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeTransaction(" + id + "[" + ts + "]) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.txnStore.storeTransaction(txn, id, ts);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeTransaction(" + id + ", " + ts + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeTransaction(TransactionUID id, boolean sync) throws BrokerException {
        this.removeTransaction(id, false, sync);
    }

    @Override
    public void removeTransaction(TransactionUID id, boolean removeAcks, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeTransaction(" + id + ", " + removeAcks + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    if (removeAcks) {
                        this.txnStore.removeTransactionAck(txn, id);
                    }
                    this.txnStore.removeTransaction(txn, id);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "removeTransaction(" + id + ", " + removeAcks + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateTransactionState(TransactionUID id, TransactionState ts, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateTransactionState(" + id + ", " + ts + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.txnStore.updateTransactionState(txn, id, ts.getState());
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "updateTransactionState(" + id + ", " + ts + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateTransactionStateWithWork(TransactionUID tid, TransactionState ts, TransactionWork txnwork, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateTransactionStateWithWork(" + tid + ", " + ts + ", " + txnwork + ", " + sync + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    for (TransactionWorkMessage txnmsg : txnwork.getSentMessages()) {
                        Packet m = txnmsg.getMessage();
                        if (m == null) continue;
                        this.msgStore.storeMessage(txn, txnmsg.getDestUID(), m, emptysids, emptystates);
                    }
                    List<TransactionWorkMessageAck> txnacks = txnwork.getMessageAcknowledgments();
                    if (txnacks != null) {
                        for (TransactionWorkMessageAck txnack : txnacks) {
                            TransactionAcknowledgement ta = txnack.getTransactionAcknowledgement();
                            if (ta == null) continue;
                            this.txnStore.storeTransactionAck(txn, tid, ta);
                        }
                    }
                    this.txnStore.updateTransactionState(txn, tid, ts.getState());
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "updateTransactionState(" + tid + ", " + ts + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllTransactionStates() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "BDBStore.getAllTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    HashMap map = this.txnStore.getAllTransactionStates(txn);
                    txn.commit();
                    HashMap hashMap = map;
                    return hashMap;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getAllTransactionStates()", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeTransactionAck(TransactionUID tid, TransactionAcknowledgement ack, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeTransactionAck(" + tid + ", " + ack + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.txnStore.storeTransactionAck(txn, tid, ack);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeTransactionAck(" + tid + ", " + ack + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeTransactionAck(TransactionUID id, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.removeTransactionAck(" + id + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.txnStore.removeTransactionAck(txn, id);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "removeTransactionAck(" + id + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID tid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTransactionAcks(" + tid + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    TransactionAcknowledgement[] acks = this.txnStore.getTransactionAcks(txn, tid);
                    txn.commit();
                    TransactionAcknowledgement[] transactionAcknowledgementArray = acks;
                    return transactionAcknowledgementArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getTransactionAcks(" + tid + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllTransactionAcks() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    HashMap map = this.txnStore.getAllTransactionAcks(txn);
                    txn.commit();
                    HashMap hashMap = map;
                    return hashMap;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getAllTransactionAcks()", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeTransaction(TransactionUID id, TransactionInfo txnInfo, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeTransaction(" + id + ", " + txnInfo + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.txnStore.storeTransaction(txn, id, txnInfo);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeTransaction(" + id + ", " + txnInfo + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeClusterTransaction(TransactionUID id, TransactionState ts, TransactionBroker[] txnBrokers, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeClusterTransaction(" + id + ", " + ts + ", " + Arrays.toString(txnBrokers) + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.txnStore.storeClusterTransaction(txn, id, ts, txnBrokers, false);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeClusterTransaction(" + id + ", " + ts + ", " + Arrays.toString(txnBrokers) + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateClusterTransaction(TransactionUID id, TransactionBroker[] txnBrokers, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateClusterTransaction(" + id + ", " + Arrays.toString(txnBrokers) + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.txnStore.updateClusterTransaction(txn, id, txnBrokers);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeClusterTransaction(" + id + ", " + Arrays.toString(txnBrokers) + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getClusterTransactionBrokers(" + id + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    TransactionBroker[] bs = this.txnStore.getClusterTransactionBrokers(txn, id);
                    txn.commit();
                    TransactionBroker[] transactionBrokerArray = bs;
                    return transactionBrokerArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getClusterTransactionBrokers(" + id + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateClusterTransactionBrokerState(TransactionUID id, int expectedTxnState, TransactionBroker txnBroker, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateClusterTransactionBrokerState(" + id + ", " + TransactionState.toString(expectedTxnState) + ", " + txnBroker + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.txnStore.updateTransactionBrokerState(txn, id, expectedTxnState, txnBroker);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "updateClusterTransactionBrokerState(" + id + ", " + TransactionState.toString(expectedTxnState) + ", " + txnBroker + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeRemoteTransaction(TransactionUID id, TransactionState ts, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeRemoteTransaction(" + id + ", " + ts + ", " + Arrays.toString(txnAcks) + ", " + txnHomeBroker + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.txnStore.storeRemoteTransaction(txn, id, ts, txnAcks, txnHomeBroker);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeRemoteTransaction(" + id + ", " + ts + ", " + Arrays.toString(txnAcks) + ", " + txnHomeBroker + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getRemoteTransactionHomeBroker(" + id + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    BrokerAddress b = this.txnStore.getRemoteTransactionHomeBroker(txn, id);
                    txn.commit();
                    BrokerAddress brokerAddress = b;
                    return brokerAddress;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getRemoteTransactionHomeBroker(" + id + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getAllRemoteTransactionStates() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllRemoteTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    HashMap map = this.txnStore.getAllRemoteTransactionStates(txn);
                    txn.commit();
                    HashMap hashMap = map;
                    return hashMap;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getAllRemoteTransactionStates()", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public TransactionState getTransactionState(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTransactionState(" + id + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    TransactionState s = this.txnStore.getTransactionState(txn, id);
                    txn.commit();
                    TransactionState transactionState = s;
                    return transactionState;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getTransactionState(" + id + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public TransactionInfo getTransactionInfo(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTransactionInfo(" + id + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    TransactionInfo ti = this.txnStore.getTransactionInfo(txn, id);
                    txn.commit();
                    TransactionInfo transactionInfo = ti;
                    return transactionInfo;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getTransactionInfo(" + id + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Collection getTransactions(String brokerID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getTransactions(" + brokerID + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    Collection c = this.txnStore.getAllTransactions(txn);
                    txn.commit();
                    Collection collection = c;
                    return collection;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getTransactions(" + brokerID + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateProperty(String name, Object value, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.updateProperty(" + name + ") called");
        }
        if (name == null) {
            throw new NullPointerException("null property name on updateProperty");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.propStore.updateProperty(txn, name, value);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "updateProperty(" + name + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Object getProperty(String name) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getProperty(" + name + ") called");
        }
        if (name == null) {
            throw new NullPointerException("null property name on getProperty()");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    Object o = this.propStore.getProperty(txn, name);
                    txn.commit();
                    Object object = o;
                    return object;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getProperty(" + name + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getPropertyNames() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    String[] names = this.propStore.getPropertyNames(txn);
                    txn.commit();
                    String[] stringArray = names;
                    return stringArray;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getPropertyNames()", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllProperties() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    Properties props = this.propStore.getProperties(txn);
                    txn.commit();
                    Properties properties = props;
                    return properties;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getProperties()", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void storeConfigChangeRecord(long timestamp, byte[] recordData, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.storeConfigChangeRecord(" + timestamp + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.configRecordStore.storeConfigChangeRecord(txn, timestamp, recordData);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "storeConfigChangeRecord(" + timestamp + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long timestamp) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getConfigChangeRecordsSince(" + timestamp + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    ArrayList<ChangeRecordInfo> rc = this.configRecordStore.getConfigChangeRecordsSince(txn, timestamp);
                    txn.commit();
                    ArrayList<ChangeRecordInfo> arrayList = rc;
                    return arrayList;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getConfigChangeRecordsSince(" + timestamp + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getAllConfigRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    List<ChangeRecordInfo> rc = this.configRecordStore.getAllConfigRecords(txn);
                    txn.commit();
                    List<ChangeRecordInfo> list = rc;
                    return list;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getAllConfigRecords()", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void clearAllConfigChangeRecords(boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.clearAllConfigChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, sync ? this.syncTxncf : null);
                    this.configRecordStore.clearAll(txn);
                    txn.commit();
                    return;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "clearAll()", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public HashMap getMessageStorageInfo(Destination dst) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getMessageStorageInfo(" + dst + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Transaction txn = null;
            Util.RetryStrategy retry = null;
            while (true) {
                try {
                    txn = this.dbEnv.beginTransaction(null, null);
                    HashMap m = this.msgStore.getMessageStorageInfo(txn, dst.getDestinationUID());
                    txn.commit();
                    HashMap hashMap = m;
                    return hashMap;
                }
                catch (Exception e) {
                    if (retry == null) {
                        retry = new Util.RetryStrategy(txn, this.maxRetries, logger, "getMessageStorageInfo(" + dst + ")", this);
                    }
                    retry.assertShouldRetry(e);
                    continue;
                }
                break;
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public String getStoreType() {
        return BDBSTORE_BASENAME;
    }

    @Override
    public boolean isJDBCStore() {
        return false;
    }

    @Override
    public boolean isBDBStore() {
        return true;
    }

    @Override
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        throw new BrokerException("BDBStore.getStorageInfo: Operation not supported");
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable<String, Object> t = new Hashtable<String, Object>();
        t.put("BDBStore version", String.valueOf(500));
        t.put("dstStore", this.dstStore.getDebugState());
        t.put("msgStore", this.msgStore.getDebugState());
        t.put("intStore", this.intStore.getDebugState());
        t.put("txnStore", this.txnStore.getDebugState());
        t.put("propStore", this.propStore.getDebugState());
        t.put("configRecordStore", this.configRecordStore.getDebugState());
        return t;
    }

    public void compactDestination(Destination destination) throws BrokerException {
    }

    protected Database getDstDatabase() {
        return this.dstDatabase;
    }

    protected Database getIntDatabase() {
        return this.intDatabase;
    }

    protected Database getTxnDatabase() {
        return this.txnDatabase;
    }

    protected Database getTxnAckDatabase() {
        return this.txnackDatabase;
    }

    protected Database getConfigRecordDatabase() {
        return this.configRecordDatabase;
    }

    protected Database getPropDatabase() {
        return this.propDatabase;
    }

    protected Database getTakeoverSessionDatabase() {
        return this.takeoverSessionDatabase;
    }

    protected StoredClassCatalog getClassCatalog() {
        return this.classCatalog;
    }

    protected DestinationStore getDstStore() {
        return this.dstStore;
    }

    protected MsgStore getMsgStore() {
        return this.msgStore;
    }

    protected TxnStore getTxnStore() {
        return this.txnStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void joinReplicationGroup(String groupName, String ebrokerid, String masterHostPort, byte[] token, Long syncTimeout, boolean takeoverPrepare, String uuid, BrokerAddress from, ClusterProtocolHelper cpi) throws BrokerException {
        this.checkClosedAndSetInProgress(16);
        ExecutorService es = null;
        try {
            if (takeoverPrepare) {
                this.storeTakeoverSession(ebrokerid, "TAKEOVER_PREPARE:" + uuid, false, true, new String[]{"TAKEOVER_PREPARE:", "TAKEOVER_PREPARED:"});
            }
            Map<String, ExecutorService> map = this.joinExecutors;
            synchronized (map) {
                es = this.joinExecutors.get(groupName);
                if (es == null) {
                    es = Executors.newSingleThreadExecutor();
                    this.joinExecutors.put(groupName, es);
                }
            }
            JoinRunnable runner = new JoinRunnable(groupName, ebrokerid, masterHostPort, token, syncTimeout, takeoverPrepare, uuid, from, cpi, this);
            es.execute(runner);
        }
        catch (Throwable t) {
            logger.logStack(32, "Exception in execute joinReplicationGroup " + cpi, t);
            throw new BrokerException(t.getMessage(), t);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initTakeoverBrokerStore(String groupName, String ebrokerid, String masterHostPort, String uuid, BrokerAddress from, ClusterProtocolHelper cpi) throws BrokerException {
        this.checkClosedAndSetInProgress();
        ExecutorService es = null;
        try {
            Map<String, ExecutorService> map = this.joinExecutors;
            synchronized (map) {
                es = this.joinExecutors.get(groupName);
                if (Globals.getBDBREPEnabled()) {
                    if (es == null) {
                        throw new BrokerException("Unexpected init takeover " + cpi + ": not prepared");
                    }
                } else {
                    es = Executors.newSingleThreadExecutor();
                    this.joinExecutors.put(groupName, es);
                }
            }
            String state = this.getTakeoverSessionState(ebrokerid);
            int ind = state.lastIndexOf(":");
            String p = null;
            if (ind != -1) {
                p = state.substring(ind + 1);
            }
            logger.log(8, "BDB store update takeover session " + ebrokerid + " to " + "TAKEOVER_COMMITTED:");
            this.updateTakeoverSessionState(ebrokerid, "TAKEOVER_COMMITTED:" + System.currentTimeMillis() + (p == null ? "" : ":" + p), new String[]{"TAKEOVER_PREPARED:" + uuid});
            InitTakeoverRunnable runner = new InitTakeoverRunnable(groupName, ebrokerid, masterHostPort, from, cpi);
            es.execute(runner);
        }
        catch (Throwable t) {
            logger.logStack(32, "Exception in execute initTakeoverBrokerStore " + cpi, t);
            throw new BrokerException(t.getMessage(), t);
        }
        finally {
            this.setInProgress(false);
        }
    }

    protected ReplicatedEnvironment joinReplicationGroup(String groupName, String ebrokerid, String masterHostPort, byte[] token, Long syncTimeout, boolean takeoverPrepare, boolean takeover, BrokerAddress from) throws BrokerException {
        String logstr = groupName + "[" + ebrokerid + ", " + masterHostPort + "]" + (from == null ? "" : from);
        ReplicatedEnvironment env = this.replicaEnvs.get(groupName);
        Integer replicaPort = null;
        if (env != null) {
            try {
                if (env.isValid()) {
                    try {
                        replicaPort = env.getRepConfig().getNodePort();
                    }
                    catch (Throwable t) {
                        logger.log(16, "Unable to get replica port from environment " + env + ": " + t.getMessage());
                    }
                }
                logger.log(8, "Closing existing replica environment " + env + " of " + groupName);
                env.close();
            }
            catch (Exception e) {
                logger.logStack(16, "Failed to close existing replica replication environment:" + env + " for " + groupName, e);
            }
        }
        String replicaHostPort = null;
        try {
            File reptop;
            File rephome;
            replicaHostPort = replicaPort == null ? this.getReplicaHostPortFor(groupName, ebrokerid) : this.getMyReplicationHost() + ":" + replicaPort;
            CommitPointConsistencyPolicy consistencyPolicy = null;
            if (token != null) {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(token));
                CommitToken t = (CommitToken)ois.readObject();
                ois.close();
                consistencyPolicy = new CommitPointConsistencyPolicy(t, syncTimeout == null ? this.replicaSyncTimeout : syncTimeout, TimeUnit.SECONDS);
            }
            if (!(rephome = new File(reptop = new File(BDBStore.getReplicaTop()), ebrokerid)).exists() && !rephome.mkdirs()) {
                String emsg = "Can't create replication store hierarchy " + rephome + " for " + logstr;
                logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            EnvironmentConfig envcf = new EnvironmentConfig();
            envcf.setAllowCreate(true);
            envcf.setTransactional(true);
            envcf.setTxnTimeout(60L, TimeUnit.SECONDS);
            if (this.useOdsync || StoreManager.isConfiguredBDBSharedFS()) {
                envcf.setConfigParam("je.log.useODSYNC", "true");
            }
            ReplicationConfig repcf = new ReplicationConfig();
            repcf.setMaxClockDelta(this.maxClockSkew, TimeUnit.SECONDS);
            repcf.setGroupName(groupName);
            repcf.setNodeName(this.getMyReplicationNodeName());
            repcf.setNodeHostPort(replicaHostPort);
            repcf.setHelperHosts(masterHostPort);
            if (takeoverPrepare) {
                repcf.setNodePriority(1);
                repcf.setConfigParam("je.rep.electableGroupSizeOverride", "2");
                repcf.setConfigParam("je.rep.electionsPrimaryRetries", "1");
                repcf.setConfigParam("je.rep.replicaTimeout", "2 s");
            } else if (takeover) {
                repcf.setDesignatedPrimary(true);
                repcf.setNodePriority(1);
                repcf.setConfigParam("je.rep.electableGroupSizeOverride", "1");
                repcf.setConfigParam("je.rep.electionsPrimaryRetries", "1");
            } else {
                repcf.setDesignatedPrimary(false);
                repcf.setNodePriority(0);
            }
            logger.log(8, "Creating replica environment on " + replicaHostPort + " for " + logstr);
            ReplicatedEnvironment repenv = null;
            if (takeover) {
                repenv = new ReplicatedEnvironment(rephome, repcf, envcf);
            } else {
                try {
                    repenv = new ReplicatedEnvironment(rephome, repcf, envcf);
                }
                catch (InsufficientLogException ilex) {
                    logger.log(8, "Received InsufficientLogException in creating replicated environment for replication group " + groupName + ":" + ilex.getMessage() + ", Use NetWorkRestore and Retry");
                    NetworkRestore restore = new NetworkRestore();
                    NetworkRestoreConfig netcf = new NetworkRestoreConfig();
                    netcf.setRetainLogFiles(false);
                    restore.execute(ilex, netcf);
                    repenv = new ReplicatedEnvironment(rephome, repcf, envcf);
                }
            }
            String instName = MigratableStoreUtil.parseEffectiveBrokerIDToInstName(ebrokerid);
            BrokerStateFile.writeRepHostPortFile(reptop, instName, replicaHostPort);
            repenv.setStateChangeListener((StateChangeListener)new ReplicationStateChangeListener(instName, groupName));
            if (consistencyPolicy != null) {
                TransactionConfig tcf = new TransactionConfig();
                tcf.setConsistencyPolicy((ReplicaConsistencyPolicy)consistencyPolicy);
                Transaction txn = repenv.beginTransaction(null, tcf);
                txn.commit();
            }
            this.replicaEnvs.put(repcf.getGroupName(), repenv);
            logger.log(8, "Replication environment created for " + logstr);
            return repenv;
        }
        catch (Exception e) {
            String emsg = "Failed to create replication environment for " + logstr;
            logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTakeOverLock(String brokerID, String targetBrokerID, long lastHeartbeat, BrokerState expectedState, long newHeartbeat, BrokerState newState, boolean force, TakingoverTracker tracker) throws TakeoverLockException, BrokerException {
        if (!Globals.getSFSHAEnabled()) {
            throw new UnsupportedOperationException("Unexpected call: getTakeOverLock");
        }
        boolean useClusterLock = Globals.getConfig().getBooleanProperty(TAKEOVER_USE_CLUSTER_LOCK_PROP, true);
        tracker.setStage_BEFORE_GET_LOCK();
        String lock = null;
        ConnectionUID obj = null;
        if (useClusterLock) {
            lock = "takeover:" + targetBrokerID;
            obj = new ConnectionUID(0L);
            if (!Globals.getClusterBroadcast().lockExclusiveResource(lock, obj)) {
                String emsg = br.getKString("B3170", targetBrokerID);
                throw new BrokerException(emsg, 409);
            }
        }
        BrokerCurrentFile bcf = null;
        BrokerStateFile bsf = null;
        try {
            File lockf = new File(LockFile.getLockFilePath(Globals.getConfig().getProperty("imq.varhome"), targetBrokerID));
            this.checkClosedAndSetInProgress();
            try {
                try {
                    if (lockf.exists()) {
                        String id;
                        LockFile lockfile = LockFile.loadLockFile(lockf, Globals.getUseFileLockForLockFile());
                        if (lockfile == null || !lockfile.getInstance().equals(targetBrokerID)) {
                            Object[] args = new String[]{targetBrokerID, lockf.getPath(), lockfile == null ? "null" : lockfile.getInstance()};
                            throw new IOException(br.getKString("B4371", args));
                        }
                        String h = lockfile.getHost();
                        int p = lockfile.getPort();
                        if (BDBStore.getDEBUG()) {
                            logger.log(8, "Broker " + targetBrokerID + " lock file " + lockf.getPath() + " exists with " + h + ":" + p);
                        }
                        if ((id = Globals.getHAMonitorService().getRemoteBrokerIDFromPortMapper(h, p, targetBrokerID)) != null && id.equals(targetBrokerID)) {
                            throw new BrokerException(br.getKString("B4372", targetBrokerID, h + ":" + p));
                        }
                    }
                    String targetdir = Globals.getJMQ_INSTANCES_HOME() + File.separator + targetBrokerID + File.separator + BDBSTORE_TOP;
                    File targetbdbtop = new File(targetdir);
                    bcf = new BrokerCurrentFile(targetbdbtop, true);
                    UID uid = bcf.readStoreSession();
                    bsf = new BrokerStateFile(this.jeenvtop, targetbdbtop, false, uid, targetBrokerID, false);
                    tracker.setStage_AFTER_GET_LOCK();
                }
                catch (Exception e) {
                    String emsg = br.getKString("B3170", targetBrokerID + " - " + e.getMessage());
                    throw new BrokerException(emsg, e, 409);
                }
                String ebrokerid = null;
                try {
                    int state = bsf.readBrokerState();
                    BrokerState bstate = BrokerState.getState(state);
                    logger.log(8, br.getKString("B1412", targetBrokerID, bstate));
                    if (!force) {
                        HAClusteredBrokerImpl.checkCanTakeoverState(BrokerState.getState(state), targetBrokerID);
                    }
                    long ssuid = bsf.readBrokerStoreSession();
                    tracker.setStoreSession(ssuid);
                    ebrokerid = MigratableStoreUtil.makeEffectiveBrokerID(targetBrokerID, new UID(ssuid));
                    UUID uuid = UUID.randomUUID();
                    this.storeTakeoverSession(ebrokerid, "TAKEOVER_PREPARE:" + uuid, false, true, new String[]{"TAKEOVER_PREPARE:", "TAKEOVER_PREPARED:"});
                    this.storeTakeoverSession(ebrokerid, "TAKEOVER_PREPARED:" + uuid, false, true, new String[]{"TAKEOVER_PREPARE:" + uuid});
                    bsf.writeBrokerState(BrokerState.FAILOVER_PREPARED, null);
                    this.updateTakeoverSessionState(ebrokerid, "TAKEOVER_COMMITTED:" + System.currentTimeMillis(), new String[]{"TAKEOVER_PREPARED:" + uuid});
                    bsf.writeBrokerState(BrokerState.FAILOVER_COMPLETE, BrokerState.FAILOVER_PREPARED);
                }
                catch (Exception e) {
                    String emsg = br.getKString("B4377", targetBrokerID, e.getMessage());
                    if (e instanceof BrokerException) {
                        if (((BrokerException)e).getStatusCode() == 409) {
                            logger.log(16, emsg);
                            throw (BrokerException)e;
                        }
                        logger.logStack(32, emsg, e);
                        throw (BrokerException)e;
                    }
                    logger.logStack(32, emsg, e);
                    throw new BrokerException(emsg);
                }
            }
            finally {
                this.setInProgress(false);
            }
        }
        finally {
            if (bcf != null) {
                bcf.close();
            }
            if (bsf != null) {
                bsf.close();
            }
            if (useClusterLock) {
                Globals.getClusterBroadcast().unlockExclusiveResource(lock, obj);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public TakeoverStoreInfo takeoverBrokerStore(String targetInstanceName, UID targetStoreSession, String targetHostPort, TakingoverTracker tracker) throws TakeoverLockException, BrokerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeReplicaMembers(ReplicatedEnvironment repenv, String masterNodeName) throws Exception {
        ReplicationGroup group = repenv.getGroup();
        Set nodes = group.getElectableNodes();
        logger.log(8, "Replication group [" + group.getName() + "] members: " + nodes);
        ReplicationNode node2 = null;
        String noden2 = null;
        ArrayList<String> removes = new ArrayList<String>();
        for (ReplicationNode node2 : nodes) {
            noden2 = node2.getName();
            if (noden2.equals(masterNodeName)) continue;
            removes.add(noden2);
        }
        HashSet<InetSocketAddress> s = new HashSet<InetSocketAddress>();
        s.add(group.getMember(masterNodeName).getSocketAddress());
        ReplicationGroupAdmin repadmin = new ReplicationGroupAdmin(group.getName(), s);
        for (String noden2 : removes) {
            logger.log(8, "Removing " + noden2 + " from replication group [" + group.getName() + "]");
            try {
                repadmin.removeMember(noden2);
                logger.log(8, "Removed " + noden2 + " from replication group [" + group.getName() + "]");
            }
            catch (Throwable t) {
                logger.logStack(16, "Unable to remove " + noden2 + " from replication group [" + group.getName() + "]", t);
            }
        }
    }

    @Override
    public String takeoverME(String brokerID, Long syncTimeout) throws BrokerException {
        return this.takeoverME(brokerID, syncTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String takeoverME(String brokerID, Long syncTimeout, boolean remove) throws BrokerException {
        List pending;
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.takeoverME(" + brokerID + ", " + syncTimeout + ")");
        }
        if ((pending = this.getTakeoverSessionsByState("TAKEOVER_COMMITTED:")) != null && pending.size() > 0) {
            throw new BrokerException(br.getKString("B4366", "[" + pending + "]"), 412);
        }
        List prepared = this.getTakeoverSessionsByState("TAKEOVER_PREPARED:");
        if (prepared != null && prepared.size() > 0) {
            StringBuffer buf = new StringBuffer();
            Iterator itr = prepared.iterator();
            while (itr.hasNext()) {
                itr.next();
                buf.append((String)itr.next() + "\n");
            }
            throw new BrokerException(br.getKString("B4367", buf.toString()), 412);
        }
        String replicaHostPort = null;
        String uuid = UUID.randomUUID().toString();
        try {
            logger.log(8, br.getKString("B1404", brokerID));
            logger.log(8, br.getKString("B1405"));
            super.setClosedAndWait();
            CommitToken commitToken = this.storeTakeoverSession(this.getMyEffectiveBrokerID(), "TAKEOVER_ME:" + uuid, false, true, TakeoverSessionStore.OWNER_STATES);
            if (Globals.getBDBREPEnabled()) {
                if (commitToken == null) {
                    throw new BrokerException("Unexpected null commit token returned");
                }
                ByteArrayOutputStream aos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(aos);
                oos.writeObject(commitToken);
                byte[] token = aos.toByteArray();
                oos.close();
                aos.close();
                replicaHostPort = Globals.getClusterBroadcast().sendTakeoverMEPrepare(brokerID, token, syncTimeout == null ? Long.valueOf(this.replicaSyncTimeout) : syncTimeout, uuid);
                logger.log(8, "The replica " + brokerID + "[" + replicaHostPort + "] to takeover me has sync'ed,  closing store");
            } else {
                CheckpointConfig cf = new CheckpointConfig();
                cf.setForce(true);
                logger.log(8, br.getKString("B1403", brokerID));
                this.dbEnv.checkpoint(cf);
                Globals.getClusterBroadcast().sendMigrateStoreRequest(brokerID, syncTimeout == null ? Long.valueOf(this.replicaSyncTimeout) : syncTimeout, uuid, this.myEffectiveBrokerID);
                DbBackup backupHelper = new DbBackup(this.dbEnv);
                backupHelper.startBackup();
                try {
                    String[] files = backupHelper.getLogFilesInBackupSet();
                    Globals.getClusterBroadcast().transferFiles(files, brokerID, syncTimeout == null ? Long.valueOf(this.replicaSyncTimeout) : syncTimeout, uuid, this.myEffectiveBrokerID, "store", this);
                }
                finally {
                    backupHelper.endBackup();
                }
            }
            this.brokerstateFile.writeBrokerState(BrokerState.FAILOVER_PREPARED, null);
            logger.log(8, br.getKString("B1421", this.myEffectiveBrokerID + " [" + uuid + "]", brokerID));
            logger.log(8, br.getKString("B1395"));
            this.closeStores(false);
        }
        catch (Throwable t) {
            Object[] eargs = new String[]{this.myEffectiveBrokerID + " [" + uuid + "]", brokerID, t.getMessage()};
            String emsg = br.getKString("B4382", eargs);
            logger.logStack(32, emsg, t);
            throw new BrokerException(emsg, t, 412);
        }
        String takerhostport = null;
        try {
            takerhostport = Globals.getClusterBroadcast().sendTakeoverME(brokerID, uuid);
            this.brokerstateFile.writeBrokerState(BrokerState.FAILOVER_COMPLETE, null);
        }
        catch (Throwable t) {
            Object[] eargs = new String[]{this.myEffectiveBrokerID + " [" + uuid + "]", brokerID, t.getMessage()};
            String emsg = br.getKString("B4383", eargs);
            logger.logStack(32, emsg, t);
            throw new BrokerException(emsg, t, 500);
        }
        String group = null;
        ReplicatedEnvironment repenv = null;
        ReplicationGroupAdmin repadmin = null;
        Set nodes = null;
        HashSet<InetSocketAddress> saddrs = null;
        Iterator itr = null;
        ReplicationNode node2 = null;
        for (Map.Entry<String, ReplicatedEnvironment> pair : this.replicaEnvs.entrySet()) {
            group = pair.getKey();
            if (!remove && !group.equals(this.getMyReplicationGroupName())) continue;
            logger.log(8, "Removing this broker from replication group " + group);
            repenv = pair.getValue();
            try {
                nodes = repenv.getGroup().getElectableNodes();
                saddrs = new HashSet<InetSocketAddress>();
                for (ReplicationNode node2 : nodes) {
                    saddrs.add(node2.getSocketAddress());
                }
                repadmin = new ReplicationGroupAdmin(group, saddrs);
                repadmin.removeMember(this.getMyReplicationNodeName());
                logger.log(8, "Removed this broker from replication group " + group);
                repenv.close();
            }
            catch (Throwable t) {
                logger.logStack(16, "Failed to remove this broker from repilcation group " + group + " members " + saddrs, t);
            }
        }
        return takerhostport;
    }

    @Override
    public HashMap getAllBrokerInfos(boolean loadSession) throws BrokerException {
        return this.getAllBrokerInfos(false, false);
    }

    private HashMap getAllBrokerInfos(boolean loadSession, boolean runningOnly) throws BrokerException {
        if (BDBStore.getDEBUG()) {
            logger.log(8, "getAllBrokerInfos called");
        }
        if (!StoreManager.isConfiguredBDBSharedFS() || StoreManager.bdbREPEnabled()) {
            throw new UnsupportedOperationException("Operation getAllBrokerInfos not supported by the " + this.getStoreType() + " store configuration");
        }
        LinkedHashMap<String, HABrokerInfo> data = new LinkedHashMap<String, HABrokerInfo>();
        File dir = new File(Globals.getJMQ_INSTANCES_HOME());
        String[] instances = dir.list();
        File instdir = null;
        String[] subdirs = null;
        Object lockfile = null;
        String url = null;
        HABrokerInfo inf = null;
        int num = instances.length;
        for (int i = 0; i < num; ++i) {
            instdir = new File(dir, instances[i]);
            if (BDBStore.getDEBUG()) {
                logger.log(8, "getAllBrokerInfos look directory " + instances[i] + " under " + Globals.getJMQ_INSTANCES_HOME());
            }
            if (!instdir.isDirectory() || instances[i].endsWith(".deleted") || (subdirs = instdir.list()) == null || subdirs.length < 1) continue;
            boolean foundbdb = false;
            for (int j = subdirs.length - 1; j >= 0; --j) {
                if (!subdirs[j].equals(BDBSTORE_TOP)) continue;
                foundbdb = true;
            }
            if (!foundbdb) {
                if (!BDBStore.getDEBUG()) continue;
                logger.log(8, "getAllBrokerInfos " + BDBSTORE_TOP + " not found in " + instdir);
                continue;
            }
            url = null;
            File envf = new File(instdir, BDBSTORE_TOP);
            try {
                url = new BrokerHostPortFile(envf, true, true).readHostPort();
            }
            catch (Exception e) {
                if (BDBStore.getDEBUG()) {
                    logger.logStack(16, "Unable to read hostport file from " + envf + ": " + e.getMessage(), e);
                }
                logger.log(16, "Unable to read hostport file from " + envf + ": " + e.getMessage());
            }
            if (url == null) continue;
            inf = new HABrokerInfo(instances[i], null, url, 0, 0, 0L, 0L);
            data.put(instances[i], inf);
        }
        if (BDBStore.getDEBUG()) {
            logger.log(8, "getAllBrokerInfos return " + data);
        }
        if (((HashMap)data).get(Globals.getBrokerID()) == null) {
            throw new BrokerException("Failed to read this broker info from store");
        }
        return data;
    }

    @Override
    public HashMap getAllBrokerInfoByState(BrokerState state) throws BrokerException {
        if (BDBStore.getDEBUG()) {
            logger.log(8, "getAllBrokerInfoByState(" + state + ") called");
        }
        if (state != BrokerState.OPERATING) {
            throw new BrokerException("getAllBrokerInfoByState: Unexpected call for state " + state);
        }
        return this.getAllBrokerInfos(false, true);
    }

    @Override
    public HABrokerInfo getBrokerInfo(String brokerID) throws BrokerException {
        if (!StoreManager.isConfiguredBDBSharedFS() || StoreManager.bdbREPEnabled()) {
            throw new UnsupportedOperationException("Operation getBrokerInfo not supported by the " + this.getStoreType() + " store configuration");
        }
        File dir = new File(Globals.getJMQ_INSTANCES_HOME());
        String[] instances = dir.list();
        File instdir = null;
        String[] subdirs = null;
        Object lockfile = null;
        String url = null;
        Object inf = null;
        int num = instances.length;
        for (int i = 0; i < num; ++i) {
            instdir = new File(dir, instances[i]);
            if (!instdir.isDirectory() || !instances[i].equals(brokerID) || (subdirs = instdir.list()) == null || subdirs.length < 1) continue;
            boolean foundbdb = false;
            for (int j = subdirs.length - 1; j >= 0; --j) {
                if (!subdirs[j].equals(BDBSTORE_TOP)) continue;
                foundbdb = true;
            }
            if (!foundbdb) continue;
            url = null;
            File envf = new File(instdir, BDBSTORE_TOP);
            try {
                url = new BrokerHostPortFile(envf, true, true).readHostPort();
                return new HABrokerInfo(instances[i], null, url, 0, 0, 0L, 0L);
            }
            catch (Exception e) {
                logger.log(16, "Unable to read hostport file from " + envf + ": " + e.getMessage());
            }
        }
        if (brokerID.equals(Globals.getBrokerID())) {
            throw new BrokerException("Failed to read this broker info from store");
        }
        return null;
    }

    @Override
    public void addBrokerInfo(String brokerID, String URL2, BrokerState state, int version, long sessionID, long heartbeat) throws BrokerException {
    }

    @Override
    public UID updateBrokerInfo(String brokerID, int updateType, Object oldValue, Object newValue) throws BrokerException {
        if (BDBStore.getDEBUG()) {
            logger.log(8, "updateBrokerInfo(" + brokerID + ", " + updateType + ", " + oldValue + ", " + newValue);
        }
        if (!StoreManager.isConfiguredBDBSharedFS() || StoreManager.bdbREPEnabled()) {
            throw new UnsupportedOperationException("Operation updateBrokerInfo not supported by the " + this.getStoreType() + " store configuration");
        }
        if (updateType != 1) {
            throw new BrokerException("updateBrokerInfo: Unexpected update type " + updateType);
        }
        if (!brokerID.equals(Globals.getBrokerID())) {
            throw new BrokerException("updateBrokerInfo: Unexpected call on broker " + brokerID);
        }
        try {
            new BrokerHostPortFile(this.bdbtop, false, true).writeHostPort((String)newValue);
        }
        catch (Exception e) {
            throw new BrokerException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public long getBrokerHeartbeat(String brokerID) throws BrokerException {
        return 0L;
    }

    @Override
    public String getStoreSessionCreator(long sessionID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getStoreSessionCreator(" + sessionID + ")");
        }
        File dir = new File(Globals.getJMQ_INSTANCES_HOME());
        String[] instances = dir.list();
        File instdir = null;
        String[] subdirs = null;
        int num = instances.length;
        for (int i = 0; i < num; ++i) {
            instdir = new File(dir, instances[i]);
            if (BDBStore.getDEBUG()) {
                logger.log(8, "getStoreSessionCreator(" + sessionID + ") look directory " + instances[i] + " under " + Globals.getJMQ_INSTANCES_HOME());
            }
            if (!instdir.isDirectory() || instances[i].endsWith(".deleted") || (subdirs = instdir.list()) == null || subdirs.length < 1) continue;
            boolean foundbdb = false;
            for (int j = subdirs.length - 1; j >= 0; --j) {
                if (!subdirs[j].equals(BDBSTORE_TOP)) continue;
                foundbdb = true;
            }
            if (!foundbdb) {
                if (!BDBStore.getDEBUG()) continue;
                logger.log(8, "getStoreSessionCreator(" + sessionID + ")" + BDBSTORE_TOP + " not found in " + instdir);
                continue;
            }
            File envf = new File(instdir, BDBSTORE_TOP);
            subdirs = envf.list();
            if (subdirs == null || subdirs.length < 1) continue;
            for (int j = subdirs.length - 1; j >= 0; --j) {
                if (!subdirs[j].endsWith(String.valueOf(sessionID))) continue;
                try {
                    return MigratableStoreUtil.parseEffectiveBrokerIDToInstName(subdirs[j]);
                }
                catch (Exception e) {
                    logger.log(16, "Unable to parse " + subdirs[j] + " under " + envf.getPath());
                }
            }
        }
        return null;
    }

    @Override
    public boolean ifOwnStoreSession(long sessionID, String brokerID) throws BrokerException {
        String bid;
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.ifOwnStoreSession(" + sessionID + ", " + brokerID + ")");
        }
        if ((bid = brokerID) == null) {
            bid = this.getStoreSessionCreator(sessionID);
            if (Store.getDEBUG()) {
                logger.log(8, "BDBStore.ifOwnStoreSession(" + sessionID + "," + brokerID + "): session creator:" + bid);
            }
        }
        if (bid == null) {
            return false;
        }
        String session = MigratableStoreUtil.makeEffectiveBrokerID(bid, new UID(sessionID));
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.ifOwnStoreSession(" + sessionID + "," + brokerID + "): effective id:" + session);
        }
        List ss = this.getTakeoverSessionsByStates(new String[]{"TAKEOVER_COMMITTED:", "NEW_INHERENTED:", "NEW_CREATED:", ":", "TAKEOVER_ME:"});
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.ifOwnStoreSession(" + sessionID + "," + brokerID + "): this broker supports store sessions:" + ss);
        }
        return ss.contains(session);
    }

    @Override
    public boolean updateBrokerState(String brokerID, BrokerState newState, BrokerState expectedState, boolean local) throws BrokerException {
        if (!local) {
            throw new UnsupportedOperationException("Unexpected call: updateBrokerState");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.brokerstateFile.writeBrokerState(newState, expectedState);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new BrokerException("Failed to update this broker state to " + newState, e);
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Long updateBrokerHeartbeat(String brokerID) throws BrokerException {
        return 0L;
    }

    public static String getReplicaTop() {
        return Globals.getJMQ_INSTANCES_HOME() + File.separator + Globals.getConfigName() + File.separator + BDBSTORE_TOP;
    }

    @Override
    public FileInputStream getFileInputStream(String filename, BrokerAddress to, Map props) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getFileInputStream(" + filename + ")");
        }
        if (Globals.getBDBREPEnabled()) {
            throw new UnsupportedOperationException("Operation getFileInputStream(" + filename + ") for file transfer is not supported for BDB replicated environment");
        }
        try {
            File f = new File(this.envhome, filename);
            props.put("filesize", f.length());
            props.put("lastmodtime", f.lastModified());
            return new FileInputStream(f);
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException("Unable to open file " + filename + " in " + this.envhome + " for file transfer", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileOutputStream getFileOutputStream(String tmpfilename, String brokerID, String uuid, boolean firstOfSet, BrokerAddress from) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.getFileOutputStream(" + tmpfilename + ")");
        }
        if (Globals.getBDBREPEnabled()) {
            throw new UnsupportedOperationException("Operation getFileOutputStream(" + tmpfilename + ") for file transfer is not supported for BDB replicated environment");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (firstOfSet) {
                this.storeTakeoverSession(brokerID, "TAKEOVER_PREPARE:" + uuid, false, true, new String[]{"TAKEOVER_PREPARE:", "TAKEOVER_PREPARED:"});
            }
            File reptop = new File(BDBStore.getReplicaTop());
            Object object = this.replicaTOPLock;
            synchronized (object) {
                if (!reptop.exists() && !reptop.mkdirs()) {
                    String emsg = "Can't create replica store hierarchy " + reptop + " for " + brokerID;
                    logger.log(32, emsg);
                    throw new BrokerException(emsg);
                }
            }
            File d = new File(reptop, brokerID);
            if (d.exists()) {
                File[] fs = d.listFiles();
                int num = fs == null ? 0 : fs.length;
                for (int i = 0; i < num; ++i) {
                    fs[i].delete();
                }
                this.deleteFile(d);
            }
            if (!d.mkdir()) {
                throw new BrokerException("Unable to make directory: " + d);
            }
            File f = new File(d, tmpfilename);
            if (f.exists()) {
                this.deleteFile(f);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(f);
            return fileOutputStream;
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException("Unable to open file " + tmpfilename + " in " + BDBStore.getReplicaTop() + " for file to be transfered over", e);
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void doneTransfer(String tmpfilename, String filename, String brokerID, long lastModTime, boolean success, BrokerAddress from) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.doneTransfer(" + tmpfilename + ", " + filename + ", " + brokerID + ", " + lastModTime + ", " + success + ", " + from + ")");
        }
        if (Globals.getBDBREPEnabled()) {
            throw new UnsupportedOperationException("Operation doneTransfer(" + filename + ", " + brokerID + ") for file transfer is not supported for BDB replicated environment");
        }
        this.checkClosedAndSetInProgress();
        try {
            File tf;
            File d = new File(BDBStore.getReplicaTop(), brokerID);
            if (!success) {
                File f = new File(d, tmpfilename);
                if (f.exists()) {
                    this.deleteFile(f);
                }
                return;
            }
            File f = new File(d, filename);
            if (f.exists()) {
                this.deleteFile(f);
            }
            if (!(tf = new File(d, tmpfilename)).exists()) {
                throw new BrokerException("File " + tf + " expected to be exist, but not");
            }
            if (!tf.renameTo(f)) {
                String emsg = Globals.getBrokerResources().getKString("B2249", tf.getPath(), f.getPath());
                throw new BrokerException(emsg);
            }
            if (f.setLastModified(lastModTime)) {
                logger.log(16, "Failed to set last modification time " + lastModTime + " to file " + f + " transfered from " + from);
            }
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException("Failed to process completed file transfer", e);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allDoneTransfer(String brokerID, String uuid, BrokerAddress from) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "BDBStore.allDoneTransfer(" + brokerID + ", " + uuid + ", " + from + ")");
        }
        if (Globals.getBDBREPEnabled()) {
            throw new UnsupportedOperationException("Operation allDoneTransfer(" + brokerID + ")" + " for file transfer is not supported for BDB replicated environment");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.storeTakeoverSession(brokerID, "TAKEOVER_PREPARED:" + uuid, false, true, new String[]{"TAKEOVER_PREPARE:" + uuid});
        }
        finally {
            this.setInProgress(false);
        }
    }

    private void deleteFile(File f) throws BrokerException {
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            int num = fs == null ? 0 : fs.length;
            for (int i = 0; i < num; ++i) {
                fs[i].delete();
            }
        }
        if (!f.delete()) {
            String fname = f.getName();
            Object[] args = new String[]{fname, f.getParent(), fname + ".deleted"};
            Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2248", args));
            File nf = new File(f.getParentFile(), fname + ".deleted");
            if (!f.renameTo(nf)) {
                Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2249", f.getPath(), nf.getPath()));
                throw new BrokerException(Globals.getBrokerResources().getKString("B4362", f));
            }
        }
    }

    @Override
    public LoadException getLoadDestinationException() {
        return null;
    }

    @Override
    public LoadException getLoadTransactionException() {
        return null;
    }

    @Override
    public LoadException getLoadTransactionAckException() {
        return null;
    }

    @Override
    public int[] getTransactionUsageInfo(TransactionUID txnID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public long getTransactionAccessedTime(TransactionUID txnID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void updateTransactionAccessedTime(TransactionUID txnID, long timestamp) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void updateRemoteTransaction(TransactionUID txnUID, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void updateInterestState(DestinationUID dID, SysMessageID mID, ConsumerUID iID, int state, boolean sync) throws BrokerException {
        this.updateInterestState(dID, mID, iID, state, sync, null, false);
    }

    public void storeInterestStates(DestinationUID dID, SysMessageID mID, ConsumerUID[] iIDs, int[] states, boolean sync) throws BrokerException {
        this.storeInterestStates(dID, mID, iIDs, states, sync, null);
    }

    @Override
    public void removeMessage(DestinationUID dID, SysMessageID mID, boolean sync) throws IOException, BrokerException {
        this.removeMessage(dID, mID, sync, false);
    }

    public int hashCode() {
        return this.partitionid.hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof PartitionedStore)) {
            return false;
        }
        return this.getPartitionID().equals(((PartitionedStore)anObject).getPartitionID());
    }

    @Override
    public void init(Store store, UID id, boolean isPrimary) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public UID getPartitionID() {
        return this.partitionid;
    }

    @Override
    public boolean isPrimaryPartition() {
        return true;
    }

    @Override
    public List<PartitionedStore> getAllStorePartitions() throws BrokerException {
        ArrayList<PartitionedStore> list = new ArrayList<PartitionedStore>();
        list.add(this);
        return list;
    }

    @Override
    public PartitionedStore getPrimaryPartition() throws BrokerException {
        return this;
    }
}

