/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ConsumerStates;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ConsumerStatesTupleBinding;
import com.sun.messaging.jmq.jmsserver.persist.bdb.MessageEnumeration;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

class DstMsgStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    DestinationUID myduid = null;
    private BDBStore parent = null;
    private Database msgdb = null;
    private Database cssdb = null;
    private TupleBinding cssBinding = null;

    protected static String getDstMsgDatabaseName(DestinationUID duid) {
        StringBuffer dstname = new StringBuffer(duid.toString());
        int indx = -1;
        while ((indx = dstname.indexOf(":")) != -1) {
            dstname.deleteCharAt(indx);
        }
        return dstname.toString();
    }

    protected DestinationUID getMyDestinationUID() {
        return this.myduid;
    }

    protected DstMsgStore(Transaction txn, DestinationUID duid, boolean create, BDBStore p) throws BrokerException, DatabaseNotFoundException {
        this.parent = p;
        this.myduid = duid;
        DstMsgStore.getDstMsgDatabaseName(duid);
        boolean thrownotfound = false;
        try {
            DatabaseConfig dbcf = new DatabaseConfig();
            dbcf.setReadOnly(this.parent.getDBEnv().getConfig().getReadOnly());
            dbcf.setAllowCreate(create);
            dbcf.setTransactional(true);
            dbcf.setSortedDuplicates(false);
            Environment env = this.parent.getDBEnv();
            try {
                this.msgdb = env.openDatabase(txn, DstMsgStore.getDstMsgDatabaseName(duid), dbcf);
            }
            catch (DatabaseNotFoundException e) {
                if (!create) {
                    thrownotfound = true;
                }
                throw e;
            }
            this.cssdb = env.openDatabase(txn, DstMsgStore.getDstMsgDatabaseName(duid) + "_cs", dbcf);
            this.cssBinding = new ConsumerStatesTupleBinding();
        }
        catch (Exception e) {
            if (e instanceof DatabaseNotFoundException && thrownotfound) {
                throw (DatabaseNotFoundException)((Object)e);
            }
            String emsg = "XXXFailed to open message database for destination " + duid;
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected void storeMessage(Transaction txn, Packet message, ConsumerUID[] sids, int[] states) throws BrokerException {
        SysMessageID mid = message.getSysMessageID();
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry(message.getBytes());
            OperationStatus status = this.msgdb.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                String emsg = this.br.getKString("B3008", mid, this.myduid);
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            if (sids == null || sids.length == 0) {
                return;
            }
            data = new DatabaseEntry();
            this.cssBinding.objectToEntry((Object)new ConsumerStates(sids, states), data);
            status = this.cssdb.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                String emsg = this.br.getKString("B3008", mid, "[" + this.cssdb.getDatabaseName() + "]");
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4004", mid + "[" + this.myduid + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void removeMessage(Transaction txn, SysMessageID mid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            OperationStatus status = this.msgdb.delete(txn, key);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3007", mid, this.myduid);
                this.logger.log(16, emsg);
                throw new BrokerException(emsg);
            }
            status = this.cssdb.delete(txn, key);
            if (status == OperationStatus.NOTFOUND) {
                return;
            }
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4033", mid + "[" + this.myduid.getName() + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected static void removeDestination(Transaction txn, DestinationUID duid, DstMsgStore dmstore, BDBStore p) throws BrokerException {
        String msgn = DstMsgStore.getDstMsgDatabaseName(duid);
        String cssn = msgn + "_cs";
        boolean ignorenotfound = false;
        try {
            if (dmstore != null) {
                Exception ex;
                block12: {
                    ex = null;
                    try {
                        dmstore.msgdb.close();
                    }
                    catch (Exception e) {
                        ex = e;
                    }
                    try {
                        dmstore.cssdb.close();
                    }
                    catch (Exception e) {
                        if (ex == null) break block12;
                        ex = e;
                    }
                }
                if (ex != null) {
                    throw ex;
                }
            }
            Environment env = p.getDBEnv();
            try {
                env.removeDatabase(txn, msgn);
            }
            catch (DatabaseNotFoundException e) {
                if (dmstore == null) {
                    ignorenotfound = true;
                }
                throw e;
            }
            env.removeDatabase(txn, cssn);
        }
        catch (Exception e) {
            if (e instanceof DatabaseNotFoundException && ignorenotfound) {
                return;
            }
            String dn = dmstore == null ? "" : dmstore.msgdb.getDatabaseName();
            String emsg = "Failed to remove message database " + dn + " for destination " + duid;
            Globals.getLogger().logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected static Enumeration messageEnumeration(DstMsgStore dmstore, BDBStore p) throws BrokerException {
        return new MessageEnumeration(dmstore == null ? null : dmstore.msgdb, p);
    }

    protected void close() {
        try {
            this.msgdb.close();
        }
        catch (Exception e) {
            this.logger.log(16, "Exception in closing message database for destination " + this.myduid);
        }
        try {
            this.cssdb.close();
        }
        catch (Exception e) {
            this.logger.log(16, "Exception in closing consumer state database for destination " + this.myduid);
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("myduid", this.myduid.toString());
        ht.put("msgdb", this.msgdb.getDatabaseName());
        ht.put("msgdbCount", String.valueOf(this.msgdb.count()));
        ht.put("msgdbConfig", this.msgdb.getConfig().toString());
        ht.put("cssdb", this.cssdb.getDatabaseName());
        ht.put("cssdbCount", String.valueOf(this.cssdb.count()));
        ht.put("cssdbConfig", this.cssdb.getConfig().toString());
        return ht;
    }

    protected void storeInterestStates(Transaction txn, SysMessageID mid, ConsumerUID[] sids, int[] states) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.msgdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3007", mid, this.myduid);
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            status = this.cssdb.get(txn, key, data, null);
            if (status != OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3084", mid + "[" + this.cssdb.getDatabaseName() + "]");
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            data = new DatabaseEntry();
            this.cssBinding.objectToEntry((Object)new ConsumerStates(sids, states), data);
            status = this.cssdb.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                String emsg = this.br.getKString("B3084", mid + "[" + this.cssdb.getDatabaseName() + "]");
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4105", mid + "[" + this.myduid + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void updateInterestState(Transaction txn, SysMessageID mid, ConsumerUID sid, int state) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.msgdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3007", mid, this.myduid);
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            data = new DatabaseEntry();
            status = this.cssdb.get(txn, key, data, LockMode.RMW);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = "XXX Interest list for message " + mid + "[" + this.myduid + "] not found in store";
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            ConsumerStates css = (ConsumerStates)this.cssBinding.entryToObject(data);
            css.setSysMessageID(mid);
            css.updateConsumerState(sid, state);
            css.toArrays();
            data = new DatabaseEntry();
            this.cssBinding.objectToEntry((Object)css, data);
            this.cssdb.put(txn, key, data);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4015", sid, mid + "[" + this.myduid + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected int getInterestState(Transaction txn, SysMessageID mid, ConsumerUID sid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.msgdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3007", mid, this.myduid);
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            data = new DatabaseEntry();
            status = this.cssdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = "XXX Interest list for message " + mid + "[" + this.myduid + "] not found in store";
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            ConsumerStates css = (ConsumerStates)this.cssBinding.entryToObject(data);
            css.setSysMessageID(mid);
            return css.getConsumerState(sid);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4036", sid, mid + "[" + this.myduid + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected HashMap getInterestStates(Transaction txn, SysMessageID mid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.msgdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3007", mid, this.myduid);
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            data = new DatabaseEntry();
            status = this.cssdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                return new HashMap();
            }
            ConsumerStates css = (ConsumerStates)this.cssBinding.entryToObject(data);
            css.setSysMessageID(mid);
            return css.getInterestStates();
        }
        catch (Exception e) {
            String emsg = "Failed to get interest list for mesage" + mid + "[" + this.myduid + "]";
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected ConsumerUID[] getUnAckedConsumerUIDs(Transaction txn, SysMessageID mid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.msgdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3007", mid, this.myduid);
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            data = new DatabaseEntry();
            status = this.cssdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = "XXX Interest list for message " + mid + "[" + this.myduid + "] not found in store";
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            ConsumerStates css = (ConsumerStates)this.cssBinding.entryToObject(data);
            return css.getUnAckedConsumerUIDs();
        }
        catch (Exception e) {
            String emsg = "Failed to get interest list for mesage" + mid + "[" + this.myduid + "]";
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected Packet getMessage(Transaction txn, SysMessageID mid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.msgdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3007", mid, this.myduid);
                this.logger.log(16, emsg);
                throw new BrokerException(emsg);
            }
            return DstMsgStore.parseMessage(data.getData());
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4107", mid + "[" + this.myduid + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
    }

    protected static HashMap getMessageStorageInfo(Transaction txn, DstMsgStore dmstore) throws BrokerException {
        HashMap<String, Number> m = new HashMap<String, Number>(2);
        int count = 0;
        long bytes = 0L;
        if (dmstore == null) {
            m.put("numMsgs", count);
            m.put("totalMsgBytes", bytes);
            return m;
        }
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            key.setPartial(0, 0, true);
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            cs = dmstore.msgdb.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                ++count;
                bytes += (long)data.getData().length;
            }
            cs.close();
            m.put("numMsgs", count);
            m.put("totalMsgBytes", bytes);
            HashMap<String, Number> hashMap = m;
            return hashMap;
        }
        catch (Exception e) {
            String emsg = "XXX Failed to get message count from store for destiation " + dmstore.myduid;
            Globals.getLogger().log(32, emsg);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    Globals.getLogger().log(16, "Failed to close cursor in getting message count from store for destination " + dmstore.myduid + ": " + e.getMessage());
                }
            }
        }
    }

    protected boolean containsMessage(Transaction txn, SysMessageID mid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.msgdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                return false;
            }
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4107", mid + "[" + this.myduid + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return true;
    }

    protected boolean hasMessageBeenAcked(Transaction txn, SysMessageID mid) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(mid.getUniqueName().getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.cssdb.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                return false;
            }
            ConsumerStates css = (ConsumerStates)this.cssBinding.entryToObject(data);
            css.setSysMessageID(mid);
            return css.hasMessageBeenAcked();
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4107", mid + "[" + this.cssdb.getDatabaseName() + "]");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Packet parseMessage(byte[] data) throws IOException {
        ByteBuffer databuf = ByteBuffer.wrap(data);
        try (JMQByteBufferInputStream bis = null;){
            bis = new JMQByteBufferInputStream(databuf);
            Packet pkt = new Packet(false);
            pkt.generateTimestamp(false);
            pkt.generateSequenceNumber(false);
            pkt.readPacket(bis);
            Packet packet = pkt;
            return packet;
        }
    }
}

