/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MySQLBrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

class MySQLMessageDAOImpl
extends MessageDAOImpl {
    private static String PROC_DELETE = null;
    private String dropStoredProcSQL = null;

    MySQLMessageDAOImpl() throws BrokerException {
        PROC_DELETE = "MQ410SP0MSG500" + DBManager.getDBManager().getTableSuffix();
        this.dropStoredProcSQL = new StringBuffer(128).append("DROP PROCEDURE IF EXISTS " + PROC_DELETE).toString();
    }

    @Override
    public void createStoredProc(Connection conn) throws BrokerException {
        block19: {
            Statement stmt;
            Exception myex;
            block18: {
                boolean myConn = false;
                myex = null;
                String sql = "";
                stmt = null;
                DBManager dbMgr = DBManager.getDBManager();
                if (conn == null) {
                    conn = dbMgr.getConnection(true);
                    myConn = true;
                }
                sql = new StringBuffer(128).append("CREATE PROCEDURE ").append(PROC_DELETE).append("( IN msgID VARCHAR (100), ").append("IN brokerID VARCHAR(100), ").append("OUT row_affected INT, ").append("OUT beingTakenOver INT, ").append("OUT brokerState INT )").append(" BEGIN ").append(" DECLARE not_found INT; ").append(" DECLARE CONTINUE HANDLER FOR NOT FOUND SET not_found=1; ").append(" SET not_found=0; ").append(" SET row_affected=1; ").append(" SET beingTakenOver=0; ").append(" SET autocommit=0; ").append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ").append("msgID; ").append(" IF not_found = 1 THEN ").append(" SET row_affected=0; ").append(" END IF; ").append(" IF not_found = 0 AND brokerID IS NOT NULL THEN ").append(" CALL " + MySQLBrokerDAOImpl.PROC_IS_BEING_TAKENOVER + "(").append("brokerID, beingTakenOver, brokerState); ").append(" END IF; ").append(" IF beingTakenOver = 0 THEN ").append("DELETE FROM ").append(dbMgr.getDAOFactory().getConsumerStateDAO().getTableName()).append(" WHERE ").append("MESSAGE_ID").append(" = msgID; ").append(" END IF; ").append("END;").toString();
                stmt = conn.createStatement();
                try {
                    DBManager.executeUpdateStatement(stmt, sql);
                }
                catch (SQLException ee) {
                    int ec = ee.getErrorCode();
                    String et = ee.getSQLState();
                    if (ec != 1304 || et != null && !et.equals("42000")) {
                        throw ee;
                    }
                    this.logger.log(8, this.br.getKString("B1429", PROC_DELETE));
                    if (myConn) {
                        this.closeSQLObjects(null, stmt, conn, myex);
                    } else {
                        this.closeSQLObjects(null, stmt, null, myex);
                    }
                    return;
                }
                try {
                    Globals.getLogger().log(8, this.br.getKString("B1428", PROC_DELETE));
                    if (DEBUG) {
                        Globals.getLogger().log(8, sql);
                    }
                    if (!myConn) break block18;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException("Failed to execute " + sql, ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(null, stmt, conn, myex);
                        } else {
                            this.closeSQLObjects(null, stmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(null, stmt, conn, myex);
                break block19;
            }
            this.closeSQLObjects(null, stmt, null, myex);
        }
    }

    @Override
    public void dropStoredProc(Connection conn) throws BrokerException {
        boolean myConn = false;
        Exception myex = null;
        String sql = this.dropStoredProcSQL;
        Statement stmt = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                conn = dbMgr.getConnection(true);
                myConn = true;
            }
            stmt = conn.createStatement();
            DBManager.executeStatement(stmt, sql);
            if (DEBUG) {
                Globals.getLogger().log(8, "DONE " + sql);
            }
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof SQLException ? CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
            throw new BrokerException("Failed to execute " + sql, ex);
        }
        finally {
            if (myConn) {
                this.closeSQLObjects(null, stmt, conn, myex);
            } else {
                this.closeSQLObjects(null, stmt, null, myex);
            }
        }
    }

    @Override
    public void delete(Connection conn, DestinationUID dstUID, String id, boolean replaycheck) throws BrokerException {
        block22: {
            Exception myex;
            CallableStatement stmt;
            block21: {
                boolean myConn = false;
                stmt = null;
                myex = null;
                String sql = "{call " + PROC_DELETE + " (?, ?, ?, ?, ?)}";
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    if (this.fi.FAULT_INJECTION) {
                        HashMap<String, String> fips = new HashMap<String, String>();
                        fips.put("mqDestinationName", DestinationUID.getUniqueString(dstUID.getName(), dstUID.isQueue()));
                        this.fi.checkFaultAndExit("txn.commit.1_8", fips, 2, false);
                    }
                    if (DEBUG) {
                        Globals.getLogger().log(8, "before call " + sql + "(" + id + ")");
                    }
                    String brokerid = dbMgr.getBrokerID();
                    stmt = conn.prepareCall(sql);
                    stmt.setString(1, id);
                    if (Globals.getHAEnabled()) {
                        stmt.setString(2, brokerid);
                    } else {
                        stmt.setNull(2, 12);
                    }
                    stmt.registerOutParameter(3, 4);
                    stmt.registerOutParameter(4, 4);
                    stmt.registerOutParameter(5, 4);
                    stmt.execute();
                    int row_affected = stmt.getInt(3);
                    int beingTakenOver = stmt.getInt(4);
                    int bstate = stmt.getInt(5);
                    if (Globals.getHAEnabled() && beingTakenOver != 0) {
                        HABrokerInfo binfo = null;
                        try {
                            binfo = dbMgr.getDAOFactory().getBrokerDAO().getBrokerInfo(conn, brokerid);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw new StoreBeingTakenOverException(this.br.getKString("B3223") + "[" + BrokerState.getState(bstate).toString() + "]" + binfo);
                    }
                    if (row_affected == 0) {
                        throw new BrokerException(this.br.getKString("B3007", id, dstUID), 404);
                    }
                    if (DEBUG) {
                        Globals.getLogger().log(8, "After call " + sql + "(" + id + ")");
                    }
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block21;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? CommDBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException("Failed to execute " + sql, ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            this.closeSQLObjects(null, stmt, conn, myex);
                        } else {
                            this.closeSQLObjects(null, stmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                this.closeSQLObjects(null, stmt, conn, myex);
                break block22;
            }
            this.closeSQLObjects(null, stmt, null, myex);
        }
    }
}

