/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TransactionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class TransactionDAOImpl
extends BaseDAOImpl
implements TransactionDAO {
    private static boolean DEBUG = false;
    private final String tableName;
    private final String insertSQL;
    private final String updateTxnStateSQL;
    private final String updateTxnHomeBrokerSQL;
    private final String updateTxnBrokersSQL;
    private final String updateAccessedTimeSQL;
    private final String deleteSQL;
    private final String selectTxnStateSQL;
    private final String selectTxnHomeBrokerSQL;
    private final String selectTxnBrokersSQL;
    private final String selectAccessedTimeSQL;
    private final String selectTxnInfoSQL;
    private final String selectTxnStatesByBrokerSQL;
    private final String selectTxnStatesBySessionSQL;
    private final String selectTxnStatesByBrokerAndTypeSQL;
    private final String selectTxnStatesBySessionAndTypeSQL;
    private final String selectRemoteTxnStatesByBrokerAndTypeSQL;
    private final String selectRemoteTxnStatesBySessionAndTypeSQL;
    private final String selectUsageInfoSQL;

    TransactionDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        String brokerNotTakenOverClause = Globals.getHAEnabled() ? " AND NOT EXISTS (" + ((BrokerDAOImpl)dbMgr.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")" : "";
        this.tableName = dbMgr.getTableName("MQTXN41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("AUTO_ROLLBACK").append(", ").append("XID").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(", ").append("STORE_SESSION_ID").append(", ").append("EXPIRED_TS").append(", ").append("ACCESSED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateTxnStateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?, ").append("TXN_STATE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(brokerNotTakenOverClause).toString();
        this.updateTxnHomeBrokerSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TXN_HOME_BROKER").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(brokerNotTakenOverClause).toString();
        this.updateTxnBrokersSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TYPE").append(" = ?, ").append("TXN_BROKERS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").append(brokerNotTakenOverClause).toString();
        this.updateAccessedTimeSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("ACCESSED_TS").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTxnStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTxnHomeBrokerSQL = new StringBuffer(128).append("SELECT ").append("TXN_HOME_BROKER").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTxnBrokersSQL = new StringBuffer(128).append("SELECT ").append("TXN_BROKERS").append(", ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAccessedTimeSQL = new StringBuffer(128).append("SELECT ").append("ACCESSED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTxnInfoSQL = new StringBuffer(128).append("SELECT ").append("TYPE").append(", ").append("STATE").append(", ").append("TXN_STATE").append(", ").append("TXN_HOME_BROKER").append(", ").append("TXN_BROKERS").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTxnStatesByBrokerSQL = new StringBuffer(128).append("SELECT txnTbl.").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("TXN_STATE").append(", ").append("TXN_BROKERS").append(" FROM ").append(this.tableName).append(" txnTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = txnTbl.").append("STORE_SESSION_ID").append(" AND ").append("STATE").append(" <> -1").append(" AND ").append("TYPE").append(" IN (").append(1).append(", ").append(2).append(")").toString();
        this.selectTxnStatesBySessionSQL = new StringBuffer(128).append("SELECT ").append("ID").append(", ").append("TYPE").append(", ").append("STATE").append(", ").append("TXN_STATE").append(", ").append("TXN_BROKERS").append(" FROM ").append(this.tableName).append(" WHERE ").append("STORE_SESSION_ID").append("= ?").append(" AND ").append("STATE").append(" <> -1").append(" AND ").append("TYPE").append(" IN (").append(1).append(", ").append(2).append(")").toString();
        this.selectTxnStatesByBrokerAndTypeSQL = new StringBuffer(128).append("SELECT txnTbl.").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" txnTbl, ").append(dbMgr.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = txnTbl.").append("STORE_SESSION_ID").append(" AND ").append("STATE").append(" <> -1").append(" AND ").append("TYPE").append(" = ?").toString();
        this.selectTxnStatesBySessionAndTypeSQL = new StringBuffer(128).append("SELECT txnTbl.").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("STORE_SESSION_ID").append("= ?").append(" AND ").append("STATE").append(" <> -1").append(" AND ").append("TYPE").append(" = ?").toString();
        this.selectRemoteTxnStatesByBrokerAndTypeSQL = new StringBuffer(256).append("SELECT ").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("TYPE").append(" = ?").append(" AND ").append("STORE_SESSION_ID").append(" NOT IN (SELECT ").append("ID").append(" FROM ").append(dbMgr.getTableName("MQSES41")).append(" WHERE ").append("BROKER_ID").append(" = ?)").append(" AND ").append("ID").append(" IN (SELECT DISTINCT c.").append("TRANSACTION_ID").append(" FROM ").append(dbMgr.getTableName("MQSES41")).append(" s, ").append(dbMgr.getTableName("MQMSG41")).append(" m, ").append(dbMgr.getTableName("MQCONSTATE41")).append(" c").append(" WHERE s.").append("BROKER_ID").append(" = ?").append(" AND s.").append("ID").append(" = m.").append("STORE_SESSION_ID").append(" AND m.").append("ID").append(" = c.").append("MESSAGE_ID").append(" AND c.").append("TRANSACTION_ID").append(" IS NOT NULL)").toString();
        this.selectRemoteTxnStatesBySessionAndTypeSQL = new StringBuffer(256).append("SELECT ").append("ID").append(", ").append("STATE").append(", ").append("TXN_STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("TYPE").append(" = ?").append(" AND ").append("STORE_SESSION_ID").append("<> ?").append(" AND ").append("ID").append(" IN (SELECT DISTINCT c.").append("TRANSACTION_ID").append(" FROM ").append(dbMgr.getTableName("MQMSG41")).append(" m, ").append(dbMgr.getTableName("MQCONSTATE41")).append(" c").append(" WHERE m.").append("STORE_SESSION_ID").append("= ?").append(" AND m.").append("ID").append(" = c.").append("MESSAGE_ID").append(" AND c.").append("TRANSACTION_ID").append(" IS NOT NULL)").toString();
        this.selectUsageInfoSQL = new StringBuffer(128).append("SELECT MAX(mcount), MAX(scount) FROM (").append("SELECT COUNT(*) AS mcount, 0 AS scount FROM ").append(dbMgr.getTableName("MQMSG41")).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(" UNION ").append("SELECT 0 AS mcount, COUNT(*) AS scount FROM ").append(dbMgr.getTableName("MQCONSTATE41")).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(")").toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQTXN41";
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, TransactionUID txnUID, TransactionState txnState, long storeSessionID) throws BrokerException {
        this.insert(conn, txnUID, txnState, null, null, 1, storeSessionID);
    }

    @Override
    public void insert(Connection conn, TransactionUID txnUID, TransactionState txnState, BrokerAddress txnHomeBroker, TransactionBroker[] txnBrokers, int type, long storeSessionID) throws BrokerException {
        block19: {
            Exception myex;
            PreparedStatement pstmt;
            block18: {
                long id = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    try {
                        pstmt = DBManager.createPreparedStatement(conn, this.insertSQL);
                        pstmt.setLong(1, id);
                        pstmt.setInt(2, type);
                        pstmt.setInt(3, txnState.getState());
                        pstmt.setInt(4, txnState.getType().intValue());
                        JMQXid jmqXid = txnState.getXid();
                        if (jmqXid != null) {
                            pstmt.setString(5, jmqXid.toString());
                        } else {
                            pstmt.setNull(5, 12);
                        }
                        Util.setObject(pstmt, 6, txnState);
                        Util.setObject(pstmt, 7, txnHomeBroker);
                        Util.setObject(pstmt, 8, txnBrokers);
                        pstmt.setLong(9, storeSessionID);
                        pstmt.setLong(10, txnState.getExpirationTime());
                        pstmt.setLong(11, txnState.getLastAccessTime());
                        pstmt.executeUpdate();
                    }
                    catch (Exception e) {
                        myex = e;
                        try {
                            if (!conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        try {
                            if (this.hasTransaction(conn, id)) {
                                throw new BrokerException(this.br.getKString("B3015", txnUID.toString()));
                            }
                        }
                        catch (Exception e2) {
                            this.logger.log(16, this.br.getKString("B4431", txnUID + "[" + storeSessionID + ", " + txnHomeBroker + "]", e2.getMessage()));
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)e) : e);
                        throw new BrokerException(this.br.getKString("B4019", txnUID), ex);
                    }
                    if (!myConn) break block18;
                }
                catch (BrokerException e) {
                    try {
                        myex = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block19;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateTransactionState(Connection conn, TransactionUID txnUID, TransactionState txnState, boolean replaycheck) throws BrokerException {
        DBManager dbMgr;
        Exception myex;
        PreparedStatement pstmt;
        boolean myConn;
        block19: {
            block20: {
                myConn = false;
                pstmt = null;
                myex = null;
                try {
                    dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (!replaycheck) break block19;
                    TransactionState st = null;
                    try {
                        st = this.getTransactionState(conn, txnUID);
                        if (st.getState() != txnState.getState()) break block19;
                        this.logger.log(8, "B1430", "TID:" + txnUID + "[" + txnState + "]");
                        if (!myConn) break block20;
                    }
                    catch (BrokerException e) {
                        if (e.getStatusCode() != 404) {
                            e.setSQLRecoverable(true);
                            e.setSQLReplayCheck(true);
                            throw e;
                        }
                        break block19;
                    }
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        boolean replayck = false;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            replayck = true;
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.updateTxnStateSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateTxnStateSQL + "]", (SQLException)e) : e);
                        BrokerException be = new BrokerException(this.br.getKString("B4137", txnUID), ex);
                        be.setSQLRecoverable(true);
                        if (!replayck) throw be;
                        be.setSQLReplayCheck(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                            throw throwable;
                        }
                        Util.close(null, pstmt, null, myex);
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                return;
            }
            Util.close(null, pstmt, null, myex);
            return;
        }
        pstmt = DBManager.createPreparedStatement(conn, this.updateTxnStateSQL);
        pstmt.setInt(1, txnState.getState());
        Util.setObject(pstmt, 2, txnState);
        pstmt.setLong(3, txnUID.longValue());
        if (Globals.getHAEnabled()) {
            pstmt.setString(4, dbMgr.getBrokerID());
        }
        if (pstmt.executeUpdate() == 0) {
            if (!Globals.getHAEnabled()) throw new BrokerException(this.br.getKString("B3016", txnUID), 404);
            String brokerID = dbMgr.getBrokerID();
            BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
            if (!dao.isBeingTakenOver(conn, brokerID)) throw new BrokerException(this.br.getKString("B3016", txnUID), 404);
            StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
            try {
                HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, brokerID);
                this.logger.logStack(32, be.getMessage() + "[" + (bkrInfo == null ? "" + brokerID : bkrInfo.toString()) + "]", be);
                throw be;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw be;
        }
        if (myConn) {
            Util.close(null, pstmt, conn, myex);
            return;
        }
        Util.close(null, pstmt, null, myex);
    }

    @Override
    public void updateTransactionHomeBroker(Connection conn, TransactionUID txnUID, BrokerAddress txnHomeBroker) throws BrokerException {
        block18: {
            Exception myex;
            PreparedStatement pstmt;
            block17: {
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.updateTxnHomeBrokerSQL);
                    Util.setObject(pstmt, 1, txnHomeBroker);
                    pstmt.setLong(2, txnUID.longValue());
                    if (Globals.getHAEnabled()) {
                        pstmt.setString(3, dbMgr.getBrokerID());
                    }
                    if (pstmt.executeUpdate() == 0) {
                        if (Globals.getHAEnabled()) {
                            String brokerID = dbMgr.getBrokerID();
                            BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
                            if (dao.isBeingTakenOver(conn, brokerID)) {
                                StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, brokerID);
                                    this.logger.logStack(32, be.getMessage() + "[" + (bkrInfo == null ? "" + brokerID : bkrInfo.toString()) + "]", be);
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                throw be;
                            }
                        }
                        throw new BrokerException(this.br.getKString("B3016", txnUID), 404);
                    }
                    if (!myConn) break block17;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.updateTxnHomeBrokerSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateTxnHomeBrokerSQL + "]", (SQLException)e) : e);
                        BrokerException be = new BrokerException(this.br.getKString("B4019", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block18;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void updateTransactionBrokers(Connection conn, TransactionUID txnUID, TransactionBroker[] txnBrokers) throws BrokerException {
        block18: {
            Exception myex;
            PreparedStatement pstmt;
            block17: {
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.updateTxnBrokersSQL);
                    pstmt.setInt(1, 2);
                    Util.setObject(pstmt, 2, txnBrokers);
                    pstmt.setLong(3, txnUID.longValue());
                    if (Globals.getHAEnabled()) {
                        pstmt.setString(4, dbMgr.getBrokerID());
                    }
                    if (pstmt.executeUpdate() == 0) {
                        if (Globals.getHAEnabled()) {
                            String brokerID = dbMgr.getBrokerID();
                            BrokerDAO dao = dbMgr.getDAOFactory().getBrokerDAO();
                            if (dao.isBeingTakenOver(conn, brokerID)) {
                                StoreBeingTakenOverException be = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo bkrInfo = dao.getBrokerInfo(conn, brokerID);
                                    this.logger.logStack(32, be.getMessage() + "[" + (bkrInfo == null ? "" + brokerID : bkrInfo.toString()) + "]", be);
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                throw be;
                            }
                        }
                        throw new BrokerException(this.br.getKString("B3016", txnUID), 404);
                    }
                    if (!myConn) break block17;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.updateTxnBrokersSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateTxnBrokersSQL + "]", (SQLException)e) : e);
                        BrokerException be = new BrokerException(this.br.getKString("B4019", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block18;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void updateTransactionBrokerState(Connection conn, TransactionUID txnUID, int expectedTxnState, TransactionBroker txnBkr) throws BrokerException {
        block16: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block15: {
                long id = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectTxnBrokersSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3016", txnUID), 404);
                    }
                    TransactionBroker[] txnBrokers = (TransactionBroker[])Util.readObject(rs, 1);
                    int state = rs.getInt(2);
                    if (state != expectedTxnState) {
                        Object[] args = new Object[]{txnBkr, txnUID, TransactionState.toString(expectedTxnState), TransactionState.toString(state)};
                        throw new BrokerException(this.br.getKString("B3219", args), 409);
                    }
                    int len = txnBrokers.length;
                    for (int i = 0; i < len; ++i) {
                        TransactionBroker bkr = txnBrokers[i];
                        if (!bkr.equals(txnBkr)) continue;
                        bkr.copyState(txnBkr);
                        break;
                    }
                    this.updateTransactionBrokers(conn, txnUID, txnBrokers);
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block15;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.selectTxnBrokersSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnBrokersSQL + "]", (SQLException)e) : e);
                        BrokerException be = new BrokerException(this.br.getKString("B4019", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block16;
            }
            Util.close(rs, pstmt, null, myex);
        }
    }

    @Override
    public void updateAccessedTime(Connection conn, TransactionUID txnUID, long accessedTime) throws BrokerException {
        block13: {
            Exception myex;
            PreparedStatement pstmt;
            block12: {
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.updateAccessedTimeSQL);
                    pstmt.setLong(1, accessedTime);
                    pstmt.setLong(2, txnUID.longValue());
                    if (pstmt.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3016", txnUID), 404);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateAccessedTimeSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4019", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block13;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void delete(Connection conn, TransactionUID txnUID) throws BrokerException {
        block14: {
            Exception myex;
            PreparedStatement pstmt;
            block13: {
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.deleteSQL);
                    pstmt.setLong(1, txnUID.longValue());
                    if (pstmt.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3016", txnUID), 404);
                    }
                    dbMgr.getDAOFactory().getConsumerStateDAO().deleteByTransaction(conn, txnUID);
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4138", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block14;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        String whereClause = null;
        if (Globals.getHAEnabled()) {
            DBManager dbMgr = DBManager.getDBManager();
            whereClause = new StringBuffer(128).append("EXISTS (SELECT ").append("ID").append(" FROM ").append(dbMgr.getTableName("MQSES41")).append(" WHERE ").append("ID").append(" = ").append(this.tableName).append(".").append("STORE_SESSION_ID").append(" AND ").append("BROKER_ID").append(" = '").append(dbMgr.getBrokerID()).append("')").toString();
        }
        this.deleteAll(conn, whereClause, null, 0);
    }

    @Override
    public TransactionState getTransactionState(Connection conn, TransactionUID txnUID) throws BrokerException {
        TransactionState txnState;
        block16: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block15: {
                txnState = null;
                long id = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectTxnStateSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        try {
                            int state = rs.getInt(1);
                            txnState = (TransactionState)Util.readObject(rs, 2);
                            txnState.setState(state);
                        }
                        catch (IOException e) {
                            this.logger.logStack(32, "B4128", e);
                        }
                    } else {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(id)), 404);
                    }
                    if (!myConn) break block15;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectTxnStateSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnStateSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4233", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block16;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return txnState;
    }

    @Override
    public BrokerAddress getTransactionHomeBroker(Connection conn, TransactionUID txnUID) throws BrokerException {
        BrokerAddress txnHomeBroker;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                txnHomeBroker = null;
                long id = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectTxnHomeBrokerSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(id)), 404);
                    }
                    txnHomeBroker = (BrokerAddress)Util.readObject(rs, 1);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnHomeBrokerSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4233", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return txnHomeBroker;
    }

    @Override
    public TransactionBroker[] getTransactionBrokers(Connection conn, TransactionUID txnUID) throws BrokerException {
        TransactionBroker[] txnBrokers;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                txnBrokers = null;
                long id = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectTxnBrokersSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(id)), 404);
                    }
                    txnBrokers = (TransactionBroker[])Util.readObject(rs, 1);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnBrokersSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4233", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return txnBrokers;
    }

    @Override
    public TransactionInfo getTransactionInfo(Connection conn, TransactionUID txnUID) throws BrokerException {
        TransactionInfo txnInfo;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                txnInfo = null;
                long id = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectTxnInfoSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(id)), 404);
                    }
                    int type = rs.getInt(1);
                    int state = rs.getInt(2);
                    TransactionState txnState = (TransactionState)Util.readObject(rs, 3);
                    txnState.setState(state);
                    BrokerAddress txnHomeBroker = (BrokerAddress)Util.readObject(rs, 4);
                    TransactionBroker[] txnBrokers = (TransactionBroker[])Util.readObject(rs, 5);
                    txnInfo = new TransactionInfo(txnState, txnHomeBroker, txnBrokers, type);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnInfoSQL + "]", (SQLException)e) : e;
                        BrokerException be = new BrokerException(this.br.getKString("B4233", txnUID), ex);
                        be.setSQLRecoverable(true);
                        throw be;
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return txnInfo;
    }

    @Override
    public long getAccessedTime(Connection conn, TransactionUID txnUID) throws BrokerException {
        long accessedTime;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                accessedTime = -1L;
                long id = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectAccessedTimeSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3016", String.valueOf(id)), 404);
                    }
                    accessedTime = rs.getLong(1);
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAccessedTimeSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4233", txnUID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return accessedTime;
    }

    @Override
    public List getTransactionsByBroker(Connection conn, String brokerID) throws BrokerException {
        ArrayList<TransactionUID> list;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                list = new ArrayList<TransactionUID>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectTxnStatesByBrokerSQL);
                    pstmt.setString(1, brokerID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new TransactionUID(rs.getLong(1)));
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTxnStatesByBrokerSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4235", brokerID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return list;
    }

    @Override
    public List getRemoteTransactionsByBroker(Connection conn, String brokerID) throws BrokerException {
        ArrayList<TransactionUID> list;
        block18: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block17: {
                list = new ArrayList<TransactionUID>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                String sql = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    sql = Globals.getHAEnabled() ? this.selectRemoteTxnStatesByBrokerAndTypeSQL : this.selectTxnStatesByBrokerAndTypeSQL;
                    if (Globals.getHAEnabled()) {
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        pstmt.setInt(1, 2);
                        pstmt.setString(2, brokerID);
                        pstmt.setString(3, brokerID);
                        if (DEBUG) {
                            this.logger.log(8, "TransactionDAOImpl.getRemoteTransactionStatesByBroker(): [" + sql + "](" + 2 + "," + brokerID + "," + brokerID + ")");
                        }
                    } else {
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        pstmt.setString(1, brokerID);
                        pstmt.setInt(2, 3);
                        if (DEBUG) {
                            this.logger.log(8, "TransactionDAOImpl.getRemoteTransactionStatesByBroker(): [" + sql + "](" + brokerID + "," + 3 + ")");
                        }
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        long id = rs.getLong(1);
                        list.add(new TransactionUID(id));
                        if (!DEBUG) continue;
                        this.logger.log(8, "TransactionDAOImpl.getRemoteTransactionStatesByBroker(): Result[" + id + "]");
                    }
                    if (!myConn) break block17;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4235", brokerID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block18;
            }
            Util.close(rs, pstmt, null, myex);
        }
        if (DEBUG) {
            this.logger.log(8, "TransactionDAOImpl.getRemoteTransactionStatesByBroker(): ResultSet[size=" + list.size() + "]");
        }
        return list;
    }

    @Override
    public HashMap getTransactionStatesByBroker(Connection conn, String brokerID, Long storeSession) throws BrokerException {
        HashMap<TransactionUID, TransactionInfo> map;
        block19: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block18: {
                map = new HashMap<TransactionUID, TransactionInfo>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                String sql = this.selectTxnStatesByBrokerSQL;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (brokerID == null) {
                        brokerID = dbMgr.getBrokerID();
                    }
                    if (storeSession != null) {
                        StoreSessionDAOImpl.checkStoreSessionOwner(conn, storeSession, brokerID);
                        sql = this.selectTxnStatesBySessionSQL;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, sql);
                    if (storeSession != null) {
                        pstmt.setLong(1, storeSession);
                    } else {
                        pstmt.setString(1, brokerID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        try {
                            long id = rs.getLong(1);
                            int type = rs.getInt(2);
                            int state = rs.getInt(3);
                            TransactionState txnState = (TransactionState)Util.readObject(rs, 4);
                            txnState.setState(state);
                            TransactionBroker[] txnBrokers = (TransactionBroker[])Util.readObject(rs, 5);
                            map.put(new TransactionUID(id), new TransactionInfo(txnState, null, txnBrokers, type));
                        }
                        catch (IOException e) {
                            this.logger.logStack(32, "B4128", e);
                        }
                    }
                    if (!myConn) break block18;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4032"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block19;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return map;
    }

    @Override
    public HashMap getRemoteTransactionStatesByBroker(Connection conn, String brokerID, Long storeSession) throws BrokerException {
        HashMap<TransactionUID, TransactionState> map;
        block23: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block22: {
                map = new HashMap<TransactionUID, TransactionState>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                String sql = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if (brokerID == null) {
                        brokerID = dbMgr.getBrokerID();
                    }
                    sql = Globals.getHAEnabled() ? this.selectRemoteTxnStatesByBrokerAndTypeSQL : this.selectTxnStatesByBrokerAndTypeSQL;
                    if (storeSession != null) {
                        StoreSessionDAOImpl.checkStoreSessionOwner(conn, storeSession, brokerID);
                        sql = Globals.getHAEnabled() ? this.selectRemoteTxnStatesBySessionAndTypeSQL : this.selectTxnStatesBySessionAndTypeSQL;
                    }
                    if (Globals.getHAEnabled()) {
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        pstmt.setInt(1, 2);
                        if (storeSession != null) {
                            pstmt.setLong(2, storeSession);
                            pstmt.setLong(3, storeSession);
                        } else {
                            pstmt.setString(2, brokerID);
                            pstmt.setString(3, brokerID);
                        }
                    } else {
                        pstmt = DBManager.createPreparedStatement(conn, sql);
                        if (storeSession != null) {
                            pstmt.setLong(1, storeSession);
                        } else {
                            pstmt.setString(1, brokerID);
                        }
                        pstmt.setInt(2, 3);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        try {
                            long id = rs.getLong(1);
                            int state = rs.getInt(2);
                            TransactionState txnState = (TransactionState)Util.readObject(rs, 3);
                            txnState.setState(state);
                            map.put(new TransactionUID(id), txnState);
                        }
                        catch (IOException e) {
                            this.logger.logStack(32, "B4128", e);
                        }
                    }
                    if (!myConn) break block22;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4032"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block23;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return map;
    }

    @Override
    public int[] getTransactionUsageInfo(Connection conn, TransactionUID txnUID) throws BrokerException {
        int[] data;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                data = new int[]{0, 0};
                long id = txnUID.longValue();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectUsageInfoSQL);
                    pstmt.setLong(1, id);
                    pstmt.setLong(2, id);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        data[0] = rs.getInt(1);
                        data[1] = rs.getInt(2);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectUsageInfoSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4233", txnUID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return data;
    }

    @Override
    public boolean hasTransaction(Connection conn, long id) throws BrokerException {
        boolean found;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                found = false;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectAccessedTimeSQL);
                    pstmt.setLong(1, id);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        found = true;
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAccessedTimeSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4233", String.valueOf(id)), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return found;
    }

    @Override
    public void checkTransaction(Connection conn, long id) throws BrokerException {
        if (!this.hasTransaction(conn, id)) {
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080[hasTransaction():" + id + "]", rbe);
            }
            throw new BrokerException(this.br.getKString("B3016", String.valueOf(id)), 404);
        }
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put("Transactions(" + this.tableName + ")", String.valueOf(count));
        return map;
    }
}

