/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.pool.RunnableFactory;
import com.sun.messaging.jmq.jmsserver.pool.ThreadPool;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQEmbeddedConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnable;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnableFactory;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.Hashtable;

public class IMQEmbeddedService
extends IMQService {
    private static boolean DEBUG = false;
    protected PacketRouter router = null;
    protected ThreadPool pool = null;
    protected RunnableFactory runfac = null;

    public IMQEmbeddedService(String name, int type, PacketRouter router, int min, int max) {
        super(name, type);
        this.router = router;
        this.runfac = this.getRunnableFactory();
        if (max == 0) {
            throw new RuntimeException(Globals.getBrokerResources().getKString("B4136", name, String.valueOf(max)));
        }
        this.pool = new ThreadPool(name, min, max, this.runfac);
    }

    @Override
    public Hashtable getPoolDebugState() {
        return this.pool.getDebugState();
    }

    public void dumpPool() {
        this.pool.debug();
    }

    protected RunnableFactory getRunnableFactory() {
        return new OperationRunnableFactory(true);
    }

    @Override
    public synchronized int getMinThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getMinimum();
    }

    @Override
    public synchronized int getMaxThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getMaximum();
    }

    @Override
    public synchronized int getActiveThreadpool() {
        if (this.pool == null) {
            return 0;
        }
        return this.pool.getThreadNum();
    }

    @Override
    public void setPriority(int priority) {
        this.pool.setPriority(priority);
    }

    @Override
    public synchronized int[] setMinMaxThreadpool(int min, int max) {
        if (this.pool == null) {
            return null;
        }
        return this.pool.setMinMax(min, max);
    }

    @Override
    public synchronized void startService(boolean startPaused) {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to start service, already started.");
            return;
        }
        this.setState(2);
        Object[] args = new String[]{this.getName(), "in-process connections", String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
        this.logger.log(8, "B1004", args);
        try {
            this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), this.getName());
        }
        catch (BrokerException e) {
            this.logger.log(16, "B2135", (Object)this.getName(), e.getMessage());
        }
        this.pool.start();
        if (startPaused) {
            this.setServiceRunning(false);
            this.setState(4);
        } else {
            this.setServiceRunning(true);
            this.setState(3);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(boolean all) {
        int i;
        Connection con;
        Object cons;
        IMQEmbeddedService iMQEmbeddedService = this;
        synchronized (iMQEmbeddedService) {
            if (this.isShuttingDown()) {
                return;
            }
            Object[] strings = new String[]{this.getName(), "none"};
            if (all) {
                this.logger.log(8, "B1007", strings);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", strings);
            }
            this.setShuttingDown(true);
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.stopConnection();
            }
        }
        cons = this;
        synchronized (cons) {
            this.setState(5);
            this.notifyAll();
        }
        if (!all) {
            return;
        }
        if (this.getServiceType() == 0) {
            cons = this.connectionList.getConnectionList(this);
            con = null;
            for (i = cons.size() - 1; i >= 0; --i) {
                con = (Connection)cons.get(i);
                con.destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        iMQEmbeddedService = this;
        synchronized (iMQEmbeddedService) {
            this.setState(6);
            this.notifyAll();
        }
        if (this.pool.isValid()) {
            this.pool.waitOnDestroy(this.getDestroyWaitTime());
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying Service {0} with protocol {1} ", (Object)this.getName(), "none");
        }
    }

    @Override
    public void stopNewConnections() throws IOException, IllegalStateException {
        if (this.getState() != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        this.setState(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startNewConnections() throws IOException {
        if (this.getState() != 8 && this.getState() != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        IMQEmbeddedService iMQEmbeddedService = this;
        synchronized (iMQEmbeddedService) {
            this.setState(3);
            this.notifyAll();
        }
    }

    @Override
    public void pauseService(boolean all) {
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to pause service " + this.name + ", already paused.");
            return;
        }
        Object[] strings = new String[]{this.getName(), "none"};
        this.logger.log(4, "B1005", strings);
        try {
            this.stopNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.setState(4);
        if (all) {
            this.pool.suspend();
        }
        this.setServiceRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeService() {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", "unable to resume service " + this.name + ", already running.");
            return;
        }
        Object[] strings = new String[]{this.getName(), "none"};
        this.logger.log(4, "B1006", strings);
        try {
            this.startNewConnections();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", "pausing service " + this, (Throwable)ex);
        }
        this.pool.resume();
        this.setServiceRunning(true);
        IMQEmbeddedService iMQEmbeddedService = this;
        synchronized (iMQEmbeddedService) {
            this.setState(3);
            this.notifyAll();
        }
    }

    public IMQEmbeddedConnection createConnection() throws IOException, BrokerException {
        IMQEmbeddedConnection con = new IMQEmbeddedConnection(this, this.router);
        OperationRunnable read = (OperationRunnable)this.pool.getAvailRunnable(false);
        OperationRunnable write = (OperationRunnable)this.pool.getAvailRunnable(false);
        if (read == null || write == null) {
            if (read != null) {
                read.release();
            }
            if (write != null) {
                write.release();
            }
            Object[] args = new String[]{this.toString(), String.valueOf(this.pool.getAssignedCnt()), String.valueOf(this.pool.getMaximum())};
            this.logger.log(16, "B3004", args);
            this.pool.debug();
            con.destroyConnection(true, 4, Globals.getBrokerResources().getKString("B3004", args));
            throw new BrokerException(Globals.getBrokerResources().getKString("B3004", args), "B3004", null, 405);
        }
        this.connectionList.addConnection(con);
        try {
            read.assignOperation(con, 1, -1);
        }
        catch (IllegalAccessException ex) {
            String emsg = "Unable to assign op to reader thread for connection: " + con;
            Globals.getLogger().logStack(32, emsg, ex);
            write.release();
            con.destroyConnection(true, 4, emsg);
            throw new BrokerException(emsg, ex);
        }
        try {
            write.assignOperation(con, 4, -1);
        }
        catch (IllegalAccessException ex) {
            String emsg = "Unable to assign op to writer thread for connection: " + con;
            Globals.getLogger().logStack(32, emsg, ex);
            read.destroy();
            con.destroyConnection(true, 4, emsg);
            throw new BrokerException(emsg, ex);
        }
        return con;
    }
}

