/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx;

import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.TransactionManagerImpl;
import com.sun.messaging.bridge.service.jms.tx.XAParticipant;
import com.sun.messaging.bridge.service.jms.tx.log.LogRecord;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TransactionImpl
implements Transaction {
    private Logger _logger = null;
    private int _status = 6;
    private GlobalXid _gxid = null;
    private TransactionManagerImpl _tm = null;
    private ArrayList<BranchXid> _seenBranchXids = new ArrayList();
    private ArrayList<XAResource> _associatedXAResources = new ArrayList();
    private Map<XAResource, XAParticipant> _participants = new LinkedHashMap<XAResource, XAParticipant>();
    private byte _branchCount = 0;
    private int _maxBranches;
    private TxLog _txlog = null;

    public TransactionImpl(GlobalXid xid, TransactionManagerImpl tm) throws SystemException {
        if (xid == null) {
            throw new SystemException("null xid");
        }
        this._tm = tm;
        this._logger = tm.getLogger();
        this._txlog = tm.getTxLog();
        this._gxid = xid;
        this._maxBranches = tm.getMaxBranches();
        this._branchCount = 0;
        this._status = 0;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this._tm + " commit " + this);
        }
        if (this._status == 1) {
            this.rollback();
            throw new RollbackException(this.toString());
        }
        if (this._status != 0) {
            throw new IllegalStateException(this.toString());
        }
        if (this._associatedXAResources.size() != 0) {
            throw new IllegalStateException("There are undelisted XAResources " + this._associatedXAResources + " in " + this);
        }
        boolean onePhase = false;
        if (this._participants.size() == 1) {
            onePhase = true;
        }
        if (!onePhase) {
            this._status = 7;
            XAParticipant party = null;
            boolean preparedOne = false;
            for (Map.Entry<XAResource, XAParticipant> pair : this._participants.entrySet()) {
                party = pair.getValue();
                try {
                    party.prepare();
                    preparedOne = true;
                }
                catch (IllegalStateException e) {
                    if (!preparedOne) {
                        throw e;
                    }
                    this.setRollbackOnly();
                    this.rollback();
                    RollbackException ex = new RollbackException(this.toString() + ": " + e.getMessage());
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                catch (Throwable t) {
                    this.setRollbackOnly();
                    if (!(t instanceof RollbackException) && !(t instanceof SystemException)) {
                        this._logger.log(Level.SEVERE, "Unexpected exception on prepare from " + party, t);
                    }
                    this.rollback();
                    RollbackException ex = new RollbackException(t.getMessage());
                    ex.initCause(t);
                    throw ex;
                }
            }
            this._status = 2;
        }
        if (this._status == 1) {
            this.rollback();
            throw new RollbackException(this.toString());
        }
        if (!onePhase) {
            try {
                LogRecord lr = new LogRecord(this._gxid, this._participants.values(), 0);
                this._txlog.logGlobalDecision(lr);
            }
            catch (Throwable t) {
                this.setRollbackOnly();
                this._logger.log(Level.SEVERE, "Unable to log commit decision " + this, t);
                this.rollback();
                RollbackException ex = new RollbackException(this.toString() + ": " + t.getMessage());
                ex.initCause(t);
                throw ex;
            }
            this._status = 2;
        }
        this._status = 8;
        Throwable ex = null;
        XAParticipant party = null;
        boolean committedOne = false;
        for (Map.Entry<XAResource, XAParticipant> pair : this._participants.entrySet()) {
            BranchXid bxid;
            LogRecord lr;
            party = pair.getValue();
            try {
                party.commit(onePhase);
                committedOne = true;
            }
            catch (IllegalStateException e) {
                if (!committedOne) {
                    throw e;
                }
                ex = e;
            }
            catch (RollbackException e) {
                if (!onePhase) {
                    this._logger.log(Level.SEVERE, "Unexpected RollbackException on 2-phase commit from " + party, e);
                    ex = new HeuristicMixedException(e.getMessage());
                    ex.initCause(e);
                    continue;
                }
                throw e;
            }
            catch (HeuristicCommitException e) {
                try {
                    lr = new LogRecord(this._gxid, this._participants.values(), 0);
                    bxid = party.getBranchXid();
                    lr.setBranchHeurCommit(bxid);
                    this._txlog.logHeuristicBranch(bxid, lr);
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic commit from " + party, t);
                }
            }
            catch (HeuristicMixedException e) {
                ex = e;
                try {
                    lr = new LogRecord(this._gxid, this._participants.values(), 0);
                    bxid = party.getBranchXid();
                    lr.setBranchHeurMixed(bxid);
                    this._txlog.logHeuristicBranch(bxid, lr);
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic mixed from " + party, t);
                }
            }
            catch (HeuristicRollbackException e) {
                ex = e;
                try {
                    lr = new LogRecord(this._gxid, this._participants.values(), 0);
                    bxid = party.getBranchXid();
                    lr.setBranchHeurRollback(bxid);
                    this._txlog.logHeuristicBranch(bxid, lr);
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic rollback from " + party, t);
                }
            }
            catch (Throwable t) {
                if (!(t instanceof SystemException)) {
                    this._logger.log(Level.SEVERE, "Unexpected exception on commit from " + party, t);
                    ex = new SystemException(t.getMessage());
                    ex.initCause(t);
                    continue;
                }
                ex = (SystemException)t;
            }
        }
        this._status = 3;
        if (ex == null) {
            this._status = 6;
            if (!onePhase) {
                try {
                    this._txlog.remove(this._gxid);
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Exception in removing comitted TM log record " + (Object)((Object)this._gxid), t);
                }
            }
        }
        if (ex != null) {
            if (ex instanceof SystemException) {
                throw (SystemException)ex;
            }
            if (ex instanceof HeuristicMixedException) {
                throw (HeuristicMixedException)ex;
            }
            if (ex instanceof IllegalStateException) {
                throw (IllegalStateException)ex;
            }
            if (ex instanceof HeuristicRollbackException) {
                throw (HeuristicRollbackException)ex;
            }
            SystemException uex = new SystemException(ex.getMessage());
            uex.initCause(ex);
            throw uex;
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this._tm + " dellistResource " + xaRes + " from " + this);
        }
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(this.toString());
        }
        XAParticipant party = this._participants.get(xaRes);
        if (party == null) {
            throw new IllegalStateException("XAResource " + xaRes + " had not associated to " + this);
        }
        int flags = flag;
        if (this._status == 1) {
            flags = 0x20000000;
        }
        try {
            party.end(flags);
            this._associatedXAResources.remove(xaRes);
            return true;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (RollbackException e) {
            this.setRollbackOnly();
            return true;
        }
        catch (Throwable t) {
            this.setRollbackOnly();
            if (t instanceof SystemException) {
                throw (SystemException)t;
            }
            this._logger.log(Level.SEVERE, "Unexpected exception occurred on end from " + party, t);
            SystemException ex = new SystemException(t.getMessage());
            ex.initCause(t);
            throw ex;
        }
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this._tm + " enlistResource " + xaRes + " to " + this);
        }
        if (this._status == 1) {
            throw new RollbackException(this.toString());
        }
        if (this._status != 0) {
            throw new IllegalStateException(this.toString());
        }
        if (this._participants.get(xaRes) != null) {
            throw new IllegalStateException("XAResource " + xaRes + " already enlisted in " + this);
        }
        String rm = null;
        try {
            rm = this._tm.getRM(xaRes);
        }
        catch (Exception e) {
            String emsg = "Enlist XAResource " + xaRes + " failed";
            this._logger.log(Level.SEVERE, emsg, e);
            SystemException ex = new SystemException(emsg);
            ex.initCause((Throwable)e);
            throw ex;
        }
        if (rm == null) {
            this.setRollbackOnly();
            throw new SystemException("No RM is registered for XAResource " + xaRes);
        }
        BranchXid bxid = this._tm.genBranchXid(this._gxid, rm, xaRes.getClass().getName(), this.getBranchCount());
        if (this._seenBranchXids.contains((Object)bxid)) {
            throw new SystemException("Unexpected duplicated branch " + (Object)((Object)bxid) + " for RM " + rm + " in " + (Object)((Object)this._gxid));
        }
        this._seenBranchXids.add(bxid);
        XAParticipant party = new XAParticipant(rm, xaRes, bxid);
        party.setLogger(this._logger);
        this._participants.put(xaRes, party);
        this._associatedXAResources.add(xaRes);
        try {
            party.start(0);
            return true;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable t) {
            this.setRollbackOnly();
            if (t instanceof RollbackException) {
                throw (RollbackException)t;
            }
            if (t instanceof SystemException) {
                throw (SystemException)t;
            }
            this._logger.log(Level.SEVERE, "Unexpected exception occurred on start from " + party, t);
            SystemException ex = new SystemException(t.getMessage());
            ex.initCause(t);
            throw ex;
        }
    }

    private synchronized byte getBranchCount() throws SystemException {
        this._branchCount = (byte)(this._branchCount + 1);
        if (this._branchCount > this._maxBranches) {
            throw new SystemException("Number of branches " + this._branchCount + " exceeded max " + this._maxBranches);
        }
        return this._branchCount;
    }

    public int getStatus() throws SystemException {
        return this._status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        throw new SystemException("operation not supported");
    }

    public void rollback() throws IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, this._tm + " rollback " + this);
        }
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(this.toString());
        }
        if (this._associatedXAResources.size() > 0) {
            XAResource[] xars = this._associatedXAResources.toArray(new XAResource[0]);
            for (int i = 0; i < xars.length; ++i) {
                try {
                    this.delistResource(xars[i], 0x20000000);
                    continue;
                }
                catch (IllegalStateException e) {
                    throw e;
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to delist resource " + xars[i] + " for rollback", t);
                }
            }
        }
        this._status = 9;
        Throwable ex = null;
        XAParticipant party = null;
        boolean rolledbackOne = false;
        for (Map.Entry<XAResource, XAParticipant> pair : this._participants.entrySet()) {
            BranchXid bxid;
            LogRecord lr;
            party = pair.getValue();
            try {
                party.rollback();
                rolledbackOne = true;
            }
            catch (IllegalStateException e) {
                if (!rolledbackOne) {
                    throw e;
                }
                ex = new SystemException(e.getMessage());
                ex.initCause(e);
            }
            catch (HeuristicCommitException e) {
                ex = e;
                try {
                    lr = new LogRecord(this._gxid, this._participants.values(), 1);
                    bxid = party.getBranchXid();
                    lr.setBranchHeurCommit(bxid);
                    this._txlog.logHeuristicBranch(bxid, lr);
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic commit from " + party, t);
                }
            }
            catch (HeuristicRollbackException e) {
                try {
                    lr = new LogRecord(this._gxid, this._participants.values(), 1);
                    bxid = party.getBranchXid();
                    lr.setBranchHeurRollback(bxid);
                    this._txlog.logHeuristicBranch(bxid, lr);
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic rollback from " + party, t);
                }
            }
            catch (HeuristicMixedException e) {
                ex = e;
                try {
                    lr = new LogRecord(this._gxid, this._participants.values(), 1);
                    bxid = party.getBranchXid();
                    lr.setBranchHeurMixed(bxid);
                    this._txlog.logHeuristicBranch(bxid, lr);
                }
                catch (Throwable t) {
                    this._logger.log(Level.WARNING, "Unable to log heuristic mixed from " + party, t);
                }
            }
            catch (Throwable t) {
                if (!(t instanceof SystemException)) {
                    ex = new SystemException(t.getMessage());
                    ex.initCause(t);
                    continue;
                }
                ex = (SystemException)t;
            }
        }
        this._status = 4;
        if (ex == null) {
            this._status = 6;
        }
        if (ex != null) {
            if (ex instanceof SystemException) {
                throw (SystemException)ex;
            }
            if (ex instanceof IllegalStateException) {
                throw (IllegalStateException)ex;
            }
            SystemException uex = new SystemException(ex.getMessage());
            uex.initCause(ex);
            throw uex;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this._status = 1;
    }

    private String statusString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        return "STATUS_UNKNOWN";
    }

    public boolean equals(Object o) {
        if (!(o instanceof TransactionImpl)) {
            return false;
        }
        TransactionImpl that = (TransactionImpl)o;
        if (this == that) {
            return true;
        }
        return this._gxid.equals((Xid)((Object)that._gxid));
    }

    public int hashCode() {
        return this._gxid.hashCode();
    }

    public String toString() {
        return (Object)((Object)this._gxid) + "[" + this.statusString(this._status) + "]";
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public String getGXidString() {
        return this._gxid.toString();
    }
}

