/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.admin.cli;

import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.api.I18n;
import org.glassfish.resources.api.Resource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

@I18n(value="resources.parser")
public class ResourcesXMLParser
implements EntityResolver {
    private File resourceFile = null;
    private Document document;
    private List<Resource> vResources;
    private Map<Resource, Node> resourceMap = new HashMap<Resource, Node>();
    private boolean isDoctypePresent = false;
    private static StringManager localStrings = StringManager.getManager(ResourcesXMLParser.class);
    private static final int NONCONNECTOR = 2;
    private static final int CONNECTOR = 1;
    private static final Logger _logger = Logger.getLogger(ResourcesXMLParser.class.getName());
    private static final String SUN_RESOURCES = "sun-resources";
    public static final String JAVA_APP_SCOPE_PREFIX = "java:app/";
    public static final String JAVA_COMP_SCOPE_PREFIX = "java:comp/";
    public static final String JAVA_MODULE_SCOPE_PREFIX = "java:module/";
    public static final String JAVA_GLOBAL_SCOPE_PREFIX = "java:global/";
    public static final List<String> namingScopes = Collections.unmodifiableList(Arrays.asList("java:app/", "java:comp/", "java:module/", "java:global/"));
    private static final String publicID_sjsas90 = "Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions";
    private static final String publicID_ges30 = "Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Resource Definitions";
    private static final String publicID_ges31 = "GlassFish.org//DTD GlassFish Application Server 3.1 Resource Definitions";
    private static final String DTD_1_5 = "glassfish-resources_1_5.dtd";
    private static final String DTD_1_4 = "sun-resources_1_4.dtd";
    private static final String DTD_1_3 = "sun-resources_1_3.dtd";
    private static final String DTD_1_2 = "sun-resources_1_2.dtd";
    private static final String DTD_1_1 = "sun-resources_1_1.dtd";
    private static final String DTD_1_0 = "sun-resources_1_0.dtd";
    private static final List<String> systemIDs = Collections.unmodifiableList(Arrays.asList("glassfish-resources_1_5.dtd", "sun-resources_1_4.dtd", "sun-resources_1_3.dtd", "sun-resources_1_2.dtd", "sun-resources_1_1.dtd", "sun-resources_1_0.dtd"));

    public ResourcesXMLParser(File resourceFile) throws Exception {
        this.resourceFile = resourceFile;
        this.initProperties();
        this.vResources = new ArrayList<Resource>();
        String scope = "";
        this.generateResourceObjects(scope);
    }

    public ResourcesXMLParser(File resourceFile, String scope) throws Exception {
        this.resourceFile = resourceFile;
        this.initProperties();
        this.vResources = new ArrayList<Resource>();
        this.generateResourceObjects(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(File to) {
        FileOutputStream out = null;
        try {
            String systemValue = new File(this.document.getDoctype().getSystemId()).getName();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("doctype-system", systemValue);
            out = new FileOutputStream(to);
            transformer.transform(new DOMSource(this.document), new StreamResult(out));
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    _logger.warning(ex.getMessage());
                }
            }
        }
    }

    public void updateDocumentNode(Resource originalResource, Resource modifiedResource) {
        Node resourceNode = this.resourceMap.remove(originalResource);
        while (resourceNode.hasChildNodes()) {
            resourceNode.removeChild(resourceNode.getFirstChild());
        }
        HashMap attrs = modifiedResource.getAttributes();
        for (Map.Entry thisEntry : attrs.entrySet()) {
            ((Element)resourceNode).setAttribute((String)thisEntry.getKey(), (String)thisEntry.getValue());
        }
        Properties props = modifiedResource.getProperties();
        for (String key : props.stringPropertyNames()) {
            String val = props.getProperty(key);
            Element prop = this.document.createElement("property");
            prop.setAttribute("name", key);
            prop.setAttribute("value", val);
            resourceNode.appendChild(prop);
        }
        this.resourceMap.put(modifiedResource, resourceNode);
    }

    public File getResourceFile() {
        return this.resourceFile;
    }

    private void initProperties() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Object bis = null;
        FileInputStream fis = null;
        try {
            AddResourcesErrorHandler errorHandler = new AddResourcesErrorHandler();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this);
            builder.setErrorHandler(errorHandler);
            Object[] args = new Object[]{this.resourceFile};
            if (this.resourceFile == null) {
                String msg = localStrings.getStringWithDefault("resources.parser.no_resource_file", "Resource file ({0} does not exist", args);
                throw new Exception(msg);
            }
            fis = new FileInputStream(this.resourceFile);
            InputSource is = new InputSource(fis);
            this.document = builder.parse(is);
            this.detectDeprecatedDescriptor();
        }
        catch (SAXException sxe) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser sp = spf.newSAXParser();
                sp.setProperty("http://xml.org/sax/properties/lexical-handler", new MyLexicalHandler());
                if (fis != null) {
                    try {
                        fis.close();
                        fis = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                fis = new FileInputStream(this.resourceFile);
                sp.getXMLReader().parse(new InputSource(fis));
            }
            catch (ParserConfigurationException ex) {
            }
            catch (SAXException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (!this.isDoctypePresent) {
                Object[] args = new Object[]{this.resourceFile.toString()};
                throw new Exception(localStrings.getStringWithDefault("resources.parser.doctype_not_present_in_xml", "Error Parsing the xml ({0}), doctype is not present", args));
            }
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            throw new Exception(x.getLocalizedMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new Exception(pce.getLocalizedMessage());
        }
        catch (IOException ioe) {
            throw new Exception(ioe.getLocalizedMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void detectDeprecatedDescriptor() {
        String publicId = this.document.getDoctype().getPublicId();
        String systemId = this.document.getDoctype().getSystemId();
        if (publicId != null && publicId.contains(SUN_RESOURCES) || systemId != null && systemId.contains(SUN_RESOURCES)) {
            String msg = localStrings.getString("deprecated.resources.dtd", (Object)this.resourceFile.getAbsolutePath());
            _logger.log(Level.FINEST, msg);
        }
    }

    private void generateResourceObjects(String scope) throws Exception {
        if (this.document != null) {
            for (Node nextKid = this.document.getDocumentElement().getFirstChild(); nextKid != null; nextKid = nextKid.getNextSibling()) {
                String nodeName = nextKid.getNodeName();
                if (nodeName.equalsIgnoreCase("custom-resource")) {
                    this.generateCustomResource(nextKid, scope);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("external-jndi-resource")) {
                    this.generateJNDIResource(nextKid, scope);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("jdbc-resource")) {
                    this.generateJDBCResource(nextKid, scope);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("jdbc-connection-pool")) {
                    this.generateJDBCConnectionPoolResource(nextKid, scope);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("mail-resource")) {
                    this.generateMailResource(nextKid, scope);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("persistence-manager-factory-resource")) {
                    this.generatePersistenceResource(nextKid);
                    _logger.log(Level.FINEST, "persistence-manager-factory-resource is no more supported , ignoring the resource description");
                    continue;
                }
                if (nodeName.equalsIgnoreCase("admin-object-resource")) {
                    this.generateAdminObjectResource(nextKid, scope);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("connector-resource")) {
                    this.generateConnectorResource(nextKid, scope);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("connector-connection-pool")) {
                    this.generateConnectorConnectionPoolResource(nextKid, scope);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("resource-adapter-config")) {
                    this.generateResourceAdapterConfig(nextKid, scope);
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("work-security-map")) continue;
                this.generateWorkSecurityMap(nextKid, scope);
            }
        }
    }

    private static List<Resource> getResourcesOfType(List<Resource> resources, int type, boolean isResourceCreation, boolean ignoreDuplicates) {
        ArrayList<Resource> nonConnectorResources = new ArrayList<Resource>();
        ArrayList<Resource> connectorResources = new ArrayList<Resource>();
        for (Resource res : resources) {
            if (ResourcesXMLParser.isConnectorResource(res)) {
                if (res.getType().equals("resource-adapter-config")) {
                    if (isResourceCreation) {
                        ResourcesXMLParser.addToList(nonConnectorResources, res, ignoreDuplicates);
                        continue;
                    }
                    ResourcesXMLParser.addToList(connectorResources, res, ignoreDuplicates);
                    continue;
                }
                ResourcesXMLParser.addToList(connectorResources, res, ignoreDuplicates);
                continue;
            }
            ResourcesXMLParser.addToList(nonConnectorResources, res, ignoreDuplicates);
        }
        List<Resource> finalSortedConnectorList = ResourcesXMLParser.sortConnectorResources(connectorResources);
        List<Resource> finalSortedNonConnectorList = ResourcesXMLParser.sortNonConnectorResources(nonConnectorResources);
        if (type == 1) {
            return finalSortedConnectorList;
        }
        return finalSortedNonConnectorList;
    }

    private static void addToList(List<Resource> resources, Resource res, boolean ignoreDuplicates) {
        if (ignoreDuplicates) {
            if (!resources.contains(res)) {
                resources.add(res);
            }
        } else {
            resources.add(res);
        }
    }

    private static List<Resource> sortConnectorResources(List<Resource> connectorResources) {
        ArrayList<Resource> raconfigs = new ArrayList<Resource>();
        ArrayList<Resource> ccps = new ArrayList<Resource>();
        ArrayList<Resource> others = new ArrayList<Resource>();
        ArrayList<Resource> finalSortedConnectorList = new ArrayList<Resource>();
        for (Resource resource : connectorResources) {
            if (resource.getType().equals("resource-adapter-config")) {
                raconfigs.add(resource);
                continue;
            }
            if (resource.getType().equals("connector-connection-pool")) {
                ccps.add(resource);
                continue;
            }
            others.add(resource);
        }
        finalSortedConnectorList.addAll(raconfigs);
        finalSortedConnectorList.addAll(ccps);
        finalSortedConnectorList.addAll(others);
        return finalSortedConnectorList;
    }

    private static List<Resource> sortNonConnectorResources(List<Resource> nonConnectorResources) {
        ArrayList<Resource> jdbccps = new ArrayList<Resource>();
        ArrayList<Resource> pmfs = new ArrayList<Resource>();
        ArrayList<Resource> others = new ArrayList<Resource>();
        ArrayList<Resource> finalSortedNonConnectorList = new ArrayList<Resource>();
        for (Resource resource : nonConnectorResources) {
            if (resource.getType().equals("jdbc-connection-pool")) {
                jdbccps.add(resource);
                continue;
            }
            if (resource.getType().equals("persistence-manager-factory-resource")) {
                pmfs.add(resource);
                continue;
            }
            others.add(resource);
        }
        finalSortedNonConnectorList.addAll(jdbccps);
        finalSortedNonConnectorList.addAll(others);
        finalSortedNonConnectorList.addAll(pmfs);
        return finalSortedNonConnectorList;
    }

    private static boolean isConnectorResource(Resource res) {
        String type = res.getType();
        return type.equals("admin-object-resource") || type.equals("connector-connection-pool") || type.equals("connector-resource") || type.equals("security-map") || type.equals("resource-adapter-config");
    }

    private String getScopedName(String name, String scope) throws Exception {
        if (namingScopes.contains(scope) && name != null) {
            for (String namingScope : namingScopes) {
                Object[] args = new Object[]{name, namingScope, scope};
                if (!name.startsWith(namingScope) || namingScope.equals(scope)) continue;
                String msg = localStrings.getStringWithDefault("invalid.scope.defined.for.resource", "Resource [ {0} ] is not allowed to specify the scope [ {1} ]. Acceptable scope for this resource is [ {2} ]", args);
                throw new IllegalStateException(msg);
            }
            if (!name.startsWith(scope)) {
                name = scope + name;
            }
        }
        return name;
    }

    private void generatePersistenceResource(Node nextKid) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = jndiNameNode.getNodeValue();
        Node factoryClassNode = attributes.getNamedItem("factory-class");
        Node poolNameNode = attributes.getNamedItem("jdbc-resource-jndi-name");
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource persistenceResource = new Resource("persistence-manager-factory-resource");
        persistenceResource.setAttribute("jndi-name", jndiName);
        if (factoryClassNode != null) {
            String factoryClass = factoryClassNode.getNodeValue();
            persistenceResource.setAttribute("factory-class", factoryClass);
        }
        if (poolNameNode != null) {
            String poolName = poolNameNode.getNodeValue();
            persistenceResource.setAttribute("jdbc-resource-jndi-name", poolName);
        }
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            persistenceResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(persistenceResource, children);
        this.vResources.add(persistenceResource);
        this.resourceMap.put(persistenceResource, nextKid);
        this.printResourceElements(persistenceResource);
    }

    private void generateCustomResource(Node nextKid, String scope) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = this.getScopedName(jndiNameNode.getNodeValue(), scope);
        Node resTypeNode = attributes.getNamedItem("res-type");
        String resType = resTypeNode.getNodeValue();
        Node factoryClassNode = attributes.getNamedItem("factory-class");
        String factoryClass = factoryClassNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource customResource = new Resource("custom-resource");
        customResource.setAttribute("jndi-name", jndiName);
        customResource.setAttribute("res-type", resType);
        customResource.setAttribute("factory-class", factoryClass);
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            customResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(customResource, children);
        this.vResources.add(customResource);
        this.resourceMap.put(customResource, nextKid);
        this.printResourceElements(customResource);
    }

    private void generateJNDIResource(Node nextKid, String scope) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = this.getScopedName(jndiNameNode.getNodeValue(), scope);
        Node jndiLookupNode = attributes.getNamedItem("jndi-lookup-name");
        String jndiLookup = jndiLookupNode.getNodeValue();
        Node resTypeNode = attributes.getNamedItem("res-type");
        String resType = resTypeNode.getNodeValue();
        Node factoryClassNode = attributes.getNamedItem("factory-class");
        String factoryClass = factoryClassNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource jndiResource = new Resource("external-jndi-resource");
        jndiResource.setAttribute("jndi-name", jndiName);
        jndiResource.setAttribute("jndi-lookup-name", jndiLookup);
        jndiResource.setAttribute("res-type", resType);
        jndiResource.setAttribute("factory-class", factoryClass);
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            jndiResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(jndiResource, children);
        this.vResources.add(jndiResource);
        this.resourceMap.put(jndiResource, nextKid);
        this.printResourceElements(jndiResource);
    }

    private void generateJDBCResource(Node nextKid, String scope) throws Exception {
        NodeList children;
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = this.getScopedName(jndiNameNode.getNodeValue(), scope);
        Node poolNameNode = attributes.getNamedItem("pool-name");
        String poolName = this.getScopedName(poolNameNode.getNodeValue(), scope);
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource jdbcResource = new Resource("jdbc-resource");
        jdbcResource.setAttribute("jndi-name", jndiName);
        jdbcResource.setAttribute("pool-name", poolName);
        if (enabledNode != null) {
            String enabledName = enabledNode.getNodeValue();
            jdbcResource.setAttribute("enabled", enabledName);
        }
        if ((children = nextKid.getChildNodes()) != null) {
            for (int ii = 0; ii < children.getLength(); ++ii) {
                if (!children.item(ii).getNodeName().equals("description") || children.item(ii).getFirstChild() == null) continue;
                jdbcResource.setDescription(children.item(ii).getFirstChild().getNodeValue());
            }
        }
        this.vResources.add(jdbcResource);
        this.resourceMap.put(jdbcResource, nextKid);
        this.printResourceElements(jdbcResource);
    }

    private void generateJDBCConnectionPoolResource(Node nextKid, String scope) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        String name = this.getScopedName(nameNode.getNodeValue(), scope);
        Node nSteadyPoolSizeNode = attributes.getNamedItem("steady-pool-size");
        Node nMaxPoolSizeNode = attributes.getNamedItem("max-pool-size");
        Node nMaxWaitTimeInMillisNode = attributes.getNamedItem("max-wait-time-in-millis");
        Node nPoolSizeQuantityNode = attributes.getNamedItem("pool-resize-quantity");
        Node nIdleTimeoutInSecNode = attributes.getNamedItem("idle-timeout-in-seconds");
        Node nIsConnectionValidationRequiredNode = attributes.getNamedItem("is-connection-validation-required");
        Node nConnectionValidationMethodNode = attributes.getNamedItem("connection-validation-method");
        Node nFailAllConnectionsNode = attributes.getNamedItem("fail-all-connections");
        Node nValidationTableNameNode = attributes.getNamedItem("validation-table-name");
        Node nResType = attributes.getNamedItem("res-type");
        Node nTransIsolationLevel = attributes.getNamedItem("transaction-isolation-level");
        Node nIsIsolationLevelQuaranteed = attributes.getNamedItem("is-isolation-level-guaranteed");
        Node datasourceNode = attributes.getNamedItem("datasource-classname");
        Node nonTransactionalConnectionsNode = attributes.getNamedItem("non-transactional-connections");
        Node allowNonComponentCallersNode = attributes.getNamedItem("allow-non-component-callers");
        Node validateAtmostOncePeriodNode = attributes.getNamedItem("validate-atmost-once-period-in-seconds");
        Node connectionLeakTimeoutNode = attributes.getNamedItem("connection-leak-timeout-in-seconds");
        Node connectionLeakReclaimNode = attributes.getNamedItem("connection-leak-reclaim");
        Node connectionCreationRetryAttemptsNode = attributes.getNamedItem("connection-creation-retry-attempts");
        Node connectionCreationRetryIntervalNode = attributes.getNamedItem("connection-creation-retry-interval-in-seconds");
        Node statementTimeoutNode = attributes.getNamedItem("statement-timeout-in-seconds");
        Node lazyConnectionEnlistmentNode = attributes.getNamedItem("lazy-connection-enlistment");
        Node lazyConnectionAssociationNode = attributes.getNamedItem("lazy-connection-association");
        Node associateWithThreadNode = attributes.getNamedItem("associate-with-thread");
        Node matchConnectionsNode = attributes.getNamedItem("match-connections");
        Node maxConnectionUsageCountNode = attributes.getNamedItem("max-connection-usage-count");
        Node wrapJDBCObjectsNode = attributes.getNamedItem("wrap-jdbc-objects");
        Node poolingNode = attributes.getNamedItem("pooling");
        Node pingNode = attributes.getNamedItem("ping");
        Node customValidationNode = attributes.getNamedItem("custom-validation");
        Node driverClassNameNode = attributes.getNamedItem("driver-classname");
        Node initSqlNode = attributes.getNamedItem("init-sql");
        Node sqlTraceListenersNode = attributes.getNamedItem("sql-trace-listeners");
        Node statementCacheSizeNode = attributes.getNamedItem("statement-cache-size");
        Node statementLeakTimeoutNode = attributes.getNamedItem("statement-leak-timeout-in-seconds");
        Node statementLeakReclaimNode = attributes.getNamedItem("statement-leak-reclaim");
        Resource jdbcConnPool = new Resource("jdbc-connection-pool");
        jdbcConnPool.setAttribute("name", name);
        if (datasourceNode != null) {
            String datasource = datasourceNode.getNodeValue();
            jdbcConnPool.setAttribute("datasource-classname", datasource);
        }
        if (nSteadyPoolSizeNode != null) {
            String sSteadyPoolSize = nSteadyPoolSizeNode.getNodeValue();
            jdbcConnPool.setAttribute("steady-pool-size", sSteadyPoolSize);
        }
        if (nMaxPoolSizeNode != null) {
            String sMaxPoolSize = nMaxPoolSizeNode.getNodeValue();
            jdbcConnPool.setAttribute("max-pool-size", sMaxPoolSize);
        }
        if (nMaxWaitTimeInMillisNode != null) {
            String sMaxWaitTimeInMillis = nMaxWaitTimeInMillisNode.getNodeValue();
            jdbcConnPool.setAttribute("max-wait-time-in-millis", sMaxWaitTimeInMillis);
        }
        if (nPoolSizeQuantityNode != null) {
            String sPoolSizeQuantity = nPoolSizeQuantityNode.getNodeValue();
            jdbcConnPool.setAttribute("pool-resize-quantity", sPoolSizeQuantity);
        }
        if (nIdleTimeoutInSecNode != null) {
            String sIdleTimeoutInSec = nIdleTimeoutInSecNode.getNodeValue();
            jdbcConnPool.setAttribute("idle-timeout-in-seconds", sIdleTimeoutInSec);
        }
        if (nIsConnectionValidationRequiredNode != null) {
            String sIsConnectionValidationRequired = nIsConnectionValidationRequiredNode.getNodeValue();
            jdbcConnPool.setAttribute("is-connection-validation-required", sIsConnectionValidationRequired);
        }
        if (nConnectionValidationMethodNode != null) {
            String sConnectionValidationMethod = nConnectionValidationMethodNode.getNodeValue();
            jdbcConnPool.setAttribute("connection-validation-method", sConnectionValidationMethod);
        }
        if (nFailAllConnectionsNode != null) {
            String sFailAllConnection = nFailAllConnectionsNode.getNodeValue();
            jdbcConnPool.setAttribute("fail-all-connections", sFailAllConnection);
        }
        if (nValidationTableNameNode != null) {
            String sValidationTableName = nValidationTableNameNode.getNodeValue();
            jdbcConnPool.setAttribute("validation-table-name", sValidationTableName);
        }
        if (nResType != null) {
            String sResType = nResType.getNodeValue();
            jdbcConnPool.setAttribute("res-type", sResType);
        }
        if (nTransIsolationLevel != null) {
            String sTransIsolationLevel = nTransIsolationLevel.getNodeValue();
            jdbcConnPool.setAttribute("transaction-isolation-level", sTransIsolationLevel);
        }
        if (nIsIsolationLevelQuaranteed != null) {
            String sIsIsolationLevelQuaranteed = nIsIsolationLevelQuaranteed.getNodeValue();
            jdbcConnPool.setAttribute("is-isolation-level-guaranteed", sIsIsolationLevelQuaranteed);
        }
        if (nonTransactionalConnectionsNode != null) {
            jdbcConnPool.setAttribute("non-transactional-connections", nonTransactionalConnectionsNode.getNodeValue());
        }
        if (allowNonComponentCallersNode != null) {
            jdbcConnPool.setAttribute("allow-non-component-callers", allowNonComponentCallersNode.getNodeValue());
        }
        if (validateAtmostOncePeriodNode != null) {
            jdbcConnPool.setAttribute("validate-atmost-once-period-in-seconds", validateAtmostOncePeriodNode.getNodeValue());
        }
        if (connectionLeakTimeoutNode != null) {
            jdbcConnPool.setAttribute("connection-leak-timeout-in-seconds", connectionLeakTimeoutNode.getNodeValue());
        }
        if (connectionLeakReclaimNode != null) {
            jdbcConnPool.setAttribute("connection-leak-reclaim", connectionLeakReclaimNode.getNodeValue());
        }
        if (connectionCreationRetryAttemptsNode != null) {
            jdbcConnPool.setAttribute("connection-creation-retry-attempts", connectionCreationRetryAttemptsNode.getNodeValue());
        }
        if (connectionCreationRetryIntervalNode != null) {
            jdbcConnPool.setAttribute("connection-creation-retry-interval-in-seconds", connectionCreationRetryIntervalNode.getNodeValue());
        }
        if (statementTimeoutNode != null) {
            jdbcConnPool.setAttribute("statement-timeout-in-seconds", statementTimeoutNode.getNodeValue());
        }
        if (lazyConnectionEnlistmentNode != null) {
            jdbcConnPool.setAttribute("lazy-connection-enlistment", lazyConnectionEnlistmentNode.getNodeValue());
        }
        if (lazyConnectionAssociationNode != null) {
            jdbcConnPool.setAttribute("lazy-connection-association", lazyConnectionAssociationNode.getNodeValue());
        }
        if (associateWithThreadNode != null) {
            jdbcConnPool.setAttribute("associate-with-thread", associateWithThreadNode.getNodeValue());
        }
        if (matchConnectionsNode != null) {
            jdbcConnPool.setAttribute("match-connections", matchConnectionsNode.getNodeValue());
        }
        if (maxConnectionUsageCountNode != null) {
            jdbcConnPool.setAttribute("max-connection-usage-count", maxConnectionUsageCountNode.getNodeValue());
        }
        if (wrapJDBCObjectsNode != null) {
            jdbcConnPool.setAttribute("wrap-jdbc-objects", wrapJDBCObjectsNode.getNodeValue());
        }
        if (poolingNode != null) {
            String pooling = poolingNode.getNodeValue();
            jdbcConnPool.setAttribute("pooling", pooling);
        }
        if (pingNode != null) {
            String ping = pingNode.getNodeValue();
            jdbcConnPool.setAttribute("ping", ping);
        }
        if (initSqlNode != null) {
            String initSQL = initSqlNode.getNodeValue();
            jdbcConnPool.setAttribute("init-sql", initSQL);
        }
        if (sqlTraceListenersNode != null) {
            String sqlTraceListeners = sqlTraceListenersNode.getNodeValue();
            jdbcConnPool.setAttribute("sql-trace-listeners", sqlTraceListeners);
        }
        if (customValidationNode != null) {
            String customValidation = customValidationNode.getNodeValue();
            jdbcConnPool.setAttribute("custom-validation", customValidation);
        }
        if (driverClassNameNode != null) {
            String driverClassName = driverClassNameNode.getNodeValue();
            jdbcConnPool.setAttribute("driver-classname", driverClassName);
        }
        if (statementCacheSizeNode != null) {
            String statementCacheSize = statementCacheSizeNode.getNodeValue();
            jdbcConnPool.setAttribute("statement-cache-size", statementCacheSize);
        }
        if (statementLeakTimeoutNode != null) {
            jdbcConnPool.setAttribute("statement-leak-timeout-in-seconds", statementLeakTimeoutNode.getNodeValue());
        }
        if (statementLeakReclaimNode != null) {
            jdbcConnPool.setAttribute("statement-leak-reclaim", statementLeakReclaimNode.getNodeValue());
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(jdbcConnPool, children);
        this.vResources.add(jdbcConnPool);
        this.resourceMap.put(jdbcConnPool, nextKid);
        this.printResourceElements(jdbcConnPool);
    }

    private void generateMailResource(Node nextKid, String scope) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        Node hostNode = attributes.getNamedItem("host");
        Node userNode = attributes.getNamedItem("user");
        Node fromAddressNode = attributes.getNamedItem("from");
        Node storeProtoNode = attributes.getNamedItem("store-protocol");
        Node storeProtoClassNode = attributes.getNamedItem("store-protocol-class");
        Node transProtoNode = attributes.getNamedItem("transport-protocol");
        Node transProtoClassNode = attributes.getNamedItem("transport-protocol-class");
        Node debugNode = attributes.getNamedItem("debug");
        Node enabledNode = attributes.getNamedItem("enabled");
        String jndiName = this.getScopedName(jndiNameNode.getNodeValue(), scope);
        String host = hostNode.getNodeValue();
        String user = userNode.getNodeValue();
        String fromAddress = fromAddressNode.getNodeValue();
        Resource mailResource = new Resource("mail-resource");
        mailResource.setAttribute("jndi-name", jndiName);
        mailResource.setAttribute("host", host);
        mailResource.setAttribute("user", user);
        mailResource.setAttribute("from", fromAddress);
        if (storeProtoNode != null) {
            String sStoreProto = storeProtoNode.getNodeValue();
            mailResource.setAttribute("store-protocol", sStoreProto);
        }
        if (storeProtoClassNode != null) {
            String sStoreProtoClass = storeProtoClassNode.getNodeValue();
            mailResource.setAttribute("store-protocol-class", sStoreProtoClass);
        }
        if (transProtoNode != null) {
            String sTransProto = transProtoNode.getNodeValue();
            mailResource.setAttribute("transport-protocol", sTransProto);
        }
        if (transProtoClassNode != null) {
            String sTransProtoClass = transProtoClassNode.getNodeValue();
            mailResource.setAttribute("transport-protocol-class", sTransProtoClass);
        }
        if (debugNode != null) {
            String sDebug = debugNode.getNodeValue();
            mailResource.setAttribute("debug", sDebug);
        }
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            mailResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(mailResource, children);
        this.vResources.add(mailResource);
        this.resourceMap.put(mailResource, nextKid);
        this.printResourceElements(mailResource);
    }

    private void generateAdminObjectResource(Node nextKid, String scope) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = this.getScopedName(jndiNameNode.getNodeValue(), scope);
        Node resTypeNode = attributes.getNamedItem("res-type");
        String resType = resTypeNode.getNodeValue();
        Node classNameNode = attributes.getNamedItem("class-name");
        String className = null;
        if (classNameNode != null) {
            className = classNameNode.getNodeValue();
        }
        Node resAdapterNode = attributes.getNamedItem("res-adapter");
        String resAdapter = resAdapterNode.getNodeValue();
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource adminObjectResource = new Resource("admin-object-resource");
        adminObjectResource.setAttribute("jndi-name", jndiName);
        adminObjectResource.setAttribute("res-type", resType);
        if (classNameNode != null) {
            adminObjectResource.setAttribute("class-name", className);
        }
        adminObjectResource.setAttribute("res-adapter", resAdapter);
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            adminObjectResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(adminObjectResource, children);
        this.vResources.add(adminObjectResource);
        this.resourceMap.put(adminObjectResource, nextKid);
        this.printResourceElements(adminObjectResource);
    }

    private void generateConnectorResource(Node nextKid, String scope) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node jndiNameNode = attributes.getNamedItem("jndi-name");
        String jndiName = this.getScopedName(jndiNameNode.getNodeValue(), scope);
        Node poolNameNode = attributes.getNamedItem("pool-name");
        String poolName = this.getScopedName(poolNameNode.getNodeValue(), scope);
        Node resTypeNode = attributes.getNamedItem("resource-type");
        Node enabledNode = attributes.getNamedItem("enabled");
        Resource connectorResource = new Resource("connector-resource");
        connectorResource.setAttribute("jndi-name", jndiName);
        connectorResource.setAttribute("pool-name", poolName);
        if (resTypeNode != null) {
            String resType = resTypeNode.getNodeValue();
            connectorResource.setAttribute("resource-type", resType);
        }
        if (enabledNode != null) {
            String sEnabled = enabledNode.getNodeValue();
            connectorResource.setAttribute("enabled", sEnabled);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(connectorResource, children);
        this.vResources.add(connectorResource);
        this.resourceMap.put(connectorResource, nextKid);
        this.printResourceElements(connectorResource);
    }

    private void generatePropertyElement(Resource rs, NodeList children) throws Exception {
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node descNode;
                if (children.item(i).getNodeName().equals("property")) {
                    NamedNodeMap attNodeMap = children.item(i).getAttributes();
                    Node nameNode = attNodeMap.getNamedItem("name");
                    Node valueNode = attNodeMap.getNamedItem("value");
                    if (nameNode != null && valueNode != null) {
                        boolean bDescFound = false;
                        String sName = nameNode.getNodeValue();
                        String sValue = valueNode.getNodeValue();
                        for (Node descNode2 = children.item(i).getFirstChild(); descNode2 != null && !bDescFound; descNode2 = descNode2.getNextSibling()) {
                            if (!descNode2.getNodeName().equalsIgnoreCase("description")) continue;
                            try {
                                rs.setProperty(sName, sValue);
                                bDescFound = true;
                                continue;
                            }
                            catch (DOMException dome) {
                                throw new Exception(dome.getLocalizedMessage());
                            }
                        }
                        if (!bDescFound) {
                            rs.setProperty(sName, sValue);
                        }
                    }
                }
                if (!children.item(i).getNodeName().equals("description") || (descNode = children.item(i).getFirstChild()) == null) continue;
                rs.setDescription(descNode.getNodeValue());
            }
        }
    }

    private void generateConnectorConnectionPoolResource(Node nextKid, String scope) throws Exception {
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        Node raConfigNode = attributes.getNamedItem("resource-adapter-name");
        Node conDefNode = attributes.getNamedItem("connection-definition-name");
        Node steadyPoolSizeNode = attributes.getNamedItem("steady-pool-size");
        Node maxPoolSizeNode = attributes.getNamedItem("max-pool-size");
        Node poolResizeNode = attributes.getNamedItem("pool-resize-quantity");
        Node idleTimeOutNode = attributes.getNamedItem("idle-timeout-in-seconds");
        Node failAllConnNode = attributes.getNamedItem("fail-all-connections");
        Node maxWaitTimeMillisNode = attributes.getNamedItem("max-wait-time-in-millis");
        Node transactionSupportNode = attributes.getNamedItem("transaction-support");
        Node connValidationReqdNode = attributes.getNamedItem("is-connection-validation-required");
        Node validateAtmostOncePeriodNode = attributes.getNamedItem("validate-atmost-once-period-in-seconds");
        Node connLeakTimeoutNode = attributes.getNamedItem("connection-leak-timeout-in-seconds");
        Node connLeakReclaimNode = attributes.getNamedItem("connection-leak-reclaim");
        Node connCreationRetryAttemptsNode = attributes.getNamedItem("connection-creation-retry-attempts");
        Node connCreationRetryIntervalNode = attributes.getNamedItem("connection-creation-retry-interval-in-seconds");
        Node lazyConnEnlistmentNode = attributes.getNamedItem("lazy-connection-enlistment");
        Node lazyConnAssociationNode = attributes.getNamedItem("lazy-connection-association");
        Node associateWithThreadNode = attributes.getNamedItem("associate-with-thread");
        Node matchConnectionsNode = attributes.getNamedItem("match-connections");
        Node maxConnUsageCountNode = attributes.getNamedItem("max-connection-usage-count");
        Node poolingNode = attributes.getNamedItem("pooling");
        Node pingNode = attributes.getNamedItem("ping");
        String poolName = null;
        Resource connectorConnPoolResource = new Resource("connector-connection-pool");
        if (nameNode != null) {
            poolName = this.getScopedName(nameNode.getNodeValue(), scope);
            connectorConnPoolResource.setAttribute("name", poolName);
        }
        if (raConfigNode != null) {
            String raConfig = raConfigNode.getNodeValue();
            connectorConnPoolResource.setAttribute("resource-adapter-name", raConfig);
        }
        if (conDefNode != null) {
            String conDef = conDefNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-definition-name", conDef);
        }
        if (steadyPoolSizeNode != null) {
            String steadyPoolSize = steadyPoolSizeNode.getNodeValue();
            connectorConnPoolResource.setAttribute("steady-pool-size", steadyPoolSize);
        }
        if (maxPoolSizeNode != null) {
            String maxPoolSize = maxPoolSizeNode.getNodeValue();
            connectorConnPoolResource.setAttribute("max-pool-size", maxPoolSize);
        }
        if (poolResizeNode != null) {
            String poolResize = poolResizeNode.getNodeValue();
            connectorConnPoolResource.setAttribute("pool-resize-quantity", poolResize);
        }
        if (idleTimeOutNode != null) {
            String idleTimeOut = idleTimeOutNode.getNodeValue();
            connectorConnPoolResource.setAttribute("idle-timeout-in-seconds", idleTimeOut);
        }
        if (failAllConnNode != null) {
            String failAllConn = failAllConnNode.getNodeValue();
            connectorConnPoolResource.setAttribute("fail-all-connections", failAllConn);
        }
        if (maxWaitTimeMillisNode != null) {
            String maxWaitTimeMillis = maxWaitTimeMillisNode.getNodeValue();
            connectorConnPoolResource.setAttribute("max-wait-time-in-millis", maxWaitTimeMillis);
        }
        if (transactionSupportNode != null) {
            String transactionSupport = transactionSupportNode.getNodeValue();
            connectorConnPoolResource.setAttribute("transaction-support", transactionSupport);
        }
        if (connValidationReqdNode != null) {
            String connValidationReqd = connValidationReqdNode.getNodeValue();
            connectorConnPoolResource.setAttribute("is-connection-validation-required", connValidationReqd);
        }
        if (validateAtmostOncePeriodNode != null) {
            String validateAtmostOncePeriod = validateAtmostOncePeriodNode.getNodeValue();
            connectorConnPoolResource.setAttribute("validate-atmost-once-period-in-seconds", validateAtmostOncePeriod);
        }
        if (connLeakTimeoutNode != null) {
            String connLeakTimeout = connLeakTimeoutNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-leak-timeout-in-seconds", connLeakTimeout);
        }
        if (connLeakReclaimNode != null) {
            String connLeakReclaim = connLeakReclaimNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-leak-reclaim", connLeakReclaim);
        }
        if (connCreationRetryAttemptsNode != null) {
            String connCreationRetryAttempts = connCreationRetryAttemptsNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-creation-retry-attempts", connCreationRetryAttempts);
        }
        if (connCreationRetryIntervalNode != null) {
            String connCreationRetryInterval = connCreationRetryIntervalNode.getNodeValue();
            connectorConnPoolResource.setAttribute("connection-creation-retry-interval-in-seconds", connCreationRetryInterval);
        }
        if (lazyConnEnlistmentNode != null) {
            String lazyConnEnlistment = lazyConnEnlistmentNode.getNodeValue();
            connectorConnPoolResource.setAttribute("lazy-connection-enlistment", lazyConnEnlistment);
        }
        if (lazyConnAssociationNode != null) {
            String lazyConnAssociation = lazyConnAssociationNode.getNodeValue();
            connectorConnPoolResource.setAttribute("lazy-connection-association", lazyConnAssociation);
        }
        if (associateWithThreadNode != null) {
            String associateWithThread = associateWithThreadNode.getNodeValue();
            connectorConnPoolResource.setAttribute("associate-with-thread", associateWithThread);
        }
        if (matchConnectionsNode != null) {
            String matchConnections = matchConnectionsNode.getNodeValue();
            connectorConnPoolResource.setAttribute("match-connections", matchConnections);
        }
        if (maxConnUsageCountNode != null) {
            String maxConnUsageCount = maxConnUsageCountNode.getNodeValue();
            connectorConnPoolResource.setAttribute("max-connection-usage-count", maxConnUsageCount);
        }
        if (poolingNode != null) {
            String pooling = poolingNode.getNodeValue();
            connectorConnPoolResource.setAttribute("pooling", pooling);
        }
        if (pingNode != null) {
            String ping = pingNode.getNodeValue();
            connectorConnPoolResource.setAttribute("ping", ping);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(connectorConnPoolResource, children);
        this.vResources.add(connectorConnPoolResource);
        this.resourceMap.put(connectorConnPoolResource, nextKid);
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (!children.item(i).getNodeName().equals("security-map")) continue;
                this.generateSecurityMap(poolName, children.item(i), scope);
            }
        }
        this.printResourceElements(connectorConnPoolResource);
    }

    private void generateWorkSecurityMap(Node node, String scope) throws Exception {
        NodeList children;
        Node raNameNode;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        Resource workSecurityMapResource = new Resource("work-security-map");
        if (nameNode != null) {
            String name = nameNode.getNodeValue();
            workSecurityMapResource.setAttribute("name", name);
        }
        if ((raNameNode = attributes.getNamedItem("resource-adapter-name")) != null) {
            workSecurityMapResource.setAttribute("resource-adapter-name", raNameNode.getNodeValue());
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                NamedNodeMap childAttributes;
                Node child = children.item(i);
                String nodeName = child.getNodeName();
                if (nodeName.equals("group-map")) {
                    Properties groupMaps = new Properties();
                    childAttributes = child.getAttributes();
                    if (childAttributes == null) continue;
                    Node eisGroup = childAttributes.getNamedItem("eis-group");
                    Node mappedGroup = childAttributes.getNamedItem("mapped-group");
                    if (eisGroup != null && mappedGroup != null) {
                        String eisGroupValue = eisGroup.getNodeValue();
                        String serverGroupValue = mappedGroup.getNodeValue();
                        if (eisGroupValue != null && serverGroupValue != null) {
                            groupMaps.put(eisGroupValue, serverGroupValue);
                        }
                    }
                    workSecurityMapResource.setAttribute("group-map", groupMaps);
                    continue;
                }
                if (!nodeName.equals("principal-map")) continue;
                Properties principalMaps = new Properties();
                childAttributes = child.getAttributes();
                if (childAttributes == null) continue;
                Node eisPrincipal = childAttributes.getNamedItem("eis-principal");
                Node mappedPrincipal = childAttributes.getNamedItem("mapped-principal");
                if (eisPrincipal != null && mappedPrincipal != null) {
                    String eisPrincipalValue = eisPrincipal.getNodeValue();
                    String serverPrincipalValue = mappedPrincipal.getNodeValue();
                    if (eisPrincipalValue != null && serverPrincipalValue != null) {
                        principalMaps.put(eisPrincipalValue, serverPrincipalValue);
                    }
                }
                workSecurityMapResource.setAttribute("principal-map", principalMaps);
            }
        }
        this.vResources.add(workSecurityMapResource);
        this.resourceMap.put(workSecurityMapResource, node);
        this.printResourceElements(workSecurityMapResource);
    }

    private void generateSecurityMap(String poolName, Node mapNode, String scope) throws Exception {
        NamedNodeMap attributes = mapNode.getAttributes();
        if (attributes == null) {
            return;
        }
        Node nameNode = attributes.getNamedItem("name");
        Resource map = new Resource("security-map");
        if (nameNode != null) {
            String name = nameNode.getNodeValue();
            map.setAttribute("name", name);
        }
        if (poolName != null) {
            map.setAttribute("pool-name", poolName);
        }
        StringBuffer principal = new StringBuffer();
        StringBuffer usergroup = new StringBuffer();
        NodeList children = mapNode.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node passwordNode;
                NamedNodeMap attributes1;
                Node gChild = children.item(i);
                String strNodeName = gChild.getNodeName();
                if (strNodeName.equals("principal")) {
                    String p = gChild.getFirstChild().getNodeValue();
                    principal.append(p).append(",");
                }
                if (strNodeName.equals("user-group")) {
                    String u = gChild.getFirstChild().getNodeValue();
                    usergroup.append(u).append(",");
                }
                if (!strNodeName.equals("backend-principal") || (attributes1 = children.item(i).getAttributes()) == null) continue;
                Node userNode = attributes1.getNamedItem("user-name");
                if (userNode != null) {
                    String userName = userNode.getNodeValue();
                    map.setAttribute("user-name", userName);
                }
                if ((passwordNode = attributes1.getNamedItem("password")) == null) continue;
                String pwd = passwordNode.getNodeValue();
                map.setAttribute("password", pwd);
            }
        }
        map.setAttribute("principal", this.convertToStringArray(principal.toString()));
        map.setAttribute("user_group", this.convertToStringArray(usergroup.toString()));
        this.vResources.add(map);
        this.resourceMap.put(map, mapNode);
    }

    private void generateResourceAdapterConfig(Node nextKid, String scope) throws Exception {
        Node resAdapNameNode;
        Node poolIdNode;
        NamedNodeMap attributes = nextKid.getAttributes();
        if (attributes == null) {
            return;
        }
        Resource resAdapterConfigResource = new Resource("resource-adapter-config");
        Node resAdapConfigNode = attributes.getNamedItem("resource-adapter-config");
        if (resAdapConfigNode != null) {
            String resAdapConfig = resAdapConfigNode.getNodeValue();
            resAdapterConfigResource.setAttribute("resource-adapter-config", resAdapConfig);
        }
        if ((poolIdNode = attributes.getNamedItem("thread-pool-ids")) != null) {
            String threadPoolId = poolIdNode.getNodeValue();
            resAdapterConfigResource.setAttribute("thread-pool-ids", threadPoolId);
        }
        if ((resAdapNameNode = attributes.getNamedItem("resource-adapter-name")) != null) {
            String resAdapName = resAdapNameNode.getNodeValue();
            resAdapterConfigResource.setAttribute("resource-adapter-name", resAdapName);
        }
        NodeList children = nextKid.getChildNodes();
        this.generatePropertyElement(resAdapterConfigResource, children);
        this.vResources.add(resAdapterConfigResource);
        this.resourceMap.put(resAdapterConfigResource, nextKid);
        this.printResourceElements(resAdapterConfigResource);
    }

    public Iterator<Resource> getResources() {
        return this.vResources.iterator();
    }

    public List<Resource> getResourcesList() {
        return this.vResources;
    }

    public static List getNonConnectorResourcesList(List<Resource> resources, boolean isResourceCreation, boolean ignoreDuplicates) {
        return ResourcesXMLParser.getResourcesOfType(resources, 2, isResourceCreation, ignoreDuplicates);
    }

    public static List getConnectorResourcesList(List<Resource> resources, boolean isResourceCreation, boolean ignoreDuplicates) {
        return ResourcesXMLParser.getResourcesOfType(resources, 1, isResourceCreation, ignoreDuplicates);
    }

    private void printResourceElements(Resource resource) {
        HashMap attrList = resource.getAttributes();
        for (String attrName : attrList.keySet()) {
            Logger.getLogger(ResourcesXMLParser.class.getName()).log(Level.FINE, "Name of the attribute:[{0}]", attrName);
        }
    }

    private String[] convertToStringArray(Object sOptions) {
        StringTokenizer optionTokenizer = new StringTokenizer((String)sOptions, ",");
        int size = optionTokenizer.countTokens();
        String[] sOptionsList = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            sOptionsList[ii] = optionTokenizer.nextToken();
        }
        return sOptionsList;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource is = null;
        String dtdFileName = DTD_1_5;
        boolean foundMatchingDTD = false;
        if (systemId != null) {
            for (int i = 0; i < systemIDs.size(); ++i) {
                if (!systemId.contains(systemIDs.get(i))) continue;
                dtdFileName = systemIDs.get(i);
                foundMatchingDTD = true;
                break;
            }
        }
        if (!foundMatchingDTD && publicId != null) {
            if (publicId.contains(publicID_sjsas90)) {
                dtdFileName = DTD_1_3;
            } else if (publicId.contains(publicID_ges30)) {
                dtdFileName = DTD_1_4;
            } else if (publicId.contains(publicID_ges31)) {
                dtdFileName = DTD_1_5;
            }
        }
        try {
            File f;
            String dtd = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "dtds" + File.separator + dtdFileName;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("using DTD [ " + dtd + " ]");
            }
            if ((f = new File(dtd)).exists()) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("DTD [" + dtd + "] exists");
                }
                is = new InputSource(new FileInputStream(dtd));
            } else {
                URL url;
                InputStream stream;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("No DTD [" + dtd + "] found, trying the enclosing jar (uber jar)");
                }
                InputStream inputStream = stream = (url = this.getClass().getResource("/dtds/" + dtdFileName)) != null ? url.openStream() : null;
                if (stream != null) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("DTD [" + dtdFileName + "] found in enclosing jar");
                    }
                    is = new InputSource(stream);
                    is.setSystemId(url.toString());
                } else if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("DTD [" + dtdFileName + " ] not found in installation, public URL might resolve it");
                }
            }
        }
        catch (Exception e) {
            throw new SAXException("cannot resolve dtd", e);
        }
        return is;
    }

    static final class AddResourcesErrorHandler
    implements ErrorHandler {
        AddResourcesErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    class MyLexicalHandler
    implements LexicalHandler {
        MyLexicalHandler() {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            ResourcesXMLParser.this.isDoctypePresent = true;
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }
}

