/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import com.ibm.jbatch.spi.TaggedJobExecution;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.batch.AbstractListCommand;
import org.glassfish.batch.AbstractLongListCommand;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_ListBatchJobExecutions")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="_ListBatchJobExecutions")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_ListBatchJobExecutions", description="_List Batch Job Executions")})
public class ListBatchJobExecutions
extends AbstractLongListCommand {
    private static final String JOB_NAME = "jobName";
    private static final String EXECUTION_ID = "executionId";
    private static final String BATCH_STATUS = "batchStatus";
    private static final String EXIT_STATUS = "exitStatus";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String JOB_PARAMETERS = "jobParameters";
    private static final String STEP_COUNT = "stepCount";
    @Param(name="executionid", shortName="x", optional=true)
    String executionId;
    @Param(primary=true, optional=true)
    String instanceId;

    @Override
    protected void executeCommand(AdminCommandContext context, Properties extraProps) throws Exception {
        ColumnFormatter columnFormatter = new ColumnFormatter(this.getDisplayHeaders());
        ArrayList<Map<String, Object>> jobExecutions = new ArrayList<Map<String, Object>>();
        extraProps.put("listBatchJobExecutions", jobExecutions);
        if (this.executionId != null) {
            JobInstance ji;
            JobOperator jobOperator = ListBatchJobExecutions.getJobOperatorFromBatchRuntime();
            JobExecution je = jobOperator.getJobExecution(Long.valueOf(this.executionId));
            if (this.instanceId != null && (ji = jobOperator.getJobInstance(Long.valueOf(this.executionId))).getInstanceId() != Long.valueOf(this.instanceId).longValue()) {
                throw new RuntimeException("executionid " + this.executionId + " is not associated with the specified instanceid (" + this.instanceId + ")" + "; did you mean " + ji.getInstanceId() + " ?");
            }
            try {
                if (this.glassFishBatchSecurityHelper.isVisibleToThisInstance(((TaggedJobExecution)je).getTagName())) {
                    jobExecutions.add(this.handleJob(je, columnFormatter));
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Exception while getting jobExecution details: " + ex);
                this.logger.log(Level.FINE, "Exception while getting jobExecution details: ", ex);
            }
        } else if (this.instanceId != null) {
            for (JobExecution je : ListBatchJobExecutions.getJobExecutionForInstance(Long.valueOf(this.instanceId))) {
                try {
                    if (!this.glassFishBatchSecurityHelper.isVisibleToThisInstance(((TaggedJobExecution)je).getTagName())) continue;
                    jobExecutions.add(this.handleJob(je, columnFormatter));
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "Exception while getting jobExecution details: " + ex);
                    this.logger.log(Level.FINE, "Exception while getting jobExecution details: ", ex);
                }
            }
        } else {
            JobOperator jobOperator = ListBatchJobExecutions.getJobOperatorFromBatchRuntime();
            Set<String> jobNames = jobOperator.getJobNames();
            if (jobNames != null) {
                for (String jn : jobOperator.getJobNames()) {
                    List<JobInstance> exe = jobOperator.getJobInstances(jn, 0, 0x7FFFFFFE);
                    if (exe == null) continue;
                    for (JobInstance ji : exe) {
                        for (JobExecution je : jobOperator.getJobExecutions(ji)) {
                            try {
                                if (!this.glassFishBatchSecurityHelper.isVisibleToThisInstance(((TaggedJobExecution)je).getTagName())) continue;
                                jobExecutions.add(this.handleJob(jobOperator.getJobExecution(je.getExecutionId()), columnFormatter));
                            }
                            catch (Exception ex) {
                                this.logger.log(Level.WARNING, "Exception while getting jobExecution details: " + ex);
                                this.logger.log(Level.FINE, "Exception while getting jobExecution details: ", ex);
                            }
                        }
                    }
                }
            }
        }
        if (jobExecutions.size() <= 0) {
            throw new RuntimeException("No Job Executions found");
        }
        context.getActionReport().setMessage(columnFormatter.toString());
    }

    @Override
    protected final String[] getAllHeaders() {
        return new String[]{JOB_NAME, EXECUTION_ID, START_TIME, END_TIME, BATCH_STATUS, EXIT_STATUS, JOB_PARAMETERS, STEP_COUNT};
    }

    @Override
    protected final String[] getDefaultHeaders() {
        return new String[]{JOB_NAME, EXECUTION_ID, START_TIME, END_TIME, BATCH_STATUS, EXIT_STATUS};
    }

    private boolean isSimpleMode() {
        for (String h : this.getOutputHeaders()) {
            if (JOB_NAME.equals(h)) continue;
            return false;
        }
        return true;
    }

    private static List<JobExecution> getJobExecutionForInstance(long instId) throws JobSecurityException, NoSuchJobException, NoSuchJobInstanceException, NoSuchJobExecutionException {
        JobOperator jobOperator = AbstractListCommand.getJobOperatorFromBatchRuntime();
        JobInstance jobInstance = null;
        block0: for (String jn : jobOperator.getJobNames()) {
            List<JobInstance> exe = jobOperator.getJobInstances(jn, 0, 0x7FFFFFFE);
            if (exe == null) continue;
            for (JobInstance ji : exe) {
                if (ji.getInstanceId() != instId) continue;
                jobInstance = ji;
                continue block0;
            }
        }
        ArrayList<JobExecution> jeList = new ArrayList<JobExecution>();
        if (jobInstance == null) {
            throw new RuntimeException("No Job Executions found for instanceid = " + instId);
        }
        List<JobExecution> lst = AbstractListCommand.getJobOperatorFromBatchRuntime().getJobExecutions(jobInstance);
        if (lst != null) {
            for (JobExecution je : lst) {
                jeList.add(jobOperator.getJobExecution(je.getExecutionId()));
            }
        }
        return jeList;
    }

    private Map<String, Object> handleJob(JobExecution je, ColumnFormatter columnFormatter) throws JobSecurityException, NoSuchJobExecutionException {
        HashMap<String, Object> jobInfo = new HashMap<String, Object>();
        int jobParamIndex = -1;
        StringTokenizer st = new StringTokenizer("", "");
        Object[] cfData = new String[this.getOutputHeaders().length];
        JobOperator jobOperator = AbstractListCommand.getJobOperatorFromBatchRuntime();
        for (int index = 0; index < this.getOutputHeaders().length; ++index) {
            Object data = null;
            switch (this.getOutputHeaders()[index]) {
                case "jobName": {
                    data = " " + je.getJobName();
                    break;
                }
                case "executionId": {
                    data = "" + je.getExecutionId();
                    break;
                }
                case "batchStatus": {
                    data = je.getBatchStatus() != null ? je.getBatchStatus() : "";
                    break;
                }
                case "exitStatus": {
                    data = je.getExitStatus() != null ? je.getExitStatus() : "";
                    break;
                }
                case "startTime": {
                    if (je.getStartTime() != null) {
                        data = je.getStartTime().getTime();
                        cfData[index] = je.getStartTime().toString();
                        break;
                    }
                    data = "";
                    break;
                }
                case "endTime": {
                    if (je.getEndTime() != null) {
                        data = je.getEndTime().getTime();
                        cfData[index] = je.getEndTime().toString();
                        break;
                    }
                    data = "";
                    break;
                }
                case "jobParameters": {
                    data = je.getJobParameters() == null ? new Properties() : je.getJobParameters();
                    jobParamIndex = index;
                    ColumnFormatter cf = new ColumnFormatter(new String[]{"KEY", "VALUE"});
                    for (Map.Entry<Object, Object> e : ((Properties)data).entrySet()) {
                        cf.addRow((Object[])new String[]{e.getKey().toString(), e.getValue().toString()});
                    }
                    st = new StringTokenizer(cf.toString(), "\n");
                    break;
                }
                case "stepCount": {
                    long exeId = this.executionId == null ? je.getExecutionId() : Long.valueOf(this.executionId).longValue();
                    data = jobOperator.getStepExecutions(exeId) == null ? 0 : jobOperator.getStepExecutions(exeId).size();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown header: " + this.getOutputHeaders()[index]);
                }
            }
            jobInfo.put(this.getOutputHeaders()[index], data);
            cfData[index] = jobParamIndex != index ? (cfData[index] == null ? data.toString() : cfData[index]) : (st.hasMoreTokens() ? st.nextToken() : "");
        }
        columnFormatter.addRow(cfData);
        cfData = new String[this.getOutputHeaders().length];
        for (int i = 0; i < this.getOutputHeaders().length; ++i) {
            cfData[i] = "";
        }
        while (st.hasMoreTokens()) {
            cfData[jobParamIndex] = st.nextToken();
            columnFormatter.addRow(cfData);
        }
        return jobInfo;
    }
}

