/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util;

import com.sun.xml.rpc.util.MapBase;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityMap
extends MapBase
implements Map,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient Object[] table;
    private int size;
    private volatile transient int modCount;
    private transient int threshold;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    public IdentityMap() {
        this.init(32);
    }

    public IdentityMap(int expectedMaxSize) {
        if (expectedMaxSize < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + expectedMaxSize);
        }
        this.init(this.capacity(expectedMaxSize));
    }

    private int capacity(int expectedMaxSize) {
        int result;
        int minCapacity = 3 * expectedMaxSize / 2;
        if (minCapacity > 0x20000000 || minCapacity < 0) {
            result = 0x20000000;
        } else {
            for (result = 4; result < minCapacity; result <<= 1) {
            }
        }
        return result;
    }

    private void init(int initCapacity) {
        this.threshold = initCapacity * 2 / 3;
        this.table = new Object[2 * initCapacity];
    }

    public IdentityMap(Map m) {
        this((int)((double)(1 + m.size()) * 1.1));
        this.putAll(m);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object x, int length) {
        int h = System.identityHashCode(x);
        return (h << 1) - (h << 8) & length - 1;
    }

    private static int nextKeyIndex(int i, int len) {
        return i + 2 < len ? i + 2 : 0;
    }

    public Object get(Object key) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return item;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
        return tab[i + 1];
    }

    public boolean containsKey(Object key) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return false;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
        return true;
    }

    public boolean containsValue(Object value) {
        Object[] tab = this.table;
        for (int i = 1; i < tab.length; i += 2) {
            if (tab[i] != value) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(Object key, Object value) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return false;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
        return tab[i + 1] == value;
    }

    public Object put(Object key, Object value) {
        Object item;
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        while ((item = tab[i]) != null) {
            if (item == k) {
                Object oldValue = tab[i + 1];
                tab[i + 1] = value;
                return oldValue;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
        ++this.modCount;
        tab[i] = k;
        tab[i + 1] = value;
        if (++this.size >= this.threshold) {
            this.resize(len);
        }
        return null;
    }

    private void resize(int newCapacity) {
        int newLength = newCapacity * 2;
        Object[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (oldLength == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (oldLength >= newLength) {
            return;
        }
        Object[] newTable = new Object[newLength];
        this.threshold = newLength / 3;
        for (int j = 0; j < oldLength; j += 2) {
            Object key = oldTable[j];
            if (key == null) continue;
            Object value = oldTable[j + 1];
            oldTable[j] = null;
            oldTable[j + 1] = null;
            int i = IdentityMap.hash(key, newLength);
            while (newTable[i] != null) {
                i = IdentityMap.nextKeyIndex(i, newLength);
            }
            newTable[i] = key;
            newTable[i + 1] = value;
        }
        this.table = newTable;
    }

    public void putAll(Map t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                ++this.modCount;
                --this.size;
                Object oldValue = tab[i + 1];
                tab[i + 1] = null;
                tab[i] = null;
                this.closeDeletion(i);
                return oldValue;
            }
            if (item == null) {
                return null;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
    }

    private boolean removeMapping(Object key, Object value) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                if (tab[i + 1] != value) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                tab[i] = null;
                tab[i + 1] = null;
                this.closeDeletion(i);
                return true;
            }
            if (item == null) {
                return false;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
    }

    private void closeDeletion(int d) {
        Object item;
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.nextKeyIndex(d, len);
        while ((item = tab[i]) != null) {
            int r = IdentityMap.hash(item, len);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                tab[d] = item;
                tab[d + 1] = tab[i + 1];
                tab[i] = null;
                tab[i + 1] = null;
                d = i;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
    }

    public void clear() {
        ++this.modCount;
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IdentityMap) {
            IdentityMap m = (IdentityMap)o;
            if (m.size() != this.size) {
                return false;
            }
            Object[] tab = m.table;
            for (int i = 0; i < tab.length; i += 2) {
                Object k = tab[i];
                if (k == null || this.containsMapping(k, tab[i + 1])) continue;
                return false;
            }
            return true;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            return ((Object)this.entrySet()).equals(m.entrySet());
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            Object k = IdentityMap.unmaskNull(key);
            result += System.identityHashCode(k) ^ System.identityHashCode(tab[i + 1]);
        }
        return result;
    }

    public Object clone() {
        try {
            IdentityMap t = (IdentityMap)super.clone();
            t.entrySet = null;
            t.table = (Object[])this.table.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        Set ks = this.keySet;
        if (ks != null) {
            return ks;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    public Collection values() {
        Collection vs = this.values;
        if (vs != null) {
            return vs;
        }
        this.values = new Values();
        return this.values;
    }

    public Set entrySet() {
        Set es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            s.writeObject(IdentityMap.unmaskNull(key));
            s.writeObject(tab[i + 1]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.init(this.capacity(size * 4 / 3));
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    private class EntryIterator
    extends IdentityMapIterator
    implements Map.Entry {
        private EntryIterator() {
        }

        public Object next() {
            this.nextIndex();
            return this;
        }

        public Object getKey() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return IdentityMap.unmaskNull(this.traversalTable[this.lastReturnedIndex]);
        }

        public Object getValue() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return this.traversalTable[this.lastReturnedIndex + 1];
        }

        public Object setValue(Object value) {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            Object oldValue = this.traversalTable[this.lastReturnedIndex + 1];
            this.traversalTable[this.lastReturnedIndex + 1] = value;
            if (this.traversalTable != IdentityMap.this.table) {
                IdentityMap.this.put(this.traversalTable[this.lastReturnedIndex], value);
            }
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return e.getKey() == this.getKey() && e.getValue() == this.getValue();
        }

        public int hashCode() {
            return System.identityHashCode(this.getKey()) ^ System.identityHashCode(this.getValue());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return IdentityMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return IdentityMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        public int size() {
            return IdentityMap.this.size;
        }

        public void clear() {
            IdentityMap.this.clear();
        }

        public boolean removeAll(Collection c) {
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        public Object[] toArray() {
            ArrayList<MapBase.SimpleEntry> c = new ArrayList<MapBase.SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new MapBase.SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList<MapBase.SimpleEntry> c = new ArrayList<MapBase.SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new MapBase.SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray(a);
        }
    }

    private abstract class IdentityMapIterator
    implements Iterator {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        private IdentityMapIterator() {
            this.index = IdentityMap.this.size != 0 ? 0 : IdentityMap.this.table.length;
            this.expectedModCount = IdentityMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityMap.this.table;
        }

        public boolean hasNext() {
            Object[] tab = this.traversalTable;
            for (int i = this.index; i < tab.length; i += 2) {
                Object key = tab[i];
                if (key == null) continue;
                this.index = i;
                this.indexValid = true;
                return true;
            }
            this.index = tab.length;
            return false;
        }

        protected int nextIndex() {
            if (IdentityMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        public void remove() {
            Object item;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityMap.this.modCount;
            int deletedSlot = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            IdentityMap.this.size--;
            this.index = deletedSlot;
            this.indexValid = false;
            Object[] tab = this.traversalTable;
            int len = tab.length;
            int d = deletedSlot;
            Object key = tab[d];
            tab[d] = null;
            tab[d + 1] = null;
            if (tab != IdentityMap.this.table) {
                IdentityMap.this.remove(key);
                this.expectedModCount = IdentityMap.this.modCount;
                return;
            }
            int i = IdentityMap.nextKeyIndex(d, len);
            while ((item = tab[i]) != null) {
                int r = IdentityMap.hash(item, len);
                if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                    if (i < deletedSlot && d >= deletedSlot && this.traversalTable == IdentityMap.this.table) {
                        int remaining = len - deletedSlot;
                        Object[] newTable = new Object[remaining];
                        System.arraycopy(tab, deletedSlot, newTable, 0, remaining);
                        this.traversalTable = newTable;
                        this.index = 0;
                    }
                    tab[d] = item;
                    tab[d + 1] = tab[i + 1];
                    tab[i] = null;
                    tab[i + 1] = null;
                    d = i;
                }
                i = IdentityMap.nextKeyIndex(i, len);
            }
        }
    }

    private class KeyIterator
    extends IdentityMapIterator {
        private KeyIterator() {
        }

        public Object next() {
            return IdentityMap.unmaskNull(this.traversalTable[this.nextIndex()]);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return IdentityMap.this.size;
        }

        public boolean contains(Object o) {
            return IdentityMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            int oldSize = IdentityMap.this.size;
            IdentityMap.this.remove(o);
            return IdentityMap.this.size != oldSize;
        }

        public boolean removeAll(Collection c) {
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        public void clear() {
            IdentityMap.this.clear();
        }

        public int hashCode() {
            int result = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                result += System.identityHashCode(i.next());
            }
            return result;
        }
    }

    private class ValueIterator
    extends IdentityMapIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.traversalTable[this.nextIndex() + 1];
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return IdentityMap.this.size;
        }

        public boolean contains(Object o) {
            return IdentityMap.this.containsValue(o);
        }

        public boolean remove(Object o) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (i.next() != o) continue;
                i.remove();
                return true;
            }
            return false;
        }

        public void clear() {
            IdentityMap.this.clear();
        }
    }
}

