/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Date;
import jcifs.smb.Info;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.util.Hexdump;

class Trans2QueryPathInformationResponse
extends SmbComTransactionResponse {
    static final int SMB_QUERY_FILE_BASIC_INFO = 257;
    static final int SMB_QUERY_FILE_STANDARD_INFO = 258;
    private int informationLevel;
    Info info;

    Trans2QueryPathInformationResponse(int informationLevel) {
        this.informationLevel = informationLevel;
        this.subCommand = (byte)5;
    }

    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 2;
    }

    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        switch (this.informationLevel) {
            case 257: {
                return this.readSmbQueryFileBasicInfoWireFormat(buffer, bufferIndex);
            }
            case 258: {
                return this.readSmbQueryFileStandardInfoWireFormat(buffer, bufferIndex);
            }
        }
        return 0;
    }

    int readSmbQueryFileStandardInfoWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        SmbQueryFileStandardInfo info = new SmbQueryFileStandardInfo();
        info.allocationSize = Trans2QueryPathInformationResponse.readInt8(buffer, bufferIndex);
        info.endOfFile = Trans2QueryPathInformationResponse.readInt8(buffer, bufferIndex += 8);
        info.numberOfLinks = Trans2QueryPathInformationResponse.readInt4(buffer, bufferIndex += 8);
        bufferIndex += 4;
        info.deletePending = (buffer[bufferIndex++] & 0xFF) > 0;
        info.directory = (buffer[bufferIndex++] & 0xFF) > 0;
        this.info = info;
        return bufferIndex - start;
    }

    int readSmbQueryFileBasicInfoWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        SmbQueryFileBasicInfo info = new SmbQueryFileBasicInfo();
        info.createTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex);
        info.lastAccessTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex += 8);
        info.lastWriteTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex += 8);
        info.changeTime = Trans2QueryPathInformationResponse.readTime(buffer, bufferIndex += 8);
        info.attributes = Trans2QueryPathInformationResponse.readInt2(buffer, bufferIndex += 8);
        this.info = info;
        return (bufferIndex += 2) - start;
    }

    public String toString() {
        return new String("Trans2QueryPathInformationResponse[" + super.toString() + "]");
    }

    class SmbQueryFileBasicInfo
    implements Info {
        long createTime;
        long lastAccessTime;
        long lastWriteTime;
        long changeTime;
        int attributes;

        SmbQueryFileBasicInfo() {
        }

        public int getAttributes() {
            return this.attributes;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public long getLastWriteTime() {
            return this.lastWriteTime;
        }

        public long getSize() {
            return 0L;
        }

        public String toString() {
            return new String("SmbQueryFileBasicInfo[createTime=" + new Date(this.createTime) + ",lastAccessTime=" + new Date(this.lastAccessTime) + ",lastWriteTime=" + new Date(this.lastWriteTime) + ",changeTime=" + new Date(this.changeTime) + ",attributes=0x" + Hexdump.toHexString(this.attributes, 4) + "]");
        }
    }

    class SmbQueryFileStandardInfo
    implements Info {
        long allocationSize;
        long endOfFile;
        int numberOfLinks;
        boolean deletePending;
        boolean directory;

        SmbQueryFileStandardInfo() {
        }

        public int getAttributes() {
            return 0;
        }

        public long getCreateTime() {
            return 0L;
        }

        public long getLastWriteTime() {
            return 0L;
        }

        public long getSize() {
            return this.endOfFile;
        }

        public String toString() {
            return new String("SmbQueryInfoStandard[allocationSize=" + this.allocationSize + ",endOfFile=" + this.endOfFile + ",numberOfLinks=" + this.numberOfLinks + ",deletePending=" + this.deletePending + ",directory=" + this.directory + "]");
        }
    }
}

