/*
 * 01/09/2002 - 20:43:57
 *
 * NetworkErrorPanel.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.gui;

import info.jdictionary.JDictionary;
import info.jdictionary.IconBank;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JComponent;
import javax.swing.BoxLayout;
import java.awt.Dimension;
import java.awt.Color;

public class NetworkErrorPanel extends JPanel {

    ProxyButton proxyButton;

    public NetworkErrorPanel(JDictionary jDictionary) {
        super();
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        setBackground(Color.white);

        JLabel label1 = new JLabel(JDictionary.getString("PossibleProblems"), IconBank.caution, 0);
        label1.setAlignmentX(0);
        JLabel label2 = new JLabel(JDictionary.getString("Problem1"));
        label2.setAlignmentX(0);
        JLabel label3 = new JLabel(JDictionary.getString("Problem3"));
        label3.setAlignmentX(0);

        proxyButton = new ProxyButton(jDictionary, null, JDictionary.getString("ProxySet"));
        proxyButton.setPreferredSize(new Dimension(80, 18));
        proxyButton.setBackground(Color.orange);

        JPanel proxyPanel = new JPanel();
        proxyPanel.setLayout(new BoxLayout(proxyPanel, BoxLayout.X_AXIS));
        proxyPanel.add(new JLabel(JDictionary.getString("Problem2")));
        proxyPanel.setBackground(Color.white);
        proxyPanel.add(proxyButton);
        proxyPanel.setAlignmentX(0);

        add(label1);
        add(label2);
        add(proxyPanel);
        add(label3);
    }


    public void addLine(JComponent component) {
        add(component);
    }


    public ProxyButton getProxyButton() {
        return proxyButton;
    }
}