/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.ConsoleInstall;
import installer.NonInteractiveInstall;
import installer.OperatingSystem;
import installer.Progress;
import installer.SwingInstall;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class Install {
    private Properties props = new Properties();
    private byte[] buf;

    private static boolean isRunningFromExclam() {
        Class<Install> clazz = Install.class;
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL uRL = codeSource.getLocation();
        return uRL.toString().contains("!");
    }

    private static void errorAndExit(boolean bl, String string) {
        if (bl) {
            JTextArea jTextArea = new JTextArea(string);
            JOptionPane.showMessageDialog(null, jTextArea, "jEdit installer error...", 0);
        } else {
            System.err.println(string);
        }
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        boolean bl = stringArray.length == 0;
        String string = System.getProperty("java.version");
        int n = Integer.parseInt(string.split("\\.", 2)[0]);
        if (n < 11) {
            Install.errorAndExit(bl, "You are running Java version " + string + " from " + System.getProperty("java.vendor") + ".\nThis installer requires Java 11 or later.");
        }
        if (Install.isRunningFromExclam()) {
            Install.errorAndExit(bl, "You are running the installer from a directory containing exclamation marks.\nIt is a known cause of failure of the installer\n(http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4523159 for the curious ones).\nPlease move the installer somewhere else and run it again.");
        }
        if (bl) {
            new SwingInstall();
        } else if (stringArray.length == 1 && stringArray[0].equals("text")) {
            new ConsoleInstall();
        } else if (stringArray.length >= 2 && stringArray[0].equals("auto")) {
            new NonInteractiveInstall(stringArray);
        } else {
            System.err.println("Usage:");
            System.err.println("java -jar <installer JAR>");
            System.err.println("java -jar <installer JAR> text");
            System.err.println("java -jar <installer JAR> auto <install dir> [unix-script=<dir>] [unix-man=<dir>]");
            System.err.println("text parameter starts installer in text-only mode.");
            System.err.println("auto parameter starts installer in non-interactive mode.");
        }
    }

    public Install() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/installer/install.props");
            this.props.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Error loading 'install.props':");
            iOException.printStackTrace();
        }
        this.buf = new byte[32768];
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public int getIntegerProperty(String string) {
        try {
            return Integer.parseInt(this.props.getProperty(string));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void copy(InputStream inputStream, String string, Progress progress) throws IOException {
        int n;
        File file = new File(string);
        OperatingSystem.getOperatingSystem().mkdirs(file.getParent());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        while ((n = inputStream.read(this.buf, 0, Math.min(inputStream.available(), this.buf.length))) != -1 && n != 0) {
            bufferedOutputStream.write(this.buf, 0, n);
            if (progress == null) continue;
            progress.advance(n);
        }
        bufferedOutputStream.close();
    }
}

