/* pasori commands */
#include "libpasori_liblocal.h"
#include <stdlib.h>

/* FIXME: UNKNOWN CONSTANTS */
const uint8 PASORI_INIT0[] = {0x62,0x01,0x82};
/* RET0                      {0x63,0x00,0x88}; */
const uint8 PASORI_INIT1[] = {0x62,0x02,0x80,0x81}; /* INIT3 */
/* RET1                      {0x63,0x00,0xcc,0x88}; */
const uint8 PASORI_INIT2[] = {0x62,0x22,0x80,0xcc,0x81,0x88};
/* RET2                      {0x63,0x00}; */
const uint8 PASORI_INIT3[] = {0x62,0x02,0x80,0x81}; /* INIT1 */
/* RET3                      {0x63,0x00,0xcc,0x88}; */
const uint8 PASORI_INIT4[] = {0x62,0x02,0x82,0x87};
/* RET4                      {0x63,0x00,0x88,0x01}; */
const uint8 PASORI_INIT5[] = {0x62,0x21,0x25,0x58};
/* RET5                      {0x63,0x00} */
const uint8 PASORI_READ0[] = {0x58};
/*RRET0                      {0x59,0x28,0x01} */
const uint8 PASORI_READ1[] = {0x54};
const uint8 PASORI_READ2[] = {0x5a,0x80};

/* internal */
void /* FIXME: return errorcode */
pasori_packet_write(pasori* p,uint8* data,int size){ /* RAW Packet SEND */
	uint8 cmd[256];
	uint8 recv[256];
	uint8 sum;
	int i;
	sum = 0;
	for(i=0;i!=size;i++){
		sum += data[i];
	}
	sum = 0x100 - sum;
	cmd[0] = 0;
	cmd[1] = 0;
	cmd[2] = 0xff;
	cmd[3] = size;
	cmd[4] = 0x100 - size;
	memcpy(&cmd[5],data,size);
	cmd[5+size] = sum;
	cmd[6+size] = 0;

	pasori_send(p,cmd,size+7,400); /* FIXME:hardcoded timeout */
	/* FIXME:handle error */
}

void
pasori_test(pasori *p,const uint8 *testptrn,uint8 size){
	uint8 recv[256];
	pasori_packet_write(p,(uint8 *)testptrn,size);
	pasori_recv(p,recv,255,400);
}

/* exports */

int
pasori_write(pasori *p,uint8 *data,uint8 size){
	uint8 cmd[256];

	cmd[0] = 0x5c;
	cmd[1] = size+1;
	memcpy(&cmd[2],data,size);


	pasori_packet_write(p,cmd,size+2); 
	return 0; /* FIXME:handle error */
	
}
	
int
pasori_read(pasori *p,uint8 *data,uint8 size){
	uint8 recv[256];
	unsigned int s;
	signed int i;

	i = pasori_recv(p,recv,255,400); /* FIXME: hardcoded timeout */
	
	if(i<=0) return 0; /* FIXME: handle timeout */
	
	s = recv[3];
	/* FIXME:calc checksum */
	/* FIXME:check buffer size */
	/* FIXME:check msgid */
	s--;
	memcpy(data,&recv[7],s);
	return s; 
}
		

/* read w/o encrypt */
int
felica_read_without_encryption02(felica* f,int servicecode,int mode,uint8 addr,uint8* b){
	uint8 cmd[15];
	uint8 resp[256];
	uint8 blklist[2];
	int i;
	blklist[0] = 0;
	blklist[1] = addr;
	blklist[0] |= 0x80; /* element size == 2 */
	
	cmd[0] = FELICA_CMD_READ_WITHOUT_ENCRYPTION;
	memcpy(&cmd[1],f->IDm,8);
	cmd[9] = 1;
	cmd[10] = L8(servicecode);
	cmd[11] = H8(servicecode);
	cmd[12] = 1;
	cmd[13] = blklist[0];
	cmd[14] = blklist[1];

	pasori_write(f->p,cmd,15);
	i = pasori_read(f->p,resp,255);
	if(i<0) return -1;
	if(resp[9] != 0){
		Log("ERROR %02X %02X\n",resp[9],resp[10]);
		return -1;
	}
	
	memcpy(b,&resp[12],16);
	
	return 0;
}

/* INIT */
int
pasori_init(pasori *p){
	uint8 recv[256];
	pasori_test(p,PASORI_INIT0,sizeof(PASORI_INIT0));
	pasori_test(p,PASORI_INIT1,sizeof(PASORI_INIT1));
	pasori_test(p,PASORI_INIT2,sizeof(PASORI_INIT2));
	pasori_test(p,PASORI_INIT3,sizeof(PASORI_INIT3));
	pasori_test(p,PASORI_INIT4,sizeof(PASORI_INIT4));
	pasori_test(p,PASORI_INIT5,sizeof(PASORI_INIT5));

	pasori_test(p,PASORI_READ2,sizeof(PASORI_READ2));
	
	return 0;
}
