/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import ch.qos.logback.classic.Level;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.cli.Cli;
import org.sonarsource.scanner.cli.Conf;
import org.sonarsource.scanner.cli.Exit;
import org.sonarsource.scanner.cli.ScannerEngineBootstrapperFactory;
import org.sonarsource.scanner.cli.Stats;
import org.sonarsource.scanner.cli.SystemInfo;
import org.sonarsource.scanner.lib.ScannerEngineBootstrapper;
import org.sonarsource.scanner.lib.ScannerEngineFacade;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private final Exit exit;
    private final Cli cli;
    private final Conf conf;
    private ScannerEngineBootstrapper scannerEngineBootstrapper;
    private final ScannerEngineBootstrapperFactory bootstrapperFactory;

    Main(Exit exit, Cli cli, Conf conf, ScannerEngineBootstrapperFactory bootstrapperFactory) {
        this.exit = exit;
        this.cli = cli;
        this.conf = conf;
        this.bootstrapperFactory = bootstrapperFactory;
    }

    public static void main(String[] args2) {
        Exit exit = new Exit();
        Cli cli = new Cli(exit).parse(args2);
        Main main = new Main(exit, cli, new Conf(cli, System.getenv()), new ScannerEngineBootstrapperFactory());
        main.analyze();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyze() {
        Stats stats = new Stats().start();
        int status = 1;
        try {
            Properties p = this.conf.properties();
            this.checkSkip(p);
            Main.configureLogging(p);
            this.init(p);
            try (ScannerEngineFacade engine = this.scannerEngineBootstrapper.bootstrap();){
                Main.logServerType(engine);
                boolean success = engine.analyze(p);
                if (success) {
                    Main.displayExecutionResult(stats, "SUCCESS");
                    status = 0;
                } else {
                    Main.displayExecutionResult(stats, "FAILURE");
                    status = 3;
                }
            }
        }
        catch (Throwable e) {
            Main.displayExecutionResult(stats, "FAILURE");
            this.showError(e, this.cli.isDebugEnabled());
            status = Main.isUserError(e) ? 2 : 1;
        }
        finally {
            this.exit.exit(status);
        }
    }

    private static void logServerType(ScannerEngineFacade engine) {
        if (engine.isSonarCloud()) {
            LOG.info("Communicating with SonarCloud");
        } else {
            String serverVersion = engine.getServerVersion();
            LOG.info("Communicating with SonarQube Server {}", (Object)serverVersion);
        }
    }

    private void checkSkip(Properties properties) {
        if ("true".equalsIgnoreCase(properties.getProperty("sonar.scanner.skip"))) {
            LOG.info("SonarScanner CLI analysis skipped");
            this.exit.exit(0);
        }
    }

    private void init(Properties p) {
        SystemInfo.print();
        if (this.cli.isDisplayVersionOnly()) {
            this.exit.exit(0);
        }
        this.scannerEngineBootstrapper = this.bootstrapperFactory.create(p, this.cli.getInvokedFrom());
    }

    private static void configureLogging(Properties props) {
        if ("true".equals(props.getProperty("sonar.verbose")) || "DEBUG".equalsIgnoreCase(props.getProperty("sonar.log.level")) || "TRACE".equalsIgnoreCase(props.getProperty("sonar.log.level"))) {
            ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
            rootLogger.setLevel(Level.DEBUG);
        }
    }

    private static void displayExecutionResult(Stats stats, String resultMsg) {
        LOG.info("EXECUTION {}", (Object)resultMsg);
        stats.stop();
    }

    private void showError(Throwable e, boolean debug) {
        String message = "Error during SonarScanner CLI execution";
        if (debug || !Main.isUserError(e)) {
            LOG.error(message, e);
        } else {
            LOG.error(message);
            LOG.error(e.getMessage());
            String previousMsg = "";
            for (Throwable cause = e.getCause(); cause != null && cause.getMessage() != null && !cause.getMessage().equals(previousMsg); cause = cause.getCause()) {
                LOG.error("Caused by: {}", (Object)cause.getMessage());
                previousMsg = cause.getMessage();
            }
        }
        if (!this.cli.isDebugEnabled()) {
            LOG.error("");
            this.suggestDebugMode();
        }
    }

    private static boolean isUserError(Throwable e) {
        return "org.sonar.api.utils.MessageException".equals(e.getClass().getName());
    }

    private void suggestDebugMode() {
        if (!this.cli.isEmbedded()) {
            LOG.error("Re-run SonarScanner CLI using the -X switch to enable full debug logging.");
        }
    }
}

