/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Stats {
    private static final Logger LOG = LoggerFactory.getLogger(Stats.class);
    private long startTime;

    Stats() {
    }

    Stats start() {
        this.startTime = System.currentTimeMillis();
        return this;
    }

    Stats stop() {
        long stopTime = System.currentTimeMillis() - this.startTime;
        LOG.atInfo().addArgument(() -> Stats.formatTime(stopTime)).log("Total time: {}");
        return this;
    }

    static String formatTime(long time) {
        long h = time / 3600000L;
        long m = (time - h * 60L * 60L * 1000L) / 60000L;
        long s = (time - h * 60L * 60L * 1000L - m * 60L * 1000L) / 1000L;
        long ms = time % 1000L;
        String format = h > 0L ? "%1$d:%2$02d:%3$02d.%4$03ds" : (m > 0L ? "%2$d:%3$02d.%4$03ds" : "%3$d.%4$03ds");
        return String.format(format, h, m, s, ms);
    }
}

