/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.JreCacheHit;

public class JavaRunner {
    private static final Logger LOG = LoggerFactory.getLogger(JavaRunner.class);
    private final Path javaExecutable;
    private final JreCacheHit jreCacheHit;

    public JavaRunner(Path javaExecutable, JreCacheHit jreCacheHit) {
        this.javaExecutable = javaExecutable;
        this.jreCacheHit = jreCacheHit;
    }

    public JreCacheHit getJreCacheHit() {
        return this.jreCacheHit;
    }

    public boolean execute(List<String> args2, @Nullable String input, Consumer<String> stdOutConsummer) {
        try {
            ArrayList<String> command = new ArrayList<String>(args2);
            command.add(0, this.javaExecutable.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing: {}", (Object)String.join((CharSequence)" ", command));
            }
            Process process = new ProcessBuilder(command).start();
            if (input != null) {
                try (OutputStream stdin = process.getOutputStream();
                     OutputStreamWriter osw = new OutputStreamWriter(stdin, StandardCharsets.UTF_8);){
                    osw.write(input);
                }
            }
            StreamGobbler stdoutConsummer = new StreamGobbler(process.getInputStream(), stdOutConsummer);
            StreamGobbler stdErrConsummer = new StreamGobbler(process.getErrorStream(), stderr -> LOG.error("[stderr] {}", stderr));
            stdErrConsummer.start();
            stdoutConsummer.start();
            int exitCode = process.waitFor();
            stdoutConsummer.join();
            stdErrConsummer.join();
            if (exitCode != 0) {
                LOG.debug("Java command exited with code {}", (Object)process.exitValue());
                return false;
            }
            return true;
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Failed to run the Java command", e);
        }
    }

    public Path getJavaExecutable() {
        return this.javaExecutable;
    }

    private static class StreamGobbler
    extends Thread {
        private final InputStream inputStream;
        private final Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream2, Consumer<String> consumer) {
            this.inputStream = inputStream2;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8)).lines().forEach(this.consumer);
        }
    }
}

