/*
** wifimgr.h
*/

/*
** Copyright (c) 2009, J.R. Oldroyd, Open Advisors Limited
** All rights reserved.
** 
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are met:
**     * Redistributions of source code must retain the above copyright
**       notice, this list of conditions and the following disclaimer.
**     * Redistributions in binary form must reproduce the above copyright
**       notice, this list of conditions and the following disclaimer in the
**       documentation and/or other materials provided with the distribution.
**     * Neither the name of the author, the author's organization nor the
**       names of its contributors may be used to endorse or promote products
**       derived from this software without specific prior written permission.
** 
** THIS SOFTWARE IS PROVIDED BY OPEN ADVISORS LIMITED ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
** DISCLAIMED. IN NO EVENT SHALL OPEN ADVISORS LIMITED BE LIABLE FOR ANY
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
** (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
** ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
** $Id$
*/

#define	WIFIMGR_CACHE_FILE	"~/.cache/wifimgr/config"

#define NETWORKS_FILE		"/etc/wpa_supplicant.conf"
#define RC_CONF_FILE		"/etc/rc.conf"
#define RC_CONF_LOCAL_FILE	"/etc/rc.conf.local"

#define ICON_PATH		"/usr/local/share/wifimgr/icons"

#define PATH_CAT		"/bin/cat"
#define PATH_CP			"/bin/cp"
#define PATH_DIFF		"/usr/bin/diff"
#define PATH_IFCONFIG		"/sbin/ifconfig"
#define PATH_NETIF		"/etc/rc.d/netif"
#define PATH_SED		"/usr/bin/sed"
#define PATH_WIFIMGRSU		"/usr/local/libexec/wifimgrsu"

#define ETCDIR			"/etc"
#define TMPDIR			"/tmp"

#define MAX_INTFS		64
#define IF_NAME_LEN		256

struct wifi_net {
	int			wn_enabled;
	unsigned int		wn_security;
#define WN_SEC_UNKNOWN		0x0
#define WN_SEC_NONE		0x1
#define WN_SEC_WEP		0x2
#define WN_SEC_WPA		0x4
#define WN_SEC_RSN		0x8
	unsigned int		wn_km;
#define WN_KM_UNKNOWN		0x0
#define WN_KM_NONE		0x1
#define WN_KM_PSK		0x2
#define WN_KM_EAP		0x4
	char			wn_key[256];
	char			wn_comment[256];
	int			wn_any_bssid;
	int			wn_chan;
	int			wn_rate;
	int			wn_bars;
	int			wn_assoc_ifn;
	struct wifi_net *	wn_next;

	int			wn_show_password;
	/* next ones are really GtkWidget * pointers */
	void *			w_wn_security;
	void *			w_wn_key;
	void *			w_sup_password;
	void *			w_sup_private_key_passwd;
	void *			w_sup_private_key2_passwd;
	void *			w_sup_ssid;
	void *			w_sup_bssid;
	void *			w_sup_priority;
	void *			w_wn_chan;
	void *			w_wn_rate;
	void *			w_wn_bars;

	char			sup_anonymous_identity[256];
	char			sup_auth_alg[256];
	char			sup_bssid[256];
	char			sup_ca_cert[256];
	char			sup_ca_cert2[256];
	char			sup_client_cert[256];
	char			sup_client_cert2[256];
	char			sup_dh_file[256];
	char			sup_dh_file2[256];
	int			sup_disabled;
	char			sup_eap[256];
	int			sup_eapol_flags;
	int			sup_eap_workaround;
	char			sup_group[256];
	char			sup_identity[256];
	char			sup_key_mgmt[256];
	int			sup_mixed_cell;
	int			sup_mode;
	char			sup_pac_file[256];
	char			sup_pairwise[256];
	char			sup_password[256];
	char			sup_phase1[256];
	char			sup_phase2[256];
	int			sup_priority;
	char			sup_private_key[256];
	char			sup_private_key2[256];
	char			sup_private_key_passwd[256];
	char			sup_private_key2_passwd[256];
	char			sup_proto[256];
	char			sup_psk[256];
	int			sup_scan_ssid;
	char			sup_subject_match[256];
	char			sup_subject_match2[256];
	char			sup_ssid[256];
	char			sup_wep_key0[256];
	char			sup_wep_key1[256];
	char			sup_wep_key2[256];
	char			sup_wep_key3[256];
	int			sup_wep_tx_keyidx;
};

struct conflist {
	char *			cl_name;
	int			cl_value;
};

struct intfs {
	char			wifi[IF_NAME_LEN];
	char			aggr[IF_NAME_LEN];
	int			type;
#define INTF_TYPE_NONE		0
#define INTF_TYPE_WLAN		1
#define INTF_TYPE_AGGR		2
	int			status;
	char			ssid[IF_NAME_LEN];
	char			bssid[IF_NAME_LEN];
};

extern struct conflist		conf_auth_alg[];
extern struct conflist		conf_eap[];
extern struct conflist		conf_group[];
extern struct conflist		conf_key_mgmt[];
extern struct conflist		conf_pairwise[];
extern struct conflist		conf_proto[];
extern struct wifi_net *	nets;
extern struct intfs *		intf;
extern int			wifi_if_status;
#define WIFI_IF_UNKNOWN		0
#define WIFI_IF_DOWN		1
#define WIFI_IF_UP		2

extern struct intfs *		add_intf(char *, char *);
extern char *			get_intf_name(int);
extern int			network_intf_status(void);
extern int			toggle_intf_up_down(void);
extern int			ifconfig_intf_status(int);
extern int			ifconfig_associated_network(void);
extern struct wifi_net *	build_network_list(void);
extern int			save_networks_file(char *);
extern int			restart_intf(void);

extern int			chop(char * s);

extern int			nl_insert(struct wifi_net **, struct wifi_net *);
#define NL_INSERT_ERROR		0
#define NL_INSERT_OK		1
#define NL_INSERT_SEC_CHG	2
extern int			nl_delete_list(struct wifi_net **);
extern void			nl_order_by_ssid(struct wifi_net **);
extern void			nl_order_by_bars(struct wifi_net **);
extern void			nl_order_by_channel(struct wifi_net **);

extern int			gui_changes;
extern int			gui_show_all_networks;
extern int			gui_networks_order;
#define ORDER_BY_SSID		0
#define ORDER_BY_BARS		1
#define ORDER_BY_CHANNEL	2
extern char			gui_response[];
extern int			gui_init(int *, char ***);
extern int			gui_message(const char *, int);
#define	MSG_INFO		0
#define	MSG_WARNING		1
#define	MSG_QUESTION		2
#define	MSG_ERROR		3
#define	MSG_INPUT		4
#define MSG_RESPONSE_OK		0
#define MSG_RESPONSE_FAIL	1
#define MSG_RESPONSE_YES	2
#define MSG_RESPONSE_NO		3
extern void			gui_loop();
