/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class HtmlPanePopup
extends MouseAdapter {
    JEditorPane htmlPane;
    JPopupMenu popup;
    JMenuItem copy;

    public HtmlPanePopup(JEditorPane htmlPane) {
        this.htmlPane = htmlPane;
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        Point p = new Point();
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.copy = new JMenuItem(Resources.getString("Copy"), IconBank.copy);
            this.popup.add(this.copy);
            this.copy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClipboardUtils.setClipboard(HtmlPanePopup.this.htmlPane.getSelectedText());
                }
            });
        }
        p.setLocation(e.getX(), e.getY());
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
        if (this.htmlPane.getSelectedText() == null) {
            this.copy.setEnabled(false);
        } else {
            this.copy.setEnabled(true);
        }
    }
}

