/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class OutputTypeChooserToolBar
extends JToolBar {
    Prefs prefs;
    JButton increment;
    JButton decrement;
    JButton newWindow;
    JLabel tableLabel;
    int numberOfOutputTypes;

    public OutputTypeChooserToolBar(Prefs prefs, int numberOfOutputTypes) {
        this.prefs = prefs;
        this.numberOfOutputTypes = numberOfOutputTypes;
        this.buildGUI(true);
    }

    OutputTypeChooserToolBar(Prefs prefs, int numberOfOutputTypes, boolean newWindowIcon) {
        this.prefs = prefs;
        this.numberOfOutputTypes = numberOfOutputTypes;
        this.buildGUI(newWindowIcon);
    }

    void buildGUI(boolean newWindowIcon) {
        this.setFloatable(false);
        this.setPreferredSize(new Dimension(50, 27));
        this.decrement = new JButton(IconBank.leftArrow);
        this.decrement.setToolTipText(Resources.getString("Previous"));
        this.increment = new JButton(IconBank.rightArrow);
        this.increment.setToolTipText(Resources.getString("Next"));
        this.newWindow = new JButton(IconBank.windows);
        this.newWindow.setToolTipText(Resources.getString("NewWindow"));
        this.tableLabel = new JLabel(this.getTableIcon());
        this.add(Box.createHorizontalGlue());
        this.add(this.decrement);
        this.add(this.tableLabel);
        this.add(this.increment);
        if (newWindowIcon) {
            this.add(Box.createHorizontalGlue());
            this.add(this.newWindow);
        }
    }

    ImageIcon getTableIcon() {
        ImageIcon tableIcon;
        switch (this.prefs.lastSelectedOutputType) {
            case 0: {
                tableIcon = IconBank.table;
                break;
            }
            case 1: {
                tableIcon = IconBank.twoTables;
                break;
            }
            case 2: {
                tableIcon = IconBank.threeTables;
                break;
            }
            default: {
                tableIcon = IconBank.table;
            }
        }
        return tableIcon;
    }

    public int getSelected() {
        return this.prefs.lastSelectedOutputType;
    }

    public void increment() {
        ++this.prefs.lastSelectedOutputType;
        if (this.prefs.lastSelectedOutputType >= this.numberOfOutputTypes) {
            this.prefs.lastSelectedOutputType = 0;
        }
        this.tableLabel.setIcon(this.getTableIcon());
    }

    public void decrement() {
        --this.prefs.lastSelectedOutputType;
        if (this.prefs.lastSelectedOutputType < 0) {
            this.prefs.lastSelectedOutputType = this.numberOfOutputTypes - 1;
        }
        this.tableLabel.setIcon(this.getTableIcon());
    }
}

