/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.Platform;
import abbot.tester.KeyStrokeMapProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.KeyStroke;

public class KeyStrokeMap
implements KeyStrokeMapProvider {
    private static Map keycodes = KeyStrokeMap.getKeyStrokeMap();
    private static Map chars = KeyStrokeMap.getCharacterMap();
    private static KeyStrokeMapProvider generator = null;
    private static Map characterMap = null;
    private static Map keyStrokeMap = null;
    private static boolean loaded = false;
    static /* synthetic */ Class class$abbot$tester$KeyStrokeMapProvider;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public static KeyStroke getKeyStroke(char ch) {
        return (KeyStroke)keycodes.get(new Character(ch));
    }

    public static char getChar(KeyStroke ks) {
        Character ch = (Character)chars.get(ks);
        if (ch == null) {
            int mask = ks.getModifiers() & 0xFFFFFFFE;
            ch = (Character)chars.get(ks = KeyStroke.getKeyStroke(ks.getKeyCode(), mask));
            if (ch == null) {
                return '\uffff';
            }
        }
        return ch.charValue();
    }

    private static KeyStrokeMapProvider getGenerator() {
        if (generator == null) {
            try {
                String gname = System.getProperty("abbot.keystroke_map_generator", "abbot.tester.KeyStrokeMap");
                if (gname != null) {
                    generator = (KeyStrokeMapProvider)Class.forName(gname).newInstance();
                }
            }
            catch (Exception e) {
                Log.warn(e);
            }
        }
        return generator;
    }

    private static Map getCharacterMap() {
        KeyStrokeMapProvider generator = KeyStrokeMap.getGenerator();
        Map m = generator != null ? generator.loadCharacterMap() : null;
        return m != null ? m : KeyStrokeMap.generateCharacterMappings();
    }

    private static Map generateCharacterMappings() {
        Log.debug("Generating default character mappings");
        HashMap map = new HashMap();
        Iterator iter = keycodes.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            map.put(keycodes.get(key), key);
        }
        return map;
    }

    private static Map getKeyStrokeMap() {
        KeyStrokeMapProvider generator = KeyStrokeMap.getGenerator();
        Map m = generator != null ? generator.loadKeyStrokeMap() : null;
        return m != null ? m : KeyStrokeMap.generateKeyStrokeMappings();
    }

    private static Map generateKeyStrokeMappings() {
        int i;
        KeyStroke stroke;
        Log.debug("Generating default keystroke mappings");
        int shift = 1;
        int ctrl = 2;
        int[][] universalMappings = new int[][]{{27, 27, 0}, {8, 8, 0}, {127, 127, 0}, {10, 10, 0}, {13, 10, 0}};
        int[][] mappings = new int[][]{{32, 32, 0}, {9, 9, 0}, {126, 192, shift}, {96, 192, 0}, {33, 49, shift}, {64, 50, shift}, {35, 51, shift}, {36, 52, shift}, {37, 53, shift}, {94, 54, shift}, {38, 55, shift}, {42, 56, shift}, {40, 57, shift}, {41, 48, shift}, {45, 45, 0}, {95, 45, shift}, {61, 61, 0}, {43, 61, shift}, {91, 91, 0}, {123, 91, shift}, {93, 93, 0}, {125, 93, shift}, {124, 92, shift}, {59, 59, 0}, {58, 59, shift}, {44, 44, 0}, {60, 44, shift}, {46, 46, 0}, {62, 46, shift}, {47, 47, 0}, {63, 47, shift}, {92, 92, 0}, {124, 92, shift}, {39, 222, 0}, {34, 222, shift}};
        HashMap<Character, KeyStroke> map = new HashMap<Character, KeyStroke>();
        for (int i2 = 0; i2 < universalMappings.length; ++i2) {
            int[] entry = universalMappings[i2];
            stroke = KeyStroke.getKeyStroke(entry[1], entry[2]);
            map.put(new Character((char)entry[0]), stroke);
        }
        Locale locale = Locale.getDefault();
        if (!Locale.US.equals(locale) && !Locale.UK.equals(locale)) {
            Log.debug("Not US: " + locale);
            return map;
        }
        for (i = 0; i < mappings.length; ++i) {
            int[] entry = mappings[i];
            KeyStroke stroke2 = KeyStroke.getKeyStroke(entry[1], entry[2]);
            map.put(new Character((char)entry[0]), stroke2);
        }
        for (i = 97; i <= 122; ++i) {
            stroke = KeyStroke.getKeyStroke(65 + i - 97, 0);
            map.put(new Character((char)i), stroke);
            stroke = KeyStroke.getKeyStroke(65 + i - 97, ctrl);
            Character key = new Character((char)(i - 97 + 1));
            if (map.get(key) != null) continue;
            map.put(key, stroke);
        }
        for (i = 65; i <= 90; ++i) {
            stroke = KeyStroke.getKeyStroke(65 + i - 65, shift);
            map.put(new Character((char)i), stroke);
        }
        for (i = 48; i <= 57; ++i) {
            stroke = KeyStroke.getKeyStroke(48 + i - 48, 0);
            map.put(new Character((char)i), stroke);
        }
        return map;
    }

    private static InputStream findMap() {
        String[] names = KeyStrokeMap.getMapNames();
        for (int i = 0; i < names.length; ++i) {
            Log.debug("Trying " + names[i]);
            String name = KeyStrokeMap.getFilename(names[i]);
            InputStream is = (class$abbot$tester$KeyStrokeMapProvider == null ? KeyStrokeMap.class$("abbot.tester.KeyStrokeMapProvider") : class$abbot$tester$KeyStrokeMapProvider).getResourceAsStream("keymaps/" + name);
            if (is == null) continue;
            return is;
        }
        return (class$abbot$tester$KeyStrokeMapProvider == null ? (class$abbot$tester$KeyStrokeMapProvider = KeyStrokeMap.class$("abbot.tester.KeyStrokeMapProvider")) : class$abbot$tester$KeyStrokeMapProvider).getResourceAsStream("keymaps/default.map");
    }

    private synchronized void loadMaps() {
        if (loaded) {
            return;
        }
        Properties props = new Properties();
        HashMap<KeyStroke, Character> cmap = null;
        HashMap<Character, KeyStroke> kmap = null;
        try {
            InputStream is = KeyStrokeMap.findMap();
            if (is == null) {
                Log.debug("No appropriate map file found");
                loaded = true;
                return;
            }
            props.load(is);
            Iterator<Object> iter = props.keySet().iterator();
            cmap = new HashMap<KeyStroke, Character>();
            kmap = new HashMap<Character, KeyStroke>();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Log.debug("Property " + key + "=" + props.getProperty(key));
                try {
                    String codeName = key.substring(0, key.indexOf("."));
                    int mask = Integer.parseInt(key.substring(key.indexOf(".") + 1), 16);
                    int value = Integer.parseInt(props.getProperty(key), 16);
                    Character ch = new Character((char)value);
                    Field field = (class$java$awt$event$KeyEvent == null ? KeyStrokeMap.class$("java.awt.event.KeyEvent") : class$java$awt$event$KeyEvent).getField("VK_" + codeName);
                    int code = field.getInt(null);
                    KeyStroke ks = KeyStroke.getKeyStroke(code, mask);
                    KeyStroke existing = (KeyStroke)kmap.get(ch);
                    if (existing == null || existing.getModifiers() != 0 && existing.getModifiers() != 1 || mask == 0 && (existing.getModifiers() != 0 || ks.toString().length() < existing.toString().length())) {
                        Log.debug("Installing " + ks + " for '" + ch + "'");
                        kmap.put(ch, ks);
                    }
                    cmap.put(ks, ch);
                }
                catch (NumberFormatException e) {
                }
                catch (Exception e) {
                    Log.warn(e);
                }
            }
        }
        catch (IOException io) {
            // empty catch block
        }
        Log.debug("Successfully loaded character/keystroke map");
        characterMap = cmap;
        keyStrokeMap = kmap;
        loaded = true;
    }

    public Map loadCharacterMap() {
        this.loadMaps();
        return characterMap;
    }

    public Map loadKeyStrokeMap() {
        this.loadMaps();
        return keyStrokeMap;
    }

    protected static String getFilename(String base) {
        return base + ".map";
    }

    protected static String[] getMapNames() {
        return KeyStrokeMap.getMapStrings(false);
    }

    protected static String[] getMapDescriptions() {
        return KeyStrokeMap.getMapStrings(true);
    }

    private static String[] getMapStrings(boolean desc) {
        ArrayList<String> list = new ArrayList<String>();
        Locale locale = Locale.getDefault();
        String name = locale.toString();
        if (desc) {
            name = "locale=" + name;
        }
        list.add(0, name);
        String os = "-" + KeyStrokeMap.getOSType();
        if (desc) {
            os = " (os=" + System.getProperty("os.name") + ", " + System.getProperty("os.version") + ")";
        }
        name = name + os;
        list.add(0, name);
        String override = System.getProperty("abbot.keyStrokeMap");
        if (override != null) {
            list.add(0, override);
        }
        return list.toArray(new String[list.size()]);
    }

    private static String getOSType() {
        return Platform.isMacintosh() ? "mac" : (Platform.isWindows() ? "w32" : "x11");
    }

    public static void main(String[] args) {
        Locale[] available = Locale.getAvailableLocales();
        System.out.println("Available Locales");
        for (int i = 0; i < available.length; ++i) {
            System.out.print(available[i].toString());
            System.out.print(" ");
        }
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

