/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.Platform;
import abbot.WaitTimedOutError;
import abbot.finder.BasicFinder;
import abbot.finder.ComponentNotFoundException;
import abbot.finder.MultipleComponentsFoundException;
import abbot.finder.matchers.JMenuItemMatcher;
import abbot.finder.matchers.JMenuMatcher;
import abbot.i18n.Strings;
import abbot.tester.AWTConstants;
import abbot.tester.ActionFailedException;
import abbot.tester.ComponentLocation;
import abbot.tester.ComponentMissingException;
import abbot.tester.ComponentNotShowingException;
import abbot.tester.ComponentTester;
import abbot.tester.InputState;
import abbot.tester.KeyStrokeMap;
import abbot.tester.RobotVerifier;
import abbot.tester.WindowTracker;
import abbot.util.AWT;
import abbot.util.Bugs;
import abbot.util.Condition;
import abbot.util.Properties;
import abbot.util.Reflector;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class Robot
implements AWTConstants {
    public static int EM_ROBOT = 0;
    public static int EM_AWT = 1;
    private static final String LABELED_BY_PROPERTY = "labeledBy";
    private static final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static final int MAX_DELAY = 60000;
    public static final int MOUSELESS_MODIFIER_MASK = 8;
    public static final String MOUSELESS_MODIFIER = AWT.getKeyModifiers(8);
    public static int defaultDelay = Properties.getProperty("abbot.robot.default_delay", 30000, 0, 60000);
    private static int eventPostDelay = Properties.getProperty("abbot.robot.event_post_delay", 100, 0, 1000);
    protected static long IDLE_TIMEOUT = Integer.getInteger("abbot.robot.idle_timeout", 10000).intValue();
    protected static int popupDelay = Properties.getProperty("abbot.robot.popup_delay", defaultDelay, 0, 60000);
    public static int componentDelay = Properties.getProperty("abbot.robot.component_delay", defaultDelay, 0, 60000);
    private static final int subMenuDelay = Platform.isOSX() ? 100 : 0;
    private static int eventMode = EM_ROBOT;
    private static boolean verified = false;
    private static boolean serviceMode = false;
    private static java.awt.Robot robot;
    private static WindowTracker tracker;
    private static InputState state;
    private static final int DEFAULT_DELAY;
    private static final int SLEEP_INTERVAL = 10;
    private static int autoDelay;
    private static final Runnable EMPTY_RUNNABLE;
    private static final int MAXIMIZE_BUTTON_OFFSET;
    private AWTEvent lastEventPosted = null;
    private MouseEvent lastMousePress = null;
    private boolean countingClicks = false;
    static /* synthetic */ Class class$java$awt$Toolkit;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$abbot$tester$Robot;

    protected static final boolean useScreenMenuBar() {
        return Platform.isOSX() && (Boolean.getBoolean("com.apple.macos.useScreenMenuBar") || Boolean.getBoolean("apple.laf.useScreenMenuBar"));
    }

    public static int getAutoDelay() {
        return autoDelay;
    }

    public static java.awt.Robot getRobot() {
        Robot.initializeRobot();
        return serviceMode ? null : robot;
    }

    public static InputState getState() {
        Robot.initializeRobot();
        return state;
    }

    private static synchronized void initializeRobot() {
        if (state == null) {
            robot = Robot.createRobot();
            tracker = WindowTracker.getTracker();
            state = new InputState();
        }
    }

    private static java.awt.Robot createRobot() {
        java.awt.Robot robot = null;
        String mode = System.getProperty("abbot.robot.mode", "robot");
        autoDelay = Properties.getProperty("abbot.robot.auto_delay", autoDelay, -1, 60000);
        try {
            robot = new java.awt.Robot();
            if (autoDelay != -1) {
                robot.setAutoDelay(autoDelay);
            } else {
                autoDelay = robot.getAutoDelay();
            }
            if (!verified) {
                boolean skip;
                verified = true;
                boolean bl = skip = !"false".equals(System.getProperty("abbot.robot.verify"));
                if (!skip && !RobotVerifier.verify(robot)) {
                    serviceMode = true;
                    System.err.println("Robot non-functional, falling back to AWT mode");
                    mode = "awt";
                }
            }
        }
        catch (AWTException e) {
            System.err.println("Falling back to AWT mode: " + e.getMessage());
            mode = "awt";
        }
        if (mode.equals("awt")) {
            eventMode = EM_AWT;
        }
        return robot;
    }

    public static int getEventMode() {
        Robot.initializeRobot();
        return eventMode;
    }

    public static String getEventModeDescription() {
        String desc;
        Robot.initializeRobot();
        String string = desc = eventMode == EM_ROBOT ? "robot" : "awt";
        if (serviceMode) {
            desc = desc + " (service)";
        }
        return desc;
    }

    public static void setEventMode(int mode) {
        Robot.initializeRobot();
        if (eventMode != mode) {
            if (mode == EM_ROBOT && (serviceMode || robot == null)) {
                String msg = Strings.get("tester.Robot.no_robot_mode");
                throw new IllegalStateException(msg);
            }
            eventMode = mode;
        }
    }

    public static int getEventPostDelay() {
        return eventPostDelay;
    }

    public static void setEventPostDelay(int delay) {
        eventPostDelay = Math.min(1000, Math.max(0, delay));
    }

    public static void setAutoDelay(int ms) {
        Robot.initializeRobot();
        ms = Math.min(60000, Math.max(0, ms));
        if (eventMode == EM_ROBOT) {
            robot.setAutoDelay(ms);
        }
        autoDelay = ms;
        Log.debug("Auto delay set to " + ms);
    }

    public Robot() {
        Robot.initializeRobot();
    }

    private void mouseMove(int x, int y) {
        if (eventMode == EM_ROBOT) {
            Log.debug("ROBOT: Mouse move: (" + x + "," + y + ")");
            robot.mouseMove(x, y);
        }
    }

    public void mousePress(int buttons) {
        if (eventMode == EM_ROBOT) {
            Log.debug("ROBOT: Mouse press: " + AWT.getMouseModifiers(buttons));
            robot.mousePress(buttons);
        } else {
            Component c = state.getMouseComponent();
            if (c == null) {
                Log.warn("No current mouse component for button press", 4);
                return;
            }
            Point where = state.getMouseLocation();
            this.postMousePress(c, where.x, where.y, buttons);
        }
    }

    public void mouseRelease() {
        this.mouseRelease(16);
    }

    public void mouseRelease(int buttons) {
        if (eventMode == EM_ROBOT) {
            Log.debug("ROBOT: Mouse release: " + AWT.getMouseModifiers(buttons));
            robot.mouseRelease(buttons);
        } else {
            Component source = state.isDragging() ? state.getDragSource() : (this.lastMousePress != null ? this.lastMousePress.getComponent() : state.getMouseComponent());
            Point where = state.getMouseLocation();
            if (source == null) {
                Log.warn("Mouse release outside of available frames");
                return;
            }
            if (where == null) {
                if (this.lastMousePress == null) {
                    Log.warn("No record of most recent mouse press");
                    return;
                }
                where = this.lastMousePress.getPoint();
            }
            this.postMouseRelease(source, where.x, where.y, buttons);
        }
    }

    public void focus(Component comp) {
        this.focus(comp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focus(final Component comp, boolean wait) {
        Component currentOwner = AWT.getFocusOwner();
        if (currentOwner == comp) {
            return;
        }
        Log.debug("Focus change");
        FocusWatcher fw = new FocusWatcher(comp);
        this.mouseMove(comp, comp.getWidth() / 2, comp.getHeight() / 2);
        this.waitForIdle();
        Window w1 = currentOwner != null ? AWT.getWindow(currentOwner) : null;
        Window w2 = AWT.getWindow(comp);
        if (w1 != w2) {
            this.activate(w2);
            this.waitForIdle();
        }
        this.invokeAndWait(comp, new Runnable(){

            public void run() {
                comp.requestFocus();
            }
        });
        try {
            if (wait) {
                long start = System.currentTimeMillis();
                while (!fw.focused) {
                    if (System.currentTimeMillis() - start > (long)componentDelay) {
                        String msg = Strings.get("tester.Robot.focus_failed", new Object[]{Robot.toString(comp)});
                        throw new ActionFailedException(msg);
                    }
                    this.sleep();
                }
            }
        }
        finally {
            comp.removeFocusListener(fw);
        }
    }

    protected EventQueue getEventQueue(Component c) {
        return c != null ? tracker.getQueue(c) : toolkit.getSystemEventQueue();
    }

    public void invokeLater(Component context, Runnable action) {
        EventQueue queue = this.getEventQueue(context);
        queue.postEvent(new InvocationEvent((Object)toolkit, action));
    }

    public void invokeAndWait(Component c, Runnable action) {
        this.invokeLater(c, action);
        this.waitForIdle();
    }

    public void invokeAction(Runnable action) {
        this.invokeLater(action);
    }

    public void invokeAction(Component c, Runnable action) {
        this.invokeLater(c, action);
    }

    public void invokeLater(Runnable action) {
        this.invokeLater(null, action);
    }

    public void invokeAndWait(Runnable action) {
        this.invokeAndWait(null, action);
    }

    public void keyPress(int keycode) {
        this.keyPress(keycode, '\uffff');
    }

    private void keyPress(int keycode, char keyChar) {
        if (eventMode == EM_ROBOT) {
            Log.debug("ROBOT: key press " + AWT.getKeyCode(keycode));
            try {
                robot.keyPress(keycode);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid key code " + keycode + " (char " + keyChar + ")");
            }
        } else {
            int mods = state.getModifiers();
            if (AWT.isModifier(keycode)) {
                mods |= AWT.keyCodeToMask(keycode);
            }
            this.postKeyEvent(401, mods, keycode, '\uffff');
            int mask = state.getModifiers();
            if (keyChar == '\uffff') {
                KeyStroke ks = KeyStroke.getKeyStroke(keycode, mask);
                keyChar = KeyStrokeMap.getChar(ks);
            }
            if (keyChar != '\uffff') {
                this.postKeyEvent(400, mask, 0, keyChar);
            }
        }
    }

    public void keyRelease(int keycode) {
        if (eventMode == EM_ROBOT) {
            int KEY_INPUT_DELAY;
            Log.debug("ROBOT: key release " + AWT.getKeyCode(keycode));
            robot.keyRelease(keycode);
            if (Bugs.hasKeyInputDelay() && (KEY_INPUT_DELAY = 200) > autoDelay) {
                this.delay(KEY_INPUT_DELAY - autoDelay);
            }
        } else {
            int mods = state.getModifiers();
            if (AWT.isModifier(keycode)) {
                mods &= ~AWT.keyCodeToMask(keycode);
            }
            this.postKeyEvent(402, mods, keycode, '\uffff');
        }
    }

    private void postKeyEvent(int id, int modifiers, int keycode, char ch) {
        Component c = this.findFocusOwner();
        if (c != null) {
            this.postEvent(c, new KeyEvent(c, id, System.currentTimeMillis(), modifiers, keycode, ch));
        } else {
            Log.warn("No component has focus, key press discarded");
        }
    }

    public void sleep() {
        this.delay(10);
    }

    public void delay(int ms) {
        if (eventMode == EM_ROBOT) {
            while (ms > 60000) {
                robot.delay(60000);
                ms -= 60000;
            }
            robot.delay(ms);
        } else {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected boolean queueBlocked() {
        return this.postInvocationEvent(toolkit.getSystemEventQueue(), toolkit, 200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean postInvocationEvent(EventQueue eq, Toolkit toolkit, long timeout) {
        RobotIdleLock lock;
        class RobotIdleLock {
            RobotIdleLock() {
            }
        }
        RobotIdleLock robotIdleLock = lock = new RobotIdleLock();
        synchronized (robotIdleLock) {
            eq.postEvent(new InvocationEvent((Object)toolkit, EMPTY_RUNNABLE, lock, true));
            long start = System.currentTimeMillis();
            try {
                lock.wait(timeout);
                return System.currentTimeMillis() - start >= IDLE_TIMEOUT;
            }
            catch (InterruptedException e) {
                Log.warn("Invocation lock interrupted");
            }
        }
        return false;
    }

    private void waitForIdle(EventQueue eq) {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Cannot call method from the event dispatcher thread");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        do {
            if (this.postInvocationEvent(eq, toolkit, IDLE_TIMEOUT)) {
                Log.warn("Timed out waiting for idle (posted invocation event): " + IDLE_TIMEOUT + "ms (after " + count + " events)" + " posted to " + eq, 0);
                break;
            }
            if (System.currentTimeMillis() - start > IDLE_TIMEOUT) {
                Log.warn("Timed out waiting for idle event queue after " + count + " events");
                break;
            }
            ++count;
            this.sleep();
        } while (eq.peekEvent() != null);
    }

    public void waitForIdle() {
        Collection queues;
        if (eventPostDelay > autoDelay) {
            this.delay(eventPostDelay - autoDelay);
        }
        if ((queues = tracker.getEventQueues()).size() == 1) {
            this.waitForIdle(toolkit.getSystemEventQueue());
        } else {
            Iterator iter = queues.iterator();
            while (iter.hasNext()) {
                EventQueue eq = (EventQueue)iter.next();
                this.waitForIdle(eq);
            }
        }
    }

    public Color sample(int x, int y) {
        if (robot != null && !serviceMode) {
            return robot.getPixelColor(x, y);
        }
        String msg = Strings.get("tester.Robot.no_sample");
        throw new UnsupportedOperationException(msg);
    }

    public Color sample(Component c, int x, int y) {
        return this.sample(c, new ComponentLocation(new Point(x, y)));
    }

    public Color sample(Component c, ComponentLocation loc) {
        Point p = loc.getPoint(c);
        Point where = AWT.getLocationOnScreen(c);
        where.translate(p.x, p.y);
        return this.sample(where.x, where.y);
    }

    public BufferedImage capture(Rectangle bounds) {
        Log.debug("Screen capture " + bounds);
        BufferedImage image = null;
        if (robot != null) {
            image = robot.createScreenCapture(bounds);
        }
        return image;
    }

    public BufferedImage capture(Component comp) {
        return this.capture(comp, true);
    }

    public BufferedImage capture(Component comp, boolean ignoreBorder) {
        Insets insets;
        Rectangle bounds = new Rectangle(comp.getSize());
        Point loc = AWT.getLocationOnScreen(comp);
        bounds.setLocation(loc.x, loc.y);
        Log.debug("Component bounds " + bounds);
        if (ignoreBorder && (insets = ((Container)comp).getInsets()) != null) {
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            Log.debug("Component insets " + insets);
        }
        return this.capture(bounds);
    }

    protected void jitter(Component comp, int x, int y) {
        Log.debug("jitter");
        this.mouseMove(comp, x > 0 ? x - 1 : x + 1, y);
    }

    protected void jitter(int x, int y) {
        this.mouseMove(x > 0 ? x - 1 : x + 1, y);
    }

    public void mouseMove(Component comp) {
        this.mouseMove(comp, comp.getWidth() / 2, comp.getHeight() / 2);
    }

    private boolean waitForComponent(Component c, long delay) {
        if (!this.isReadyForInput(c)) {
            Log.debug("Waiting for component to show: " + Robot.toString(c));
            long start = System.currentTimeMillis();
            while (!this.isReadyForInput(c)) {
                Component invoker;
                if (c instanceof JPopupMenu && (invoker = ((JPopupMenu)c).getInvoker()) instanceof JMenu) {
                    this.jitter(invoker, invoker.getWidth() / 2, invoker.getHeight() / 2);
                }
                if (System.currentTimeMillis() - start > delay) {
                    Log.warn("Component " + Robot.toString(c) + " (" + Integer.toHexString(c.hashCode()) + ")" + " not ready after " + delay + "ms: " + "showing=" + c.isShowing() + " win ready=" + tracker.isWindowReady(AWT.getWindow(c)));
                    return false;
                }
                this.sleep();
            }
        }
        return true;
    }

    public void mouseMove(Component comp, int x, int y) {
        if (!this.waitForComponent(comp, componentDelay)) {
            String msg = "Can't obtain position of component " + Robot.toString(comp);
            throw new ComponentNotShowingException(msg);
        }
        if (eventMode == EM_ROBOT) {
            try {
                Point point = AWT.getLocationOnScreen(comp);
                if (point != null) {
                    point.translate(x, y);
                    this.mouseMove(point.x, point.y);
                }
            }
            catch (IllegalComponentStateException e) {}
        } else {
            Component eventSource = comp;
            int id = 503;
            boolean outside = false;
            if (state.isDragging()) {
                id = 506;
                eventSource = state.getDragSource();
            } else {
                Point pt = new Point(x, y);
                eventSource = comp = AWT.retargetMouseEvent(comp, id, pt);
                x = pt.x;
                y = pt.y;
                outside = x < 0 || y < 0 || x >= comp.getWidth() || y >= comp.getHeight();
            }
            Component current = state.getMouseComponent();
            if (current != comp) {
                if (outside && current != null) {
                    Point pt = SwingUtilities.convertPoint(comp, x, y, current);
                    this.postMouseMotion(current, 505, pt);
                    return;
                }
                this.postMouseMotion(comp, 504, new Point(x, y));
            }
            Point pt = new Point(x, y);
            if (id == 506) {
                pt = SwingUtilities.convertPoint(comp, pt, eventSource);
            }
            this.postMouseMotion(eventSource, id, pt);
            if (outside) {
                this.postMouseMotion(comp, 505, new Point(x, y));
            }
        }
    }

    public void dragOver(Component dst, int x, int y) {
        this.mouseMove(dst, x - 4, y);
        this.mouseMove(dst, x, y);
    }

    public void drag(Component src, int sx, int sy) {
        this.drag(src, sx, sy, 16);
    }

    public void drag(Component src, int sx, int sy, int buttons) {
        if (Bugs.dragDropRequiresNativeEvents() && eventMode != EM_ROBOT && !Boolean.getBoolean("abbot.ignore_drag_error")) {
            String msg = Strings.get("abbot.Robot.no_drag_available");
            if (serviceMode) {
                throw new ActionFailedException(msg);
            }
            Log.warn(msg);
        }
        Log.debug("drag");
        int DRAG_DELAY = Properties.getProperty("abbot.robot.drag_delay", Platform.isX11() || Platform.isOSX() ? 100 : 0, 0, 60000);
        this.mousePress(src, sx, sy, buttons);
        if (DRAG_DELAY > autoDelay) {
            this.delay(DRAG_DELAY);
        }
        if (Platform.isWindows() || Platform.isMacintosh()) {
            int dy;
            int dx = sx + AWTConstants.DRAG_THRESHOLD < src.getWidth() ? AWTConstants.DRAG_THRESHOLD : 0;
            int n = dy = sy + AWTConstants.DRAG_THRESHOLD < src.getHeight() ? AWTConstants.DRAG_THRESHOLD : 0;
            if (dx == 0 && dy == 0) {
                dx = AWTConstants.DRAG_THRESHOLD;
            }
            this.mouseMove(src, sx + dx / 4, sy + dy / 4);
            this.mouseMove(src, sx + dx / 2, sy + dy / 2);
            this.mouseMove(src, sx + dx, sy + dy);
            this.mouseMove(src, sx + dx + 1, sy + dy);
        } else {
            this.mouseMove(src, sx + AWTConstants.DRAG_THRESHOLD / 2, sy + AWTConstants.DRAG_THRESHOLD / 2);
            this.mouseMove(src, sx + AWTConstants.DRAG_THRESHOLD, sy + AWTConstants.DRAG_THRESHOLD);
            this.mouseMove(src, sx + AWTConstants.DRAG_THRESHOLD / 2, sy + AWTConstants.DRAG_THRESHOLD / 2);
            this.mouseMove(src, sx, sy);
        }
        Log.debug("drag started");
    }

    public void drop(Component target, int x, int y) {
        Log.debug("drop");
        int DROP_DELAY = Properties.getProperty("abbot.robot.drop_delay", Platform.isWindows() ? 200 : 0, 0, 60000);
        this.dragOver(target, x, y);
        long start = System.currentTimeMillis();
        while (!state.isDragging()) {
            if (System.currentTimeMillis() - start > (long)(eventPostDelay * 4)) {
                String msg = Strings.get("Robot.no_current_drag");
                throw new ActionFailedException(msg);
            }
            this.sleep();
        }
        if (DROP_DELAY > autoDelay) {
            this.delay(DROP_DELAY - autoDelay);
        }
        this.mouseRelease(state.getButtons());
        Log.debug("dropped");
    }

    private void postMouseMotion(Component dst, int id, Point to) {
        if (id != 506) {
            dst = AWT.retargetMouseEvent(dst, id, to);
        }
        if (state.getMouseComponent() != dst || !to.equals(state.getMouseLocation())) {
            this.postEvent(dst, new MouseEvent(dst, id, System.currentTimeMillis(), state.getModifiers(), to.x, to.y, state.getClickCount(), false));
        }
    }

    public void key(int keycode) {
        this.key(keycode, 0);
    }

    public void setModifiers(int modifiers, boolean press) {
        boolean meta;
        boolean altGraph = (modifiers & 0x20) != 0;
        boolean shift = (modifiers & 1) != 0;
        boolean alt = (modifiers & 8) != 0;
        boolean ctrl = (modifiers & 2) != 0;
        boolean bl = meta = (modifiers & 4) != 0;
        if (press) {
            if (altGraph) {
                this.keyPress(65406);
            }
            if (alt) {
                this.keyPress(18);
            }
            if (shift) {
                this.keyPress(16);
            }
            if (ctrl) {
                this.keyPress(17);
            }
            if (meta) {
                this.keyPress(157);
            }
        } else {
            if (meta) {
                this.keyRelease(157);
            }
            if (ctrl) {
                this.keyRelease(17);
            }
            if (shift) {
                this.keyRelease(16);
            }
            if (alt) {
                this.keyRelease(18);
            }
            if (altGraph) {
                this.keyRelease(65406);
            }
        }
    }

    public void key(int keycode, int modifiers) {
        this.key('\uffff', keycode, modifiers);
    }

    private void key(char ch, int keycode, int modifiers) {
        Log.debug("key keycode=" + AWT.getKeyCode(keycode) + " mod=" + AWT.getKeyModifiers(modifiers));
        boolean isModifier = true;
        switch (keycode) {
            case 65406: {
                modifiers |= 0x20;
                break;
            }
            case 18: {
                modifiers |= 8;
                break;
            }
            case 16: {
                modifiers |= 1;
                break;
            }
            case 17: {
                modifiers |= 2;
                break;
            }
            case 157: {
                modifiers |= 4;
                break;
            }
            default: {
                isModifier = false;
            }
        }
        this.setModifiers(modifiers, true);
        if (!isModifier) {
            this.keyPress(keycode, ch);
            this.keyRelease(keycode);
        }
        this.setModifiers(modifiers, false);
        if (Bugs.hasKeyStrokeGenerationBug()) {
            this.delay(100);
        }
    }

    public void keyStroke(char ch) {
        KeyStroke ks = KeyStrokeMap.getKeyStroke(ch);
        if (ks == null) {
            Log.debug("No key mapping for '" + ch + "'");
            Component focus = this.findFocusOwner();
            if (focus == null) {
                Log.warn("No component has focus, keystroke discarded", 0);
                return;
            }
            KeyEvent ke = new KeyEvent(focus, 400, System.currentTimeMillis(), 0, 0, ch);
            if (eventMode == EM_ROBOT) {
                this.waitForIdle();
            }
            this.postEvent(focus, ke);
        } else {
            int keycode = ks.getKeyCode();
            int mod = ks.getModifiers();
            Log.debug("Char '" + ch + "' generated by keycode=" + keycode + " mod=" + mod);
            this.key(ch, keycode, mod);
        }
    }

    public void keyString(String str) {
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            this.keyStroke(ch[i]);
        }
    }

    public void mousePress(Component comp) {
        this.mousePress(comp, 16);
    }

    public void mousePress(Component comp, int mask) {
        this.mousePress(comp, comp.getWidth() / 2, comp.getHeight() / 2, mask);
    }

    public void mousePress(Component comp, int x, int y) {
        this.mousePress(comp, x, y, 16);
    }

    public void mousePress(Component comp, int x, int y, int mask) {
        if (eventMode == EM_ROBOT && Bugs.hasRobotMotionBug()) {
            this.jitter(comp, x, y);
        }
        this.mouseMove(comp, x, y);
        if (eventMode == EM_ROBOT) {
            this.mousePress(mask);
        } else {
            this.postMousePress(comp, x, y, mask);
        }
    }

    private void postMousePress(Component comp, int x, int y, int mask) {
        long delta;
        long when = this.lastMousePress != null ? this.lastMousePress.getWhen() : 0L;
        long now = System.currentTimeMillis();
        int count = 1;
        Point where = new Point(x, y);
        comp = AWT.retargetMouseEvent(comp, 501, where);
        if (this.countingClicks && comp == this.lastMousePress.getComponent() && (delta = now - when) < 250L) {
            count = state.getClickCount() + 1;
        }
        this.postEvent(comp, new MouseEvent(comp, 501, now, state.getKeyModifiers() | mask, where.x, where.y, count, AWTConstants.POPUP_ON_PRESS && (mask & AWTConstants.POPUP_MASK) != 0));
    }

    private void postMouseRelease(Component c, int x, int y, int mask) {
        long now = System.currentTimeMillis();
        int count = state.getClickCount();
        Point where = new Point(x, y);
        c = AWT.retargetMouseEvent(c, 501, where);
        this.postEvent(c, new MouseEvent(c, 502, now, state.getKeyModifiers() | mask, where.x, where.y, count, !AWTConstants.POPUP_ON_PRESS && (mask & AWTConstants.POPUP_MASK) != 0));
    }

    public final void click(Component comp) {
        this.click(comp, comp.getWidth() / 2, comp.getHeight() / 2);
    }

    public final void click(Component comp, int mask) {
        this.click(comp, comp.getWidth() / 2, comp.getHeight() / 2, mask);
    }

    public final void click(Component comp, int x, int y) {
        this.click(comp, x, y, 16);
    }

    public final void click(Component comp, int x, int y, int mask) {
        this.click(comp, x, y, mask, 1);
    }

    public void click(Component comp, int x, int y, int mask, int count) {
        Log.debug("Click at (" + x + "," + y + ") on " + Robot.toString(comp) + (count > 1 ? " count=" + count : ""));
        int keyModifiers = mask & 0xFFFFFFE3;
        mask &= 0x1C;
        this.setModifiers(keyModifiers, true);
        int oldDelay = Robot.getAutoDelay();
        if (count > 1 && oldDelay * 2 > 200) {
            Robot.setAutoDelay(0);
        }
        long last = System.currentTimeMillis();
        this.mousePress(comp, x, y, mask);
        while (count-- > 1) {
            this.mouseRelease(mask);
            long delta = System.currentTimeMillis() - last;
            if (delta > 250L) {
                Log.warn("Unexpected delay in multi-click: " + delta);
            }
            last = System.currentTimeMillis();
            this.mousePress(mask);
        }
        Robot.setAutoDelay(oldDelay);
        this.mouseRelease(mask);
        this.setModifiers(keyModifiers, false);
    }

    public void selectAWTMenuItemByLabel(Frame frame, String path) {
        this.selectAWTMenuItem(frame, path);
    }

    public void selectAWTMenuItem(Frame frame, String path) {
        MenuBar mb = frame.getMenuBar();
        if (mb == null) {
            String msg = Strings.get("tester.Robot.no_menu_bar", new Object[]{Robot.toString(frame)});
            throw new ActionFailedException(msg);
        }
        MenuItem[] items = AWT.findAWTMenuItems(frame, path);
        if (items.length == 0) {
            String msg = Strings.get("tester.Robot.no_menu_item", new Object[]{path, Robot.toString(frame)});
            throw new ActionFailedException(msg);
        }
        if (items.length > 1) {
            String msg = Strings.get("tester.Robot.multiple_menu_items");
            throw new ActionFailedException(msg);
        }
        this.selectAWTMenuItem(items[0]);
    }

    public void selectAWTPopupMenuItemByLabel(Component invoker, String path) {
        this.selectAWTPopupMenuItem(invoker, path);
    }

    public void selectAWTPopupMenuItem(Component invoker, String path) {
        try {
            PopupMenu[] popups = AWT.getPopupMenus(invoker);
            if (popups.length == 0) {
                throw new ActionFailedException(Strings.get("tester.Robot.awt_popup_missing"));
            }
            MenuItem[] items = AWT.findAWTPopupMenuItems(invoker, path);
            if (items.length == 1) {
                this.selectAWTPopupMenuItem(items[0]);
                return;
            }
            if (items.length == 0) {
                String msg = Strings.get("tester.Robot.no_popup_menu_item", new Object[]{path, Robot.toString(invoker)});
                throw new ActionFailedException(msg);
            }
            String msg = Strings.get("tester.Robot.multiple_menu_items", new Object[]{path});
            throw new ActionFailedException(msg);
        }
        finally {
            AWT.dismissAWTPopup();
        }
    }

    protected void fireAccessibleAction(Component context, final AccessibleAction action, String name) {
        if (action == null || action.getAccessibleActionCount() <= 0) {
            String msg = Strings.get("tester.Robot.no_accessible_action", new String[]{name});
            throw new ActionFailedException(msg);
        }
        this.invokeLater(context, new Runnable(){

            public void run() {
                action.doAccessibleAction(0);
            }
        });
    }

    private Component getContext(MenuComponent item) {
        while (!(item.getParent() instanceof Component) && item.getParent() instanceof MenuComponent) {
            item = (MenuComponent)((Object)item.getParent());
        }
        return (Component)item.getParent();
    }

    public void selectAWTMenuItem(MenuComponent item) {
        this.fireAccessibleAction(this.getContext(item), item.getAccessibleContext().getAccessibleAction(), Robot.toString(item));
        if (this.queueBlocked()) {
            this.key(27);
        }
    }

    public void selectAWTPopupMenuItem(MenuComponent item) {
        this.fireAccessibleAction(this.getContext(item), item.getAccessibleContext().getAccessibleAction(), Robot.toString(item));
        if (this.queueBlocked()) {
            this.key(27);
        }
    }

    protected boolean isReadyForInput(Component c) {
        if (eventMode == EM_AWT) {
            return c.isShowing();
        }
        Window w = AWT.getWindow(c);
        if (w == null) {
            throw new ActionFailedException("Component '" + Robot.toString(c) + "' has no Window ancestor");
        }
        return c.isShowing() && tracker.isWindowReady(w);
    }

    private boolean isOnJMenuBar(Component item) {
        if (item instanceof JMenuBar) {
            return true;
        }
        Component parent = item instanceof JPopupMenu ? ((JPopupMenu)item).getInvoker() : item.getParent();
        return parent != null && this.isOnJMenuBar(parent);
    }

    public void selectMenuItem(Component sameWindow, String path) {
        try {
            Window window = AWT.getWindow(sameWindow);
            List selectionPath = JMenuItemMatcher.splitMenuPath(path);
            int i = selectionPath.size();
            Container context = window;
            for (int j = 0; j < i; ++j) {
                String nextPath = (String)selectionPath.get(j);
                JMenuItemMatcher m = j == i - 1 ? new JMenuItemMatcher(nextPath) : new JMenuMatcher(nextPath);
                Component item = BasicFinder.getDefault().find(context, m);
                this.selectMenuItem(item);
                this.waitForIdle();
                context = (Container)item;
            }
        }
        catch (ComponentNotFoundException e) {
            throw new ComponentMissingException("Can't find menu item '" + path + "'");
        }
        catch (MultipleComponentsFoundException e) {
            throw new ActionFailedException(e.getMessage());
        }
    }

    public void selectMenuItem(Component item) {
        Window win;
        Log.debug("Selecting menu item " + Robot.toString(item));
        Component parent = item.getParent();
        JPopupMenu parentPopup = null;
        if (parent instanceof JPopupMenu) {
            parentPopup = (JPopupMenu)parent;
            parent = ((JPopupMenu)parent).getInvoker();
        }
        boolean inMenuBar = parent instanceof JMenuBar;
        boolean isMenu = item instanceof JMenu;
        if (this.isOnJMenuBar(item) && Robot.useScreenMenuBar()) {
            this.fireAccessibleAction(item, item.getAccessibleContext().getAccessibleAction(), Robot.toString(item));
            return;
        }
        if (parent instanceof JMenuItem && (parentPopup == null || !parentPopup.isShowing())) {
            Log.debug("Opening parent menu " + Robot.toString(parent));
            this.selectMenuItem(parent);
        }
        if (inMenuBar && (win = AWT.getWindow(parent)) != null) {
            this.invokeAndWait(win, new Runnable(){

                public void run() {
                    win.toFront();
                }
            });
            this.mouseMove(win);
        }
        if (isMenu && !inMenuBar && subMenuDelay > autoDelay) {
            this.delay(subMenuDelay - autoDelay);
        }
        Log.debug("Activating menu item " + Robot.toString(item));
        if (!item.isEnabled()) {
            throw new ActionFailedException("Menu item " + Robot.toString(item) + " is disabled");
        }
        this.click(item);
        this.waitForIdle();
        if (isMenu) {
            JPopupMenu popup = ((JMenu)item).getPopupMenu();
            if (!this.waitForComponent(popup, popupDelay)) {
                String msg = "Clicking on '" + ((JMenu)item).getText() + "' never produced a popup menu";
                throw new ComponentMissingException(msg);
            }
            if (subMenuDelay > autoDelay) {
                this.delay(subMenuDelay - autoDelay);
            }
        }
    }

    public void selectPopupMenuItem(Component invoker, ComponentLocation loc, String path) {
        Point where = loc.getPoint(invoker);
        if (where.x == -1) {
            where.x = invoker.getWidth() / 2;
        }
        if (where.y == -1) {
            where.y = invoker.getHeight() / 2;
        }
        Component popup = this.showPopupMenu(invoker, where.x, where.y);
        try {
            List selectionPath = JMenuItemMatcher.splitMenuPath(path);
            Container context = (Container)popup;
            int i = selectionPath.size();
            for (int j = 0; j < i; ++j) {
                JMenuItemMatcher m = new JMenuItemMatcher((String)selectionPath.get(j));
                Component item = BasicFinder.getDefault().find(context, m);
                this.selectMenuItem(item);
                this.waitForIdle();
                context = (Container)item;
            }
        }
        catch (ComponentNotFoundException e) {
            throw new ComponentMissingException("Can't find menu item '" + path + "'");
        }
        catch (MultipleComponentsFoundException e) {
            throw new ActionFailedException(e.getMessage());
        }
    }

    public Component showPopupMenu(Component invoker) {
        return this.showPopupMenu(invoker, invoker.getWidth() / 2, invoker.getHeight() / 2);
    }

    public Component showPopupMenu(Component invoker, int x, int y) {
        String where = " at (" + x + "," + y + ")";
        Log.debug("Invoking popup " + where);
        this.click(invoker, x, y, AWTConstants.POPUP_MASK);
        JPopupMenu popup = AWT.findActivePopupMenu();
        if (popup == null) {
            String msg = "No popup responded to " + AWTConstants.POPUP_MODIFIER + where + " on " + Robot.toString(invoker);
            throw new ComponentMissingException(msg);
        }
        int POPUP_DELAY = 10000;
        long start = System.currentTimeMillis();
        while (!this.isReadyForInput(SwingUtilities.getWindowAncestor(popup)) && System.currentTimeMillis() - start > (long)POPUP_DELAY) {
            this.sleep();
        }
        return popup;
    }

    public void activate(final Window win) {
        this.invokeAndWait(win, new Runnable(){

            public void run() {
                win.toFront();
                win.toFront();
            }
        });
        this.mouseMove(win);
    }

    protected Point getCloseLocation(Container c) {
        Dimension size = c.getSize();
        Insets insets = c.getInsets();
        if (Platform.isOSX()) {
            return new Point(insets.left + 15, insets.top / 2);
        }
        return new Point(size.width - insets.right - 10, insets.top / 2);
    }

    public void close(Window w) {
        if (w.isShowing()) {
            try {
                Point p = this.getCloseLocation(w);
                this.mouseMove(w, p.x, p.y);
            }
            catch (Exception e) {
                // empty catch block
            }
            WindowEvent ev = new WindowEvent(w, 201);
            Applet applet = AWT.findAppletDescendent(w);
            EventQueue eq = tracker.getQueue(applet != null ? applet : w);
            eq.postEvent(ev);
        }
    }

    protected Point getMoveLocation(Container c) {
        Dimension size = c.getSize();
        Insets insets = c.getInsets();
        return new Point(size.width / 2, insets.top / 2);
    }

    public void move(Container comp, int newx, int newy) {
        Point loc = AWT.getLocationOnScreen(comp);
        this.moveBy(comp, newx - loc.x, newy - loc.y);
    }

    public void moveBy(final Container comp, final int dx, final int dy) {
        Point p;
        final Point loc = AWT.getLocationOnScreen(comp);
        boolean userMovable = this.userMovable(comp);
        if (userMovable) {
            p = this.getMoveLocation(comp);
            this.mouseMove(comp, p.x, p.y);
            this.mouseMove(comp, p.x + dx, p.y + dy);
        }
        this.invokeAndWait(comp, new Runnable(){

            public void run() {
                comp.setLocation(new Point(loc.x + dx, loc.y + dy));
            }
        });
        if (userMovable) {
            p = this.getMoveLocation(comp);
            this.mouseMove(comp, p.x, p.y);
        }
    }

    protected Point getResizeLocation(Container c) {
        Dimension size = c.getSize();
        Insets insets = c.getInsets();
        return new Point(size.width - insets.right / 2, size.height - insets.bottom / 2);
    }

    protected boolean userMovable(Component comp) {
        return comp instanceof Dialog || comp instanceof Frame || Robot.canMoveWindows();
    }

    protected boolean userResizable(Component comp) {
        if (comp instanceof Dialog) {
            return ((Dialog)comp).isResizable();
        }
        if (comp instanceof Frame) {
            return ((Frame)comp).isResizable();
        }
        return Robot.canResizeWindows();
    }

    public void resize(Container comp, int width, int height) {
        Dimension size = comp.getSize();
        this.resizeBy(comp, width - size.width, height - size.height);
    }

    public void resizeBy(final Container comp, final int dx, final int dy) {
        Point p;
        boolean userResizable = this.userResizable(comp);
        if (userResizable) {
            p = this.getResizeLocation(comp);
            this.mouseMove(comp, p.x, p.y);
            this.mouseMove(comp, p.x + dx, p.y + dy);
        }
        this.invokeAndWait(comp, new Runnable(){

            public void run() {
                comp.setSize(comp.getWidth() + dx, comp.getHeight() + dy);
            }
        });
        if (userResizable) {
            p = this.getResizeLocation(comp);
            this.mouseMove(comp, p.x, p.y);
        }
    }

    protected Point getIconifyLocation(Container c) {
        Dimension size = c.getSize();
        Insets insets = c.getInsets();
        Point loc = new Point();
        loc.y = insets.top / 2;
        if (Platform.isOSX()) {
            loc.x = 35;
        } else if (Platform.isWindows()) {
            int offset = Platform.isWindowsXP() ? 64 : 45;
            loc.x = size.width - insets.right - offset;
        }
        return loc;
    }

    protected Point getMaximizeLocation(Container c) {
        Point loc = this.getIconifyLocation(c);
        loc.x += MAXIMIZE_BUTTON_OFFSET;
        return loc;
    }

    public void iconify(final Frame frame) {
        Point loc = this.getIconifyLocation(frame);
        if (loc != null) {
            this.mouseMove(frame, loc.x, loc.y);
        }
        this.invokeLater(frame, new Runnable(){

            public void run() {
                frame.setState(1);
            }
        });
    }

    public void deiconify(Frame frame) {
        this.normalize(frame);
    }

    public void normalize(final Frame frame) {
        this.invokeLater(frame, new Runnable(){

            public void run() {
                frame.setState(0);
                if (Bugs.hasFrameDeiconifyBug()) {
                    frame.setVisible(true);
                }
            }
        });
    }

    public void maximize(final Frame frame) {
        Point loc = this.getMaximizeLocation(frame);
        if (loc != null) {
            this.mouseMove(frame, loc.x, loc.y);
        }
        this.invokeLater(frame, new Runnable(){

            public void run() {
                try {
                    int MAXIMIZED_BOTH = 6;
                    Boolean b = (Boolean)(class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = Robot.class$("java.awt.Toolkit")) : class$java$awt$Toolkit).getMethod("isFrameStateSupported", Integer.TYPE).invoke((Object)toolkit, new Integer(6));
                    if (!b.booleanValue() || serviceMode) {
                        throw new ActionFailedException("Platform won't maximize");
                    }
                    (class$java$awt$Frame == null ? (class$java$awt$Frame = Robot.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("setExtendedState", Integer.TYPE).invoke((Object)frame, new Integer(6));
                }
                catch (Exception e) {
                    Log.debug("Maximize not supported: " + e);
                    Rectangle rect = frame.getGraphicsConfiguration().getBounds();
                    frame.setLocation(rect.x, rect.y);
                    frame.setSize(rect.width, rect.height);
                }
            }
        });
    }

    public void sendEvent(AWTEvent event) {
        if (eventMode == EM_ROBOT) {
            int id = event.getID();
            Log.debug("Sending event id " + id);
            if (id >= 500 && id <= 507) {
                MouseEvent me = (MouseEvent)event;
                Component comp = me.getComponent();
                if (id == 503) {
                    this.mouseMove(comp, me.getX(), me.getY());
                } else if (id == 506) {
                    this.mouseMove(comp, me.getX(), me.getY());
                } else if (id == 501) {
                    this.mouseMove(comp, me.getX(), me.getY());
                    this.mousePress(me.getModifiers() & 0x1C);
                } else if (id == 504) {
                    this.mouseMove(comp, me.getX(), me.getY());
                } else if (id == 505) {
                    this.mouseMove(comp, me.getX(), me.getY());
                } else if (id == 502) {
                    this.mouseMove(comp, me.getX(), me.getY());
                    this.mouseRelease(me.getModifiers() & 0x1C);
                }
            } else if (id >= 400 && id <= 402) {
                KeyEvent ke = (KeyEvent)event;
                if (id == 401) {
                    this.keyPress(ke.getKeyCode());
                } else if (id == 402) {
                    this.keyRelease(ke.getKeyCode());
                }
            } else {
                Log.warn("Event not supported: " + event);
            }
        } else {
            this.postEvent((Component)event.getSource(), event);
        }
    }

    public static String getEventID(AWTEvent event) {
        switch (event.getID()) {
            case 503: {
                return "MOUSE_MOVED";
            }
            case 506: {
                return "MOUSE_DRAGGED";
            }
            case 501: {
                return "MOUSE_PRESSED";
            }
            case 500: {
                return "MOUSE_CLICKED";
            }
            case 502: {
                return "MOUSE_RELEASED";
            }
            case 504: {
                return "MOUSE_ENTERED";
            }
            case 505: {
                return "MOUSE_EXITED";
            }
            case 401: {
                return "KEY_PRESSED";
            }
            case 400: {
                return "KEY_TYPED";
            }
            case 402: {
                return "KEY_RELEASED";
            }
            case 200: {
                return "WINDOW_OPENED";
            }
            case 201: {
                return "WINDOW_CLOSING";
            }
            case 202: {
                return "WINDOW_CLOSED";
            }
            case 203: {
                return "WINDOW_ICONIFIED";
            }
            case 204: {
                return "WINDOW_DEICONIFIED";
            }
            case 205: {
                return "WINDOW_ACTIVATED";
            }
            case 206: {
                return "WINDOW_DEACTIVATED";
            }
            case 100: {
                return "COMPONENT_MOVED";
            }
            case 101: {
                return "COMPONENT_RESIZED";
            }
            case 102: {
                return "COMPONENT_SHOWN";
            }
            case 103: {
                return "COMPONENT_HIDDEN";
            }
            case 1004: {
                return "FOCUS_GAINED";
            }
            case 1005: {
                return "FOCUS_LOST";
            }
            case 1400: {
                return "HIERARCHY_CHANGED";
            }
            case 1401: {
                return "ANCESTOR_MOVED";
            }
            case 1402: {
                return "ANCESTOR_RESIZED";
            }
            case 800: {
                return "PAINT";
            }
            case 801: {
                return "UPDATE";
            }
            case 1001: {
                return "ACTION_PERFORMED";
            }
            case 1101: {
                return "CARET_POSITION_CHANGED";
            }
            case 1100: {
                return "INPUT_METHOD_TEXT_CHANGED";
            }
        }
        return Reflector.getFieldName(event.getClass(), event.getID(), "");
    }

    public static Class getCanonicalClass(Class refClass) {
        String className = refClass.getName();
        while (className.indexOf("$") != -1 || className.startsWith("javax.swing.plaf") || className.startsWith("com.apple.mrj")) {
            refClass = refClass.getSuperclass();
            className = refClass.getName();
        }
        return refClass;
    }

    public static String toString(Component comp) {
        if (comp == null) {
            return "(null)";
        }
        if (AWT.isTransientPopup(comp)) {
            boolean tooltip = AWT.isToolTip(comp);
            if (AWT.isHeavyweightPopup(comp)) {
                return tooltip ? Strings.get("component.heavyweight_tooltip") : Strings.get("component.heavyweight_popup");
            }
            if (AWT.isLightweightPopup(comp)) {
                return tooltip ? Strings.get("component.lightweight_tooltip") : Strings.get("component.lightweight_popup");
            }
        } else if (AWT.isSharedInvisibleFrame(comp)) {
            return Strings.get("component.default_frame");
        }
        String name = Robot.getDescriptiveName(comp);
        String classDesc = Robot.descriptiveClassName(comp.getClass());
        name = name == null ? (AWT.isContentPane(comp) ? Strings.get("component.content_pane") : (AWT.isGlassPane(comp) ? Strings.get("component.glass_pane") : (comp instanceof JLayeredPane ? Strings.get("component.layered_pane") : (comp instanceof JRootPane ? Strings.get("component.root_pane") : classDesc + " instance")))) : "'" + name + "' (" + classDesc + ")";
        return name;
    }

    public static String toString(Object obj) {
        if (obj instanceof Component) {
            return Robot.toString((Component)obj);
        }
        if (obj instanceof MenuBar) {
            return "MenuBar";
        }
        if (obj instanceof MenuItem) {
            return ((MenuItem)obj).getLabel();
        }
        return obj.toString();
    }

    protected static String descriptiveClassName(Class cls) {
        StringBuffer desc = new StringBuffer(Robot.simpleClassName(cls));
        Class coreClass = Robot.getCanonicalClass(cls);
        String coreClassName = coreClass.getName();
        while (!(coreClassName.startsWith("java.awt.") || coreClassName.startsWith("javax.swing.") || coreClassName.startsWith("java.applet."))) {
            coreClass = coreClass.getSuperclass();
            coreClassName = coreClass.getName();
        }
        if (!coreClass.equals(cls)) {
            desc.append("/");
            desc.append(Robot.simpleClassName(coreClass));
        }
        return desc.toString();
    }

    public static String toHierarchyPath(Component c) {
        StringBuffer buf = new StringBuffer();
        Container parent = c.getParent();
        if (parent != null) {
            buf.append(Robot.toHierarchyPath(parent));
            buf.append(":");
        }
        buf.append(Robot.descriptiveClassName(c.getClass()));
        String name = Robot.getDescriptiveName(c);
        if (name != null) {
            buf.append("(");
            buf.append(name);
            buf.append(")");
        } else if (parent != null && parent.getComponentCount() > 1 && c instanceof JPanel) {
            buf.append("[");
            buf.append(String.valueOf(Robot.getIndex(parent, c)));
            buf.append("]");
        }
        return buf.toString();
    }

    public static String toString(AWTEvent event) {
        String name = Robot.toString(event.getSource());
        String desc = Robot.getEventID(event);
        if (event.getID() == 401 || event.getID() == 402) {
            KeyEvent ke = (KeyEvent)event;
            desc = desc + " (" + AWT.getKeyCode(ke.getKeyCode());
            if (ke.getModifiers() != 0) {
                desc = desc + "/" + AWT.getKeyModifiers(ke.getModifiers());
            }
            desc = desc + ")";
        } else if (event.getID() == 1100) {
            desc = desc + " (" + ((InputMethodEvent)event).getCommittedCharacterCount() + ")";
        } else if (event.getID() == 400) {
            char ch = ((KeyEvent)event).getKeyChar();
            int mods = ((KeyEvent)event).getModifiers();
            desc = desc + " ('" + ch + (mods != 0 ? "/" + AWT.getKeyModifiers(mods) : "") + "')";
        } else if (event.getID() >= 500 && event.getID() <= 507) {
            MouseEvent me = (MouseEvent)event;
            if (me.getModifiers() != 0) {
                desc = desc + " <" + AWT.getMouseModifiers(me.getModifiers());
                if (me.getClickCount() > 1) {
                    desc = desc + "," + me.getClickCount();
                }
                desc = desc + ">";
            }
            desc = desc + " (" + me.getX() + "," + me.getY() + ")";
        } else if (event.getID() == 1400) {
            HierarchyEvent he = (HierarchyEvent)event;
            long flags = he.getChangeFlags();
            String type = "";
            String bar = "";
            if ((flags & 4L) != 0L) {
                type = type + (he.getComponent().isShowing() ? "" : "!") + "SHOWING";
                bar = "|";
            }
            if ((flags & 1L) != 0L) {
                type = type + bar + "PARENT:" + Robot.toString(he.getComponent().getParent());
                bar = "|";
            }
            if ((flags & 2L) != 0L) {
                type = type + bar + "DISPLAYABILITY";
            }
            desc = desc + " (" + type + ")";
        }
        return desc + " on " + name;
    }

    public static int getEventID(Class cls, String id) {
        return Reflector.getFieldValue(cls, id);
    }

    public static String simpleClassName(Class cls) {
        String name = cls.getName();
        int dot = name.lastIndexOf(".");
        return name.substring(dot + 1, name.length());
    }

    protected void postEvent(Component comp, AWTEvent ev) {
        if (Log.isClassDebugEnabled(class$abbot$tester$Robot == null ? (class$abbot$tester$Robot = Robot.class$("abbot.tester.Robot")) : class$abbot$tester$Robot)) {
            Log.debug("POST: " + Robot.toString(ev));
        }
        if (eventMode == EM_AWT && AWT.isAWTPopupMenuBlocking()) {
            throw new Error("Event queue is blocked by an active AWT PopupMenu");
        }
        state.update(ev);
        EventQueue q = this.getEventQueue(comp);
        q.postEvent(ev);
        this.delay(autoDelay);
        AWTEvent prev = this.lastEventPosted;
        this.lastEventPosted = ev;
        if (ev instanceof MouseEvent) {
            if (ev.getID() == 501) {
                this.lastMousePress = (MouseEvent)ev;
                this.countingClicks = true;
            } else if (ev.getID() != 502 && ev.getID() != 500) {
                this.countingClicks = false;
            }
        }
        if (eventMode == EM_AWT && ev.getID() == 502 && prev.getID() == 501) {
            MouseEvent me = (MouseEvent)ev;
            MouseEvent click = new MouseEvent(comp, 500, System.currentTimeMillis(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), false);
            this.postEvent(comp, click);
        }
    }

    public void wait(Condition condition) {
        this.wait(condition, (long)defaultDelay);
    }

    public void wait(Condition condition, long timeout) {
        this.wait(condition, timeout, 10);
    }

    public void wait(Condition condition, long timeout, int interval) {
        long start = System.currentTimeMillis();
        while (!condition.test()) {
            if (System.currentTimeMillis() - start > timeout) {
                String msg = "Timed out waiting for " + condition;
                throw new WaitTimedOutError(msg);
            }
            this.delay(interval);
        }
    }

    public void reset() {
        if (eventMode == EM_ROBOT) {
            Dimension d = toolkit.getScreenSize();
            this.mouseMove(d.width / 2, d.height / 2);
            this.mouseMove(d.width / 2 - 1, d.height / 2 - 1);
        } else {
            state.clear();
        }
    }

    public Component findFocusOwner() {
        return AWT.getFocusOwner();
    }

    public static String getDescriptiveName(Component c) {
        if (AWT.isSharedInvisibleFrame(c)) {
            return Strings.get("component.default_frame");
        }
        String name = Robot.getName(c);
        if (name != null || (name = Robot.getTitle(c)) != null || (name = Robot.getText(c)) != null || (name = Robot.getLabel(c)) != null || (name = Robot.getIconName(c)) == null) {
            // empty if block
        }
        return name;
    }

    public static String getName(Component c) {
        String name = AWT.hasDefaultName(c) ? null : c.getName();
        return name;
    }

    public static int getIndex(Container parent, Component comp) {
        if (comp instanceof Window) {
            Window[] owned = ((Window)parent).getOwnedWindows();
            for (int i = 0; i < owned.length; ++i) {
                if (owned[i] != comp) continue;
                return i;
            }
        } else {
            Component[] children = parent.getComponents();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] != comp) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getText(Component c) {
        if (c instanceof AbstractButton) {
            return ComponentTester.stripHTML(((AbstractButton)c).getText());
        }
        if (c instanceof JLabel) {
            return ComponentTester.stripHTML(((JLabel)c).getText());
        }
        if (c instanceof Label) {
            return ((Label)c).getText();
        }
        return null;
    }

    public static String getLabel(Component c) {
        String label = null;
        if (c instanceof JComponent) {
            Object obj = ((JComponent)c).getClientProperty(LABELED_BY_PROPERTY);
            if (obj != null) {
                if (obj instanceof JLabel) {
                    label = ((JLabel)obj).getText();
                } else if (obj instanceof String) {
                    label = (String)obj;
                }
            }
        } else if (c instanceof Button) {
            label = ((Button)c).getLabel();
        } else if (c instanceof Checkbox) {
            label = ((Checkbox)c).getLabel();
        }
        return ComponentTester.stripHTML(label);
    }

    public static String getIconName(Component c) {
        AccessibleIcon[] icons;
        String icon = null;
        AccessibleContext context = c.getAccessibleContext();
        if (context != null && (icons = context.getAccessibleIcon()) != null && icons.length > 0 && (icon = icons[0].getAccessibleIconDescription()) != null) {
            icon = icon.substring(icon.lastIndexOf("/") + 1);
            icon = icon.substring(icon.lastIndexOf("\\") + 1);
        }
        return icon;
    }

    public static String getBorderTitle(Component c) {
        String title = null;
        if (c instanceof JComponent) {
            title = Robot.getBorderTitle(((JComponent)c).getBorder());
        }
        return title;
    }

    private static String getBorderTitle(Border b) {
        String title = null;
        if (b instanceof TitledBorder) {
            title = ((TitledBorder)b).getTitle();
        } else if (b instanceof CompoundBorder && (title = Robot.getBorderTitle(((CompoundBorder)b).getInsideBorder())) == null) {
            title = Robot.getBorderTitle(((CompoundBorder)b).getOutsideBorder());
        }
        return title;
    }

    public static String getTitle(Component c) {
        if (c instanceof Dialog) {
            return ((Dialog)c).getTitle();
        }
        if (c instanceof Frame) {
            return ((Frame)c).getTitle();
        }
        if (c instanceof JInternalFrame) {
            return ((JInternalFrame)c).getTitle();
        }
        return null;
    }

    public static boolean canResizeWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static boolean canMoveWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static int getPreferredRobotAutoDelay() {
        return 30;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        autoDelay = DEFAULT_DELAY = Robot.getPreferredRobotAutoDelay();
        EMPTY_RUNNABLE = new Runnable(){

            public void run() {
            }
        };
        MAXIMIZE_BUTTON_OFFSET = Platform.isOSX() ? 25 : (Platform.isWindows() ? -20 : 0);
    }

    private class FocusWatcher
    extends FocusAdapter {
        public volatile boolean focused = false;

        public FocusWatcher(Component c) {
            c.addFocusListener(this);
            this.focused = AWT.getFocusOwner() == c;
        }

        public void focusGained(FocusEvent f) {
            this.focused = true;
        }

        public void focusLost(FocusEvent f) {
            this.focused = false;
        }
    }
}

