/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.abbot;

import abbot.Log;
import abbot.finder.BasicFinder;
import abbot.finder.ComponentFinder;
import abbot.finder.ComponentNotFoundException;
import abbot.finder.ComponentSearchException;
import abbot.finder.Hierarchy;
import abbot.finder.Matcher;
import abbot.finder.MultipleComponentsFoundException;
import abbot.finder.TestHierarchy;
import abbot.finder.matchers.WindowMatcher;
import abbot.tester.Robot;
import abbot.tester.WindowTracker;
import abbot.util.AWTFixtureHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import junit.framework.TestCase;

public abstract class ComponentTestFixture
extends TestCase {
    public static final int EVENT_GENERATION_DELAY = 5000;
    public static final int WINDOW_DELAY = 20000;
    public static final int POPUP_DELAY = 10000;
    protected static final Class[] DISPOSE_CLASSES = new Class[]{class$java$awt$Component == null ? (class$java$awt$Component = ComponentTestFixture.class$("java.awt.Component")) : class$java$awt$Component, class$abbot$tester$ComponentTester == null ? (class$abbot$tester$ComponentTester = ComponentTestFixture.class$("abbot.tester.ComponentTester")) : class$abbot$tester$ComponentTester};
    private AWTFixtureHelper fixtureHelper;
    private Throwable edtException;
    private long edtExceptionTime;
    private ComponentFinder finder;
    private Hierarchy hierarchy;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$abbot$tester$ComponentTester;

    protected Robot getRobot() {
        return this.fixtureHelper.getRobot();
    }

    protected WindowTracker getWindowTracker() {
        return this.fixtureHelper.getWindowTracker();
    }

    protected void sleep() {
        this.getRobot().sleep();
    }

    protected Frame showFrame(Component comp) {
        return this.fixtureHelper.showFrame(comp, null, this.getName());
    }

    protected Frame showFrame(Component comp, Dimension size) {
        return this.fixtureHelper.showFrame(comp, size, this.getName());
    }

    protected void showWindow(Window w) {
        this.showWindow(w, null, true);
    }

    protected void showWindow(Window w, Dimension size) {
        this.showWindow(w, size, true);
    }

    protected void showWindow(Window w, Dimension size, boolean pack) {
        this.fixtureHelper.showWindow(w, size, pack);
    }

    protected void waitForWindow(Window w, boolean visible) {
        this.fixtureHelper.waitForWindow(w, visible);
    }

    protected void hideWindow(Window w) {
        this.fixtureHelper.hideWindow(w);
    }

    protected void disposeWindow(Window w) {
        this.fixtureHelper.disposeWindow(w);
    }

    protected void setModifiers(int modifiers, boolean pressed) {
        this.fixtureHelper.setModifiers(modifiers, pressed);
    }

    protected void invokeAndWait(Runnable runnable) {
        this.fixtureHelper.invokeAndWait(runnable);
    }

    protected void invokeLater(Runnable runnable) {
        this.fixtureHelper.invokeLater(runnable);
    }

    protected void installPopup(Component invoker, JPopupMenu popup) {
        this.fixtureHelper.installPopup(invoker, popup);
    }

    protected void showPopup(JPopupMenu popup, Component invoker) {
        this.showPopup(popup, invoker, invoker.getWidth() / 2, invoker.getHeight() / 2);
    }

    protected void showPopup(JPopupMenu popup, Component invoker, int x, int y) {
        this.fixtureHelper.showPopup(popup, invoker, x, y);
    }

    protected Dialog showModalDialog(Runnable showAction) throws ComponentSearchException {
        return this.fixtureHelper.showModalDialog(showAction, this.getFinder());
    }

    protected Dialog showModalDialog(Runnable showAction, Component contents) throws Exception {
        return this.showModalDialog(showAction);
    }

    protected boolean isShowing(String id) {
        try {
            this.getFinder().find(new WindowMatcher(id, true));
        }
        catch (ComponentNotFoundException e) {
            return false;
        }
        catch (MultipleComponentsFoundException multipleComponentsFoundException) {
            // empty catch block
        }
        return true;
    }

    public ComponentTestFixture(String name) {
        super(name);
    }

    public ComponentTestFixture() {
    }

    protected void fixtureSetUp() throws Throwable {
        this.hierarchy = this.createHierarchy();
        this.finder = new BasicFinder(this.hierarchy);
        this.fixtureHelper = new AWTFixtureHelper(this.hierarchy){

            protected void disposeAll() {
                ComponentTestFixture.this.disposeAll();
            }
        };
    }

    protected void fixtureTearDown() throws Throwable {
        this.edtExceptionTime = this.fixtureHelper.getEventDispatchErrorTime();
        this.edtException = this.fixtureHelper.getEventDispatchError();
        this.fixtureHelper.dispose();
        this.fixtureHelper = null;
        this.clearTestFields();
        this.hierarchy = null;
        this.finder = null;
    }

    protected void disposeAll() {
        Iterator iter = this.hierarchy.getRoots().iterator();
        while (iter.hasNext()) {
            this.hierarchy.dispose((Window)iter.next());
        }
    }

    private void clearTestFields() {
        try {
            Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if ((fields[i].getModifiers() & 8) != 0) continue;
                fields[i].setAccessible(true);
                for (int c = 0; c < DISPOSE_CLASSES.length; ++c) {
                    Class cls = DISPOSE_CLASSES[c];
                    if (!cls.isAssignableFrom(fields[i].getType())) continue;
                    fields[i].set((Object)this, null);
                }
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        if (Boolean.getBoolean("abbot.skip_ui_tests")) {
            return;
        }
        Throwable exception = null;
        long exceptionTime = -1L;
        try {
            try {
                this.fixtureSetUp();
                super.runBare();
            }
            catch (Throwable e) {
                exception = e;
            }
            finally {
                block21: {
                    Log.log("tearing down fixture: " + this.getName());
                    try {
                        this.fixtureTearDown();
                    }
                    catch (Throwable tearingDown) {
                        if (exception != null) break block21;
                        exception = tearingDown;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        catch (Throwable e) {
            exceptionTime = System.currentTimeMillis();
            exception = e;
        }
        finally {
            if (this.edtException != null && (exception == null || this.edtExceptionTime < exceptionTime)) {
                exception = new EventDispatchException(this.edtException);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected Hierarchy createHierarchy() {
        return new TestHierarchy();
    }

    protected ComponentFinder getFinder() {
        return this.finder;
    }

    protected Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ComponentMatcher
    implements Matcher {
        private Component component;

        public ComponentMatcher(Component c) {
            this.component = c;
        }

        public boolean matches(Component c) {
            return c == this.component;
        }
    }

    public class EventDispatchException
    extends InvocationTargetException {
        private EventDispatchException(Throwable t) {
            super(t, "An exception was thrown on the event dispatch thread: " + t.toString());
        }

        public void printStackTrace() {
            this.getTargetException().printStackTrace();
        }

        public void printStackTrace(PrintStream p) {
            this.getTargetException().printStackTrace(p);
        }

        public void printStackTrace(PrintWriter p) {
            this.getTargetException().printStackTrace(p);
        }
    }
}

