/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.abbot;

import abbot.Log;
import java.util.ArrayList;
import junit.extensions.RepeatedTest;
import junit.extensions.abbot.TestHelper;
import junit.framework.Test;

public class RepeatHelper
extends TestHelper {
    private static int repeatCount = 1;

    protected RepeatHelper() {
    }

    protected static String[] parseArgs(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            try {
                repeatCount = Integer.parseInt(args[i]);
                continue;
            }
            catch (NumberFormatException e) {
                list.add(args[i]);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static void runTests(String[] args, Class testClass) {
        args = Log.init(args);
        args = RepeatHelper.parseArgs(args);
        args = TestHelper.parseArgs(args);
        try {
            Test test = RepeatHelper.collectTests(args, testClass);
            if (repeatCount > 1) {
                test = new RepeatedTest(test, repeatCount);
            }
            RepeatHelper.runTest(test);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-2);
        }
    }
}

