/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.smtp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.core.test.smtp.SmtpActionType;
import org.apache.logging.log4j.core.test.smtp.SmtpMessage;
import org.apache.logging.log4j.core.test.smtp.SmtpRequest;
import org.apache.logging.log4j.core.test.smtp.SmtpResponse;
import org.apache.logging.log4j.core.test.smtp.SmtpState;

public class SimpleSmtpServer
implements Runnable {
    private final List<SmtpMessage> receivedMail = new ArrayList<SmtpMessage>();
    public static final int DEFAULT_SMTP_PORT = 25;
    private volatile boolean stopped = true;
    private ServerSocket serverSocket;
    private int port = 25;
    private static final int TIMEOUT = 500;

    public SimpleSmtpServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UNENCRYPTED_SERVER_SOCKET"})
    public void run() {
        this.stopped = false;
        try {
            try {
                this.serverSocket = new ServerSocket(this.port);
                this.serverSocket.setSoTimeout(500);
            }
            finally {
                SimpleSmtpServer simpleSmtpServer = this;
                synchronized (simpleSmtpServer) {
                    this.notifyAll();
                }
            }
            while (!this.isStopped()) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                }
                catch (Exception e) {
                    if (socket == null) continue;
                    socket.close();
                    continue;
                }
                BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                PrintWriter out = new PrintWriter(socket.getOutputStream());
                SimpleSmtpServer simpleSmtpServer = this;
                synchronized (simpleSmtpServer) {
                    List<SmtpMessage> msgs = this.handleTransaction(out, input);
                    this.receivedMail.addAll(msgs);
                }
                socket.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void stop() {
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<SmtpMessage> handleTransaction(PrintWriter out, BufferedReader input) throws IOException {
        String line;
        SmtpState smtpState = SmtpState.CONNECT;
        SmtpRequest smtpRequest = new SmtpRequest(SmtpActionType.CONNECT, "", smtpState);
        SmtpResponse smtpResponse = smtpRequest.execute();
        SimpleSmtpServer.sendResponse(out, smtpResponse);
        smtpState = smtpResponse.getNextState();
        ArrayList<SmtpMessage> msgList = new ArrayList<SmtpMessage>();
        SmtpMessage msg = new SmtpMessage();
        while (smtpState != SmtpState.CONNECT && (line = input.readLine()) != null) {
            SmtpRequest request = SmtpRequest.createRequest(line, smtpState);
            SmtpResponse response = request.execute();
            smtpState = response.getNextState();
            SimpleSmtpServer.sendResponse(out, response);
            String params = request.getParams();
            msg.store(response, params);
            if (smtpState != SmtpState.QUIT) continue;
            msgList.add(msg);
            msg = new SmtpMessage();
        }
        return msgList;
    }

    private static void sendResponse(PrintWriter out, SmtpResponse smtpResponse) {
        if (smtpResponse.getCode() > 0) {
            int code = smtpResponse.getCode();
            String message = smtpResponse.getMessage();
            out.print(code + " " + message + "\r\n");
            out.flush();
        }
    }

    public synchronized Iterator<SmtpMessage> getReceivedEmail() {
        return this.receivedMail.iterator();
    }

    public synchronized int getReceivedEmailSize() {
        return this.receivedMail.size();
    }

    public static SimpleSmtpServer start() {
        return SimpleSmtpServer.start(25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleSmtpServer start(int port) {
        SimpleSmtpServer server = new SimpleSmtpServer(port);
        Thread t = new Thread(server);
        SimpleSmtpServer simpleSmtpServer = server;
        synchronized (simpleSmtpServer) {
            t.start();
            try {
                server.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return server;
    }
}

