/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.gui;

import info.jdictionary.FileDownloader;
import info.jdictionary.IconBank;
import info.jdictionary.ImageBank;
import info.jdictionary.JDictionary;
import info.jdictionary.gui.NetworkErrorCenteredPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class UpgradeAgent
extends JPanel {
    JDictionary jDictionary;
    DownloadThread downloadThread;
    boolean downloading = false;
    boolean success = false;
    boolean downloadError = false;
    JLabel header = new JLabel(ImageBank.getImageByName("UpgradeHeader.png"));
    JLabel text;
    JLabel waitText = new JLabel(JDictionary.getString("InfoAboutNewVersion"), IconBank.info, 0);
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel actionPanel = new JPanel();
    JScrollPane scrollPane = new JScrollPane();
    JProgressBar progressBar = new JProgressBar();
    JButton button = new JButton();
    BoxLayout boxLayout1 = new BoxLayout(this, 1);
    BoxLayout boxLayout2 = new BoxLayout(this.actionPanel, 1);
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();

    public UpgradeAgent(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(this.boxLayout1);
        this.setBackground(Color.white);
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.add((Component)this.waitText, "Center");
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.getViewport().add(this.jPanel1);
        this.actionPanel.setLayout(this.boxLayout2);
        this.actionPanel.setBackground(Color.white);
        this.jPanel2.setLayout(this.borderLayout2);
        this.jPanel2.setMinimumSize(new Dimension(0, 55));
        this.jPanel2.setPreferredSize(new Dimension(0, 55));
        this.jPanel2.setMaximumSize(new Dimension(5000, 55));
        this.jPanel2.setAlignmentX(0.0f);
        this.jPanel2.add(this.actionPanel);
        this.progressBar.setStringPainted(true);
        this.button.setAlignmentX(0.5f);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpgradeAgent.this.button_actionPerformed(e);
            }
        });
        this.add((Component)this.header, null);
        this.add((Component)this.scrollPane, null);
        this.add((Component)this.jPanel2, null);
        this.downloadInfo();
    }

    void upgradeActionPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (UpgradeAgent.this.downloading) {
                    UpgradeAgent.this.actionPanel.removeAll();
                    UpgradeAgent.this.button.setText(JDictionary.getString("StopDownload"));
                    UpgradeAgent.this.button.setIcon(IconBank.stop);
                    UpgradeAgent.this.actionPanel.add(UpgradeAgent.this.button);
                    UpgradeAgent.this.actionPanel.add(UpgradeAgent.this.progressBar);
                    UpgradeAgent.this.actionPanel.validate();
                    UpgradeAgent.this.actionPanel.repaint();
                    return;
                }
                if (!UpgradeAgent.this.success) {
                    UpgradeAgent.this.actionPanel.removeAll();
                    return;
                }
                if (!UpgradeAgent.this.permissionToUpgrade()) {
                    UpgradeAgent.this.actionPanel.removeAll();
                    UpgradeAgent.this.actionPanel.setLayout(new BorderLayout());
                    JLabel error = new JLabel(JDictionary.getString("NoPermission"), IconBank.caution, 0);
                    UpgradeAgent.this.actionPanel.add(error);
                    UpgradeAgent.this.actionPanel.validate();
                    UpgradeAgent.this.actionPanel.repaint();
                    return;
                }
                UpgradeAgent.this.actionPanel.removeAll();
                UpgradeAgent.this.button.setText(JDictionary.getString("DownloadAndUpgrade"));
                UpgradeAgent.this.button.setIcon(IconBank.laptopIn);
                UpgradeAgent.this.button.setEnabled(true);
                UpgradeAgent.this.actionPanel.add(UpgradeAgent.this.button);
                if (UpgradeAgent.this.downloadError) {
                    JLabel errorLabel = new JLabel(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("DownloadTip4")))).append(" ").append(JDictionary.getString("WebSite")))), IconBank.caution, 0);
                    errorLabel.setAlignmentX(0.5f);
                    UpgradeAgent.this.actionPanel.add(errorLabel);
                }
                UpgradeAgent.this.progressBar.setValue(UpgradeAgent.this.progressBar.getMinimum());
                UpgradeAgent.this.progressBar.setString(JDictionary.getString("SearchingForDownloadServer"));
                UpgradeAgent.this.actionPanel.validate();
                UpgradeAgent.this.actionPanel.repaint();
            }
        });
    }

    void downloadInfo() {
        new Thread(){

            public void run() {
                URL textURL = null;
                float latestJDictionaryVersion = UpgradeAgent.this.jDictionary.getNewJDictionaryVersionChecker().getLatestVersion();
                if (latestJDictionaryVersion <= 0.0f) {
                    UpgradeAgent.this.success = false;
                    NetworkErrorCenteredPanel networkErrorCenteredPanel = new NetworkErrorCenteredPanel(UpgradeAgent.this.jDictionary);
                    UpgradeAgent.this.showComponent(networkErrorCenteredPanel);
                    UpgradeAgent.this.upgradeActionPanel();
                    return;
                }
                if (JDictionary.getJDictionaryVersion() >= latestJDictionaryVersion) {
                    UpgradeAgent.this.text = new JLabel(JDictionary.getString("UsingLatestJDictionary"), IconBank.bulb, 0);
                    UpgradeAgent.this.showComponent(UpgradeAgent.this.text);
                    UpgradeAgent.this.upgradeActionPanel();
                    return;
                }
                textURL = UpgradeAgent.this.getTextURL();
                if (textURL == null) {
                    UpgradeAgent.this.success = false;
                    NetworkErrorCenteredPanel networkErrorCenteredPanel = new NetworkErrorCenteredPanel(UpgradeAgent.this.jDictionary);
                    networkErrorCenteredPanel.getNetworkErrorPanel().addLine(new JLabel(JDictionary.getString("DownloadTip4"), IconBank.bulb, 0));
                    networkErrorCenteredPanel.getNetworkErrorPanel().addLine(new JLabel("           ".concat(String.valueOf(String.valueOf(JDictionary.getString("WebSite"))))));
                    UpgradeAgent.this.showComponent(networkErrorCenteredPanel);
                    UpgradeAgent.this.upgradeActionPanel();
                    return;
                }
                try {
                    UpgradeAgent.this.text = new JLabel(new ImageIcon(textURL));
                }
                catch (Exception e) {
                    UpgradeAgent.this.success = false;
                    NetworkErrorCenteredPanel networkErrorCenteredPanel = new NetworkErrorCenteredPanel(UpgradeAgent.this.jDictionary);
                    networkErrorCenteredPanel.getNetworkErrorPanel().addLine(new JLabel(JDictionary.getString("DownloadTip4"), IconBank.info, 0));
                    networkErrorCenteredPanel.getNetworkErrorPanel().addLine(new JLabel("           ".concat(String.valueOf(String.valueOf(JDictionary.getString("WebSite"))))));
                    UpgradeAgent.this.showComponent(networkErrorCenteredPanel);
                    UpgradeAgent.this.upgradeActionPanel();
                    return;
                }
                UpgradeAgent.this.success = true;
                UpgradeAgent.this.showComponent(UpgradeAgent.this.text);
                UpgradeAgent.this.upgradeActionPanel();
            }
        }.start();
        this.add((Component)this.jPanel2, null);
    }

    void showComponent(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpgradeAgent.this.jPanel1.removeAll();
                UpgradeAgent.this.jPanel1.add((Component)component, "Center");
                UpgradeAgent.this.jPanel1.validate();
                UpgradeAgent.this.scrollPane.validate();
                UpgradeAgent.this.jPanel1.repaint();
            }
        });
    }

    boolean permissionToUpgrade() {
        File f = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.jDictionary.getBaseDir()))).append(JDictionary.getFileSeparator()).append("jdictionary.jar"))));
        return f.canWrite();
    }

    void button_actionPerformed(ActionEvent e) {
        if (!this.downloading) {
            this.downloading = true;
            this.downloadError = false;
            this.upgradeActionPanel();
            this.startDownload();
        } else {
            this.downloading = false;
            this.downloadThread.terminate();
            this.downloadThread = null;
            this.upgradeActionPanel();
        }
    }

    void startDownload() {
        this.downloadThread = new DownloadThread();
        this.downloadThread.start();
    }

    public boolean isSuccess() {
        return this.success;
    }

    private URL getTextURL() {
        URL textURL = null;
        try {
            textURL = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("SourceforgeDownloadServerURL")))).append("/").append(JDictionary.getString("InfoAboutNewVersionFile")).append("_").append(JDictionary.getLanguage()))));
            if (textURL.openConnection().getContentLength() > 5000) {
                URL uRL = textURL;
                return uRL;
            }
            textURL = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("SourceforgeDownloadServerURL")))).append("/").append(JDictionary.getString("InfoAboutNewVersionFile")))));
            if (textURL.openConnection().getContentLength() > 5000) {
                URL uRL = textURL;
                return uRL;
            }
            textURL = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("InfoServerURL")))).append("/").append(JDictionary.getString("InfoAboutNewVersionFile")).append("_").append(JDictionary.getLanguage()))));
            if (textURL.openConnection().getContentLength() > 5000) {
                URL uRL = textURL;
                return uRL;
            }
            textURL = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("InfoServerURL")))).append("/").append(JDictionary.getString("InfoAboutNewVersionFile")))));
            if (textURL.openConnection().getContentLength() > 5000) {
                URL uRL = textURL;
                return uRL;
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    class DownloadThread
    extends Thread {
        FileDownloader downloader;
        boolean terminated = false;

        DownloadThread() {
        }

        public void run() {
            byte[] b = null;
            this.downloader = new FileDownloader();
            b = this.downloader.download(this.getUpgradeURL(), UpgradeAgent.this.progressBar);
            if (b == null) {
                UpgradeAgent.this.downloading = false;
                if (!this.terminated) {
                    UpgradeAgent.this.downloadError = true;
                }
                UpgradeAgent.this.upgradeActionPanel();
                return;
            }
            UpgradeAgent.this.button.setEnabled(false);
            this.extractUpgrade(b);
            UpgradeAgent.this.jDictionary.getPluginManager().removeAllPlugins();
            try {
                Runtime.getRuntime().exec(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(System.getProperty("java.home")))).append(JDictionary.getFileSeparator()).append("bin").append(JDictionary.getFileSeparator()).append("java Upgrader"))), null, new File(UpgradeAgent.this.jDictionary.getBaseDir()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.exit(0);
        }

        public void terminate() {
            this.terminated = true;
            this.downloader.terminate();
        }

        void extractUpgrade(byte[] b) {
            try {
                File f = new File("upgrade");
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(b);
                fos.close();
                ZipFile zf = new ZipFile("upgrade");
                ZipEntry ze = null;
                InputStream is = null;
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ze = entries.nextElement();
                    f = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(UpgradeAgent.this.jDictionary.getBaseDir()))).append(JDictionary.getFileSeparator()).append(ze.getName()))));
                    if (f.exists()) {
                        f.delete();
                    }
                    fos = new FileOutputStream(f);
                    is = zf.getInputStream(ze);
                    int c = 0;
                    while ((c = is.read()) != -1) {
                        fos.write(c);
                    }
                }
                fos.close();
                is.close();
                zf.close();
                f = new File("upgrade");
                f.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        URL getUpgradeURL() {
            URL url = null;
            try {
                url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("SourceforgeDownloadServerURL")))).append("/").append(JDictionary.getString("UpgradeFile")))));
                if (url.openConnection().getContentLength() > 20000) {
                    URL uRL = url;
                    return uRL;
                }
                url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("InfoServerURL")))).append("/").append(JDictionary.getString("UpgradeFile")))));
            }
            catch (Exception e) {
                URL uRL = null;
                return uRL;
            }
            return url;
        }
    }
}

