/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.modules;

import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.JDictionary;
import info.jdictionary.Plugin;
import info.jdictionary.events.PluginScanFinishedEvent;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.gui.InfoPanel;
import info.jdictionary.gui.OutputTabbedPane;
import info.jdictionary.listeners.PluginScanFinishedListener;
import info.jdictionary.listeners.PluginSelectionListener;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultOutput
extends JPanel {
    DefaultFrameAssembler assembler;
    HashMap outputCache = new HashMap();
    BorderLayout borderLayout = new BorderLayout();
    ArrayList startedPlugins = new ArrayList();

    public DefaultOutput(DefaultFrameAssembler assembler) {
        this.assembler = assembler;
        this.setLayout(this.borderLayout);
        assembler.getJDictionary().getPluginManager().addPluginSelectionListener(new PluginSelectionListener(){

            public void pluginSelected(PluginSelectionEvent e) {
                DefaultOutput.this.pluginManager_pluginSelected(e);
            }
        });
        assembler.getJDictionary().getPluginManager().addPluginScanFinishedListener(new PluginScanFinishedListener(){

            public void pluginScanFinished(PluginScanFinishedEvent e) {
                DefaultOutput.this.pluginManager_pluginScanFinished(e);
            }
        });
    }

    private void show(PluginInfoSheet sheet) {
        JTabbedPane outputTabbedPane = (JTabbedPane)this.outputCache.get(sheet);
        if (outputTabbedPane == null) {
            outputTabbedPane = this.buildOutputTabbedPane(sheet);
        }
        if (this.getComponentCount() > 0 && this.getComponent(0) == outputTabbedPane) {
            return;
        }
        this.removeAll();
        this.add(outputTabbedPane);
        this.startPlugin(outputTabbedPane);
    }

    private void show(PluginInfoSheet sheet, String name) {
        JTabbedPane outputTabbedPane = (JTabbedPane)this.outputCache.get(sheet);
        if (outputTabbedPane == null) {
            outputTabbedPane = this.buildOutputTabbedPane(sheet);
        }
        for (int i = 0; i < outputTabbedPane.getTabCount(); ++i) {
            if (!outputTabbedPane.getTitleAt(i).equals(name)) continue;
            if (this.getComponentCount() > 0 && this.getComponent(0) instanceof OutputTabbedPane && (JTabbedPane)this.getComponent(0) == outputTabbedPane) {
                if (((JTabbedPane)this.getComponent(0)).getSelectedIndex() != i) {
                    outputTabbedPane.setSelectedIndex(i);
                    this.startPlugin(outputTabbedPane);
                }
                return;
            }
            this.removeAll();
            this.add(outputTabbedPane);
            outputTabbedPane.setSelectedIndex(i);
            this.startPlugin(outputTabbedPane);
            return;
        }
        this.show(sheet);
    }

    public void show(final Component comp) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultOutput.this.removeAll();
                DefaultOutput.this.add(comp);
                DefaultOutput.this.getParent().validate();
                DefaultOutput.this.getParent().repaint();
                DefaultOutput.this.assembler.getJDictionary().getPluginManager().selectPlugin(null, null);
            }
        });
    }

    public void showDefault() {
        PluginManager pluginManager = this.assembler.getJDictionary().getPluginManager();
        JDictionary jDictionary = this.assembler.getJDictionary();
        JPanel p = pluginManager.getNumberOfLoadedPlugins() > 0 ? jDictionary.getSplashScreen() : (pluginManager.getNumberOfPluginFiles() > 0 ? jDictionary.getAllPluginsDeactivatedScreen() : jDictionary.getNoPluginInstalledScreen());
        this.show(p);
    }

    public Component getOutputComponent() {
        if (this.getComponentCount() != 0) {
            return this.getComponent(0);
        }
        return null;
    }

    OutputTabbedPane buildOutputTabbedPane(PluginInfoSheet sheet) {
        OutputTabbedPane outputTabbedPane = new OutputTabbedPane(sheet);
        ArrayList plugin = this.assembler.getJDictionary().getPluginManager().getPlugin(sheet);
        for (int count = plugin.size() - 1; count >= 0; --count) {
            Plugin pluginPiece = (Plugin)plugin.get(count);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            outputTabbedPane.add(pluginPiece.toString(), jPanel);
        }
        outputTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DefaultOutput.this.outputTabbedPane_stateChanged(e);
            }
        });
        this.outputCache.put(sheet, outputTabbedPane);
        return outputTabbedPane;
    }

    void outputTabbedPane_stateChanged(ChangeEvent e) {
        OutputTabbedPane outputTabbedPane = (OutputTabbedPane)e.getSource();
        this.startPlugin(outputTabbedPane);
        this.assembler.getJDictionary().getPluginManager().selectPlugin(outputTabbedPane.getSheet(), outputTabbedPane.getTitleAt(outputTabbedPane.getSelectedIndex()));
    }

    void pluginManager_pluginSelected(PluginSelectionEvent e) {
        if (e.getSelectedPlugin() != null) {
            if (e.getSelectedSubPlugin() == null) {
                this.show(e.getSelectedPlugin());
            } else {
                this.show(e.getSelectedPlugin(), e.getSelectedSubPlugin());
            }
        } else if (this.getComponentCount() == 0 || this.getComponentCount() > 0 && this.getComponent(0) instanceof OutputTabbedPane) {
            this.showDefault();
        }
    }

    void pluginManager_pluginScanFinished(PluginScanFinishedEvent e) {
        if (this.getComponentCount() == 0 || this.assembler.getJDictionary().getPluginManager().getSelectedPlugin() == null && (this.getComponent(0) instanceof OutputTabbedPane || this.getComponent(0) instanceof InfoPanel)) {
            this.showDefault();
        }
    }

    void startPlugin(JTabbedPane outputTabbedPane) {
        int selectedIndex = outputTabbedPane.getSelectedIndex();
        JPanel contentPane = (JPanel)outputTabbedPane.getComponentAt(selectedIndex);
        ArrayList plugin = this.assembler.getJDictionary().getPluginManager().getPlugin(((OutputTabbedPane)outputTabbedPane).getSheet());
        Plugin pluginPiece = (Plugin)plugin.get(plugin.size() - (selectedIndex + 1));
        this.startPlugin(pluginPiece, contentPane);
    }

    void startPlugin(final Plugin plugin, final JPanel contentPane) {
        if (this.startedPlugins.contains(plugin)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DefaultOutput.this.getParent().validate();
                    DefaultOutput.this.getParent().repaint();
                }
            });
        } else {
            this.startedPlugins.add(plugin);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    plugin.construct(contentPane);
                    plugin.start();
                    DefaultOutput.this.getParent().validate();
                    DefaultOutput.this.getParent().repaint();
                }
            });
        }
    }
}

