/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.pluginstuff;

import info.jdictionary.IconBank;
import info.jdictionary.ImageBank;
import info.jdictionary.JDictionary;
import info.jdictionary.events.PluginFilesChangeEvent;
import info.jdictionary.events.PluginStructureChangeEvent;
import info.jdictionary.gui.PluginInfoSheetPanel;
import info.jdictionary.listeners.PluginFilesChangeListener;
import info.jdictionary.listeners.PluginStructureChangeListener;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class PluginStatusChanger
extends JPanel
implements Runnable {
    JDictionary jDictionary;
    PluginManager pluginManager;
    ArrayList pluginStatusPanels;
    JPanel availablePluginsPanel = new JPanel();
    JPanel pluginOutputPanel = new JPanel();
    ImageIcon spacerLine = ImageBank.getImageByName("Spacer.jpg");
    ImageIcon headerImage = ImageBank.getImageByName("ActivateHeader.png");
    BoxLayout boxLayout1 = new BoxLayout(this, 1);
    BoxLayout boxLayout2 = new BoxLayout(this.pluginOutputPanel, 1);
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel headerLabel = new JLabel();
    JScrollPane pluginOutputScrollPane = new JScrollPane();

    public PluginStatusChanger(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        this.pluginManager = jDictionary.getPluginManager();
        this.pluginManager.addPluginFilesChangeListener(new PluginFilesChangeListener(){

            public void pluginFilesChanged(PluginFilesChangeEvent e) {
                PluginStatusChanger.this.reBuildPluginStatusPanels();
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.boxLayout1);
        this.setBackground(Color.white);
        this.setAlignmentY(0.0f);
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        this.availablePluginsPanel.setBackground(Color.white);
        this.availablePluginsPanel.setAlignmentX(0.0f);
        this.availablePluginsPanel.setMinimumSize(new Dimension(300, 100));
        this.availablePluginsPanel.setPreferredSize(new Dimension(1000, 1000));
        this.availablePluginsPanel.setLayout(this.borderLayout1);
        this.availablePluginsPanel.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("AvailablePlugins")));
        this.headerLabel.setMinimumSize(new Dimension(300, 65));
        this.headerLabel.setPreferredSize(new Dimension(500, 65));
        this.headerLabel.setIcon(this.headerImage);
        this.pluginOutputScrollPane.setHorizontalScrollBarPolicy(31);
        this.pluginOutputPanel.setBackground(Color.white);
        this.add((Component)this.headerLabel, null);
        this.add((Component)this.availablePluginsPanel, null);
        this.availablePluginsPanel.add((Component)this.pluginOutputScrollPane, "Center");
        this.pluginOutputScrollPane.getViewport().add((Component)this.pluginOutputPanel, null);
    }

    public void run() {
        this.reBuildPluginStatusPanels();
    }

    synchronized void toggleStatus(PluginStatusPanel p) {
        if (p.isActive()) {
            this.pluginManager.setInActive(p.sheet.getFileName());
        } else {
            this.pluginManager.setActive(p.sheet.getFileName());
        }
        this.pluginManager.scanPlugins();
    }

    public void reBuildPluginStatusPanels() {
        this.pluginStatusPanels = new ArrayList();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginStatusChanger.this.pluginOutputPanel.removeAll();
                if (PluginStatusChanger.this.pluginManager.getNumberOfPluginFiles() == 0) {
                    PluginStatusChanger.this.pluginOutputPanel.setLayout(new BorderLayout());
                    PluginStatusChanger.this.pluginOutputPanel.add(new JLabel(JDictionary.getString("NoPlugins"), IconBank.info, 0));
                    PluginStatusChanger.this.pluginOutputPanel.validate();
                    PluginStatusChanger.this.pluginOutputPanel.repaint();
                    return;
                }
                File[] pluginFiles = PluginStatusChanger.this.pluginManager.getPluginFiles();
                ArrayList<PluginInfoSheet> sheets = new ArrayList<PluginInfoSheet>();
                for (int i = 0; i < pluginFiles.length; ++i) {
                    PluginInfoSheet tempSheet;
                    if (PluginStatusChanger.this.pluginManager.isThereNewerPluginFileAvailable(pluginFiles[i].getName())) continue;
                    try {
                        tempSheet = PluginInfoSheet.CreateInfoSheet(pluginFiles[i]);
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    sheets.add(tempSheet);
                }
                SwingUtilities.invokeLater(new Runnable(this, sheets){
                    private final /* synthetic */ ArrayList val$sheets;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$sheets = val$sheets;
                    }

                    public void run() {
                        2.access$0(this.this$1).pluginOutputPanel.setLayout(2.access$0(this.this$1).boxLayout2);
                        for (int n = 0; n < this.val$sheets.size(); ++n) {
                            PluginStatusChanger pluginStatusChanger = 2.access$0(this.this$1);
                            pluginStatusChanger.getClass();
                            PluginStatusPanel p = pluginStatusChanger.new PluginStatusPanel(2.access$0(this.this$1).jDictionary, (PluginInfoSheet)this.val$sheets.get(n));
                            2.access$0(this.this$1).pluginOutputPanel.add(p);
                            2.access$0(this.this$1).pluginStatusPanels.add(p);
                            if (n >= 2.access$0(this.this$1).pluginManager.getNumberOfPluginFiles() - 1) continue;
                            JLabel spacer = new JLabel(2.access$0(this.this$1).spacerLine);
                            spacer.setPreferredSize(new Dimension(200, 1));
                            2.access$0(this.this$1).pluginOutputPanel.add(spacer);
                        }
                        2.access$0(this.this$1).pluginOutputPanel.validate();
                        2.access$0(this.this$1).pluginOutputScrollPane.validate();
                        2.access$0(this.this$1).pluginOutputPanel.repaint();
                    }
                });
            }

            static /* synthetic */ PluginStatusChanger access$0(2 x$0) {
                return x$0.PluginStatusChanger.this;
            }
        });
    }

    class PluginStatusPanel
    extends JPanel {
        JDictionary jDictionary;
        PluginInfoSheet sheet;
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout1 = new BoxLayout(this, 0);
        BoxLayout boxLayout2 = new BoxLayout(this.jPanel1, 1);
        PluginInfoSheetPanel sheetPanel;
        JScrollPane jScrollPane1 = new JScrollPane();
        JButton button = new JButton();
        JLabel status = new JLabel();

        public PluginStatusPanel(JDictionary jDictionary, PluginInfoSheet sheet) {
            this.sheet = sheet;
            this.jDictionary = jDictionary;
            this.sheetPanel = new PluginInfoSheetPanel(sheet);
            PluginStatusChanger.this.pluginManager.addPluginStructureChangeListener(new PluginStructureChangeListener(this){
                private final /* synthetic */ PluginStatusPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void pluginAdded(PluginStructureChangeEvent e) {
                    this.this$1.update();
                }

                public void pluginRemoved(PluginStructureChangeEvent e) {
                    this.this$1.update();
                }
            });
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.update();
        }

        private void jbInit() throws Exception {
            this.setBackground(new Color(255, 255, 255));
            this.setPreferredSize(new Dimension(370, 85));
            this.setMinimumSize(new Dimension(300, 85));
            this.setLayout(this.boxLayout1);
            this.setBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3));
            this.setAlignmentX(0.0f);
            this.jPanel1.setLayout(this.boxLayout2);
            this.jPanel1.setPreferredSize(new Dimension(110, 55));
            this.jPanel1.setBackground(new Color(255, 255, 255));
            this.jPanel2.setBackground(new Color(255, 255, 255));
            this.jScrollPane1.setPreferredSize(new Dimension(300, 70));
            this.jScrollPane1.setMinimumSize(new Dimension(100, 70));
            this.status.setAlignmentX(0.0f);
            this.button.setAlignmentX(0.0f);
            this.button.setMargin(new Insets(0, 3, 0, 3));
            this.button.addActionListener(new ActionListener(this){
                private final /* synthetic */ PluginStatusPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.button_actionPerformed(e);
                }
            });
            this.jPanel1.add(this.status);
            this.jPanel1.add(Box.createVerticalGlue());
            this.jPanel1.add(this.button);
            this.jPanel2.add(this.jPanel1);
            this.add(this.jScrollPane1);
            this.add(this.jPanel2);
            this.jScrollPane1.getViewport().add(this.sheetPanel);
        }

        boolean isActive() {
            return PluginStatusChanger.this.pluginManager.isItActive(this.sheet.getFileName());
        }

        void update() {
            this.button.setEnabled(true);
            if (this.isActive()) {
                this.status.setText(JDictionary.getString("Active"));
                this.status.setIcon(IconBank.trafficGreen);
                this.button.setText(JDictionary.getString("Deactivate"));
                this.button.setIcon(IconBank.unPlug);
            } else {
                this.status.setText(JDictionary.getString("Deactivated"));
                this.status.setIcon(IconBank.trafficRed);
                this.button.setText(JDictionary.getString("Activate"));
                this.button.setIcon(IconBank.plug);
            }
        }

        void button_actionPerformed(ActionEvent e) {
            this.button.setEnabled(false);
            if (this.isActive()) {
                this.status.setIcon(IconBank.trafficYellow);
            } else {
                this.status.setIcon(IconBank.trafficRedYellow);
            }
            PluginStatusChanger.this.toggleStatus(this);
        }

        public boolean isInstalled() {
            return PluginStatusChanger.this.pluginManager.isItInstalled(this.sheet);
        }
    }
}

