package com.incors.plaf.kunststoff;

/*
 * This code was developed by INCORS GmbH (www.incors.com).
 * It is published under the terms of the Lesser GNU Public License.
 */

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.plaf.metal.*;

/**
 * The main class for the Kunststoff Look&Feel.
 *
 * To use this Look&Feel, simply include these three lines into your code
 * KunststoffLookAndFeel kunststoffLF = new KunststoffLookAndFeel();
 * kunststoffLF.setCurrentTheme(new KunststoffTheme());
 * UIManager.setLookAndFeel(kunststoffLF);
 */
public class KunststoffLookAndFeel extends MetalLookAndFeel {

  public KunststoffLookAndFeel() {
    super();
  }

  public String getID() {
    return "Kunststoff";
  }

  public String getName() {
    return "Kunststoff";
  }

  public String getDescription() {
    return "Look and Feel giving a plastic effect. Written by Jan Bsenberg, 2001";
  }

  public boolean isNativeLookAndFeel() {
    return false;
  }

  public boolean isSupportedLookAndFeel() {
    return true;
  }



  protected void initClassDefaults(UIDefaults table) {
    super.initClassDefaults(table);
    putDefault(table, "ButtonUI");
    //putDefault(table, "ComboBoxUI");
    putDefault(table, "TabbedPaneUI");
    //putDefault(table, "TextFieldUI");
    //putDefault(table, "ListUI");  // you might want to delete this line
    putDefault(table, "MenuBarUI");
    putDefault(table, "MenuUI");
    putDefault(table, "ScrollBarUI");
    putDefault(table, "ToolBarUI");
    putDefault(table, "RadioButtonUI");
  }



  protected void putDefault(UIDefaults table, String uiKey) {
    try  {
      String className = "com.incors.plaf.kunststoff.Kunststoff"+uiKey;
      table.put(uiKey, className);
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }



  protected void initSystemColorDefaults(UIDefaults table) {
    super.initSystemColorDefaults(table);
    table.put("textHighlight", getTranslucentColor(getTextHighlightColor(), 96));
  }


  protected void initComponentDefaults(UIDefaults table) {
    super.initComponentDefaults(table);
    table.put("SplitPaneDivider.border", null);
  }

  // helper to simplify creation of translucent colors
  private Color getTranslucentColor(Color c, int alpha) {
    return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
  }



}